/*
 * "Bien Dvelopper pour le Web 2.0", Chapitre 8 : APIs REST.
 *
 * Exemple sur The Weather Channel - prvisions mto  4 jours.
 *
 * Ncessite Prototype 1.5.0_rc1 ou ultrieur et GoogleAJAXSLT 0.5
 * ou ultrieur.
 */

// Noms des mois pour le reformatage des dates
DAY_NAMES = {
    'Monday': 'lundi', 'Tuesday': 'mardi', 'Wednesday': 'mercredi',
    'Thursday': 'jeudi', 'Friday': 'vendredi', 'Saturday': 'samedi',
    'Sunday': 'dimanche'
};

// Par dfaut, on regarde la mto de Paris, France (12 "Paris" aux USA :-))
DEFAULT_LOCATION = 'FRXX0076';
// Nombre de jours (1-10) pour les prvisions
FORECAST_DAYS = 4;
// Intervalle de 2 heures, conformment au guide d'implmentation TWC.
FORECAST_REFRESH = 2 * 60 * 60 * 1000;
// Requte d'obtention de prvision
FORECAST_TEMPLATE = new Template(
    'http://xoap.weather.com/weather/local/#{code}?dayf=#{daysAhead}&unit=m');
// Requte d'obtention de codes de lieux
LOCATION_TEMPLATE = new Template(
    'http://xoap.weather.com/search/search?where=#{name}');

// Expressions rationnelles d'extraction de donnes  localiser
RE_LOCALTIME = '(<span id="cityTime">)(.*?)(</span>)';
RE_LATESTUPDATE = '(<span id="latestUpdate">)(.*?) Local Time(</span>)';
RE_DAYNAME = '(<span class="dayName">)(.*?)(</span>)';

var gForecastParams = { code: DEFAULT_LOCATION, daysAhead: FORECAST_DAYS };
var gForecastTimer;
var gLocalTime;
var gLocalTimeTimer;
// Les feuilles XSL/T pour la recherche et les prvisions, charges au
// dbut de l'excution.
var gForecastXSLT;
var gSearchXSLT;

/*
 * Notre propre classe de compltion automatique !  Ajoute une possibilit de
 * transformation XSL/T du contenu XML rcupr par AJAX, afin de pouvoir
 * utiliser des contenus autres qu'un UL/LI :-)
 *
 * Ncessite Google AJAXSLT 0.5 ou ultrieur.
 */
Ajax.XSLTCompleter = Class.create();
Object.extend(Ajax.XSLTCompleter.prototype, Ajax.Autocompleter.prototype);
Object.extend(Ajax.XSLTCompleter.prototype, {
    initialize: function() {
        Ajax.Autocompleter.prototype.initialize.apply(this, arguments);
        this.options.onComplete = this.onComplete.bind(this);
        var options = arguments[3] || {}
        if ("string" == typeof this.options.xslt)
            this.options.xslt = xmlParse(this.options.xslt);
    },

    onComplete: function(request) {
        // IE et Opera ne recuperent pas correctement responseXML, alors
        // on re-parse manuellement...
        var data = xmlParse(request.responseText);
        var html = xsltProcess(data, this.options.xslt);
        this.updateChoices(html);
    }
});

function adjustData(html) {
    // L'heure locale courante du lieu affich
    html = html.gsub(RE_LOCALTIME, function(match) {
        gLocalTime = new Date('1/1/1970 ' + match[2]);
        gLocalTime.setSeconds(new Date().getSeconds());
        return match[1] + gLocalTime.toLocaleTimeString() + match[3];
    });
    // L'heure de dernire mise  jour
    html = html.gsub(RE_LATESTUPDATE, function(match) {
        var lsup = new Date(match[2]);
        if (lsup.getFullYear() < 1980)
            lsup.setFullYear(lsup.getFullYear() + 100);
        return match[1] + lsup.toLocaleString() + match[3];
    });
    // Jours de la semaine
    html = html.gsub(RE_DAYNAME, function(match) {
        return match[1] + DAY_NAMES[match[2]] + match[3];
    });
    return html;
} // adjustData

function cancelTimers() {
    if (gForecastTimer)
        window.clearInterval(gForecastTimer);
    if (gLocalTimeTimer)
        window.clearInterval(gLocalTimeTimer);
} // cancelTimers

function hideIndicator() {
    with ($('indicator')) {
        hide();
        update('');
    }
} // hideIndicator

function showIndicator() {
    with ($('indicator')) {
        update('');
        show();
    }
} // showIndicator

function getForecast(e) {
    if (e)
        Event.stop(e);
    if (gLocalTimeTimer)
        window.clearInterval(gLocalTimeTimer);
    var url = FORECAST_TEMPLATE.evaluate(gForecastParams);
    showIndicator();
    $('results').update('');
    new Ajax.Request('/xmlProxy', {
        method: 'get',
        parameters: 'url=' + encodeURIComponent(url),
        onFailure: hideIndicator,
        onSuccess: function(requester) {
            $('indicator').update('Mise en forme&#8230;');
            // Le boulot "lourd" est dport de 10ms pour laisser le temps au
            // texte de l'indicateur d'tre affich ;-)
            var tmr = window.setTimeout(function() {
                window.clearTimeout(tmr);
                // IE et Opera ne recuperent pas correctement responseXML, alors
                // on re-parse manuellement...
                var data = xmlParse(requester.responseText);
                var html = xsltProcess(data, gForecastXSLT);
                $('results').update(adjustData(html));
                if ($('cityTime'))
                    gLocalTimeTimer = window.setInterval(updateLocalTime, 1000);
                hideIndicator();
            }, 10);
        }
    });
} // getForecast

function initPage() {
    Event.observe('cityForm', 'submit', getForecast);
    new Ajax.Request('/xsl/search.xsl', {
        method: 'get',
        onSuccess: function(requester) {
            // IE et Opera ne recuperent pas correctement responseXML, alors
            // on re-parse manuellement...
            gSearchXSLT = xmlParse(requester.responseText);
            new Ajax.XSLTCompleter('edtCity', 'city_suggestions', '/xmlProxy', {
                method: 'get',
                paramName: 'foo',
                indicator: 'indicator',
                minChars: 2,
                xslt: gSearchXSLT,
                callback: function(e, entry) {
                    // de foo=blah%20truc  url=http://xoap....?where=blah%20truc
                    var url = LOCATION_TEMPLATE.evaluate({ name: entry.substring(4) });
                    return 'url=' + encodeURIComponent(url);
                },
                afterUpdateElement: function(e, elt) {
                    // <li><span class="informal">CODE</span> : li.fC.fC
                    gForecastParams.code = elt.firstChild.firstChild.nodeValue;
                }
            });
            $('btnDisplay').disabled = false;
        }
    });
    new Ajax.Request('/xsl/forecast.xsl', {
        method: 'get',
        onSuccess: function(requester) {
            // IE et Opera ne recuperent pas correctement responseXML, alors
            // on re-parse manuellement...
            gForecastXSLT = xmlParse(requester.responseText);
            getForecast();
            gForecastTimer = window.setInterval(getForecast, FORECAST_REFRESH);
        }
    });
} // initPage

function updateLocalTime() {
    gLocalTime.setTime(gLocalTime.getTime() + 1000);
    $('cityTime').update(gLocalTime.toLocaleTimeString());
} // updateLocalTime

// En cas d'exception, masquer l'indicateur de progression et afficher
// l'exception dans une bote de message.
Ajax.Responders.register({
    onException: function(requester, e) {
        $('indicator').hide();
        alert(e);
    }
});

// viter la console de journalisation de Google AJAXSLT.
logging__ = false;

Event.observe(window, 'load', initPage);
Event.observe(window, 'unload', cancelTimers);
