<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
    <xsl:template match="/">
        <xsl:apply-templates select="/weather"/>
        <xsl:apply-templates select="/error"/>
    </xsl:template>
    <xsl:template match="weather">
        <div id="weatherData">
            <xsl:apply-templates select="loc"/>
            <xsl:apply-templates select="dayf"/>
        </div>
    </xsl:template>
    <xsl:template match="loc">
        <p class="cityInfo">
            <xsl:value-of select="dnam"/>
            <xsl:text> @ </xsl:text>
            <span id="cityTime"><xsl:value-of select="tm"/></span>
        </p>
    </xsl:template>
    <xsl:template match="dayf">
        <div class="forecast">
            <xsl:for-each select="day">
                <xsl:sort select="@d"/>
                <div class="dayForecast">
                    <span class="dayName"><xsl:value-of select="@t"/></span>
                    <xsl:element name="img">
                        <xsl:attribute name="class">picto</xsl:attribute>
                        <xsl:attribute name="src">icons/<xsl:value-of select="part[@p='d']/icon"/>.png</xsl:attribute>
                        <xsl:if test="part[@p='d']/t != 'N/A'">
                            <xsl:attribute name="alt"><xsl:value-of select="part[@p='d']/t"/></xsl:attribute>
                            <xsl:attribute name="title"><xsl:value-of select="part[@p='d']/t"/></xsl:attribute>
                        </xsl:if>
                    </xsl:element>
                    <span class="temps">
                        <xsl:if test="low != 'N/A'">
                            <xsl:value-of select="low"/>
                        </xsl:if>
                        <xsl:if test="hi != 'N/A'">
                            <xsl:if test="low != 'N/A'">/</xsl:if>
                            <xsl:value-of select="hi"/>
                        </xsl:if>
                        <xsl:if test="hi != 'N/A' or low != 'N/A'">&deg;C</xsl:if>
                    </span>
                </div>
            </xsl:for-each>
        </div>
        <p class="forecastUpdateTime">
            Derni&egrave;re mise &agrave; jour des mesures&nbsp;:
            <span id="latestUpdate"><xsl:value-of select="lsup"/></span>
        </p>
    </xsl:template>
    <xsl:template match="error">
        <p class="error">
            Erreur #<xsl:value-of select="err/@type"/>&nbsp;:
            <xsl:value-of select="err"/>
        </p>
    </xsl:template>
</xsl:stylesheet>
