<?xml version="1.0" encoding="iso-8859-15"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:template match="/">
    <xsl:apply-templates select="/feed"/>
</xsl:template>
<xsl:template match="feed">
    <xsl:call-template name="header"/>
    <xsl:call-template name="body"/>
    <xsl:call-template name="footer"/>
</xsl:template>
<xsl:template name="header">
    <div id="header">
        <h1><xsl:value-of select="title"/></h1>
        <p id="lastBuildDate">
            Derni&egrave;re mise &agrave; jour&nbsp;:
            <span class="timestamp"><xsl:value-of select="updated"/></span>
        </p>
    </div>
</xsl:template>
<xsl:template name="body">
    <dl>
        <xsl:for-each select="entry">
            <xsl:element name="dt">
				<xsl:copy-of select="@xml:lang"/>
				<xsl:element name="a">
					<xsl:attribute name="href"><xsl:value-of select="link[@type='text/html']/@href"/></xsl:attribute>
					<xsl:value-of select="title"/>
				</xsl:element>
				<span class="pubDate">
					&middot;
					<span class="timestamp"><xsl:value-of select="updated"/></span>
				</span>
			</xsl:element>
			<dd>
				<xsl:copy-of select="@xml:lang"/>
				<p class="summary">
					<xsl:value-of select="summary"/>
					<span class="toggler">[
						<xsl:element name="a">
							<xsl:attribute name="href"><xsl:value-of select="link[@type='text/html']/@href"/></xsl:attribute>
							Voir tout l'article
						</xsl:element>
					]</span>
				</p>
				<div class="content" style="display: none">
					<div><xsl:value-of select="content"/></div>
				</div>
			</dd>
        </xsl:for-each>
    </dl>
</xsl:template>
<xsl:template name="footer">
    <p class="footer"><xsl:value-of select="copyright"/></p>
</xsl:template>
</xsl:stylesheet>
