      $set preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set preprocess(htmlpp) stephtml endp

      *>****************************************************************
       identification division.
      *>****************************************************************
           program-id. "compteur".


      *>****************************************************************
       environment division.
      *>****************************************************************

      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the server-side application
      *> without use of the litlink compiler directive.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "compteur.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "compteur.cpy".
      *>----------------------------------------------------------------

      *> Enter additional working-storage items here
       01 datejour pic 9(6).
       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.

      *> Default server-side application code which echoes its input
      *> back to the Browser using the first, or only, output form.
      *> This can be used in prototypes regardless of whether
      *> different forms are used for input and output or not

      *> This code is also suitable for a server-side application which
      *> uses different forms for input and output, where the input form
      *> contains a single submit button and where there is only one
      *> output form.
      *> See the end of this file for advice on handling other cases

      *> If there is no input from the Browser, then initial field
      *> values are output

           perform process-form-input-data
           perform convert-input
           if mf-server-exec = "no"
              perform compteur-ini
           else
               perform process-business-logic
               perform compteur-cvt
           end-if
           perform compteur-out

           exit program
           stop run.

      *>----------------------------------------------------------------
       process-form-input-data section.

           *> Accept the input from the Browser, and check for errors
           perform browser-initialize
           accept htmlform
           exit.

      *>----------------------------------------------------------------
       convert-input section.

           *> Convert numeric input values
           perform input-conversion

           *> Add additional validation here

           if v-all-ok = 0
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       process-business-logic section.
         accept datejour from date.
         if datejour not = compteurdate
            move datejour to compteurdate
            move 1 to compteurcookie
         else
            add 1 to compteurcookie
         end-if
         move compteurcookie to compteur
      *> Add application business logic here. It is recommended that you
      *> place the business logic in a separate module and call it from
      *> this server-side application, possibly as follows
      *>   call "mainprog" using FormFields
      *> using the 'cpy' copybook for this server-side application in
      *> the linkage section of your business logic module
      *>
      *> The benefits are:
      *>  - business processing and presentation logic are kept separate
      *>  - they can therefore be worked on independently
      *>  - the business logic can be Animated if the application is
      *>    moved to a Unix server

           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.

           *> The input conversion routines detected errors so
           *> display a message and stop
           exec html
               :v-first-bad is a numeric field and
               contains an invalid or out of range value,
               please enter a valid value
           end-exec
           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and data conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "compteur.cpv".

      *>----------------------------------------------------------------
      *> ADAPTING THIS SERVER-SIDE APPLICATION TO HANDLE OTHER
      *> INPUT/OUTPUT CONFIGURATIONS
      *>----------------------------------------------------------------
      *> If there are multiple output forms, then you may need to alter
      *> some of the lines
      *>   perform compteur-cvt
      *>
      *>   perform compteur-out
      *>
      *> to select a different output section

      *>----------------------------------------------------------------
      *> If there are multiple submit buttons on the input form
      *> you need to test the text returned by the Browser for the
      *> submit button that was actually clicked, to determine what
      *> action to take.
      *> Remove comments as necessary.
      *>
      *>   perform process-form-input-data
      *>   perform convert-input
      *>   evaluate ssubmit
      *>       when spaces
      *>           *> Add code to initialize an 'empty' form
      *>           perform compteur-cvt
      *>
      *>           perform compteur-out
      *>
      *>       when "Submit1" *> duplicate and edit this line to match
      *>                      *> the captions on your submit buttons
      *>           *> Set flags/parameters for business logic
      *>           *> appropriate for the button that was clicked
      *>           perform process-business-logic
      *>           perform compteur-cvt
      *>
      *>           perform compteur-out
      *>
      *>       when "Submit2" *> duplicate and edit this line to match
      *>                      *> the captions on your submit buttons
      *>           *> Set flags/parameters for business logic
      *>           *> appropriate for the button that was clicked
      *>           perform process-business-logic
      *>           perform compteur-cvt
      *>
      *>           perform compteur-out
      *>
      *>   end-evaluate
      *>   exit program
      *>   stop run.
      *>----------------------------------------------------------------
