      $set preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set preprocess(htmlpp) stephtml endp
      $set sql(dbman=odbc)

      *>***************************************************************
       identification division.
      *>***************************************************************
           program-id. "CCYform".


      *>***************************************************************
       environment division.
      *>***************************************************************

       class-control.
       copy "ClCtrl.cpy".

      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the server-side application
      *> without use of the litlink compiler directive.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.

       copy "ObjRef.cpy".
       copy "UsCtrl.cpy".
       copy "Connect.cpy".
       copy "Ini.cpy".
       copy "Dates.cpy".

       01 TempIdx                      pic 9(5).
       01 TempX20                      pic x(20).
      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "CCYform.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "CCYform.cpy".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Control Area
           exec sql include sqlca end-exec.

      *>----------------------------------------------------------------
      *> The following field receives ESQL error messages wider than the
      *> 70 bytes provided by the SQLCA field SQLERRMC
           01 MFSQLMessageText         pic x(256).
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Descriptor Area
           exec sql include sqlda end-exec.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following record, it contains state
      *> information saved between server-side application invokations
      *>     Session identifier for state maintenance routines
           01 client-id                pic x(30).
      *>     Length of saved state record
           01 client-length            pic xxxx comp-x.
      *>     Status returned by state maintenance routines
           01 server-status            pic x comp-x.
      *>     The state record itself
           01 client-state.
      *>     The fieldname used for ordering rows
             03 s-order-field          pic x(32).
      *>     The fieldname used for filtering rows
             03 s-filter-field         pic x(32).
      *>     The current filter value
             03 s-filter-value         pic x(256).
      *>     The current filter operator
             03 s-filter-op            pic xx.
      *>     The first row displayed to the Browser
             03 first-A-ID             pic S9(9) COMP-5.
             03 first-A-ID-R-LOCALISER pic S9(9) COMP-5.
             03 first-A-ISOCODE        pic X(3).
             03 first-A-NAME           pic X(40).
             03 first-A-DECPOS         pic S9(9) COMP-5.
             03 first-A-UOQ            pic X(4).
             03 first-A-INTBAS         pic X(32).
             03 first-A-EXCHANGE       pic S9(14)v9(4) COMP-3.
             03 first-A-REFCCY         pic S9(9) COMP-5.
             03 first-A-UEMCCY         pic S9(9) COMP-5.
             03 first-A-LAST-USER      pic X(20).
             03 first-A-LAST-MODIFY    pic X(26).
             03 first-A-LAST-VALIDATOR pic X(20).
             03 first-A-LAST-VALIDATE  pic X(26).
             03 first-A-DOWNLOADKEY    pic X(32).
             03 first-A-STATUS         pic X(32).
             03 n-first-A-ID           pic s9(4) comp-5.
             03 n-first-A-ID-R-LOCALISER pic s9(4) comp-5.
             03 n-first-A-ISOCODE      pic s9(4) comp-5.
             03 n-first-A-NAME         pic s9(4) comp-5.
             03 n-first-A-DECPOS       pic s9(4) comp-5.
             03 n-first-A-UOQ          pic s9(4) comp-5.
             03 n-first-A-INTBAS       pic s9(4) comp-5.
             03 n-first-A-EXCHANGE     pic s9(4) comp-5.
             03 n-first-A-REFCCY       pic s9(4) comp-5.
             03 n-first-A-UEMCCY       pic s9(4) comp-5.
             03 n-first-A-LAST-USER    pic s9(4) comp-5.
             03 n-first-A-LAST-MODIFY  pic s9(4) comp-5.
             03 n-first-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-first-A-LAST-VALIDATE pic s9(4) comp-5.
             03 n-first-A-DOWNLOADKEY  pic s9(4) comp-5.
             03 n-first-A-STATUS       pic s9(4) comp-5.
      *>     The last row displayed to the Browser (table view only)
             03 last-A-ID              pic S9(9) COMP-5.
             03 last-A-ID-R-LOCALISER  pic S9(9) COMP-5.
             03 last-A-ISOCODE         pic X(3).
             03 last-A-NAME            pic X(40).
             03 last-A-DECPOS          pic S9(9) COMP-5.
             03 last-A-UOQ             pic X(4).
             03 last-A-INTBAS          pic X(32).
             03 last-A-EXCHANGE        pic S9(14)v9(4) COMP-3.
             03 last-A-REFCCY          pic S9(9) COMP-5.
             03 last-A-UEMCCY          pic S9(9) COMP-5.
             03 last-A-LAST-USER       pic X(20).
             03 last-A-LAST-MODIFY     pic X(26).
             03 last-A-LAST-VALIDATOR  pic X(20).
             03 last-A-LAST-VALIDATE   pic X(26).
             03 last-A-DOWNLOADKEY     pic X(32).
             03 last-A-STATUS          pic X(32).
             03 n-last-A-ID            pic s9(4) comp-5.
             03 n-last-A-ID-R-LOCALISER pic s9(4) comp-5.
             03 n-last-A-ISOCODE       pic s9(4) comp-5.
             03 n-last-A-NAME          pic s9(4) comp-5.
             03 n-last-A-DECPOS        pic s9(4) comp-5.
             03 n-last-A-UOQ           pic s9(4) comp-5.
             03 n-last-A-INTBAS        pic s9(4) comp-5.
             03 n-last-A-EXCHANGE      pic s9(4) comp-5.
             03 n-last-A-REFCCY        pic s9(4) comp-5.
             03 n-last-A-UEMCCY        pic s9(4) comp-5.
             03 n-last-A-LAST-USER     pic s9(4) comp-5.
             03 n-last-A-LAST-MODIFY   pic s9(4) comp-5.
             03 n-last-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-last-A-LAST-VALIDATE pic s9(4) comp-5.
             03 n-last-A-DOWNLOADKEY   pic s9(4) comp-5.
             03 n-last-A-STATUS        pic s9(4) comp-5.
      *>     The field values when the filter was last changed
             03 filter-A-ID            pic S9(9) COMP-5.
             03 filter-A-ID-R-LOCALISER pic S9(9) COMP-5.
             03 filter-A-ISOCODE       pic X(3).
             03 filter-A-NAME          pic X(40).
             03 filter-A-DECPOS        pic S9(9) COMP-5.
             03 filter-A-UOQ           pic X(4).
             03 filter-A-INTBAS        pic X(32).
             03 filter-A-EXCHANGE      pic S9(14)v9(4) COMP-3.
             03 filter-A-REFCCY        pic S9(9) COMP-5.
             03 filter-A-UEMCCY        pic S9(9) COMP-5.
             03 filter-A-LAST-USER     pic X(20).
             03 filter-A-LAST-MODIFY   pic X(26).
             03 filter-A-LAST-VALIDATOR pic X(20).
             03 filter-A-LAST-VALIDATE pic X(26).
             03 filter-A-DOWNLOADKEY   pic X(32).
             03 filter-A-STATUS        pic X(32).
             03 n-filter-A-ID          pic s9(4) comp-5.
             03 n-filter-A-ID-R-LOCALISER pic s9(4) comp-5.
             03 n-filter-A-ISOCODE     pic s9(4) comp-5.
             03 n-filter-A-NAME        pic s9(4) comp-5.
             03 n-filter-A-DECPOS      pic s9(4) comp-5.
             03 n-filter-A-UOQ         pic s9(4) comp-5.
             03 n-filter-A-INTBAS      pic s9(4) comp-5.
             03 n-filter-A-EXCHANGE    pic s9(4) comp-5.
             03 n-filter-A-REFCCY      pic s9(4) comp-5.
             03 n-filter-A-UEMCCY      pic s9(4) comp-5.
             03 n-filter-A-LAST-USER   pic s9(4) comp-5.
             03 n-filter-A-LAST-MODIFY pic s9(4) comp-5.
             03 n-filter-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-filter-A-LAST-VALIDATE pic s9(4) comp-5.
             03 n-filter-A-DOWNLOADKEY pic s9(4) comp-5.
             03 n-filter-A-STATUS      pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following fields, they are used by
      *> the generated SQL data access code
      *>----------------------------------------------------------------
           01 sql-text                 pic x(1024).
           01 sql-index                pic 9(4) comp-5.
           01 where-clause             pic x(1024).
           01 order-clause             pic x(1024).
           01 temp                     pic x(256).
           01 temp-index               pic xxxx comp-5.
           01 stat-index               pic xxxx comp-5.
           01 last-indicator           pic s9(4) comp-5.
           01 i                        pic x(4) comp-5.
           01 target-row               pic S9(15).
           01 filter-field             pic x(32).
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to pass input parameters
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>   Fields to be used in SQL Select statements
           01 selectColumns.
             03 filler pic x(24) value "A.ID, A.ID_R_LOCALISER, ".
             03 filler pic x(19) value "A.ISOCODE, A.NAME, ".
             03 filler pic x(27) value "A.DECPOS, A.UOQ, A.INTBAS, ".
             03 filler pic x(22) value "A.EXCHANGE, A.REFCCY, ".
             03 filler pic x(23) value "A.UEMCCY, A.LAST_USER, ".
             03 filler pic x(15) value "A.LAST_MODIFY, ".
             03 filler pic x(18) value "A.LAST_VALIDATOR, ".
             03 filler pic x(17) value "A.LAST_VALIDATE, ".
             03 filler pic x(23) value "A.DOWNLOADKEY, A.STATUS".
      *>   Fields that are part of the primary key
           01 PrimaryKeyColumns.
             03 filler pic x(05) value "A.ID#".
      *>   Tables to be used in SQL Select statements
           01 selectTables.
             03 filler pic x(07) value "CCY_V A".
      *>   Fields that can be updated
           01 updateColumns.
             03 filler pic x(27) value "A.ID_R_LOCALISER#A.ISOCODE#".
             03 filler pic x(22) value "A.NAME#A.DECPOS#A.UOQ#".
             03 filler pic x(20) value "A.INTBAS#A.EXCHANGE#".
             03 filler pic x(18) value "A.REFCCY#A.UEMCCY#".
             03 filler pic x(26) value "A.LAST_USER#A.LAST_MODIFY#".
             03 filler pic x(17) value "A.LAST_VALIDATOR#".
             03 filler pic x(16) value "A.LAST_VALIDATE#".
             03 filler pic x(23) value "A.DOWNLOADKEY#A.STATUS#".
      *>   Field values for SQL Insert and Update statements
           01 New-SQL-Values.
             03 new-A-ID               pic S9(9) COMP-5.
             03 new-A-ID-R-LOCALISER   pic S9(9) COMP-5.
             03 new-A-ISOCODE          pic X(3).
             03 new-A-NAME             pic X(40).
             03 new-A-DECPOS           pic S9(9) COMP-5.
             03 new-A-UOQ              pic X(4).
             03 new-A-INTBAS           pic X(32).
             03 new-A-EXCHANGE         pic S9(14)v9(4) COMP-3.
             03 new-A-REFCCY           pic S9(9) COMP-5.
             03 new-A-UEMCCY           pic S9(9) COMP-5.
             03 new-A-LAST-USER        pic X(20).
             03 new-A-LAST-MODIFY      pic X(26).
             03 new-A-LAST-VALIDATOR   pic X(20).
             03 new-A-LAST-VALIDATE    pic X(26).
             03 new-A-DOWNLOADKEY      pic X(32).
             03 new-A-STATUS           pic X(32).
             03 n-new-A-ID             pic s9(4) comp-5.
             03 n-new-A-ID-R-LOCALISER pic s9(4) comp-5.
             03 n-new-A-ISOCODE        pic s9(4) comp-5.
             03 n-new-A-NAME           pic s9(4) comp-5.
             03 n-new-A-DECPOS         pic s9(4) comp-5.
             03 n-new-A-UOQ            pic s9(4) comp-5.
             03 n-new-A-INTBAS         pic s9(4) comp-5.
             03 n-new-A-EXCHANGE       pic s9(4) comp-5.
             03 n-new-A-REFCCY         pic s9(4) comp-5.
             03 n-new-A-UEMCCY         pic s9(4) comp-5.
             03 n-new-A-LAST-USER      pic s9(4) comp-5.
             03 n-new-A-LAST-MODIFY    pic s9(4) comp-5.
             03 n-new-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-new-A-LAST-VALIDATE  pic s9(4) comp-5.
             03 n-new-A-DOWNLOADKEY    pic s9(4) comp-5.
             03 n-new-A-STATUS         pic s9(4) comp-5.
      *>   Contains the name of the field being processed
           01 field-name               pic x(40).
      *>   Operator used for positioning within select rows.
      *>   Will be ">=" for Next, "<=" for Prev
      *>   and "??" (meaning no where clause needed for positioning)
      *>   for First and Last
           01 search-op                pic xx.
      *>   Ordering specification, null terminated.
      *>   Wiil be empty for First and Next and DESC for Last and Prev
           01 sort-spec                pic x(8).
      *>   Holds the name of the column to order by
           01 order-field              pic x(32).
      *>   The name of the file used to store server state
           01 state-filename           pic x(255)
               value "MF-STATE-SAVE.DAT".
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to return results from
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>      Status of last SQL statement executed
           01 sql-status               pic 9.
               88 sql-ok                 value 0.
               88 no-data                value 1.
               88 sql-error              value 2.
      *>      Result of field comparison routines
           01 order-status             pic s9.
               88 IsLess               value -1.
               88 IsEqual              value 0.
               88 IsGreater            value +1.
      *>      Partial result of field comparison - order field only
           01 find-status              pic s9.
               88 foundLess            value -1.
               88 foundEqual           value 0.
               88 foundGreater         value +1.
      *>      Result of state mainenance routine call
           01 state-status             pic x comp-x.
      *>      SQL Indicator variables for last SQL statement executed
           01 SQL-Indicators.
             03 n-A-ID                 pic s9(4) comp-5.
             03 n-A-ID-R-LOCALISER     pic s9(4) comp-5.
             03 n-A-ISOCODE            pic s9(4) comp-5.
             03 n-A-NAME               pic s9(4) comp-5.
             03 n-A-DECPOS             pic s9(4) comp-5.
             03 n-A-UOQ                pic s9(4) comp-5.
             03 n-A-INTBAS             pic s9(4) comp-5.
             03 n-A-EXCHANGE           pic s9(4) comp-5.
             03 n-A-REFCCY             pic s9(4) comp-5.
             03 n-A-UEMCCY             pic s9(4) comp-5.
             03 n-A-LAST-USER          pic s9(4) comp-5.
             03 n-A-LAST-MODIFY        pic s9(4) comp-5.
             03 n-A-LAST-VALIDATOR     pic s9(4) comp-5.
             03 n-A-LAST-VALIDATE      pic s9(4) comp-5.
             03 n-A-DOWNLOADKEY        pic s9(4) comp-5.
             03 n-A-STATUS             pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *> Enter additional working-storage items here

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.

           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Access" using UsCtrlStruct

           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           invoke DatesRef "Finalize" returning DatesRef


           call "sstate"
           call "MF_CLIENT_STATE_FILE"
               using state-filename server-status

           perform process-form-input-data
           if f-Action = "Inserer" or "Modifier" or "Query"
              initialize A-ID-R-LOCALISER
              if f-Localselect(1) <> spaces then
                  move f-Localselect(1) to TempX20

                  EXEC SQL
                      SELECT A.ID
                      INTO :A-ID-R-LOCALISER
                      FROM CTY_V A
                      WHERE A.SHORTNAME = :TempX20
                  END-EXEC

                  if sqlcode <> 0 then
                     move f-A-ID-R-LOCALISER to A-ID-R-LOCALISER
                     move "Selected city has been modified by another us
      -    "er" to frmesStatus
                     perform convert-input
                     perform combo
                     perform ccyform-cvt
                     perform ccyform-out
                     stop run
                  end-if

                  move A-ID-R-LOCALISER to f-A-ID-R-LOCALISER
              else
                  initialize f-A-ID-R-LOCALISER
              end-if
              *> unit of quotation
              move f-uoqselect(1) to f-A-UOQ
              *> interest basis
              move f-baseselect(1) to f-A-INTBAS
           end-if

           perform set-sql-nulls
           perform convert-input
           perform translate-combos
           perform restore-state
           perform sql-start
           evaluate Action
               when "First"
                   perform do-first
               when "Previous"
                   perform do-previous
               when "Next"
                   perform do-next
               when "Last"
                   perform do-last
               when "Insert record"
                   perform do-insert
               when "Update record"
                   perform do-update
               when "Delete record"
                   perform do-delete

              when "Validate record"
                  perform do-validate

               when "Query"
                   perform do-find
               when "Clear screen"
                   perform do-clear
               when other
                   if client-id = spaces
                       perform do-default-operation
                   else
                       perform do-first-from-table
                   end-if
           end-evaluate

           perform combo


           perform save-state
           perform setup-controls
           perform ccyform-cvt

           perform blank-sql-nulls
           perform ccyform-out

           perform sql-finish
           exit program
           stop run.

      *>----------------------------------------------------------------
       combo section.

           *> fill the City Combo Box
           EXEC SQL
               SELECT A.SHORTNAME
               INTO :localselect
               FROM CTY_V A
               WHERE A.STATUS = 'Valid'
               ORDER BY A.SHORTNAME
            END-EXEC

           move sqlerrd(3) to c-localselect

           *> get the item to be selected
           if A-ID-R-LOCALISER <> 0
              EXEC SQL
                   SELECT A.SHORTNAME
                   INTO :TempX20
                   FROM CTY_V A
                   WHERE ( A.ID = :A-ID-R-LOCALISER )
              END-EXEC
              perform varying TempIdx from 1 by 1 until
                              TempIdx > c-localselect
                if localselect(TempIdx) >= TempX20
                   if localselect(TempIdx) > TempX20
                       add 1 to c-localselect
                       move TempX20 to
                            localselect(c-localselect)
                       move 1 to i-localselect(c-localselect)
                   else
                       move 1 to i-localselect(TempIdx)
                   end-if
                   exit perform
                end-if
              end-perform
           end-if


           *> fill the Unit of Quotation  Combo Box
           move "0001" to uoqselect(1)
           move "0010" to uoqselect(2)
           move "0100" to uoqselect(3)
           move "1000" to uoqselect(4)
           move 4 to c-uoqselect
           if A-UOQ <> spaces then
              perform varying TempIdx from 1 by 1 until
                              TempIdx > c-uoqselect
              if uoqselect(TempIdx) = A-UOQ
                  move 1 to i-uoqselect(TempIdx)
                  exit perform
              end-if
              end-perform
           end-if

           *> fill the Interest basis combo-box
           move "360 jours" to baseselect(1)
           move "365 jours" to baseselect(2)
           move 2 to c-baseselect
           if A-INTBAS <> spaces then
              perform varying TempIdx from 1 by 1 until
                              TempIdx > c-baseselect
              if baseselect(TempIdx) = A-INTBAS
                  move 1 to i-baseselect(TempIdx)
                  exit perform
              end-if
              end-perform
           end-if

           exit.


      *>----------------------------------------------------------------
       base-sql section.

           exec sql
               declare sql_cursor cursor for dyna_stat
           end-exec
           exit.

      *>----------------------------------------------------------------
       sql-start section.

           *> Initialise the sql session
      *    exec sql
      *      connect to 'eurecas' user 'admin'
      *    end-exec
      *    if sqlcode not = 0
      *        exec html
      *            <br><br><em>
      *            There was an error connecting to the
      *              database.<br><br>
      *            SQLSTATE = :sqlstate<br><br>
      *            SQL Error Message = :MFSQLMessageText<br><br>
      *            </em>
      *            </body>
      *            </html>
      *        end-exec
      *        exit program
      *        stop run
      *    end-if

           *> Initialise variables
           move 0 to target-row
           move spaces to frmesStatus
           move 1 to stat-index
           move OrderBy(1) to order-field

           *> Initialise filtering control variables
           move FilterBy(1) to filter-field
           if filter-field = spaces
               if client-id = spaces
                   move "(none)" to filter-field
               else
                   move "(existing)" to filter-field
               end-if
           end-if

           *> We use != in Browser to avoid special HTML chars
           *> Convert to SQL 'not equal' if necessary
           if c-FilterType > 0
               move FilterType(1) to s-filter-op
               if s-filter-op = "!="
                   move "<>" to s-filter-op
               end-if
           end-if

           *> If filter field has changed, save filter value
           *> for status line
           if filter-field not = "(existing)"
               perform save-filter
               move filter-field to s-filter-field

               if s-filter-field not = '(none)'
                   evaluate s-filter-field
                       when "A.ID"
                           move f-A-ID to s-filter-value
                       when "A.ID_R_LOCALISER"
                           move f-A-ID-R-LOCALISER to s-filter-value
                       when "A.ISOCODE"
                           move f-A-ISOCODE to s-filter-value
                       when "A.NAME"
                           move f-A-NAME to s-filter-value
                       when "A.DECPOS"
                           move f-A-DECPOS to s-filter-value
                       when "A.UOQ"
                           move f-A-UOQ to s-filter-value
                       when "A.INTBAS"
                           move f-A-INTBAS to s-filter-value
                       when "A.EXCHANGE"
                           move f-A-EXCHANGE to s-filter-value
                       when "A.REFCCY"
                           move f-A-REFCCY to s-filter-value
                       when "A.UEMCCY"
                           move f-A-UEMCCY to s-filter-value
                       when "A.LAST_USER"
                           move f-A-LAST-USER to s-filter-value
                       when "A.LAST_MODIFY"
                           move f-A-LAST-MODIFY to s-filter-value
                       when "A.LAST_VALIDATOR"
                           move f-A-LAST-VALIDATOR to s-filter-value
                       when "A.LAST_VALIDATE"
                           move f-A-LAST-VALIDATE to s-filter-value
                       when "A.DOWNLOADKEY"
                           move f-A-DOWNLOADKEY to s-filter-value
                       when "A.STATUS"
                           move f-A-STATUS to s-filter-value
                   end-evaluate

                   perform varying i from length s-filter-value by -1
                           until i = 0
                       if s-filter-value(i:1) = space
                           move x"0" to s-filter-value(i:1)
                       else
                           exit perform
                       end-if
                   end-perform

                   if s-filter-value(1:1)=x"0"
                       move z"(empty)" to s-filter-value
                   end-if
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-finish section.

           *> Finalise SQL session
           exec sql disconnect end-exec
           exit.

      *>----------------------------------------------------------------
       do-sql-query section.

           *> Build dynamic SQL query for current order and filter
           *> settings, then prepare it
           move spaces to sql-text
           move 0 to sqld sqln
           move 1 to sql-index
           move low-values to where-clause order-clause

           if order-field = spaces
               *> Default to 1st primary key field
               move "A.ID" to order-field
           end-if

           if search-op not = '??'
               *> For next, prev and find add the order field
               *> to the where clause
               move order-field to field-name
               perform sql-add-param
           end-if

           if (s-filter-field not = "(none)")
               move s-filter-field to field-name
               perform sql-add-filter-param
           end-if


           move 1 to sql-index
           move order-field to field-name
           perform trim-field-name
           string
               field-name delimited x"0"
               sort-spec delimited x"0"
           into order-clause pointer sql-index

           *> Append primary key columns that are not the order field
           *> to the order clause to guarantee a unique row order
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform trim-field-name
               string
                   ", " delimited size
                   field-name delimited x"0"
                   sort-spec delimited x"0"
               into order-clause pointer sql-index
           end-perform

           move 1 to sql-index,
           string
               "select " delimited size
               selectColumns delimited size
               " from "  delimited size
               selectTables delimited size
               where-clause delimited x"0"
               " order by " delimited size
               order-clause delimited x"0"
               x"0" delimited size
           into sql-text pointer sql-index

           exec sql
                   prepare dyna_stat from :sql-text
           end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error processing this request.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               exit program
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-add-param section.

           *> Add field-name as a parameter to the where clause
           *> for positioning purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of A-ID to sqllen(sqln)
                   set sqldata(sqln) to address of A-ID
                   set sqlind(sqln) to address of n-A-ID
                   move n-A-ID to last-indicator
                 when "A.ID_R_LOCALISER"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of A-ID-R-LOCALISER to sqllen(sqln)
                   set sqldata(sqln) to address of A-ID-R-LOCALISER
                   set sqlind(sqln) to address of n-A-ID-R-LOCALISER
                   move n-A-ID-R-LOCALISER to last-indicator
                 when "A.ISOCODE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-ISOCODE to sqllen(sqln)
                   set sqldata(sqln) to address of A-ISOCODE
                   set sqlind(sqln) to address of n-A-ISOCODE
                   move n-A-ISOCODE to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of A-NAME
                   set sqlind(sqln) to address of n-A-NAME
                   move n-A-NAME to last-indicator
                 when "A.DECPOS"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of A-DECPOS to sqllen(sqln)
                   set sqldata(sqln) to address of A-DECPOS
                   set sqlind(sqln) to address of n-A-DECPOS
                   move n-A-DECPOS to last-indicator
                 when "A.UOQ"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-UOQ to sqllen(sqln)
                   set sqldata(sqln) to address of A-UOQ
                   set sqlind(sqln) to address of n-A-UOQ
                   move n-A-UOQ to last-indicator
                 when "A.INTBAS"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-INTBAS to sqllen(sqln)
                   set sqldata(sqln) to address of A-INTBAS
                   set sqlind(sqln) to address of n-A-INTBAS
                   move n-A-INTBAS to last-indicator
                 when "A.EXCHANGE"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = (004 * 256) + 018
                   set sqldata(sqln) to address of A-EXCHANGE
                   set sqlind(sqln) to address of n-A-EXCHANGE
                   move n-A-EXCHANGE to last-indicator
                 when "A.REFCCY"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of A-REFCCY to sqllen(sqln)
                   set sqldata(sqln) to address of A-REFCCY
                   set sqlind(sqln) to address of n-A-REFCCY
                   move n-A-REFCCY to last-indicator
                 when "A.UEMCCY"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of A-UEMCCY to sqllen(sqln)
                   set sqldata(sqln) to address of A-UEMCCY
                   set sqlind(sqln) to address of n-A-UEMCCY
                   move n-A-UEMCCY to last-indicator
                 when "A.LAST_USER"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-USER to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-USER
                   set sqlind(sqln) to address of n-A-LAST-USER
                   move n-A-LAST-USER to last-indicator
                 when "A.LAST_MODIFY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-MODIFY to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-MODIFY
                   set sqlind(sqln) to address of n-A-LAST-MODIFY
                   move n-A-LAST-MODIFY to last-indicator
                 when "A.LAST_VALIDATOR"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-VALIDATOR to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-VALIDATOR
                   set sqlind(sqln) to address of n-A-LAST-VALIDATOR
                   move n-A-LAST-VALIDATOR to last-indicator
                 when "A.LAST_VALIDATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-VALIDATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-VALIDATE
                   set sqlind(sqln) to address of n-A-LAST-VALIDATE
                   move n-A-LAST-VALIDATE to last-indicator
                 when "A.DOWNLOADKEY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-DOWNLOADKEY to sqllen(sqln)
                   set sqldata(sqln) to address of A-DOWNLOADKEY
                   set sqlind(sqln) to address of n-A-DOWNLOADKEY
                   move n-A-DOWNLOADKEY to last-indicator
                 when "A.STATUS"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-STATUS to sqllen(sqln)
                   set sqldata(sqln) to address of A-STATUS
                   set sqlind(sqln) to address of n-A-STATUS
                   move n-A-STATUS to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If we specify 'is [not] null'
               *> we'll exclude rows from the result set that we may
               *> need to step through. All we can do is exclude
               *> the field from the where clause.
               *> The moral is that for large tables it's best to
               *> disallow ordering on nullable columns.
               subtract 1 from sqld sqln
               exit section
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           string
               field-name delimited x"0"
               search-op delimited size
               " ?" delimited size
           into where-clause pointer sql-index
           exit.

      *>----------------------------------------------------------------
       sql-add-filter-param section.

           *> Add field-name as a parameter to the where clause
           *> for filtering purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of filter-A-ID to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-ID
                   set sqlind(sqln) to address of n-filter-A-ID
                   move n-filter-A-ID to last-indicator
                 when "A.ID_R_LOCALISER"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of filter-A-ID-R-LOCALISER to
                     sqllen(sqln)
                   set sqldata(sqln) to address of
                     filter-A-ID-R-LOCALISER
                   set sqlind(sqln) to address of
                     n-filter-A-ID-R-LOCALISER
                   move n-filter-A-ID-R-LOCALISER to last-indicator
                 when "A.ISOCODE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-ISOCODE to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-ISOCODE
                   set sqlind(sqln) to address of n-filter-A-ISOCODE
                   move n-filter-A-ISOCODE to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-NAME
                   set sqlind(sqln) to address of n-filter-A-NAME
                   move n-filter-A-NAME to last-indicator
                 when "A.DECPOS"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of filter-A-DECPOS to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-DECPOS
                   set sqlind(sqln) to address of n-filter-A-DECPOS
                   move n-filter-A-DECPOS to last-indicator
                 when "A.UOQ"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-UOQ to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-UOQ
                   set sqlind(sqln) to address of n-filter-A-UOQ
                   move n-filter-A-UOQ to last-indicator
                 when "A.INTBAS"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-INTBAS to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-INTBAS
                   set sqlind(sqln) to address of n-filter-A-INTBAS
                   move n-filter-A-INTBAS to last-indicator
                 when "A.EXCHANGE"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = (004 * 256) + 018
                   set sqldata(sqln) to address of filter-A-EXCHANGE
                   set sqlind(sqln) to address of n-filter-A-EXCHANGE
                   move n-filter-A-EXCHANGE to last-indicator
                 when "A.REFCCY"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of filter-A-REFCCY to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-REFCCY
                   set sqlind(sqln) to address of n-filter-A-REFCCY
                   move n-filter-A-REFCCY to last-indicator
                 when "A.UEMCCY"
                   move ESQL-INTEGER-NULL to sqltype(sqln)
                   move length of filter-A-UEMCCY to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-UEMCCY
                   set sqlind(sqln) to address of n-filter-A-UEMCCY
                   move n-filter-A-UEMCCY to last-indicator
                 when "A.LAST_USER"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-USER to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-USER
                   set sqlind(sqln) to address of n-filter-A-LAST-USER
                   move n-filter-A-LAST-USER to last-indicator
                 when "A.LAST_MODIFY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-MODIFY to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-MODIFY
                   set sqlind(sqln) to address of n-filter-A-LAST-MODIFY
                   move n-filter-A-LAST-MODIFY to last-indicator
                 when "A.LAST_VALIDATOR"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-VALIDATOR to
                     sqllen(sqln)
                   set sqldata(sqln) to address of
                     filter-A-LAST-VALIDATOR
                   set sqlind(sqln) to address of
                     n-filter-A-LAST-VALIDATOR
                   move n-filter-A-LAST-VALIDATOR to last-indicator
                 when "A.LAST_VALIDATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-VALIDATE to sqllen(sqln)
                   set sqldata(sqln) to address of
                     filter-A-LAST-VALIDATE
                   set sqlind(sqln) to address of
                     n-filter-A-LAST-VALIDATE
                   move n-filter-A-LAST-VALIDATE to last-indicator
                 when "A.DOWNLOADKEY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-DOWNLOADKEY to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-DOWNLOADKEY
                   set sqlind(sqln) to address of n-filter-A-DOWNLOADKEY
                   move n-filter-A-DOWNLOADKEY to last-indicator
                 when "A.STATUS"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-STATUS to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-STATUS
                   set sqlind(sqln) to address of n-filter-A-STATUS
                   move n-filter-A-STATUS to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If the filter operator is
               *> equals or not equals we will deal with it later.
               *> Otherwise the field must be excluded because
               *> all we can do with nulls is equals and not equals
               *> and this might exclude rows that we might need to
               *> step through
               if s-filter-op = "<=" or ">="
                   subtract 1 from sqld sqln
                   exit section
               end-if
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           if last-indicator >= 0
               string
                   field-name delimited x"0"
                   s-filter-op delimited size
                   " ?" delimited size
               into where-clause pointer sql-index
           else
               *> Deal with null values. These require different
               *> SQL syntax
               subtract 1 from sqld sqln
               if s-filter-op = "="
                   string
                       field-name delimited x"0"
                       ' IS NULL' delimited size
                   into where-clause pointer sql-index
               else
                   string
                       field-name delimited x"0"
                       ' IS NOT NULL' delimited size
                   into where-clause pointer sql-index
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       trim-field-name section.

           *> Null terminate field-name and trim trailing spaces
           move length field-name to i
           perform until i = 0 or field-name(i:1) not = space
               move x"0" to field-name(i:1)
               subtract 1 from i
           end-perform
           exit.

      *>----------------------------------------------------------------
       sql-open section.

           *> Open a cursor to retrieve the query results
           exec sql open sql_cursor using descriptor :sqlda end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error opening a SQL cursor.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               exit program
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-fetch section.

           *> Get the next row from the query result set.
           *> Set the status to sql-ok, no-data or sql-error
           *> Terminate with error message if sql-error
           exec sql
             fetch sql_cursor into
                   :A-ID:n-A-ID,
                   :A-ID-R-LOCALISER:n-A-ID-R-LOCALISER,
                   :A-ISOCODE:n-A-ISOCODE,
                   :A-NAME:n-A-NAME,
                   :A-DECPOS:n-A-DECPOS,
                   :A-UOQ:n-A-UOQ,
                   :A-INTBAS:n-A-INTBAS,
                   :A-EXCHANGE:n-A-EXCHANGE,
                   :A-REFCCY:n-A-REFCCY,
                   :A-UEMCCY:n-A-UEMCCY,
                   :A-LAST-USER:n-A-LAST-USER,
                   :A-LAST-MODIFY:n-A-LAST-MODIFY,
                   :A-LAST-VALIDATOR:n-A-LAST-VALIDATOR,
                   :A-LAST-VALIDATE:n-A-LAST-VALIDATE,
                   :A-DOWNLOADKEY:n-A-DOWNLOADKEY,
                   :A-STATUS:n-A-STATUS
           end-exec

           set sql-ok to true

           if sqlcode = 100
               set no-data to true
               exec sql close sql_cursor end-exec
               initialize A-ID
               initialize A-ID-R-LOCALISER
               initialize A-ISOCODE
               initialize A-NAME
               initialize A-DECPOS
               initialize A-UOQ
               initialize A-INTBAS
               initialize A-EXCHANGE
               initialize A-REFCCY
               initialize A-UEMCCY
               initialize A-LAST-USER
               initialize A-LAST-MODIFY
               initialize A-LAST-VALIDATOR
               initialize A-LAST-VALIDATE
               initialize A-DOWNLOADKEY
               initialize A-STATUS
           end-if

           if sqlcode < 0
               set sql-error to true
               exec html
                   <br><br><em>
                   There was an error retrieving query results.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               exit program
               stop run
           end-if

           if sql-ok
               *> Blank out fields where the database returned a null
               perform init-sql-nulls
           end-if
           exit.

      *>----------------------------------------------------------------
       finish-sql-query section.

           *> Finalise the current query
           exec sql close sql_cursor end-exec
           exit.

      *>----------------------------------------------------------------
       do-first-from-table section.

           *> Get the row the user selected in table view. If it has
           *> been deleted by another user, get the next row in the
           *> current ordering

           *> Retrieve the 'row-numer in table' parameter passed in the
           *> hyperlink.
           move function numval(Action) to target-row
           *> Get the ordering from the saved server state
           move s-order-field to order-field

           *> Restore field values for 1st row in table and
           *> position to it
           perform restore-first
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> There may be duplicate order field values,
           *> so skip rows until we're at or beyond the row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform

           *> Check that the filter hasn't excluded all rows
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> Step through rows until we get to the one we need
           *> or we've read all the selected rows
           subtract 1 from target-row
           perform until target-row <= 0 or no-data
              perform sql-fetch
              subtract 1 from target-row
           end-perform

           *> Tidy up and deal with the case where we ran out of data
           *> becuase rows were deleted by other users
           perform finish-sql-query
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-first section.

           *> Output 1st row
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-next section.

           *> Output next row
           move ">=" to search-op
           move low-values to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicate order field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
               perform sql-fetch
           end-if
           perform finish-sql-query

           *> If end of data reached, wrap round to start
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-previous section.

           *> Output previous row
           move "<=" to search-op
           move z" desc " to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicates order field values,
           *> so skip rows until we're at or before the last row
           *> or out of rows
           set IsGreater to true
           perform until not IsGreater
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
              perform sql-fetch
           end-if
           perform finish-sql-query

           *> If start of data reached, wrap round to end
           if no-data
               move
          "Start of table reached, position reset to last record"
                to frmesStatus
               perform do-last
           end-if
           exit.

      *>----------------------------------------------------------------
       do-last section.

           *> Output last row
           move "??" to search-op
           move z" desc " to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-insert section.

            *> user control
            invoke UsCtrlRef "Ins" using UsCtrlStruct
            if UsCtrlMsg <> spaces
               exit section
            end-if

            move UsCtrlStatus to A-STATUS
            move UsCtrlShortname to A-LAST-USER
            initialize n-A-STATUS n-A-LAST-USER n-A-LAST-MODIFY



           *> Insert a new row
           exec sql
             insert into CCY_V
               (ID_R_LOCALISER, ISOCODE, NAME, DECPOS, UOQ, INTBAS,
                 EXCHANGE, REFCCY, UEMCCY, LAST_USER, LAST_MODIFY,
                 LAST_VALIDATOR, LAST_VALIDATE, DOWNLOADKEY, STATUS)
             values (
               :A-ID-R-LOCALISER,
               :A-ISOCODE,
               :A-NAME,
               :A-DECPOS,
               :A-UOQ,
               :A-INTBAS,
               :A-EXCHANGE,
               :A-REFCCY,
               :A-UEMCCY,
               :A-LAST-USER:n-A-LAST-USER,
               :yyyy-mm-dd-hhmnss:n-A-LAST-MODIFY,
               NULL,
               NULL,
               :A-DOWNLOADKEY:n-A-DOWNLOADKEY,
               :A-STATUS)
           end-exec


           if sqlcode not = 0
               move
                  'Insert failed, possibly due to data duplication'
                   to frmesStatus
               exec sql rollback end-exec
           else
               *> Reset ordering and filtering to avoid confusion
               *> if the new row is excluded from the selected
               *> row set
               exec sql commit end-exec
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform save-first
               perform do-re-read
               move "New record inserted successfully" to frmesStatus
           end-if
           exit.

      *>----------------------------------------------------------------
       do-update section.

           *> Update the last row output

           *> Check that there are some columns the user is allowed to
           *> update
           if updateColumns = spaces
               perform restore-first
               perform do-re-read
               move "There are no updatable columns on this form"
                   to frmesStatus
               exit section
           end-if

           *> Check that this isn't an attempt to update the primary
           *> key
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Primary Key fields may not be updated"
                   to frmesStatus
               exit section
           end-if

           *> Save new values and retrieve old row. This checks that
           *> row is still there, and should be enough for most servers
           *> to lock the row until the update is complete
           move A-ID to new-A-ID
           move n-A-ID to n-new-A-ID
           move A-ID-R-LOCALISER to new-A-ID-R-LOCALISER
           move n-A-ID-R-LOCALISER to n-new-A-ID-R-LOCALISER
           move A-ISOCODE to new-A-ISOCODE
           move n-A-ISOCODE to n-new-A-ISOCODE
           move A-NAME to new-A-NAME
           move n-A-NAME to n-new-A-NAME
           move A-DECPOS to new-A-DECPOS
           move n-A-DECPOS to n-new-A-DECPOS
           move A-UOQ to new-A-UOQ
           move n-A-UOQ to n-new-A-UOQ
           move A-INTBAS to new-A-INTBAS
           move n-A-INTBAS to n-new-A-INTBAS
           move A-EXCHANGE to new-A-EXCHANGE
           move n-A-EXCHANGE to n-new-A-EXCHANGE
           move A-REFCCY to new-A-REFCCY
           move n-A-REFCCY to n-new-A-REFCCY
           move A-UEMCCY to new-A-UEMCCY
           move n-A-UEMCCY to n-new-A-UEMCCY
           move A-LAST-USER to new-A-LAST-USER
           move n-A-LAST-USER to n-new-A-LAST-USER
           move A-LAST-MODIFY to new-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-new-A-LAST-MODIFY
           move A-LAST-VALIDATOR to new-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-new-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to new-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-new-A-LAST-VALIDATE
           move A-DOWNLOADKEY to new-A-DOWNLOADKEY
           move n-A-DOWNLOADKEY to n-new-A-DOWNLOADKEY
           move A-STATUS to new-A-STATUS
           move n-A-STATUS to n-new-A-STATUS

           perform Restore-First

           perform do-re-read
           if no-data
               move
                   "The row has been deleted by another user"
                   to frmesStatus
               exit section
           else
               perform compare-key-to-first
               if not IsEqual
                   move
                       "The row has been deleted by another user"
                   to frmesStatus
               exit section
           end-if

           *> Chech that the row hasn't changed since it was output
           *> last time
           perform compare-updatable-to-first
           if not IsEqual
               perform do-re-read
               move
          "This row has been updated by another user - please try again"
                   to frmesStatus
               exit section
           end-if

           *> User control
           invoke UsCtrlRef "Upd" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-USER
           initialize n-new-A-STATUS
                      n-new-A-LAST-USER n-new-A-LAST-MODIFY


           *> All OK, so do the update
           exec sql
             update CCY_V set
               ID_R_LOCALISER = :new-A-ID-R-LOCALISER,
               ISOCODE = :new-A-ISOCODE,
               NAME = :new-A-NAME,
               DECPOS = :new-A-DECPOS,
               UOQ = :new-A-UOQ,
               INTBAS = :new-A-INTBAS,
               EXCHANGE = :new-A-EXCHANGE,
               REFCCY = :new-A-REFCCY,
               UEMCCY = :new-A-UEMCCY,
               LAST_USER = :new-A-LAST-USER
                           :n-new-A-LAST-USER,
               LAST_MODIFY = :yyyy-mm-dd-hhmnss
                             :n-new-A-LAST-MODIFY,
               LAST_VALIDATOR = NULL,
               LAST_VALIDATE = NULL,
               DOWNLOADKEY = :new-A-DOWNLOADKEY
                             :n-new-A-DOWNLOADKEY,
               STATUS = :new-A-STATUS
             where ID = :new-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                       move
                   "No record to update, it may have been deleted"
                       to frmesStatus
                   exec sql rollback end-exec
               else
                   move MFSQLMessageText to frmesStatus
                   exec sql rollback end-exec
               end-if
           else
               *> Reset ordering and filtering to avoid confusion
               *> if the row is now excluded from the selected
               *> row set. Commit the update first
               exec sql commit end-exec
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform save-first
               perform do-re-read
               move "Record updated successfully" to frmesStatus
           end-if
           exit.

      *>----------------------------------------------------------------
       do-delete section.

           *> Delete the last row output

           *> First check that the user isn't trying to delete a
           *> different row
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Only the current record may be deleted"
                   to frmesStatus
               exit section
           end-if

           *> User control
           move first-A-STATUS to UsCtrlStatus
           invoke UsCtrlRef "Del" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-USER
           initialize n-new-A-STATUS
                      n-new-A-LAST-USER n-new-A-LAST-MODIFY


           *> Delete the row
      *    exec sql
      *      delete from CCY_V where ID = :first-A-ID
      *    end-exec

           *> Delete the row (update)
           exec sql
             update CCY_V set
             STATUS = :new-A-STATUS,
             LAST_USER = :new-A-LAST-USER:n-new-A-LAST-USER,
             LAST_MODIFY = :yyyy-mm-dd-hhmnss:n-new-A-LAST-MODIFY,
             LAST_VALIDATE = NULL,
             LAST_VALIDATOR = NULL
             where ID = :first-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                   move
                       "No record to delete,  " &
                       "it may have been deleted by another user"
                     to frmesStatus
                   initialize A-ID
                   initialize A-ID-R-LOCALISER
                   initialize A-ISOCODE
                   initialize A-NAME
                   initialize A-DECPOS
                   initialize A-UOQ
                   initialize A-INTBAS
                   initialize A-EXCHANGE
                   initialize A-REFCCY
                   initialize A-UEMCCY
                   initialize A-LAST-USER
                   initialize A-LAST-MODIFY
                   initialize A-LAST-VALIDATOR
                   initialize A-LAST-VALIDATE
                   initialize A-DOWNLOADKEY
                   initialize A-STATUS
                   exec sql rollback end-exec
               else
                   move MFSQLMessageText to frmesStatus
                   exec sql rollback end-exec
               end-if
           else
               *> Commit the change and step on to next row
               exec sql commit end-exec
               perform do-re-read
               move "Record deleted successfully" to frmesStatus
           end-if
           exit.

      *>---------------------------------------------------------------
       do-validate section.


           *> First check that the user isn't trying to delete a
           *> different row
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Only the current record may be validated"
                   to frmesStatus
               exit section
           end-if

           *> User control
           move first-A-STATUS to UsCtrlStatus
           invoke UsCtrlRef "Val" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-USER
           initialize n-new-A-STATUS
                      n-new-A-LAST-VALIDATOR n-new-A-LAST-VALIDATE



           *> Validate the row
           exec sql
             update CCY_V set
             STATUS = :new-A-STATUS,
         LAST_VALIDATOR = :new-A-LAST-VALIDATOR:n-new-A-LAST-VALIDATOR,
             LAST_VALIDATE = :yyyy-mm-dd-hhmnss:n-new-A-LAST-VALIDATE,
             where ID = :first-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                   move
                       "No record to validate,  " &
                       "it may have been deleted by another user"
                     to frmesStatus
                   initialize A-ID
                   initialize A-ID-R-LOCALISER
                   initialize A-ISOCODE
                   initialize A-NAME
                   initialize A-DECPOS
                   initialize A-UOQ
                   initialize A-INTBAS
                   initialize A-EXCHANGE
                   initialize A-REFCCY
                   initialize A-UEMCCY
                   initialize A-LAST-USER
                   initialize A-LAST-MODIFY
                   initialize A-LAST-VALIDATOR
                   initialize A-LAST-VALIDATE
                   initialize A-DOWNLOADKEY
                   initialize A-STATUS
                   exec sql rollback end-exec
               else
                   move MFSQLMessageText to frmesStatus
                   exec sql rollback end-exec
               end-if
           else
               *> Commit the change and step on to next row
               exec sql commit end-exec
               perform do-re-read
               move "Record validated successfully" to frmesStatus
           end-if
           exit.

      *>----------------------------------------------------------------
       do-clear section.

           *> Clear the form
           initialize A-ID
           initialize A-ID-R-LOCALISER
           initialize A-ISOCODE
           initialize A-NAME
           initialize A-DECPOS
           initialize A-UOQ
           initialize A-INTBAS
           initialize A-EXCHANGE
           initialize A-REFCCY
           initialize A-UEMCCY
           initialize A-LAST-USER
           initialize A-LAST-MODIFY
           initialize A-LAST-VALIDATOR
           initialize A-LAST-VALIDATE
           initialize A-DOWNLOADKEY
           initialize A-STATUS
           exit.

      *>----------------------------------------------------------------
       do-default-operation section.

           *> On initial entry, set order field to 1st primary key
           *> column, no filtering and output 1st row
           move "A.ID" to order-field
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-find section.

           *> Position to the row with order field >= the value input
           *> by the user. If this is an empty value, position to 1st
           *> row
           move ">=" to search-op
           move low-values to sort-spec
           evaluate order-field
                 when "A.ID"
                   if f-A-ID = spaces
                       move "??" to search-op
                   end-if
                 when "A.ID_R_LOCALISER"
                   if f-A-ID-R-LOCALISER = spaces
                       move "??" to search-op
                   end-if
                 when "A.ISOCODE"
                   if f-A-ISOCODE = spaces
                       move "??" to search-op
                   end-if
                 when "A.NAME"
                   if f-A-NAME = spaces
                       move "??" to search-op
                   end-if
                 when "A.DECPOS"
                   if f-A-DECPOS = spaces
                       move "??" to search-op
                   end-if
                 when "A.UOQ"
                   if f-A-UOQ = spaces
                       move "??" to search-op
                   end-if
                 when "A.INTBAS"
                   if f-A-INTBAS = spaces
                       move "??" to search-op
                   end-if
                 when "A.EXCHANGE"
                   if f-A-EXCHANGE = spaces
                       move "??" to search-op
                   end-if
                 when "A.REFCCY"
                   if f-A-REFCCY = spaces
                       move "??" to search-op
                   end-if
                 when "A.UEMCCY"
                   if f-A-UEMCCY = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_USER"
                   if f-A-LAST-USER = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_MODIFY"
                   if f-A-LAST-MODIFY = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_VALIDATOR"
                   if f-A-LAST-VALIDATOR = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_VALIDATE"
                   if f-A-LAST-VALIDATE = spaces
                       move "??" to search-op
                   end-if
                 when "A.DOWNLOADKEY"
                   if f-A-DOWNLOADKEY = spaces
                       move "??" to search-op
                   end-if
                 when "A.STATUS"
                   if f-A-STATUS = spaces
                       move "??" to search-op
                   end-if
           end-evaluate
           if search-op = ">="
               perform save-first
           end-if
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           perform finish-sql-query

           *> If there are no suitable rows, output the last row,
           *> if there is one
           if no-data
               perform do-last
               if not no-data
                   perform setup-status
                   string
                       " - positioned at end" delimited size
                   into frmesStatus pointer stat-index
               end-if
           else
               *> Inform the user what happened
               perform setup-status
               if search-op = "??"
                   *> Empty search value, so we're on the 1st row
                   string
                       " - positioned at start" delimited size
                   into frmesStatus pointer stat-index
               else
                   *> Compare order field and the user's value
                   perform compare-to-first
                   if foundEqual
                       string
                           " - positioned where requested"
                               delimited size
                       into frmesStatus pointer stat-index
                   else
                       string
                           " - positioned at next match"
                               delimited size
                       into frmesStatus pointer stat-index
                   end-if
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       do-re-read section.

           *> Re-read current row, allowing for the possibility
           *> that it may no longer exist
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> There may be duplicate field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       init-sql-nulls section.

           *> Initialize working fields where the server has returned
           *>a null
           if n-A-ID < 0
             initialize A-ID
           end-if
           if n-A-ID-R-LOCALISER < 0
             initialize A-ID-R-LOCALISER
           end-if
           if n-A-ISOCODE < 0
             initialize A-ISOCODE
           end-if
           if n-A-NAME < 0
             initialize A-NAME
           end-if
           if n-A-DECPOS < 0
             initialize A-DECPOS
           end-if
           if n-A-UOQ < 0
             initialize A-UOQ
           end-if
           if n-A-INTBAS < 0
             initialize A-INTBAS
           end-if
           if n-A-EXCHANGE < 0
             initialize A-EXCHANGE
           end-if
           if n-A-REFCCY < 0
             initialize A-REFCCY
           end-if
           if n-A-UEMCCY < 0
             initialize A-UEMCCY
           end-if
           if n-A-LAST-USER < 0
             initialize A-LAST-USER
           end-if
           if n-A-LAST-MODIFY < 0
             initialize A-LAST-MODIFY
           end-if
           if n-A-LAST-VALIDATOR < 0
             initialize A-LAST-VALIDATOR
           end-if
           if n-A-LAST-VALIDATE < 0
             initialize A-LAST-VALIDATE
           end-if
           if n-A-DOWNLOADKEY < 0
             initialize A-DOWNLOADKEY
           end-if
           if n-A-STATUS < 0
             initialize A-STATUS
           end-if
           exit.

      *>----------------------------------------------------------------
       set-sql-nulls section.

           *> Set SQL Indicator variable for nullable fields where the
           *> input from the Browser is blank and the SpacesAsNull
           *> attribute is set
           if f-A-ID = spaces
             move -1 to n-A-ID
           else
             move 0 to n-A-ID
           end-if
           if f-A-ID-R-LOCALISER = spaces
             move -1 to n-A-ID-R-LOCALISER
           else
             move 0 to n-A-ID-R-LOCALISER
           end-if
           if f-A-ISOCODE = spaces
             move -1 to n-A-ISOCODE
           else
             move 0 to n-A-ISOCODE
           end-if
           if f-A-NAME = spaces
             move -1 to n-A-NAME
           else
             move 0 to n-A-NAME
           end-if
           if f-A-DECPOS = spaces
             move -1 to n-A-DECPOS
           else
             move 0 to n-A-DECPOS
           end-if
           if f-A-UOQ = spaces
             move -1 to n-A-UOQ
           else
             move 0 to n-A-UOQ
           end-if
           if f-A-INTBAS = spaces
             move -1 to n-A-INTBAS
           else
             move 0 to n-A-INTBAS
           end-if
           if f-A-EXCHANGE = spaces
             move -1 to n-A-EXCHANGE
           else
             move 0 to n-A-EXCHANGE
           end-if
           if f-A-REFCCY = spaces
             move -1 to n-A-REFCCY
           else
             move 0 to n-A-REFCCY
           end-if
           if f-A-UEMCCY = spaces
             move -1 to n-A-UEMCCY
           else
             move 0 to n-A-UEMCCY
           end-if
           if f-A-LAST-USER = spaces
             move -1 to n-A-LAST-USER
           else
             move 0 to n-A-LAST-USER
           end-if
           if f-A-LAST-MODIFY = spaces
             move -1 to n-A-LAST-MODIFY
           else
             move 0 to n-A-LAST-MODIFY
           end-if
           if f-A-LAST-VALIDATOR = spaces
             move -1 to n-A-LAST-VALIDATOR
           else
             move 0 to n-A-LAST-VALIDATOR
           end-if
           if f-A-LAST-VALIDATE = spaces
             move -1 to n-A-LAST-VALIDATE
           else
             move 0 to n-A-LAST-VALIDATE
           end-if
           if f-A-DOWNLOADKEY = spaces
             move -1 to n-A-DOWNLOADKEY
           else
             move 0 to n-A-DOWNLOADKEY
           end-if
           if f-A-STATUS = spaces
             move -1 to n-A-STATUS
           else
             move 0 to n-A-STATUS
           end-if
           exit.

      *>----------------------------------------------------------------
       blank-sql-nulls section.

           *> Set Browser fields to spaces for nullable fields where
           *> the server has returned a null and the SpacesAsNull
           *> attribute is set
           if n-A-ID < 0
             move spaces to f-A-ID
           end-if
           if n-A-ID-R-LOCALISER < 0
             move spaces to f-A-ID-R-LOCALISER
           end-if
           if n-A-ISOCODE < 0
             move spaces to f-A-ISOCODE
           end-if
           if n-A-NAME < 0
             move spaces to f-A-NAME
           end-if
           if n-A-DECPOS < 0
             move spaces to f-A-DECPOS
           end-if
           if n-A-UOQ < 0
             move spaces to f-A-UOQ
           end-if
           if n-A-INTBAS < 0
             move spaces to f-A-INTBAS
           end-if
           if n-A-EXCHANGE < 0
             move spaces to f-A-EXCHANGE
           end-if
           if n-A-REFCCY < 0
             move spaces to f-A-REFCCY
           end-if
           if n-A-UEMCCY < 0
             move spaces to f-A-UEMCCY
           end-if
           if n-A-LAST-USER < 0
             move spaces to f-A-LAST-USER
           end-if
           if n-A-LAST-MODIFY < 0
             move spaces to f-A-LAST-MODIFY
           end-if
           if n-A-LAST-VALIDATOR < 0
             move spaces to f-A-LAST-VALIDATOR
           end-if
           if n-A-LAST-VALIDATE < 0
             move spaces to f-A-LAST-VALIDATE
           end-if
           if n-A-DOWNLOADKEY < 0
             move spaces to f-A-DOWNLOADKEY
           end-if
           if n-A-STATUS < 0
             move spaces to f-A-STATUS
           end-if
           exit.

      *>----------------------------------------------------------------
       save-filter section.

           *> Save current field values for use in filtering
           move A-ID to filter-A-ID
           move n-A-ID to n-filter-A-ID
           move A-ID-R-LOCALISER to filter-A-ID-R-LOCALISER
           move n-A-ID-R-LOCALISER to n-filter-A-ID-R-LOCALISER
           move A-ISOCODE to filter-A-ISOCODE
           move n-A-ISOCODE to n-filter-A-ISOCODE
           move A-NAME to filter-A-NAME
           move n-A-NAME to n-filter-A-NAME
           move A-DECPOS to filter-A-DECPOS
           move n-A-DECPOS to n-filter-A-DECPOS
           move A-UOQ to filter-A-UOQ
           move n-A-UOQ to n-filter-A-UOQ
           move A-INTBAS to filter-A-INTBAS
           move n-A-INTBAS to n-filter-A-INTBAS
           move A-EXCHANGE to filter-A-EXCHANGE
           move n-A-EXCHANGE to n-filter-A-EXCHANGE
           move A-REFCCY to filter-A-REFCCY
           move n-A-REFCCY to n-filter-A-REFCCY
           move A-UEMCCY to filter-A-UEMCCY
           move n-A-UEMCCY to n-filter-A-UEMCCY
           move A-LAST-USER to filter-A-LAST-USER
           move n-A-LAST-USER to n-filter-A-LAST-USER
           move A-LAST-MODIFY to filter-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-filter-A-LAST-MODIFY
           move A-LAST-VALIDATOR to filter-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-filter-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to filter-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-filter-A-LAST-VALIDATE
           move A-DOWNLOADKEY to filter-A-DOWNLOADKEY
           move n-A-DOWNLOADKEY to n-filter-A-DOWNLOADKEY
           move A-STATUS to filter-A-STATUS
           move n-A-STATUS to n-filter-A-STATUS
           exit.

      *>----------------------------------------------------------------
       save-first section.

           *> Save current field values for future use
           move A-ID to first-A-ID
           move n-A-ID to n-first-A-ID
           move A-ID-R-LOCALISER to first-A-ID-R-LOCALISER
           move n-A-ID-R-LOCALISER to n-first-A-ID-R-LOCALISER
           move A-ISOCODE to first-A-ISOCODE
           move n-A-ISOCODE to n-first-A-ISOCODE
           move A-NAME to first-A-NAME
           move n-A-NAME to n-first-A-NAME
           move A-DECPOS to first-A-DECPOS
           move n-A-DECPOS to n-first-A-DECPOS
           move A-UOQ to first-A-UOQ
           move n-A-UOQ to n-first-A-UOQ
           move A-INTBAS to first-A-INTBAS
           move n-A-INTBAS to n-first-A-INTBAS
           move A-EXCHANGE to first-A-EXCHANGE
           move n-A-EXCHANGE to n-first-A-EXCHANGE
           move A-REFCCY to first-A-REFCCY
           move n-A-REFCCY to n-first-A-REFCCY
           move A-UEMCCY to first-A-UEMCCY
           move n-A-UEMCCY to n-first-A-UEMCCY
           move A-LAST-USER to first-A-LAST-USER
           move n-A-LAST-USER to n-first-A-LAST-USER
           move A-LAST-MODIFY to first-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-first-A-LAST-MODIFY
           move A-LAST-VALIDATOR to first-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-first-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to first-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-first-A-LAST-VALIDATE
           move A-DOWNLOADKEY to first-A-DOWNLOADKEY
           move n-A-DOWNLOADKEY to n-first-A-DOWNLOADKEY
           move A-STATUS to first-A-STATUS
           move n-A-STATUS to n-first-A-STATUS
           exit.

      *>----------------------------------------------------------------
       restore-first section.

           *> Restore the 1st row output last time in table view,
           *> or last row output in form view
           move first-A-ID to A-ID
           move n-first-A-ID to n-A-ID
           move first-A-ID-R-LOCALISER to A-ID-R-LOCALISER
           move n-first-A-ID-R-LOCALISER to n-A-ID-R-LOCALISER
           move first-A-ISOCODE to A-ISOCODE
           move n-first-A-ISOCODE to n-A-ISOCODE
           move first-A-NAME to A-NAME
           move n-first-A-NAME to n-A-NAME
           move first-A-DECPOS to A-DECPOS
           move n-first-A-DECPOS to n-A-DECPOS
           move first-A-UOQ to A-UOQ
           move n-first-A-UOQ to n-A-UOQ
           move first-A-INTBAS to A-INTBAS
           move n-first-A-INTBAS to n-A-INTBAS
           move first-A-EXCHANGE to A-EXCHANGE
           move n-first-A-EXCHANGE to n-A-EXCHANGE
           move first-A-REFCCY to A-REFCCY
           move n-first-A-REFCCY to n-A-REFCCY
           move first-A-UEMCCY to A-UEMCCY
           move n-first-A-UEMCCY to n-A-UEMCCY
           move first-A-LAST-USER to A-LAST-USER
           move n-first-A-LAST-USER to n-A-LAST-USER
           move first-A-LAST-MODIFY to A-LAST-MODIFY
           move n-first-A-LAST-MODIFY to n-A-LAST-MODIFY
           move first-A-LAST-VALIDATOR to A-LAST-VALIDATOR
           move n-first-A-LAST-VALIDATOR to n-A-LAST-VALIDATOR
           move first-A-LAST-VALIDATE to A-LAST-VALIDATE
           move n-first-A-LAST-VALIDATE to n-A-LAST-VALIDATE
           move first-A-DOWNLOADKEY to A-DOWNLOADKEY
           move n-first-A-DOWNLOADKEY to n-A-DOWNLOADKEY
           move first-A-STATUS to A-STATUS
           move n-first-A-STATUS to n-A-STATUS
           exit.

      *>----------------------------------------------------------------
       save-state section.

           *> Save state for next call, initialising the state file
           *> if this is the first call of the session
           move order-field to s-order-field
           perform save-first
           move length of client-state to client-length
           move frmehstate to client-id
           if client-id = spaces
               call "MF_CLIENT_STATE_ALLOCATE"
                   using client-id client-length state-status
               move client-id to frmehstate
           end-if
           call "MF_CLIENT_STATE_SAVE"
               using client-id client-state client-length state-status
           exit.

      *>----------------------------------------------------------------
       restore-state section.

           *> Resore state from last call, if there was a last call
           move frmehstate to client-id
           if client-id not = spaces
               move length of client-state to client-length
               call "MF_CLIENT_STATE_RESTORE"
                   using client-id client-state client-length
                       state-status
           end-if
           exit.

      *>----------------------------------------------------------------
       setup-controls section.

           *> Set up data for HTML Select controls
           move "ID" to OrderBy(001)
           move "ID_R_LOCALISER" to OrderBy(002)
           move "ISOCODE" to OrderBy(003)
           move "NAME" to OrderBy(004)
           move "DECPOS" to OrderBy(005)
           move "UOQ" to OrderBy(006)
           move "INTBAS" to OrderBy(007)
           move "EXCHANGE" to OrderBy(008)
           move "REFCCY" to OrderBy(009)
           move "UEMCCY" to OrderBy(010)
           move "LAST_USER" to OrderBy(011)
           move "LAST_MODIFY" to OrderBy(012)
           move "LAST_VALIDATOR" to OrderBy(013)
           move "LAST_VALIDATE" to OrderBy(014)
           move "DOWNLOADKEY" to OrderBy(015)
           move "STATUS" to OrderBy(016)
           move 016 to c-OrderBy

           evaluate order-field
             when spaces
             when "A.ID"
               move 1 to i-OrderBy(001)
             when "A.ID_R_LOCALISER"
               move 1 to i-OrderBy(002)
             when "A.ISOCODE"
               move 1 to i-OrderBy(003)
             when "A.NAME"
               move 1 to i-OrderBy(004)
             when "A.DECPOS"
               move 1 to i-OrderBy(005)
             when "A.UOQ"
               move 1 to i-OrderBy(006)
             when "A.INTBAS"
               move 1 to i-OrderBy(007)
             when "A.EXCHANGE"
               move 1 to i-OrderBy(008)
             when "A.REFCCY"
               move 1 to i-OrderBy(009)
             when "A.UEMCCY"
               move 1 to i-OrderBy(010)
             when "A.LAST_USER"
               move 1 to i-OrderBy(011)
             when "A.LAST_MODIFY"
               move 1 to i-OrderBy(012)
             when "A.LAST_VALIDATOR"
               move 1 to i-OrderBy(013)
             when "A.LAST_VALIDATE"
               move 1 to i-OrderBy(014)
             when "A.DOWNLOADKEY"
               move 1 to i-OrderBy(015)
             when "A.STATUS"
               move 1 to i-OrderBy(016)
           end-evaluate

           move "(none)" to FilterBy(001)
           move "(existing)" to FilterBy(002)
           move "ID" to FilterBy(003)
           move "ID_R_LOCALISER" to FilterBy(004)
           move "ISOCODE" to FilterBy(005)
           move "NAME" to FilterBy(006)
           move "DECPOS" to FilterBy(007)
           move "UOQ" to FilterBy(008)
           move "INTBAS" to FilterBy(009)
           move "EXCHANGE" to FilterBy(010)
           move "REFCCY" to FilterBy(011)
           move "UEMCCY" to FilterBy(012)
           move "LAST_USER" to FilterBy(013)
           move "LAST_MODIFY" to FilterBy(014)
           move "LAST_VALIDATOR" to FilterBy(015)
           move "LAST_VALIDATE" to FilterBy(016)
           move "DOWNLOADKEY" to FilterBy(017)
           move "STATUS" to FilterBy(018)
           move 018 to c-FilterBy

           if s-filter-field = spaces or "(none)"
               move 1 to i-FilterBy(1)
           else
               move 1 to i-FilterBy(2)
           end-if

           move 6 to c-FilterType
           move "<" to FilterType(1)
           move "<=" to FilterType(2)
           move "=" to FilterType(3)
           move "!=" to FilterType(4)
           move ">=" to FilterType(5)
           move ">" to FilterType(6)

           evaluate s-filter-op
               when "<"
                   move 1 to i-FilterType(1)
               when "<="
                   move 1 to i-FilterType(2)
               when spaces
               when "="
                   move 1 to i-FilterType(3)
               when "<>"
                   move 1 to i-FilterType(4)
               when  ">="
                   move 1 to i-FilterType(5)
               when  ">"
                   move 1 to i-FilterType(6)
           end-evaluate
           perform setup-status
           exit.

      *>----------------------------------------------------------------
       setup-status section.

           *> Setup status line
           if frmesStatus not = spaces
               exit section
           end-if

           if s-filter-field not = '(none)'
               if s-filter-op = '<>'
                   move '!=' to s-filter-op
               end-if

               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", filtering on " delimited size
                   s-filter-field(3:) delimited space
                   " " delimited size
                   s-filter-op delimited size
                  " " delimited size
                   s-filter-value delimited x"0"
               into frmesStatus pointer stat-index

               if s-filter-op = '!='
                   move '<>' to s-filter-op
               end-if

           else
               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", with no filtering " delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       translate-combos section.

           *> Pre-process data returned by HTML Select controls
           evaluate OrderBy(1)
             when "ID"
               move "A.ID" to OrderBy(1)
             when "ID_R_LOCALISER"
               move "A.ID_R_LOCALISER" to OrderBy(1)
             when "ISOCODE"
               move "A.ISOCODE" to OrderBy(1)
             when "NAME"
               move "A.NAME" to OrderBy(1)
             when "DECPOS"
               move "A.DECPOS" to OrderBy(1)
             when "UOQ"
               move "A.UOQ" to OrderBy(1)
             when "INTBAS"
               move "A.INTBAS" to OrderBy(1)
             when "EXCHANGE"
               move "A.EXCHANGE" to OrderBy(1)
             when "REFCCY"
               move "A.REFCCY" to OrderBy(1)
             when "UEMCCY"
               move "A.UEMCCY" to OrderBy(1)
             when "LAST_USER"
               move "A.LAST_USER" to OrderBy(1)
             when "LAST_MODIFY"
               move "A.LAST_MODIFY" to OrderBy(1)
             when "LAST_VALIDATOR"
               move "A.LAST_VALIDATOR" to OrderBy(1)
             when "LAST_VALIDATE"
               move "A.LAST_VALIDATE" to OrderBy(1)
             when "DOWNLOADKEY"
               move "A.DOWNLOADKEY" to OrderBy(1)
             when "STATUS"
               move "A.STATUS" to OrderBy(1)
           end-evaluate

           evaluate FilterBy(1)
             when "ID"
               move "A.ID" to FilterBy(1)
             when "ID_R_LOCALISER"
               move "A.ID_R_LOCALISER" to FilterBy(1)
             when "ISOCODE"
               move "A.ISOCODE" to FilterBy(1)
             when "NAME"
               move "A.NAME" to FilterBy(1)
             when "DECPOS"
               move "A.DECPOS" to FilterBy(1)
             when "UOQ"
               move "A.UOQ" to FilterBy(1)
             when "INTBAS"
               move "A.INTBAS" to FilterBy(1)
             when "EXCHANGE"
               move "A.EXCHANGE" to FilterBy(1)
             when "REFCCY"
               move "A.REFCCY" to FilterBy(1)
             when "UEMCCY"
               move "A.UEMCCY" to FilterBy(1)
             when "LAST_USER"
               move "A.LAST_USER" to FilterBy(1)
             when "LAST_MODIFY"
               move "A.LAST_MODIFY" to FilterBy(1)
             when "LAST_VALIDATOR"
               move "A.LAST_VALIDATOR" to FilterBy(1)
             when "LAST_VALIDATE"
               move "A.LAST_VALIDATE" to FilterBy(1)
             when "DOWNLOADKEY"
               move "A.DOWNLOADKEY" to FilterBy(1)
             when "STATUS"
               move "A.STATUS" to FilterBy(1)
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       compare-to-first section.

           *> Compare current order field values with the
           *> corresponding 'first-' values
           move order-field to field-name
           perform compare-field-to-first
           move order-status to find-status
           if not IsEqual
               exit section
           end-if

           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-key-to-first section.

           *> Compare current primary key field values with the
           *> corresponding 'first-' values
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.
      *>----------------------------------------------------------------
       compare-updatable-to-first section.

           *> Compare current updateable field values with the
           *> corresponding 'first-' values
           move UpdateColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-field-to-first section.

           *> Compare the field (whose name is in field-name)
           *> with the corresponding 'first-' value
           evaluate field-name
               when "A.ID"
                 if A-ID > first-A-ID
                   set IsGreater to true
                 else
                   if A-ID < first-A-ID
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ID_R_LOCALISER"
                 if A-ID-R-LOCALISER > first-A-ID-R-LOCALISER
                   set IsGreater to true
                 else
                   if A-ID-R-LOCALISER < first-A-ID-R-LOCALISER
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ISOCODE"
                 if A-ISOCODE > first-A-ISOCODE
                   set IsGreater to true
                 else
                   if A-ISOCODE < first-A-ISOCODE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NAME"
                 if A-NAME > first-A-NAME
                   set IsGreater to true
                 else
                   if A-NAME < first-A-NAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.DECPOS"
                 if A-DECPOS > first-A-DECPOS
                   set IsGreater to true
                 else
                   if A-DECPOS < first-A-DECPOS
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.UOQ"
                 if A-UOQ > first-A-UOQ
                   set IsGreater to true
                 else
                   if A-UOQ < first-A-UOQ
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.INTBAS"
                 if A-INTBAS > first-A-INTBAS
                   set IsGreater to true
                 else
                   if A-INTBAS < first-A-INTBAS
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.EXCHANGE"
                 if A-EXCHANGE > first-A-EXCHANGE
                   set IsGreater to true
                 else
                   if A-EXCHANGE < first-A-EXCHANGE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.REFCCY"
                 if A-REFCCY > first-A-REFCCY
                   set IsGreater to true
                 else
                   if A-REFCCY < first-A-REFCCY
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.UEMCCY"
                 if A-UEMCCY > first-A-UEMCCY
                   set IsGreater to true
                 else
                   if A-UEMCCY < first-A-UEMCCY
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_USER"
                 if A-LAST-USER > first-A-LAST-USER
                   set IsGreater to true
                 else
                   if A-LAST-USER < first-A-LAST-USER
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_MODIFY"
                 if A-LAST-MODIFY > first-A-LAST-MODIFY
                   set IsGreater to true
                 else
                   if A-LAST-MODIFY < first-A-LAST-MODIFY
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_VALIDATOR"
                 if A-LAST-VALIDATOR > first-A-LAST-VALIDATOR
                   set IsGreater to true
                 else
                   if A-LAST-VALIDATOR < first-A-LAST-VALIDATOR
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_VALIDATE"
                 if A-LAST-VALIDATE > first-A-LAST-VALIDATE
                   set IsGreater to true
                 else
                   if A-LAST-VALIDATE < first-A-LAST-VALIDATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.DOWNLOADKEY"
                 if A-DOWNLOADKEY > first-A-DOWNLOADKEY
                   set IsGreater to true
                 else
                   if A-DOWNLOADKEY < first-A-DOWNLOADKEY
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.STATUS"
                 if A-STATUS > first-A-STATUS
                   set IsGreater to true
                 else
                   if A-STATUS < first-A-STATUS
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       process-form-input-data section.
           *> Accept the input from the Browser, and check for errors
           perform browser-initialize
           accept htmlform
           if HTMLForm = spaces
               move z"no" to MF-SERVER-EXEC
           else
               move z"yes" to MF-SERVER-EXEC
           end-if
           exit.

      *>----------------------------------------------------------------
       convert-input section.

           move function UPPER-CASE(f-A-ISOCODE) to f-A-ISOCODE


           perform input-conversion

           *> field validation
           if Action = "Insert record" or "Update record" then
               if A-NAME = spaces
                   move "A_NAME" to v-first-bad
                   perform output-form-error-and-stop
               end-if
           end-if

           if v-all-ok = 0

               inspect v-first-bad replacing all "-" by "_"

               perform output-form-error-and-stop
           end-if


           if v-all-ok = 0
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           *> The input conversion routines detected errors so
           *> display a message and stop
      *    exec html
      *        :v-first-bad is a numeric field and
      *        contains an invalid or out of range value,
      *        please enter a valid value
      *    end-exec

           perform setup-controls
           perform combo

           evaluate v-first-bad
             when "A_NAME"
                move "Nom devise." to frmesStatus
             when other
                string v-first-bad delimited by space
                       "."
                into frmesStatus
           end-evaluate

           if v-all-ok = 0
               string frmesStatus delimited by "."
                      " is a numeric field and has an invalid value."
               into frmesStatus
           else
               string frmesStatus delimited by "."
                      " is a required field."
               into frmesStatus
           end-if

           perform ccyform-cvt
           perform ccyform-out

           exec HTML
               <SCRIPT>
               document.FORM1.:v-first-bad .focus();
               alert(":frmesStatus");
               </SCRIPT>
           end-exec


           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "CCYform.cpv".
      *>----------------------------------------------------------------
