// Create a Cookie (only if it doesn't exist)
function CreateCookie (name,value) {
   var argv = CreateCookie.arguments;
   var argc = CreateCookie.arguments.length;
   var expires = (argc > 2) ? argv[2] : null;
   var path    = (argc > 3) ? argv[3] : null;
   var domain  = (argc > 4) ? argv[4] : null;
   var secure  = (argc > 5) ? argv[5] : false;

   if (GetCookie(name)) {
       return;
   }
   else {
       SetCookie(name,value,expires,path,domain,secure);
   }
} 

// Set (and create if it doesn't exist) a Cookie
// Expiry date (if specified) must be of the form dd,mm,yyyy
function SetCookie (name, value) {
   var argv = SetCookie.arguments;
   var argc = SetCookie.arguments.length;
   if (argc > 2) {
        if (argv[2] != null) {
            var index1 = argv[2].indexOf(",");
            if (index1 != -1){
                var yyyy = parseInt(argv[2].substring(0,index1));
                index1 = index1 + 1
                var index2 = argv[2].lastIndexOf(",");
                if (index2 != -1){ 
                        var mm = parseInt(argv[2].substring(index1,index2));
                        mm = mm - 1;
                        index2 = index2 + 1;
                        var dd = parseInt(argv[2].substring(index2));
                        var expires = new Date(yyyy,mm,dd);
                }
            }  
        }
   }
   var path    = (argc > 3) ? argv[3] : null;
   var domain  = (argc > 4) ? argv[4] : null;
   var secure  = (argc > 5) ? argv[5] : false;

   var temp = name + "=" + escape(value) +
   ((expires == null) ? "" : ("; expires=" + expires.toGMTString())) +
   ((path == null)    ? "" : ("; path=" + path)) +
   ((domain == null)  ? "" : ("; domain=" + domain)) +
   ((secure == true)  ? "; secure" : "");
   document.cookie=temp;
}

// Delete a Cookie
function DeleteCookie (name,path,domain) {
   if (GetCookie(name)) {
     document.cookie = name + "=" +
       ((path)   ? "; path=" + path : "") +
       ((domain) ? "; domain=" + domain : "") +
       "; expires=Thu, 01-Jan-70 00:00:01 GMT";
   }
}

// Get Cookie function
function GetCookie(name) {
   var arg = name+"=";
   var alen = arg.length;
   var clen = document.cookie.length;
   var i = 0;

   while (i < clen) {
      var j = i + alen;
      if (document.cookie.substring(i, j) == arg) return getCookieVal(j);
      i = document.cookie.indexOf(" ", i) + 1;
      if (i == 0) break;
   }
   return null;
}

// Get Cookie Value function
function getCookieVal(offset) {
   var endstr = document.cookie.indexOf (";", offset);
   if (endstr == -1) endstr = document.cookie.length;
   return unescape (document.cookie.substring(offset, endstr));
}

