      $set preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set preprocess(htmlpp) stephtml endp
      *set sql(dbman=odbc)

      *>***************************************************************
       identification division.
      *>***************************************************************
           program-id. "Chpform".


      *>***************************************************************
       environment division.
      *>***************************************************************
       class-control.
       copy "ClCtrl.cpy".

      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the CGI without use of the litlink
      *> compiler directive.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.
            copy "ObjRef.cpy".
            copy "UsCtrl.cpy".
            copy "Toc-Tab.cpy".
            copy "Dates.cpy".
       01 FetchTemp                     pic x(254).
       01 Slave-Url                     pic x(254).
       01 BeginUrl                      pic 9(4).
       01 EndUrl                        pic 9(4).
       01 Empty                         pic x(50) value all ".".
       01 TempIdx                       pic 9(05).
       01 NbrTab                        pic 9(2).
      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "Chpform.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "Chpform.cpy".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Control Area
           exec sql include sqlca end-exec.

      *>----------------------------------------------------------------
      *> The following field receives ESQL error messages wider than the
      *> 70 bytes provided by the SQLCA field SQLERRMC
           01 MFSQLMessageText         pic x(256).
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Descriptor Area
           exec sql include sqlda end-exec.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following record, it contains
      *> state information saved between CGI invokations
      *>     Session identifier for state maintenance routines
           01 client-id                pic x(30).
      *>     Length of saved state record
           01 client-length            pic xxxx comp-x.
      *>     Status returned by state maintenance routines
           01 server-status            pic x comp-x.
      *>     The state record itself
           01 client-state.
      *>     The fieldname used for ordering rows
             03 s-order-field          pic x(32).
      *>     The fieldname used for filtering rows
             03 s-filter-field         pic x(32).
      *>     The current filter value
             03 s-filter-value         pic x(256).
      *>     The current filter operator
             03 s-filter-op            pic xx.
      *>     The first row displayed to the Browser
             03 first-A-ID             pic S9(12) COMP-3.
             03 first-A-ID-IS-IN-CHAPTER pic S9(12) COMP-3.
             03 first-A-STATUS         pic X(32).
             03 first-A-SEQ-NBR        pic S9(2) COMP-3.
             03 first-A-HYPER-LINK     pic X(254).
             03 first-A-MASTER-URL     pic X(254).
             03 first-A-SLAVE-URL      pic X(254).
             03 first-A-IMG-SRC        pic X(254).
             03 first-A-LINE-NR        pic S9(1) COMP-3.
             03 first-A-TAB-NR         pic S9(1) COMP-3.
             03 first-A-CRITICAL       pic X(5).
             03 first-A-LAST-USER      pic X(20).
             03 first-A-LAST-MODIFY    pic X(26).
             03 first-A-LAST-VALIDATOR pic X(20).
             03 first-A-LAST-VALIDATE  pic X(26).
             03 n-first-A-ID-IS-IN-CHAPTER pic s9(4) comp-5.
             03 n-first-A-MASTER-URL   pic s9(4) comp-5.
             03 n-first-A-SLAVE-URL    pic s9(4) comp-5.
             03 n-first-A-IMG-SRC      pic s9(4) comp-5.
             03 n-first-A-LINE-NR      pic s9(4) comp-5.
             03 n-first-A-TAB-NR       pic s9(4) comp-5.
             03 n-first-A-CRITICAL     pic s9(4) comp-5.
             03 n-first-A-LAST-USER    pic s9(4) comp-5.
             03 n-first-A-LAST-MODIFY  pic s9(4) comp-5.
             03 n-first-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-first-A-LAST-VALIDATE pic s9(4) comp-5.
      *>     The last row displayed to the Browser (table view only)
             03 last-A-ID              pic S9(12) COMP-3.
             03 last-A-ID-IS-IN-CHAPTER pic S9(12) COMP-3.
             03 last-A-STATUS          pic X(32).
             03 last-A-SEQ-NBR         pic S9(2) COMP-3.
             03 last-A-HYPER-LINK      pic X(254).
             03 last-A-MASTER-URL      pic X(254).
             03 last-A-SLAVE-URL       pic X(254).
             03 last-A-IMG-SRC         pic X(254).
             03 last-A-LINE-NR         pic S9(1) COMP-3.
             03 last-A-TAB-NR          pic S9(1) COMP-3.
             03 last-A-CRITICAL        pic X(5).
             03 last-A-LAST-USER       pic X(20).
             03 last-A-LAST-MODIFY     pic X(26).
             03 last-A-LAST-VALIDATOR  pic X(20).
             03 last-A-LAST-VALIDATE   pic X(26).
             03 n-last-A-ID-IS-IN-CHAPTER pic s9(4) comp-5.
             03 n-last-A-MASTER-URL    pic s9(4) comp-5.
             03 n-last-A-SLAVE-URL     pic s9(4) comp-5.
             03 n-last-A-IMG-SRC       pic s9(4) comp-5.
             03 n-last-A-LINE-NR       pic s9(4) comp-5.
             03 n-last-A-TAB-NR        pic s9(4) comp-5.
             03 n-last-A-CRITICAL      pic s9(4) comp-5.
             03 n-last-A-LAST-USER     pic s9(4) comp-5.
             03 n-last-A-LAST-MODIFY   pic s9(4) comp-5.
             03 n-last-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-last-A-LAST-VALIDATE pic s9(4) comp-5.
      *>     The field values when the filter was last changed
             03 filter-A-ID            pic S9(12) COMP-3.
             03 filter-A-ID-IS-IN-CHAPTER pic S9(12) COMP-3.
             03 filter-A-STATUS        pic X(32).
             03 filter-A-SEQ-NBR       pic S9(2) COMP-3.
             03 filter-A-HYPER-LINK    pic X(254).
             03 filter-A-MASTER-URL    pic X(254).
             03 filter-A-SLAVE-URL     pic X(254).
             03 filter-A-IMG-SRC       pic X(254).
             03 filter-A-LINE-NR       pic S9(1) COMP-3.
             03 filter-A-TAB-NR        pic S9(1) COMP-3.
             03 filter-A-CRITICAL      pic X(5).
             03 filter-A-LAST-USER     pic X(20).
             03 filter-A-LAST-MODIFY   pic X(26).
             03 filter-A-LAST-VALIDATOR pic X(20).
             03 filter-A-LAST-VALIDATE pic X(26).
             03 n-filter-A-ID-IS-IN-CHAPTER pic s9(4) comp-5.
             03 n-filter-A-MASTER-URL  pic s9(4) comp-5.
             03 n-filter-A-SLAVE-URL   pic s9(4) comp-5.
             03 n-filter-A-IMG-SRC     pic s9(4) comp-5.
             03 n-filter-A-LINE-NR     pic s9(4) comp-5.
             03 n-filter-A-TAB-NR      pic s9(4) comp-5.
             03 n-filter-A-CRITICAL    pic s9(4) comp-5.
             03 n-filter-A-LAST-USER   pic s9(4) comp-5.
             03 n-filter-A-LAST-MODIFY pic s9(4) comp-5.
             03 n-filter-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-filter-A-LAST-VALIDATE pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following fields, they are used by
      *> the generated SQL data access code
      *>----------------------------------------------------------------
           01 sql-text                 pic x(1024).
           01 sql-index                pic 9(4) comp-5.
           01 where-clause             pic x(1024).
           01 order-clause             pic x(1024).
           01 temp                     pic x(256).
           01 temp-index               pic xxxx comp-5.
           01 stat-index               pic xxxx comp-5.
           01 last-indicator           pic s9(4) comp-5.
           01 i                        pic x(4) comp-5.
           01 target-row               pic S9(15).
           01 filter-field             pic x(32).
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to pass input parameters
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>   Fields to be used in SQL Select statements
           01 selectColumns.
             03 filler pic x(26) value "A.ID, A.ID_IS_IN_CHAPTER, ".
             03 filler pic x(21) value "A.STATUS, A.SEQ_NBR, ".
             03 filler pic x(28) value "A.HYPER_LINK, A.MASTER_URL, ".
             03 filler pic x(24) value "A.SLAVE_URL, A.IMG_SRC, ".
             03 filler pic x(21) value "A.LINE_NR, A.TAB_NR, ".
             03 filler pic x(25) value "A.CRITICAL, A.LAST_USER, ".
             03 filler pic x(15) value "A.LAST_MODIFY, ".
             03 filler pic x(18) value "A.LAST_VALIDATOR, ".
             03 filler pic x(15) value "A.LAST_VALIDATE".
      *>   Fields that are part of the primary key
           01 PrimaryKeyColumns.
             03 filler pic x(05) value "A.ID#".
      *>   Tables to be used in SQL Select statements
           01 selectTables.
             03 filler pic x(11) value "CHAPTER_V A".
      *>   Fields that can be updated
           01 updateColumns.
             03 filler pic x(28) value "A.ID_IS_IN_CHAPTER#A.STATUS#".
             03 filler pic x(23) value "A.SEQ_NBR#A.HYPER_LINK#".
             03 filler pic x(25) value "A.MASTER_URL#A.SLAVE_URL#".
             03 filler pic x(20) value "A.IMG_SRC#A.LINE_NR#".
             03 filler pic x(20) value "A.TAB_NR#A.CRITICAL#".
             03 filler pic x(26) value "A.LAST_USER#A.LAST_MODIFY#".
             03 filler pic x(17) value "A.LAST_VALIDATOR#".
             03 filler pic x(16) value "A.LAST_VALIDATE#".
      *>   Field values for SQL Insert and Update statements
           01 New-SQL-Values.
             03 new-A-ID               pic S9(12) COMP-3.
             03 new-A-ID-IS-IN-CHAPTER pic S9(12) COMP-3.
             03 new-A-STATUS           pic X(32).
             03 new-A-SEQ-NBR          pic S9(2) COMP-3.
             03 new-A-HYPER-LINK       pic X(254).
             03 new-A-MASTER-URL       pic X(254).
             03 new-A-SLAVE-URL        pic X(254).
             03 new-A-IMG-SRC          pic X(254).
             03 new-A-LINE-NR          pic S9(1) COMP-3.
             03 new-A-TAB-NR           pic S9(1) COMP-3.
             03 new-A-CRITICAL         pic X(5).
             03 new-A-LAST-USER        pic X(20).
             03 new-A-LAST-MODIFY      pic X(26).
             03 new-A-LAST-VALIDATOR   pic X(20).
             03 new-A-LAST-VALIDATE    pic X(26).
             03 n-new-A-ID-IS-IN-CHAPTER pic s9(4) comp-5.
             03 n-new-A-MASTER-URL     pic s9(4) comp-5.
             03 n-new-A-SLAVE-URL      pic s9(4) comp-5.
             03 n-new-A-IMG-SRC        pic s9(4) comp-5.
             03 n-new-A-LINE-NR        pic s9(4) comp-5.
             03 n-new-A-TAB-NR         pic s9(4) comp-5.
             03 n-new-A-CRITICAL       pic s9(4) comp-5.
             03 n-new-A-LAST-USER      pic s9(4) comp-5.
             03 n-new-A-LAST-MODIFY    pic s9(4) comp-5.
             03 n-new-A-LAST-VALIDATOR pic s9(4) comp-5.
             03 n-new-A-LAST-VALIDATE  pic s9(4) comp-5.
      *>   Contains the name of the field being processed
           01 field-name               pic x(40).
      *>   Operator used for positioning within select rows.
      *>   Will be ">=" for Next, "<=" for Prev
      *>   and "??" (meaning no where clause needed for positioning)
      *>   for First and Last
           01 search-op                pic xx.
      *>   Ordering specification, null terminated.
      *>   Wiil be empty for First and Next and DESC for Last and Prev
           01 sort-spec                pic x(8).
      *>   Holds the name of the column to order by
           01 order-field              pic x(32).
      *>   The name of the file used to store server state
           01 state-filename           pic x(255)
               value "STATE.DAT".
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to return results from
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>      Status of last SQL statement executed
           01 sql-status               pic 9.
               88 sql-ok                 value 0.
               88 no-data                value 1.
               88 sql-error              value 2.
      *>      Result of field comparison routines
           01 order-status             pic s9.
               88 IsLess               value -1.
               88 IsEqual              value 0.
               88 IsGreater            value +1.
      *>      Partial result of field comparison - order field only
           01 find-status              pic s9.
               88 foundLess            value -1.
               88 foundEqual           value 0.
               88 foundGreater         value +1.
      *>      Result of state mainenance routine call
           01 state-status             pic x comp-x.
      *>      SQL Indicator variables for last SQL statement executed
           01 SQL-Indicators.
             03 n-A-ID-IS-IN-CHAPTER   pic s9(4) comp-5.
             03 n-A-MASTER-URL         pic s9(4) comp-5.
             03 n-A-SLAVE-URL          pic s9(4) comp-5.
             03 n-A-IMG-SRC            pic s9(4) comp-5.
             03 n-A-LINE-NR            pic s9(4) comp-5.
             03 n-A-TAB-NR             pic s9(4) comp-5.
             03 n-A-CRITICAL           pic s9(4) comp-5.
             03 n-A-LAST-USER          pic s9(4) comp-5.
             03 n-A-LAST-MODIFY        pic s9(4) comp-5.
             03 n-A-LAST-VALIDATOR     pic s9(4) comp-5.
             03 n-A-LAST-VALIDATE      pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *> Enter additional working-storage items here

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.
           *> control the user access
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Access" using UsCtrlStruct
           *> allocate state file
           call "sstate"
           call "MF_CLIENT_STATE_FILE"
               using state-filename server-status
           *> get system date and time
           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           invoke DatesRef "Finalize" returning DatesRef

           perform process-form-input-data
      *>---get the chapter id corresponding to his hyper link in the
      *>   selection box
           if f-Action = "Insrer" or "Modifier" or "Query"
               if f-Select1(1) <> spaces then
                   initialize FetchTemp
                   if f-Select1(1)(1:1) = "."
                       UNSTRING f-Select1(1) delimited by all "....."
                       into Temp FetchTemp
                   else
                       move f-Select1(1) to FetchTemp
                   end-if

                   EXEC SQL
                       SELECT A.ID
                       INTO :A-ID-IS-IN-CHAPTER
                       FROM CHAPTER_V A
                       WHERE A.HYPER_LINK = :FetchTemp
                   END-EXEC

                  if sqlcode <> 0 then
                     move f-A-ID-IS-IN-CHAPTER to A-ID-IS-IN-CHAPTER
                     move "Selected chapter has been modified by another
      -    " user" to f-frmesStatus
                     perform combo
                     perform chpform-out
                     stop run
                  end-if

                   move A-ID-IS-IN-CHAPTER to f-A-ID-IS-IN-CHAPTER
               else
                   initialize f-A-ID-IS-IN-CHAPTER
               end-if

               *> critical combo
               move f-Select2(1) to f-A-CRITICAL
           end-if

           perform set-sql-nulls
           perform convert-input
           perform translate-combos
           perform restore-state
           perform sql-start

           evaluate Action
               when "<<"
                   perform do-first
               when "<"
                   perform do-previous
               when ">"
                   perform do-next
               when ">>"
                   perform do-last
               when "Inserer"
                   perform do-insert
               when "Modifier"
                   perform do-update
               when "Supprimer"
                   perform do-delete
               when "Valider"
                   perform do-validate
               when "Query"
                   perform do-find
               when "Vider"
                   perform do-clear
               when "Add"
                   perform do-add
               when "Remove selection"
                   perform do-remove-selection
               when other
                   if client-id = spaces
                       perform do-default-operation
                   else
                       perform do-first-from-table
                   end-if
           end-evaluate

           perform combo

           perform save-state
           perform setup-controls
           perform Chpform-cvt
           perform blank-sql-nulls
           perform Chpform-out
           perform sql-finish

           exit program
           stop run.

      *>----------------------------------------------------------------
       combo section.
           *> fill the Chapter Combo-box
           invoke Tree "New" returning TreeRef
           invoke TreeRef "CreateChapter" using UsCtrlStruct Toc-Tab
           invoke TreeRef "Finalize" returning TreeRef

           perform varying Toc-Idx from 1 by 1 until Toc-Idx >Toc-Max
               move Toc-HyperLink(Toc-Idx) to
                                   Select1(Toc-Idx)
           end-perform

           compute c-Select1 = Toc-Idx

           *> get the item to be selected
           if A-ID-IS-IN-CHAPTER <> 0 then
               initialize FetchTemp
               EXEC SQL
                   SELECT A.HYPER_LINK, A.Tab_NR
                       INTO :FetchTemp, :NbrTab:UsCtrlInd
                       FROM CHAPTER_V A
                       WHERE ( A.ID = :A-ID-IS-IN-CHAPTER  )
               END-EXEC

               string empty( 1 : 5 * NbrTab) delimited by size
                      FetchTemp
               into   Temp

               perform varying TempIdx from 1 by 1 until
                               TempIdx > c-Select1
               if Select1(TempIdx) = Temp
                   move 1 to i-Select1(TempIdx)
                   exit perform
               end-if
               end-perform
           else
               move 1 to i-Select1(c-Select1)
           end-if

      *> fill the critical combo box with default values
           move "No" to Select2(1)
           move "Yes" to Select2(2)
           move 2 to c-Select2

           if A-ID <> 0 then
               EXEC SQL
                   SELECT A.CRITICAL
                       INTO :Select2(1)
                       FROM CHAPTER_V A
                       WHERE A.ID = :A-Id
               END-EXEC

      *>-------fill the critical combo box with default values
               if Select2(1) = "Yes" then
                   move "No" to Select2(2)
               else
                   move "Yes" to Select2(2)
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       base-sql section.

           exec sql
               declare sql_cursor cursor for dyna_stat
           end-exec
           exit.

      *>----------------------------------------------------------------
       sql-start section.
           *> Initialise variables
           move 0 to target-row
           move spaces to frmesStatus
           move 1 to stat-index
           move OrderBy(1) to order-field

           *> Initialise filtering control variables
           move FilterBy(1) to filter-field
           if filter-field = spaces
               if client-id = spaces
                   move "(none)" to filter-field
               else
                   move "(existing)" to filter-field
               end-if
           end-if

           *> We use != in Browser to avoid special HTML chars
           *> Convert to SQL 'not equal' if necessary
           if c-FilterType > 0
               move FilterType(1) to s-filter-op
               if s-filter-op = "!="
                   move "<>" to s-filter-op
               end-if
           end-if

           *> If filter field has changed, save filter value
           *> for status line
           if filter-field not = "(existing)"
               perform save-filter
               move filter-field to s-filter-field

               if s-filter-field not = '(none)'
                   evaluate s-filter-field
                       when "A.ID"
                           move f-A-ID to s-filter-value
                       when "A.ID_IS_IN_CHAPTER"
                           move f-A-ID-IS-IN-CHAPTER to s-filter-value
                       when "A.STATUS"
                           move f-A-STATUS to s-filter-value
                       when "A.SEQ_NBR"
                           move f-A-SEQ-NBR to s-filter-value
                       when "A.HYPER_LINK"
                           move f-A-HYPER-LINK to s-filter-value
                       when "A.MASTER_URL"
                           move f-A-MASTER-URL to s-filter-value
                       when "A.SLAVE_URL"
                           move f-A-SLAVE-URL to s-filter-value
                       when "A.IMG_SRC"
                           move f-A-IMG-SRC to s-filter-value
                       when "A.LINE_NR"
                           move f-A-LINE-NR to s-filter-value
                       when "A.TAB_NR"
                           move f-A-TAB-NR to s-filter-value
                       when "A.CRITICAL"
                           move f-A-CRITICAL to s-filter-value
                       when "A.LAST_USER"
                           move f-A-LAST-USER to s-filter-value
                       when "A.LAST_MODIFY"
                           move f-A-LAST-MODIFY to s-filter-value
                       when "A.LAST_VALIDATOR"
                           move f-A-LAST-VALIDATOR to s-filter-value
                       when "A.LAST_VALIDATE"
                           move f-A-LAST-VALIDATE to s-filter-value
                   end-evaluate

                   perform varying i from length s-filter-value by -1
                           until i = 0
                       if s-filter-value(i:1) = space
                           move x"0" to s-filter-value(i:1)
                       else
                           exit perform
                       end-if
                   end-perform

                   if s-filter-value(1:1)=x"0"
                       move z"(empty)" to s-filter-value
                   end-if
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-finish section.

           *> Finalise SQL session
           exec sql disconnect end-exec
           invoke UsCtrlRef "Finalize" returning UsCtrlRef
           exit.

      *>----------------------------------------------------------------
       do-sql-query section.

           *> Build dynamic SQL query for current order and filter
           *> settings, then prepare it
           move spaces to sql-text
           move 0 to sqld sqln
           move 1 to sql-index
           move low-values to where-clause order-clause

           if order-field = spaces
               *> Default to 1st primary key field
               move "A.ID" to order-field
           end-if

           if search-op not = '??'
               *> For next, prev and find add the order field
               *> to the where clause
               move order-field to field-name
               perform sql-add-param
           end-if

           if (s-filter-field not = "(none)")
               move s-filter-field to field-name
               perform sql-add-filter-param
           end-if

           move 1 to sql-index
           move order-field to field-name
           perform trim-field-name
           string
               field-name delimited x"0"
               sort-spec delimited x"0"
           into order-clause pointer sql-index

           *> Append primary key columns that are not the order field
           *> to the order clause to guarantee a unique row order
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform trim-field-name
               string
                   ", " delimited size
                   field-name delimited x"0"
                   sort-spec delimited x"0"
               into order-clause pointer sql-index
           end-perform

           move 1 to sql-index,
           string
               "select " delimited size
               selectColumns delimited size
               " from "  delimited size
               selectTables delimited size
               where-clause delimited x"0"
               " order by " delimited size
               order-clause delimited x"0"
               x"0" delimited size
           into sql-text pointer sql-index

           exec sql
                   prepare dyna_stat from :sql-text
           end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error processing this request.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-add-param section.

           *> Add field-name as a parameter to the where clause
           *> for positioning purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_IS_IN_CHAPTER"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID-IS-IN-CHAPTER
                   set sqlind(sqln) to address of n-A-ID-IS-IN-CHAPTER
                   move n-A-ID-IS-IN-CHAPTER to last-indicator
                 when "A.STATUS"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of A-STATUS to sqllen(sqln)
                   set sqldata(sqln) to address of A-STATUS
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.SEQ_NBR"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 002
                   set sqldata(sqln) to address of A-SEQ-NBR
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.HYPER_LINK"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of A-HYPER-LINK to sqllen(sqln)
                   set sqldata(sqln) to address of A-HYPER-LINK
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.MASTER_URL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-MASTER-URL to sqllen(sqln)
                   set sqldata(sqln) to address of A-MASTER-URL
                   set sqlind(sqln) to address of n-A-MASTER-URL
                   move n-A-MASTER-URL to last-indicator
                 when "A.SLAVE_URL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-SLAVE-URL to sqllen(sqln)
                   set sqldata(sqln) to address of A-SLAVE-URL
                   set sqlind(sqln) to address of n-A-SLAVE-URL
                   move n-A-SLAVE-URL to last-indicator
                 when "A.IMG_SRC"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-IMG-SRC to sqllen(sqln)
                   set sqldata(sqln) to address of A-IMG-SRC
                   set sqlind(sqln) to address of n-A-IMG-SRC
                   move n-A-IMG-SRC to last-indicator
                 when "A.LINE_NR"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of A-LINE-NR
                   set sqlind(sqln) to address of n-A-LINE-NR
                   move n-A-LINE-NR to last-indicator
                 when "A.TAB_NR"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of A-TAB-NR
                   set sqlind(sqln) to address of n-A-TAB-NR
                   move n-A-TAB-NR to last-indicator
                 when "A.CRITICAL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-CRITICAL to sqllen(sqln)
                   set sqldata(sqln) to address of A-CRITICAL
                   set sqlind(sqln) to address of n-A-CRITICAL
                   move n-A-CRITICAL to last-indicator
                 when "A.LAST_USER"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-USER to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-USER
                   set sqlind(sqln) to address of n-A-LAST-USER
                   move n-A-LAST-USER to last-indicator
                 when "A.LAST_MODIFY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-MODIFY to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-MODIFY
                   set sqlind(sqln) to address of n-A-LAST-MODIFY
                   move n-A-LAST-MODIFY to last-indicator
                 when "A.LAST_VALIDATOR"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-VALIDATOR to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-VALIDATOR
                   set sqlind(sqln) to address of n-A-LAST-VALIDATOR
                   move n-A-LAST-VALIDATOR to last-indicator
                 when "A.LAST_VALIDATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-VALIDATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-VALIDATE
                   set sqlind(sqln) to address of n-A-LAST-VALIDATE
                   move n-A-LAST-VALIDATE to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If we specify 'is [not] null'
               *> we'll exclude rows from the result set that we may
               *> need to step through. All we can do is exclude
               *> the field from the where clause.
               *> The moral is that for large tables it's best to
               *> disallow ordering on nullable columns.
               subtract 1 from sqld sqln
               exit section
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           string
               field-name delimited x"0"
               search-op delimited size
               " ?" delimited size
           into where-clause pointer sql-index
           exit.

      *>----------------------------------------------------------------
       sql-add-filter-param section.

           *> Add field-name as a parameter to the where clause
           *> for filtering purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_IS_IN_CHAPTER"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of
                     filter-A-ID-IS-IN-CHAPTER
                   set sqlind(sqln) to address of
                     n-filter-A-ID-IS-IN-CHAPTER
                   move n-filter-A-ID-IS-IN-CHAPTER to last-indicator
                 when "A.STATUS"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of filter-A-STATUS to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-STATUS
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.SEQ_NBR"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 002
                   set sqldata(sqln) to address of filter-A-SEQ-NBR
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.HYPER_LINK"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of filter-A-HYPER-LINK to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-HYPER-LINK
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.MASTER_URL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-MASTER-URL to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-MASTER-URL
                   set sqlind(sqln) to address of n-filter-A-MASTER-URL
                   move n-filter-A-MASTER-URL to last-indicator
                 when "A.SLAVE_URL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-SLAVE-URL to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-SLAVE-URL
                   set sqlind(sqln) to address of n-filter-A-SLAVE-URL
                   move n-filter-A-SLAVE-URL to last-indicator
                 when "A.IMG_SRC"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-IMG-SRC to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-IMG-SRC
                   set sqlind(sqln) to address of n-filter-A-IMG-SRC
                   move n-filter-A-IMG-SRC to last-indicator
                 when "A.LINE_NR"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of filter-A-LINE-NR
                   set sqlind(sqln) to address of n-filter-A-LINE-NR
                   move n-filter-A-LINE-NR to last-indicator
                 when "A.TAB_NR"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of filter-A-TAB-NR
                   set sqlind(sqln) to address of n-filter-A-TAB-NR
                   move n-filter-A-TAB-NR to last-indicator
                 when "A.CRITICAL"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-CRITICAL to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-CRITICAL
                   set sqlind(sqln) to address of n-filter-A-CRITICAL
                   move n-filter-A-CRITICAL to last-indicator
                 when "A.LAST_USER"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-USER to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-USER
                   set sqlind(sqln) to address of n-filter-A-LAST-USER
                   move n-filter-A-LAST-USER to last-indicator
                 when "A.LAST_MODIFY"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-MODIFY to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-MODIFY
                   set sqlind(sqln) to address of
                     n-filter-A-LAST-MODIFY
                   move n-filter-A-LAST-MODIFY to last-indicator
                 when "A.LAST_VALIDATOR"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-VALIDATOR to
                     sqllen(sqln)
                   set sqldata(sqln) to address of
                     filter-A-LAST-VALIDATOR
                   set sqlind(sqln) to address of
                     n-filter-A-LAST-VALIDATOR
                   move n-filter-A-LAST-VALIDATOR to last-indicator
                 when "A.LAST_VALIDATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-VALIDATE to
                     sqllen(sqln)
                   set sqldata(sqln) to address of
                     filter-A-LAST-VALIDATE
                   set sqlind(sqln) to address of
                     n-filter-A-LAST-VALIDATE
                   move n-filter-A-LAST-VALIDATE to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If the filter operator is
               *> equals or not equals we will deal with it later.
               *> Otherwise the field must be excluded because
               *> all we can do with nulls is equals and not equals
               *> and this might exclude rows that we might need to
               *> step through
               if s-filter-op = "<=" or ">="
                   subtract 1 from sqld sqln
                   exit section
               end-if
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           if last-indicator >= 0
               string
                   field-name delimited x"0"
                   s-filter-op delimited size
                   " ?" delimited size
               into where-clause pointer sql-index
           else
               *> Deal with null values. These require different
               *> SQL syntax
               subtract 1 from sqld sqln
               if s-filter-op = "="
                   string
                       field-name delimited x"0"
                       ' IS NULL' delimited size
                   into where-clause pointer sql-index
               else
                   string
                       field-name delimited x"0"
                       ' IS NOT NULL' delimited size
                   into where-clause pointer sql-index
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       trim-field-name section.

           *> Null terminate field-name and trim trailing spaces
           move length field-name to i
           perform until i = 0 or field-name(i:1) not = space
               move x"0" to field-name(i:1)
               subtract 1 from i
           end-perform
           exit.

      *>----------------------------------------------------------------
       sql-open section.

           *> Open a cursor to retrieve the query results
           exec sql open sql_cursor using descriptor :sqlda end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error opening a SQL cursor.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-fetch section.

           *> Get the next row from the query result set.
           *> Set the status to sql-ok, no-data or sql-error
           *> Terminate with error message if sql-error
           exec sql
             fetch sql_cursor into
                   :A-ID,
                   :A-ID-IS-IN-CHAPTER:n-A-ID-IS-IN-CHAPTER,
                   :A-STATUS,
                   :A-SEQ-NBR,
                   :A-HYPER-LINK,
                   :A-MASTER-URL:n-A-MASTER-URL,
                   :A-SLAVE-URL:n-A-SLAVE-URL,
                   :A-IMG-SRC:n-A-IMG-SRC,
                   :A-LINE-NR:n-A-LINE-NR,
                   :A-TAB-NR:n-A-TAB-NR,
                   :A-CRITICAL:n-A-CRITICAL,
                   :A-LAST-USER:n-A-LAST-USER,
                   :A-LAST-MODIFY:n-A-LAST-MODIFY,
                   :A-LAST-VALIDATOR:n-A-LAST-VALIDATOR,
                   :A-LAST-VALIDATE:n-A-LAST-VALIDATE
           end-exec

           set sql-ok to true

           if sqlcode = 100
               set no-data to true
               initialize A-ID
               initialize A-ID-IS-IN-CHAPTER
               initialize A-STATUS
               initialize A-SEQ-NBR
               initialize A-HYPER-LINK
               initialize A-MASTER-URL
               initialize A-SLAVE-URL
               initialize A-IMG-SRC
               initialize A-LINE-NR
               initialize A-TAB-NR
               initialize A-CRITICAL
               initialize A-LAST-USER
               initialize A-LAST-MODIFY
               initialize A-LAST-VALIDATOR
               initialize A-LAST-VALIDATE
           end-if

           if sqlcode < 0
               set sql-error to true
               exec html
                   <br><br><em>
                   There was an error retrieving query results.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if

           if sql-ok
               *> Blank out fields where the database returned a null
               perform init-sql-nulls
           end-if
           exit.

      *>----------------------------------------------------------------
       finish-sql-query section.

           *> Finalise the current query
           exec sql close sql_cursor end-exec
           exit.

      *>----------------------------------------------------------------
       do-first-from-table section.

           *> Get the row the user selected in table view. If it has
           *> been deleted by another user, get the next row in the
           *> current ordering

           *> Retrieve the 'row-numer in table' parameter passed in the
           *> hpyerlink.
           move function numval(Action) to target-row
           *> Get the ordering from the saved server state
           move s-order-field to order-field

           *> Restore field values for 1st row in table and
           *> position to it
           perform restore-first
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> Check that the filter hasn't excluded all rows
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> Step through rows until we get to the one we need
           *> or we've read all the selected rows
           subtract 1 from target-row
           perform until target-row <= 0 or no-data
              perform sql-fetch
              subtract 1 from target-row
           end-perform

           *> Tidy up and deal with the case where we ran out of data
           *> becuase rows were deleted by other users
           perform finish-sql-query
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-first section.

           *> Output 1st row
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-next section.

           *> Output next row
           move ">=" to search-op
           move low-values to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicates order field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
               perform sql-fetch
           end-if
           perform finish-sql-query

           *> If end of data reached, wrap round to start
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-previous section.

           *> Output previous row
           move "<=" to search-op
           move z" desc " to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicates order field values,
           *> so skip rows until we're at or before the last row
           *> or out of rows
           set IsGreater to true
           perform until not IsGreater
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
              perform sql-fetch
           end-if
           perform finish-sql-query

           *> If start of data reached, wrap round to end
           if no-data
               move
          "Start of table reached, position reset to last record"
                to frmesStatus
               perform do-last
           end-if
           exit.

      *>----------------------------------------------------------------
       do-last section.

           *> Output last row
           move "??" to search-op
           move z" desc " to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-insert section.

           *> user control
           invoke UsCtrlRef "Ins" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to A-STATUS
           move UsCtrlShortname to A-LAST-USER
           initialize n-A-LAST-USER
           *> Insert a new row
           exec sql
             insert into CHAPTER_V
               (ID_IS_IN_CHAPTER, STATUS, SEQ_NBR, HYPER_LINK,
                 MASTER_URL, SLAVE_URL,
                 IMG_SRC, LINE_NR, TAB_NR, CRITICAL, LAST_USER,
                 LAST_MODIFY, LAST_VALIDATOR, LAST_VALIDATE)
             values (
               :A-ID-IS-IN-CHAPTER:n-A-ID-IS-IN-CHAPTER,
               :A-STATUS,
               :A-SEQ-NBR,
               :A-HYPER-LINK,
               :A-MASTER-URL:n-A-MASTER-URL,
               :A-SLAVE-URL:n-A-SLAVE-URL,
               :A-IMG-SRC:n-A-IMG-SRC,
               :A-LINE-NR:n-A-LINE-NR,
               :A-TAB-NR:n-A-TAB-NR,
               :A-CRITICAL:n-A-CRITICAL,
               :A-LAST-USER:n-A-LAST-USER,
               :yyyy-mm-dd-hhmnss,
               NULL,
               NULL)
           end-exec

           if sqlcode not = 0
              *>Check the unicity constraint
              if sqlstate = 23000
                 move
                 "Master Url or Hyper Link should be unique"
                 to frmesStatus
               else
                   move sqlerrmc to frmesStatus
               end-if
               exec sql rollback end-exec
           else
               exec sql commit end-exec
               exec sql
                    select ID
                    into :A-ID
                    from CHAPTER_V
                    where HYPER_LINK = :A-HYPER-LINK
               end-exec
               *> Reset ordering and filtering to avoid confusion
               *> if the new row is excluded from the selected
               *> row set
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform do-re-read
               move "New record inserted successfully" to frmesStatus
           end-if
           exit.

      *>----------------------------------------------------------------
       do-update section.

           *> Update the last row output

           *> Check that there are some columns the user is allowed to
           *> update
           if updateColumns = spaces
               perform restore-first
               perform do-re-read
               move "There are no updatable columns on this form"
                   to frmesStatus
               exit section
           end-if

           *> Check that this isn't an attempt to update the primary
           *> key
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Primary Key fields may not be updated"
                   to frmesStatus
               exit section
           end-if

           *> Save new values and retrieve old row. This checks that
           *> row is still there, and should be enough for most servers
           *> to lock the row until the update is complete
           move A-ID to new-A-ID
           move A-ID-IS-IN-CHAPTER to new-A-ID-IS-IN-CHAPTER
           move n-A-ID-IS-IN-CHAPTER to n-new-A-ID-IS-IN-CHAPTER
           move A-STATUS to new-A-STATUS
           move A-SEQ-NBR to new-A-SEQ-NBR
           move A-HYPER-LINK to new-A-HYPER-LINK
           move A-MASTER-URL to new-A-MASTER-URL
           move n-A-MASTER-URL to n-new-A-MASTER-URL
           move A-SLAVE-URL to new-A-SLAVE-URL
           move n-A-SLAVE-URL to n-new-A-SLAVE-URL
           move A-IMG-SRC to new-A-IMG-SRC
           move n-A-IMG-SRC to n-new-A-IMG-SRC
           move A-LINE-NR to new-A-LINE-NR
           move n-A-LINE-NR to n-new-A-LINE-NR
           move A-TAB-NR to new-A-TAB-NR
           move n-A-TAB-NR to n-new-A-TAB-NR
           move A-CRITICAL to new-A-CRITICAL
           move n-A-CRITICAL to n-new-A-CRITICAL
           move A-LAST-USER to new-A-LAST-USER
           move n-A-LAST-USER to n-new-A-LAST-USER
           move A-LAST-MODIFY to new-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-new-A-LAST-MODIFY
           move A-LAST-VALIDATOR to new-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-new-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to new-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-new-A-LAST-VALIDATE

           perform Restore-First

           perform do-re-read
           if no-data
               move
                   "The row has been deleted by another user"
                   to frmesStatus
               exit section
           else
               perform compare-key-to-first
               if not IsEqual
                   move
                       "The row has been deleted by another user"
                   to frmesStatus
               exit section
           end-if

           *> Chech that the row hasn't changed since it was output
           *> last time
           perform compare-updatable-to-first
           if not IsEqual
               perform do-re-read
               move
          "This row has been updated by another user - please try again"
                   to frmesStatus
               exit section
           end-if

           *> User control
           invoke UsCtrlRef "Upd" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-USER
           initialize n-new-A-LAST-USER

           *> All OK, so do the update
           exec sql
             update CHAPTER_V set
               ID_IS_IN_CHAPTER = :new-A-ID-IS-IN-CHAPTER
                                  :n-new-A-ID-IS-IN-CHAPTER,
               STATUS = :new-A-STATUS,
               SEQ_NBR = :new-A-SEQ-NBR,
               HYPER_LINK = :new-A-HYPER-LINK,
               MASTER_URL = :new-A-MASTER-URL:n-new-A-MASTER-URL,
               SLAVE_URL = :new-A-SLAVE-URL:n-new-A-SLAVE-URL,
               IMG_SRC = :new-A-IMG-SRC
                         :n-new-A-IMG-SRC,
               LINE_NR = :new-A-LINE-NR
                         :n-new-A-LINE-NR,
               TAB_NR = :new-A-TAB-NR
                        :n-new-A-TAB-NR,
               CRITICAL = :new-A-CRITICAL
                          :n-new-A-CRITICAL,
               LAST_USER = :new-A-LAST-USER
                           :n-new-A-LAST-USER,
               LAST_MODIFY = :yyyy-mm-dd-hhmnss,
               LAST_VALIDATE = NULL,
               LAST_VALIDATOR = NULL
             where ID = :first-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                       move
                   "No record to update, it may have been deleted"
                       to frmesStatus
                   exec sql rollback end-exec
               else
                  *>Check the unicity constraint
                   if sqlcode = -1 and sqlstate = 23000
                      move
                      "Master Url or Hyper Link should be unique"
                      to frmesStatus
                   else
                       move sqlerrmc to frmesStatus
                   end-if
                   exec sql rollback end-exec
               end-if
           else
               *> Reset ordering and filtering to avoid confusion
               *> if the row is now excluded from the selected
               *> row set. Commit the update first
               exec sql commit end-exec
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform do-re-read
               move "Record updated successfully" to frmesStatus
           end-if
           exit.

      *>----------------------------------------------------------------
       do-delete section.

           *> Delete the last row output

           *> Check that there are some columns the user is allowed to
           *> update
           if updateColumns = spaces
               perform restore-first
               perform do-re-read
               move "There are no updatable columns on this form"
                   to frmesStatus
               exit section
           end-if

           *> Check that this isn't an attempt to update the primary
           *> key
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Modifications are not allowed when deleting"
                   to frmesStatus
               exit section
           end-if

           *> Save new values and retrieve old row. This checks that
           *> row is still there, and should be enough for most servers
           *> to lock the row until the update is complete
           move A-ID to new-A-ID
           move A-ID-IS-IN-CHAPTER to new-A-ID-IS-IN-CHAPTER
           move n-A-ID-IS-IN-CHAPTER to n-new-A-ID-IS-IN-CHAPTER
           move A-STATUS to new-A-STATUS
           move A-SEQ-NBR to new-A-SEQ-NBR
           move A-HYPER-LINK to new-A-HYPER-LINK
           move A-MASTER-URL to new-A-MASTER-URL
           move n-A-MASTER-URL to n-new-A-MASTER-URL
           move A-SLAVE-URL to new-A-SLAVE-URL
           move n-A-SLAVE-URL to n-new-A-SLAVE-URL
           move A-IMG-SRC to new-A-IMG-SRC
           move n-A-IMG-SRC to n-new-A-IMG-SRC
           move A-LINE-NR to new-A-LINE-NR
           move n-A-LINE-NR to n-new-A-LINE-NR
           move A-TAB-NR to new-A-TAB-NR
           move n-A-TAB-NR to n-new-A-TAB-NR
           move A-CRITICAL to new-A-CRITICAL
           move n-A-CRITICAL to n-new-A-CRITICAL
           move A-LAST-USER to new-A-LAST-USER
           move n-A-LAST-USER to n-new-A-LAST-USER
           move A-LAST-MODIFY to new-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-new-A-LAST-MODIFY
           move A-LAST-VALIDATOR to new-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-new-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to new-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-new-A-LAST-VALIDATE

           perform Restore-First

           perform do-re-read
           if no-data
               move
                   "The row has been deleted by another user"
                   to frmesStatus
               exit section
           else
               perform compare-key-to-first
               if not IsEqual
                   move
                       "The row has been deleted by another user"
                   to frmesStatus
               exit section
           end-if

           *> Chech that the row hasn't changed since it was output
           *> last time
           perform compare-updatable-to-first
           if not IsEqual
               perform do-re-read
               move
          "This row has been updated by another user - please try again"
                   to frmesStatus
               exit section
           end-if

           *> User control
           move first-A-STATUS to UsCtrlStatus
           invoke UsCtrlRef "Del" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-USER
           initialize n-new-A-LAST-USER

           *> All OK, so do the delete (update)
           exec sql
             update CHAPTER_V set
             STATUS = :new-A-STATUS,
             LAST_USER = :new-A-LAST-USER:n-new-A-LAST-USER,
             LAST_MODIFY = :yyyy-mm-dd-hhmnss,
             LAST_VALIDATE = NULL,
             LAST_VALIDATOR = NULL
             where ID = :first-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                       move
                   "No record to delete, it may have been deleted"
                       to frmesStatus
                   exec sql rollback end-exec
               else
                   move sqlerrmc to frmesStatus
                   exec sql rollback end-exec
               end-if
           else
               *> Reset ordering and filtering to avoid confusion
               *> if the row is now excluded from the selected
               *> row set. Commit the update first
               exec sql commit end-exec
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform do-re-read
               move "Record deleted successfully" to frmesStatus
           end-if
           exit.
      *>---------------------------------------------------------------
        do-validate section.
           *> Check that there are some columns the user is allowed to
           *> update
           if updateColumns = spaces
               perform restore-first
               perform do-re-read
               move "There are no updatable columns on this form"
                   to frmesStatus
               exit section
           end-if

           *> Check that this isn't an attempt to update the primary
           *> key
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Primary Key fields may not be updated"
                   to frmesStatus
               exit section
           end-if

           *> Save new values and retrieve old row. This checks that
           *> row is still there, and should be enough for most server
           *> to lock the row until the update is complete
           move A-ID to new-A-ID
           move A-ID-IS-IN-CHAPTER to new-A-ID-IS-IN-CHAPTER
           move n-A-ID-IS-IN-CHAPTER to n-new-A-ID-IS-IN-CHAPTER
           move A-STATUS to new-A-STATUS
           move A-SEQ-NBR to new-A-SEQ-NBR
           move A-HYPER-LINK to new-A-HYPER-LINK
           move A-MASTER-URL to new-A-MASTER-URL
           move n-A-MASTER-URL to n-new-A-MASTER-URL
           move A-SLAVE-URL to new-A-SLAVE-URL
           move n-A-SLAVE-URL to n-new-A-SLAVE-URL
           move A-IMG-SRC to new-A-IMG-SRC
           move n-A-IMG-SRC to n-new-A-IMG-SRC
           move A-LINE-NR to new-A-LINE-NR
           move n-A-LINE-NR to n-new-A-LINE-NR
           move A-TAB-NR to new-A-TAB-NR
           move n-A-TAB-NR to n-new-A-TAB-NR
           move A-CRITICAL to new-A-CRITICAL
           move n-A-CRITICAL to n-new-A-CRITICAL
           move A-LAST-USER to new-A-LAST-USER
           move n-A-LAST-USER to n-new-A-LAST-USER
           move A-LAST-MODIFY to new-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-new-A-LAST-MODIFY
           move A-LAST-VALIDATOR to new-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-new-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to new-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-new-A-LAST-VALIDATE

           perform Restore-First

           perform do-re-read
           if no-data
               move
                   "The row has been deleted by another user"
                   to frmesStatus
               exit section
           else
               perform compare-key-to-first
               if not IsEqual
                   move
                       "The row has been deleted by another user"
                   to frmesStatus
               exit section
           end-if

           *> Chech that the row hasn't changed since it was output
           *> last time
           perform compare-updatable-to-first
           if not IsEqual
               perform do-re-read
               move
          "This row has been updated by another user - please try again"
                   to frmesStatus
               exit section
           end-if

            *> User control
           move first-A-STATUS to UsCtrlStatus
           move first-A-LAST-USER to UsCtrlLastUser
           invoke UsCtrlRef "Val" using UsCtrlStruct
           if UsCtrlMsg <> spaces
              exit section
           end-if

           move UsCtrlStatus to new-A-STATUS
           move UsCtrlShortname to new-A-LAST-VALIDATOR
           initialize n-new-A-LAST-VALIDATOR

            *> All OK, so do the update
            exec sql
              update CHAPTER_V set
                STATUS = :new-A-STATUS,
          LAST_VALIDATOR = :new-A-LAST-VALIDATOR:n-new-A-LAST-VALIDATOR,
               LAST_VALIDATE = :yyyy-mm-dd-hhmnss
              where ID = :first-A-ID
            end-exec

            if sqlcode not = 0
                if sqlcode = 100
                        move
                    "No record to update, it may have been deleted"
                        to frmesStatus
                    exec sql rollback end-exec
                else
                    move MFSQLMessageText to frmesStatus
                    exec sql rollback end-exec
                end-if
            else
                *> Reset ordering and filtering to avoid confusion
                *> if the row is now excluded from the selected
                *> row set. Commit the update first
                exec sql commit end-exec
                move "A.ID" to order-field
                move "(none)" to s-filter-field
                perform do-re-read
                move "Record updated successfully" to frmesStatus
            end-if
            exit.
      *>----------------------------------------------------------------
       do-add section.
           exit.
       do-remove-selection section.
           exit.
      *>----------------------------------------------------------------
       do-clear section.

           *> Clear the form
           initialize A-ID
           initialize A-ID-IS-IN-CHAPTER
           initialize A-STATUS
           initialize A-SEQ-NBR
           initialize A-HYPER-LINK
           initialize A-MASTER-URL
           initialize A-SLAVE-URL
           initialize A-IMG-SRC
           initialize A-LINE-NR
           initialize A-TAB-NR
           initialize A-CRITICAL
           initialize A-LAST-USER
           initialize A-LAST-MODIFY
           initialize A-LAST-VALIDATOR
           initialize A-LAST-VALIDATE
           exit.

      *>----------------------------------------------------------------
       do-default-operation section.

           *> On initial entry, set order field to 1st primary key
           *> column, no filtering and output 1st row
           move "A.ID" to order-field
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-find section.

           *> Position to the row with order field >= the value input
           *> by the user. If this is an empty value, position to 1st
           *> row
           move ">=" to search-op
           move low-values to sort-spec
           evaluate order-field
                 when "A.ID"
                   if f-A-ID = spaces
                       move "??" to search-op
                   end-if
                 when "A.ID_IS_IN_CHAPTER"
                   if f-A-ID-IS-IN-CHAPTER = spaces
                       move "??" to search-op
                   end-if
                 when "A.STATUS"
                   if f-A-STATUS = spaces
                       move "??" to search-op
                   end-if
                 when "A.SEQ_NBR"
                   if f-A-SEQ-NBR = spaces
                       move "??" to search-op
                   end-if
                 when "A.HYPER_LINK"
                   if f-A-HYPER-LINK = spaces
                       move "??" to search-op
                   end-if
                 when "A.MASTER_URL"
                   if f-A-MASTER-URL = spaces
                       move "??" to search-op
                   end-if
                 when "A.SLAVE_URL"
                   if f-A-SLAVE-URL = spaces
                       move "??" to search-op
                   end-if
                 when "A.IMG_SRC"
                   if f-A-IMG-SRC = spaces
                       move "??" to search-op
                   end-if
                 when "A.LINE_NR"
                   if f-A-LINE-NR = spaces
                       move "??" to search-op
                   end-if
                 when "A.TAB_NR"
                   if f-A-TAB-NR = spaces
                       move "??" to search-op
                   end-if
                 when "A.CRITICAL"
                   if f-A-CRITICAL = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_USER"
                   if f-A-LAST-USER = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_MODIFY"
                   if f-A-LAST-MODIFY = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_VALIDATOR"
                   if f-A-LAST-VALIDATOR = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_VALIDATE"
                   if f-A-LAST-VALIDATE = spaces
                       move "??" to search-op
                   end-if
           end-evaluate
           if search-op = ">="
               perform save-first
           end-if
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           perform finish-sql-query

           *> If there are no suitable rows, output the last row,
           *> if there is one
           if no-data
               perform do-last
               if not no-data
                   perform setup-status
                   string
                       " - positioned at end" delimited size
                   into frmesStatus pointer stat-index
               end-if
           else
               *> Inform the user what happened
               perform setup-status
               if search-op = "??"
                   *> Empty search value, so we're on the 1st row
                   string
                       " - positioned at start" delimited size
                   into frmesStatus pointer stat-index
               else
                   *> Compare order field and the user's value
                   perform compare-to-first
                   if foundEqual
                       string
                           " - positioned where requested"
                               delimited size
                       into frmesStatus pointer stat-index
                   else
                       string
                           " - positioned at next match"
                               delimited size
                       into frmesStatus pointer stat-index
                   end-if
               end-if
           end-if
           exit.
      *>----------------------------------------------------------------
       do-re-read section.

           *> Re-read current row, allowing for the possibility
           *> that it may no longer exist
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> There may be duplicate field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       init-sql-nulls section.

           *> Initialize working fields where the server has returned
           *>a null
           if n-A-ID-IS-IN-CHAPTER < 0
             initialize A-ID-IS-IN-CHAPTER
           end-if
           if n-A-MASTER-URL < 0
             initialize A-MASTER-URL
           end-if
           if n-A-SLAVE-URL < 0
             initialize A-SLAVE-URL
           end-if
           if n-A-IMG-SRC < 0
             initialize A-IMG-SRC
           end-if
           if n-A-LINE-NR < 0
             initialize A-LINE-NR
           end-if
           if n-A-TAB-NR < 0
             initialize A-TAB-NR
           end-if
           if n-A-CRITICAL < 0
             initialize A-CRITICAL
           end-if
           if n-A-LAST-USER < 0
             initialize A-LAST-USER
           end-if
           if n-A-LAST-MODIFY < 0
             initialize A-LAST-MODIFY
           end-if
           if n-A-LAST-VALIDATOR < 0
             initialize A-LAST-VALIDATOR
           end-if
           if n-A-LAST-VALIDATE < 0
             initialize A-LAST-VALIDATE
           end-if
           exit.

      *>----------------------------------------------------------------
       set-sql-nulls section.

           *> Set SQL Indicator variable for nullable fields where the
           *> input from the Browser is blank and the SpacesAsNull
           *> attribute is set
           if f-A-ID-IS-IN-CHAPTER = spaces
             move -1 to n-A-ID-IS-IN-CHAPTER
           else
             move 0 to n-A-ID-IS-IN-CHAPTER
           end-if
           if f-A-MASTER-URL = spaces
             move -1 to n-A-MASTER-URL
           else
             move 0 to n-A-MASTER-URL
           end-if
           if f-A-SLAVE-URL = spaces
             move -1 to n-A-SLAVE-URL
           else
             move 0 to n-A-SLAVE-URL
           end-if
           if f-A-IMG-SRC = spaces
             move -1 to n-A-IMG-SRC
           else
             move 0 to n-A-IMG-SRC
           end-if
           if f-A-LINE-NR = spaces
             move -1 to n-A-LINE-NR
           else
             move 0 to n-A-LINE-NR
           end-if
           if f-A-TAB-NR = spaces
             move -1 to n-A-TAB-NR
           else
             move 0 to n-A-TAB-NR
           end-if
           if f-A-CRITICAL = spaces
             move -1 to n-A-CRITICAL
           else
             move 0 to n-A-CRITICAL
           end-if
           if f-A-LAST-USER = spaces
             move -1 to n-A-LAST-USER
           else
             move 0 to n-A-LAST-USER
           end-if
           if f-A-LAST-MODIFY = spaces
             move -1 to n-A-LAST-MODIFY
           else
             move 0 to n-A-LAST-MODIFY
           end-if
           if f-A-LAST-VALIDATOR = spaces
             move -1 to n-A-LAST-VALIDATOR
           else
             move 0 to n-A-LAST-VALIDATOR
           end-if
           if f-A-LAST-VALIDATE = spaces
             move -1 to n-A-LAST-VALIDATE
           else
             move 0 to n-A-LAST-VALIDATE
           end-if
           exit.

      *>----------------------------------------------------------------
       blank-sql-nulls section.

           *> Set Browser fields to spaces for nullable fields where
           *> the server has returned a null and the SpacesAsNull
           *> attribute is set
           if n-A-ID-IS-IN-CHAPTER < 0
             move spaces to f-A-ID-IS-IN-CHAPTER
           end-if
           if n-A-MASTER-URL < 0
             move spaces to f-A-MASTER-URL
           end-if
           if n-A-SLAVE-URL < 0
             move spaces to f-A-SLAVE-URL
           end-if
           if n-A-IMG-SRC < 0
             move spaces to f-A-IMG-SRC
           end-if
           if n-A-LINE-NR < 0
             move spaces to f-A-LINE-NR
           end-if
           if n-A-TAB-NR < 0
             move spaces to f-A-TAB-NR
           end-if
           if n-A-CRITICAL < 0
             move spaces to f-A-CRITICAL
           end-if
           if n-A-LAST-USER < 0
             move spaces to f-A-LAST-USER
           end-if
           if n-A-LAST-MODIFY < 0
             move spaces to f-A-LAST-MODIFY
           end-if
           if n-A-LAST-VALIDATOR < 0
             move spaces to f-A-LAST-VALIDATOR
           end-if
           if n-A-LAST-VALIDATE < 0
             move spaces to f-A-LAST-VALIDATE
           end-if
           exit.

      *>----------------------------------------------------------------
       save-filter section.

           *> Save current field values for use in filtering
           move A-ID to filter-A-ID
           move A-ID-IS-IN-CHAPTER to filter-A-ID-IS-IN-CHAPTER
           move n-A-ID-IS-IN-CHAPTER to n-filter-A-ID-IS-IN-CHAPTER
           move A-STATUS to filter-A-STATUS
           move A-SEQ-NBR to filter-A-SEQ-NBR
           move A-HYPER-LINK to filter-A-HYPER-LINK
           move A-MASTER-URL to filter-A-MASTER-URL
           move n-A-MASTER-URL to n-filter-A-MASTER-URL
           move A-SLAVE-URL to filter-A-SLAVE-URL
           move n-A-SLAVE-URL to n-filter-A-SLAVE-URL
           move A-IMG-SRC to filter-A-IMG-SRC
           move n-A-IMG-SRC to n-filter-A-IMG-SRC
           move A-LINE-NR to filter-A-LINE-NR
           move n-A-LINE-NR to n-filter-A-LINE-NR
           move A-TAB-NR to filter-A-TAB-NR
           move n-A-TAB-NR to n-filter-A-TAB-NR
           move A-CRITICAL to filter-A-CRITICAL
           move n-A-CRITICAL to n-filter-A-CRITICAL
           move A-LAST-USER to filter-A-LAST-USER
           move n-A-LAST-USER to n-filter-A-LAST-USER
           move A-LAST-MODIFY to filter-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-filter-A-LAST-MODIFY
           move A-LAST-VALIDATOR to filter-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-filter-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to filter-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-filter-A-LAST-VALIDATE
           exit.

      *>----------------------------------------------------------------
       save-first section.

           *> Save current field values for future use
           move A-ID to first-A-ID
           move A-ID-IS-IN-CHAPTER to first-A-ID-IS-IN-CHAPTER
           move n-A-ID-IS-IN-CHAPTER to n-first-A-ID-IS-IN-CHAPTER
           move A-STATUS to first-A-STATUS
           move A-SEQ-NBR to first-A-SEQ-NBR
           move A-HYPER-LINK to first-A-HYPER-LINK
           move A-MASTER-URL to first-A-MASTER-URL
           move n-A-MASTER-URL to n-first-A-MASTER-URL
           move A-SLAVE-URL to first-A-SLAVE-URL
           move n-A-SLAVE-URL to n-first-A-SLAVE-URL
           move A-IMG-SRC to first-A-IMG-SRC
           move n-A-IMG-SRC to n-first-A-IMG-SRC
           move A-LINE-NR to first-A-LINE-NR
           move n-A-LINE-NR to n-first-A-LINE-NR
           move A-TAB-NR to first-A-TAB-NR
           move n-A-TAB-NR to n-first-A-TAB-NR
           move A-CRITICAL to first-A-CRITICAL
           move n-A-CRITICAL to n-first-A-CRITICAL
           move A-LAST-USER to first-A-LAST-USER
           move n-A-LAST-USER to n-first-A-LAST-USER
           move A-LAST-MODIFY to first-A-LAST-MODIFY
           move n-A-LAST-MODIFY to n-first-A-LAST-MODIFY
           move A-LAST-VALIDATOR to first-A-LAST-VALIDATOR
           move n-A-LAST-VALIDATOR to n-first-A-LAST-VALIDATOR
           move A-LAST-VALIDATE to first-A-LAST-VALIDATE
           move n-A-LAST-VALIDATE to n-first-A-LAST-VALIDATE
           exit.

      *>----------------------------------------------------------------
       restore-first section.

           *> Restore the 1st row output last time in table view,
           *> or last row output in form view
           move first-A-ID to A-ID
           move first-A-ID-IS-IN-CHAPTER to A-ID-IS-IN-CHAPTER
           move n-first-A-ID-IS-IN-CHAPTER to n-A-ID-IS-IN-CHAPTER
           move first-A-STATUS to A-STATUS
           move first-A-SEQ-NBR to A-SEQ-NBR
           move first-A-HYPER-LINK to A-HYPER-LINK
           move first-A-MASTER-URL to A-MASTER-URL
           move n-first-A-MASTER-URL to n-A-MASTER-URL
           move first-A-SLAVE-URL to A-SLAVE-URL
           move n-first-A-SLAVE-URL to n-A-SLAVE-URL
           move first-A-IMG-SRC to A-IMG-SRC
           move n-first-A-IMG-SRC to n-A-IMG-SRC
           move first-A-LINE-NR to A-LINE-NR
           move n-first-A-LINE-NR to n-A-LINE-NR
           move first-A-TAB-NR to A-TAB-NR
           move n-first-A-TAB-NR to n-A-TAB-NR
           move first-A-CRITICAL to A-CRITICAL
           move n-first-A-CRITICAL to n-A-CRITICAL
           move first-A-LAST-USER to A-LAST-USER
           move n-first-A-LAST-USER to n-A-LAST-USER
           move first-A-LAST-MODIFY to A-LAST-MODIFY
           move n-first-A-LAST-MODIFY to n-A-LAST-MODIFY
           move first-A-LAST-VALIDATOR to A-LAST-VALIDATOR
           move n-first-A-LAST-VALIDATOR to n-A-LAST-VALIDATOR
           move first-A-LAST-VALIDATE to A-LAST-VALIDATE
           move n-first-A-LAST-VALIDATE to n-A-LAST-VALIDATE
           exit.

      *>----------------------------------------------------------------
       save-state section.

           *> Save state for next call, initialising the state file
           *> if this is the first call of the session
           move order-field to s-order-field
           perform save-first
           move length of client-state to client-length
           move frmehstate  to client-id
           if client-id = spaces
               call "MF_CLIENT_STATE_ALLOCATE"
                   using client-id client-length state-status
               move client-id to frmehstate
           end-if
           call "MF_CLIENT_STATE_SAVE"
               using client-id client-state client-length state-status
           exit.

      *>----------------------------------------------------------------
       restore-state section.

           *> Resore state from last call, if there was a last call
           move frmehstate to client-id
           if client-id not = spaces
               move length of client-state to client-length
               call "MF_CLIENT_STATE_RESTORE"
                   using client-id client-state client-length
                       state-status
           end-if
           exit.

      *>----------------------------------------------------------------
       setup-controls section.

           *> Set up data for HTML Select controls
           move "ID" to OrderBy(001)
           move "ID_IS_IN_CHAPTER" to OrderBy(002)
           move "STATUS" to OrderBy(003)
           move "SEQ_NBR" to OrderBy(004)
           move "HYPER_LINK" to OrderBy(005)
           move "MASTER_URL" to OrderBy(006)
           move "SLAVE_URL" to OrderBy(007)
           move "IMG_SRC" to OrderBy(008)
           move "LINE_NR" to OrderBy(009)
           move "TAB_NR" to OrderBy(010)
           move "CRITICAL" to OrderBy(011)
           move "LAST_USER" to OrderBy(012)
           move "LAST_MODIFY" to OrderBy(013)
           move "LAST_VALIDATOR" to OrderBy(014)
           move "LAST_VALIDATE" to OrderBy(015)
           move 015 to c-OrderBy

           evaluate order-field
             when spaces
             when "A.ID"
               move 1 to i-OrderBy(001)
             when "A.ID_IS_IN_CHAPTER"
               move 1 to i-OrderBy(002)
             when "A.STATUS"
               move 1 to i-OrderBy(003)
             when "A.SEQ_NBR"
               move 1 to i-OrderBy(004)
             when "A.HYPER_LINK"
               move 1 to i-OrderBy(005)
             when "A.MASTER_URL"
               move 1 to i-OrderBy(006)
             when "A.SLAVE_URL"
               move 1 to i-OrderBy(007)
             when "A.IMG_SRC"
               move 1 to i-OrderBy(008)
             when "A.LINE_NR"
               move 1 to i-OrderBy(009)
             when "A.TAB_NR"
               move 1 to i-OrderBy(010)
             when "A.CRITICAL"
               move 1 to i-OrderBy(011)
             when "A.LAST_USER"
               move 1 to i-OrderBy(012)
             when "A.LAST_MODIFY"
               move 1 to i-OrderBy(013)
             when "A.LAST_VALIDATOR"
               move 1 to i-OrderBy(014)
             when "A.LAST_VALIDATE"
               move 1 to i-OrderBy(015)
           end-evaluate

           move "(none)" to FilterBy(001)
           move "(existing)" to FilterBy(002)
           move "ID" to FilterBy(003)
           move "ID_IS_IN_CHAPTER" to FilterBy(004)
           move "STATUS" to FilterBy(005)
           move "SEQ_NBR" to FilterBy(006)
           move "HYPER_LINK" to FilterBy(007)
           move "MASTER_URL" to FilterBy(008)
           move "SLAVE_URL" to FilterBy(009)
           move "IMG_SRC" to FilterBy(010)
           move "LINE_NR" to FilterBy(011)
           move "TAB_NR" to FilterBy(012)
           move "CRITICAL" to FilterBy(013)
           move "LAST_USER" to FilterBy(014)
           move "LAST_MODIFY" to FilterBy(015)
           move "LAST_VALIDATOR" to FilterBy(016)
           move "LAST_VALIDATE" to FilterBy(017)
           move 017 to c-FilterBy

           if s-filter-field = spaces or "(none)"
               move 1 to i-FilterBy(1)
           else
               move 1 to i-FilterBy(2)
           end-if

           move 6 to c-FilterType
           move "<" to FilterType(1)
           move "<=" to FilterType(2)
           move "=" to FilterType(3)
           move "!=" to FilterType(4)
           move ">=" to FilterType(5)
           move ">" to FilterType(6)

           evaluate s-filter-op
               when "<"
                   move 1 to i-FilterType(1)
               when "<="
                   move 1 to i-FilterType(2)
               when spaces
               when "="
                   move 1 to i-FilterType(3)
               when "<>"
                   move 1 to i-FilterType(4)
               when  ">="
                   move 1 to i-FilterType(5)
               when  ">"
                   move 1 to i-FilterType(6)
           end-evaluate
           perform setup-status
           exit.

      *>----------------------------------------------------------------
       setup-status section.

           *> Setup status line
           if frmesStatus not = spaces
               exit section
           end-if

           if s-filter-field not = '(none)'
               if s-filter-op = '<>'
                   move '!=' to s-filter-op
               end-if

               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", filtering on " delimited size
                   s-filter-field(3:) delimited space
                   " " delimited size
                   s-filter-op delimited size
                  " " delimited size
                   s-filter-value delimited x"0"
               into frmesStatus pointer stat-index

               if s-filter-op = '!='
                   move '<>' to s-filter-op
               end-if

           else
               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", with no filtering " delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       translate-combos section.

           *> Pre-process data returned by HTML Select controls
           evaluate OrderBy(1)
             when "ID"
               move "A.ID" to OrderBy(1)
             when "ID_IS_IN_CHAPTER"
               move "A.ID_IS_IN_CHAPTER" to OrderBy(1)
             when "STATUS"
               move "A.STATUS" to OrderBy(1)
             when "SEQ_NBR"
               move "A.SEQ_NBR" to OrderBy(1)
             when "HYPER_LINK"
               move "A.HYPER_LINK" to OrderBy(1)
             when "MASTER_URL"
               move "A.MASTER_URL" to OrderBy(1)
             when "SLAVE_URL"
               move "A.SLAVE_URL" to OrderBy(1)
             when "IMG_SRC"
               move "A.IMG_SRC" to OrderBy(1)
             when "LINE_NR"
               move "A.LINE_NR" to OrderBy(1)
             when "TAB_NR"
               move "A.TAB_NR" to OrderBy(1)
             when "CRITICAL"
               move "A.CRITICAL" to OrderBy(1)
             when "LAST_USER"
               move "A.LAST_USER" to OrderBy(1)
             when "LAST_MODIFY"
               move "A.LAST_MODIFY" to OrderBy(1)
             when "LAST_VALIDATOR"
               move "A.LAST_VALIDATOR" to OrderBy(1)
             when "LAST_VALIDATE"
               move "A.LAST_VALIDATE" to OrderBy(1)
           end-evaluate

           evaluate FilterBy(1)
             when "ID"
               move "A.ID" to FilterBy(1)
             when "ID_IS_IN_CHAPTER"
               move "A.ID_IS_IN_CHAPTER" to FilterBy(1)
             when "STATUS"
               move "A.STATUS" to FilterBy(1)
             when "SEQ_NBR"
               move "A.SEQ_NBR" to FilterBy(1)
             when "HYPER_LINK"
               move "A.HYPER_LINK" to FilterBy(1)
             when "MASTER_URL"
               move "A.MASTER_URL" to FilterBy(1)
             when "SLAVE_URL"
               move "A.SLAVE_URL" to FilterBy(1)
             when "IMG_SRC"
               move "A.IMG_SRC" to FilterBy(1)
             when "LINE_NR"
               move "A.LINE_NR" to FilterBy(1)
             when "TAB_NR"
               move "A.TAB_NR" to FilterBy(1)
             when "CRITICAL"
               move "A.CRITICAL" to FilterBy(1)
             when "LAST_USER"
               move "A.LAST_USER" to FilterBy(1)
             when "LAST_MODIFY"
               move "A.LAST_MODIFY" to FilterBy(1)
             when "LAST_VALIDATOR"
               move "A.LAST_VALIDATOR" to FilterBy(1)
             when "LAST_VALIDATE"
               move "A.LAST_VALIDATE" to FilterBy(1)
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       compare-to-first section.

           *> Compare current order field values with the
           *> corresponding 'first-' values
           move order-field to field-name
           perform compare-field-to-first
           move order-status to find-status
           if not IsEqual
               exit section
           end-if

           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-key-to-first section.

           *> Compare current primary key field values with the
           *> corresponding 'first-' values
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-updatable-to-first section.

           *> Compare current updateable field values with the
           *> corresponding 'first-' values
           move UpdateColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-field-to-first section.

           *> Compare the field (whose name is in field-name)
           *> with the corresponding 'first-' value
           evaluate field-name
               when "A.ID"
                 if A-ID > first-A-ID
                   set IsGreater to true
                 else
                   if A-ID < first-A-ID
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ID_IS_IN_CHAPTER"
                 if A-ID-IS-IN-CHAPTER > first-A-ID-IS-IN-CHAPTER
                   set IsGreater to true
                 else
                   if A-ID-IS-IN-CHAPTER < first-A-ID-IS-IN-CHAPTER
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.STATUS"
                 if A-STATUS > first-A-STATUS
                   set IsGreater to true
                 else
                   if A-STATUS < first-A-STATUS
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.SEQ_NBR"
                 if A-SEQ-NBR > first-A-SEQ-NBR
                   set IsGreater to true
                 else
                   if A-SEQ-NBR < first-A-SEQ-NBR
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.HYPER_LINK"
                 if A-HYPER-LINK > first-A-HYPER-LINK
                   set IsGreater to true
                 else
                   if A-HYPER-LINK < first-A-HYPER-LINK
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.MASTER_URL"
                 if A-MASTER-URL > first-A-MASTER-URL
                   set IsGreater to true
                 else
                   if A-MASTER-URL < first-A-MASTER-URL
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.SLAVE_URL"
                 if A-SLAVE-URL > first-A-SLAVE-URL
                   set IsGreater to true
                 else
                   if A-SLAVE-URL < first-A-SLAVE-URL
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.IMG_SRC"
                 if A-IMG-SRC > first-A-IMG-SRC
                   set IsGreater to true
                 else
                   if A-IMG-SRC < first-A-IMG-SRC
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LINE_NR"
                 if A-LINE-NR > first-A-LINE-NR
                   set IsGreater to true
                 else
                   if A-LINE-NR < first-A-LINE-NR
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.TAB_NR"
                 if A-TAB-NR > first-A-TAB-NR
                   set IsGreater to true
                 else
                   if A-TAB-NR < first-A-TAB-NR
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.CRITICAL"
                 if A-CRITICAL > first-A-CRITICAL
                   set IsGreater to true
                 else
                   if A-CRITICAL < first-A-CRITICAL
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_USER"
                 if A-LAST-USER > first-A-LAST-USER
                   set IsGreater to true
                 else
                   if A-LAST-USER < first-A-LAST-USER
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_MODIFY"
                 if A-LAST-MODIFY > first-A-LAST-MODIFY
                   set IsGreater to true
                 else
                   if A-LAST-MODIFY < first-A-LAST-MODIFY
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_VALIDATOR"
                 if A-LAST-VALIDATOR > first-A-LAST-VALIDATOR
                   set IsGreater to true
                 else
                   if A-LAST-VALIDATOR < first-A-LAST-VALIDATOR
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_VALIDATE"
                 if A-LAST-VALIDATE > first-A-LAST-VALIDATE
                   set IsGreater to true
                 else
                   if A-LAST-VALIDATE < first-A-LAST-VALIDATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       process-form-input-data section.
           *> Accept the CGI input from the Browser, and check for
           *> errors
           perform browser-initialize
           accept htmlform
           exit.

      *>----------------------------------------------------------------
       convert-input section.
          *> field value
           move function LOWER-CASE(f-A-MASTER-URL) to f-A-MASTER-URL
           move function LOWER-CASE(f-A-SLAVE-URL) to f-A-SLAVE-URL

           perform input-conversion
           *> field validation
           if Action = "Modifier" or = "Inserer" then
               if A-HYPER-LINK = spaces
                   move "A_HYPER_LINK" to v-first-bad
                   perform output-form-error-and-stop
               end-if
               if A-MASTER-URL = spaces
                   move "No" to A-CRITICAL
               end-if
           end-if
           *> numeric validation
           if v-all-ok = 0
               inspect v-first-bad replacing all "-" by "_"
               perform output-form-error-and-stop
           end-if

           exit.
      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           *> The input conversion routines detected errors so
           *> display a message and stop
           perform setup-controls
           perform combo
           evaluate v-first-bad
           when "A_HYPER_LINK"
               move "Hyper Link." to frmesStatus
           when "A_SEQ_NBR"
               move "Sequence Number." to frmesStatus
           when "A_LINE_NR"
             move "Number of Lines." to frmesStatus
           when "A_TAB_NR"
             move "Number of Tabs." to frmesStatus
           when other
               string v-first-bad delimited by space
                      "."
               into frmesStatus
           end-evaluate

           if v-all-ok = 0
               string frmesStatus delimited by "."
                      " is a numeric field and has an invalid value."
               into frmesStatus
           else
               string frmesStatus delimited by "."
                      " is a required field."
               into frmesStatus
           end-if

           perform chpform-cvt
           perform chpform-out

           exec HTML
               <SCRIPT>
               document.DataForm.:v-first-bad .focus();
               alert(":frmesStatus");
               </SCRIPT>
           end-exec

           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "Chpform.cpv".
      *>----------------------------------------------------------------
