      $set mfoo ooctrl(+n)

      *>-----------------------------------------------------------
      *> Class realizing a connection to a data base.
      *>-----------------------------------------------------------
       class-id. Connect data is protected
                       inherits from Base.

       object section.
      *>---Classes used by the Cookie class
       class-control.
       copy "ClCtrl.cpy".
      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------
      *>---Default connect data when none are found in the "ini" file
       01 WsDefaultConnectName         pic x(8)  value "eurecas".
       01 WsDefaultConnectPassword     pic x(20) value "eurecas".
       01 WsDefaultConnectDb           pic x(20) value "eurecas".
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(10) value z"Not found".

      *>definitions of sqlcode, etc
       exec sql include SQLCA end-exec

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.

       procedure division returning LnkApplication.

          invoke Super "new" returning LnkApplication
          invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>-----------------------------------------------------------

       method-id. "Init".

       procedure division.

           exit method.
       end method "Init".

      *>-----------------------------------------------------------
      *> Methdod realizing a connection to a data base, using a user
      *> name, a password and the name of the data source.
      *>-----------------------------------------------------------
       method-id. "ConnectDb".

       local-storage section.
      *>---User name, password, data source
      *exec sql
      *   begin declare section
      *end-exec
       01 LsName                       pic x(8).
       01 LsPassword                   pic x(20).
       01 LsDb                         pic x(8).
      *exec sql end declare section end-exec

       copy "ObjRef.cpy".
       copy "Ini.cpy".

       linkage section.
       copy "Connect.cpy".

       procedure division returning ConnectStruct.
           initialize IniStruct ConnectStruct

      *>---Get the reference of the new Ini class object
           invoke Ini "New" returning IniRef

      *>---Get the connect name from the eurecas "ini" file
           move "..\Eurecas.ini" to IniFileName
           move "Connect"       to IniSectionName
           move "Name"          to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If name not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultConnectName to LsName
           else
               move IniString to LsName
           end-if

           initialize IniString

      *>---Get the connect password from the eurecas "ini" file
           move "Password"      to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If password not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultConnectPassword to LsPassword
           else
               move IniString to LsPassword
           end-if

           initialize IniString

      *>---Get the connect data source from the eurecas "ini" file
           move "Db"                   to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If data base not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultConnectDb to LsDb
           else
               move IniString to LsDb
           end-if

      *>---Destroy the "ini" class object
           invoke IniRef "Finalize" returning IniRef

      *>---Realize the connection to the data base
           EXEC SQL
               CONNECT :LsName IDENTIFIED BY :LsPassword USING :LsDb
           END-EXEC

      *>---Check possible errors
           if sqlcode <> 0 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to ConnectMsg
           end-if

           exit method.
       end method "ConnectDb".

      *>-----------------------------------------------------------
      *> Destruction of this object.
      *>-----------------------------------------------------------
       method-id. "Finalize".

       local-storage section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke super "Finalize" returning lnkData

           exit method.
       end method "Finalize".

       end object.
       end class Connect.
