      $set preprocess(htmlpp) endp mfoo ooctrl(+n)

      *>-----------------------------------------------------------
      *> Class inplementing methods for reading the cookie information
      *> sent by a browser and creating a cookie for a client using
      *> the given cookie name and value, and an expiration date.
      *>-----------------------------------------------------------

       class-id. Cookie data is protected
                       inherits from Base.

       object section.
      *>---Classes used by the Cookie class
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.

       procedure division returning LnkApplication.

          invoke Super "new" returning LnkApplication
          invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
       01 OSCookie                 pic x(255).
       01 client-cookie is external-form.
          05 cookie-value          pic x(255) identified by OSCookie.
      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>-----------------------------------------------------------
       method-id. "Init".

       procedure division.

           exit method.
       end method "Init".

      *>-----------------------------------------------------------
      *> In : CookieName       -> Cookie name                  pic x(256)
      *>
      *> Out: CookieValue      -> Cookie value                 pic x(256)
      *>
      *> Get the cookie information which was sent by the browser
      *>-----------------------------------------------------------
       method-id. "GetCookie".

       local-storage section.

       linkage section.
       copy "cookie.cpy".

       procedure division using CookieStruct.
           call "ACCCGI"
           initialize OSCookie
           move CookieName to OSCookie
           accept client-cookie
           move cookie-value to CookieValue

           exit method.
       end method "GetCookie".

      *>-----------------------------------------------------------
      *> In : Cyyyymmdd        -> Us date                      pic 9(8)
      *>      Chhmnss          -> hour minutes seconds         pic 9(6)
      *>      CNumberOfDays    -> Number of days to be added to the
      *>                          current date for the expiration date
      *>                          of the cookie                pic s9(6)
      *>      CookieName       -> Cookie name                  pic x(256)
      *>      CookieValue      -> Cookie value                 pic x(256)
      *>
      *> Out: None
      *>
      *> Create a cookie for the client using the given expiration date
      *> and time of the cookie and a name and value for this cookie.
      *> If no date and no time is specified (=zero) then no expiration
      *> date is given. If the specified time is not zero and the date
      *> is, then the current date is used.
      *> A number of days to be added to the date should be given,
      *> to determinate the date of expiration of the cookie.
      *>-----------------------------------------------------------
       method-id. "SetCookie".

       local-storage section.
      *>---Reference of a date class object
       01 LsDates                      object reference.
       copy "dates.cpy".

       linkage section.
       copy "cookie.cpy".

       procedure division using CookieStruct.

      *>---Get the correct formatted expiration date for the cookie
           initialize DateStruct
           move Cyyyymmdd to yyyymmdd
           move Chhmnss to hhmnss
           move CNumberOfDays to NumberOfDays


      *>---This condition enables to be able not to specify an
      *>   expiration date
           if (Cyyyymmdd <> zero) or
                   (Chhmnss <> zero) then
               invoke Dates "New" returning LsDates
               invoke LsDates "CookieExpire" using DateStruct
      *>------Destroy the dates class object
               invoke LsDates "Finalize" returning LsDates
           end-if

      *>---Create the cookie for the client using the given data
       exec html
           <META HTTP-EQUIV="Set-Cookie" CONTENT=
           ":CookieName=:CookieValue; expires=:CookieExpireDate">
       end-exec

           exit method.
       end method "SetCookie".

      *>-----------------------------------------------------------
      *> Destruction of this object.
      *>-----------------------------------------------------------
       method-id. "Finalize".

       local-storage section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke super "Finalize" returning lnkData

           exit method.
       end method "Finalize".

       end object.
       end class Cookie.
