      $set mfoo
      *>-----------------------------------------------------------
      *> Dates class implementing methods for manipulation of dates
      *> and time.
      *>-----------------------------------------------------------


       class-id. Dates data is protected
                       inherits from Base.

       object section.
      *>---Classes used by the Ini class
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------
      *>---Default delimiters when none are found in the "ini" file
       01 WsDefaultDateDelimiter       pic x value "-".
       01 WsDefaultTimeDelimiter       pic x value ":".
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(10) value z"Not found".

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.

       procedure division returning LnkApplication.

          invoke Super "New" returning LnkApplication
          invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
       copy "ObjRef.cpy".

      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>-----------------------------------------------------------
       method-id. "Init".

       procedure division.

           exit method.
       end method "Init".

      *>-----------------------------------------------------------
      *> In : hhmnss       -> hour minutes seconds     pic 9(6)
      *>
      *> Out: hhmn         -> hh:mn                    pic x(5)
      *>      hhmnss-a     -> hh:mn:ss                 pic x(8)
      *>
      *> Returns the given time as a display field
      *>-----------------------------------------------------------
       method-id. "TimeToDisplay".

       local-storage section.
       copy "Ini.cpy".

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Get the reference of the new Ini class object
           invoke Ini "New" returning IniRef

      *>---Get the time delimiter from the eurecas "ini" file
           move "..\eurecas.ini"   to IniFileName
           move "Dates"          to IniSectionName
           move "Time-Delimiter" to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If delimiter not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultTimeDelimiter to IniString
           end-if

      *>---Put the display time together
           string hhmnss(1:2)    delimited by size
                  IniString(1:1) delimited by size
                  hhmnss(3:4)    delimited by size
           into hhmn

      *>---Put the display time together
           string hhmn           delimited by size
                  IniString(1:1) delimited by size
                  hhmnss(5:2)    delimited by size
           into hhmnss-a

      *>---Destroy the "ini" class object
           invoke IniRef "Finalize" returning IniRef

           exit method.
       end method "TimeToDisplay".

      *>-----------------------------------------------------------
      *> In : ddmmyyyy         -> european date    pic 9(8)
      *>      yyyymmdd         -> US date          pic 9(8)
      *>
      *> Out: dd-mm-yyyy       -> dd-mm-yyyy       pic x(10)
      *>      yyyy-mm-dd       -> yyyy-mm-dd       pic x(10).
      *>      ExtendedDate     -> Wdy, dd-Mon-yy   pic x(12).
      *>
      *> Returns the given date as a display field
      *>-----------------------------------------------------------
       method-id. "DateToDisplay".

       local-storage section.
       copy "Ini.cpy".

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Get the reference of the new Ini class object
           invoke Ini "New" returning IniRef

      *>---Get the date delimiter from the eurecas "ini" file
           move "..\eurecas.ini"   to IniFileName
           move "Dates"          to IniSectionName
           move "Date-Delimiter" to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If delimiter not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultDateDelimiter to IniString
           end-if

      *>---Put the european display date together
           string ddmmyyyy(1:2)    delimited by size
                  IniString(1:1)   delimited by size
                  ddmmyyyy(3:2)    delimited by size
                  IniString(1:1)   delimited by size
                  ddmmyyyy(5:4)    delimited by size
           into dd-mm-yyyy
      *>---Put the US display date together
           string yyyymmdd(1:4)    delimited by size
                  IniString(1:1)   delimited by size
                  yyyymmdd(5:2)    delimited by size
                  IniString(1:1)   delimited by size
                  yyyymmdd(7:2)    delimited by size
           into yyyy-mm-dd

      *>---Get the month of year in alphanumeric
           invoke Self "MonthOfYear" using DateStruct
      *>---Get the US date
           invoke Self "EuroToUs" using DateStruct
      *>---Get the day of the week in alphanumeric
           invoke Self "DayOfWeek" using DateStruct

      *>---Put the display date together
           string DayOfWeek-a      delimited by size
                  ", "             delimited by size
                  ddmmyyyy(1:2)    delimited by size
                  IniString(1:1)   delimited by size
                  MonthOfYear      delimited by size
                  IniString(1:1)   delimited by size
                  ddmmyyyy(7:2)    delimited by size
           into ExtendedDate

      *>---Destroy the "ini" class object
           invoke IniRef "Finalize" returning IniRef

           exit method.
       end method "DateToDisplay".
      *>-----------------------------------------------------------
      *> In : dd-mm-yyyy       -> european date    pic x(10)
      *>      yyyy-mm-dd       -> US date          pic x(10)
      *>
      *> Out: ddmmyyyy         -> ddmmyyyy         pic 9(8)
      *>      yyyymmdd         -> yyyymmdd         pic 9(8).
      *>
      *> Returns the given date as a display field
      *>-----------------------------------------------------------
       method-id. "DisplayToDate".

       local-storage section.
       copy "Ini.cpy".

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Put the european display date to Euro date
           string dd-mm-yyyy(1:2)  delimited by size
                  dd-mm-yyyy(4:2)    delimited by size
                  dd-mm-yyyy(7:4)    delimited by size
           into ddmmyyyy
      *>---Put the US display date date to US date
           string yyyy-mm-dd(1:4)    delimited by size
                  yyyy-mm-dd(6:2)    delimited by size
                  yyyy-mm-dd(9:2)    delimited by size
           into yyyymmdd

           exit method.
       end method "DisplayToDate".

      *>-----------------------------------------------------------
      *> In : ddmmyyyy     -> European date    pic 9(8)
      *>      dd-mm-yyyy   -> Euro date displa pic x(10)
      *>
      *> Out: yyyymmdd     -> US date          pic 9(8)
      *>      yyyy-mm-dd   -> US date display  pic x(10)
      *>
      *> Returns the given european date in US format
      *>-----------------------------------------------------------
       method-id. "EuroToUs".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Put the US date together
           string ddmmyyyy(5:4) delimited by size
                  ddmmyyyy(3:2) delimited by size
                  ddmmyyyy(1:2) delimited by size
           into yyyymmdd
      *>---Put the US date together
           string dd-mm-yyyy(7:4) delimited by size
                  dd-mm-yyyy(6:1) delimited by size
                  dd-mm-yyyy(4:2) delimited by size
                  dd-mm-yyyy(3:1) delimited by size
                  dd-mm-yyyy(1:2) delimited by size
           into yyyy-mm-dd

           exit method.
       end method "EuroToUs".

      *>-----------------------------------------------------------
      *> In : yyyymmdd     -> US date          pic 9(8)
      *>      yyyy-mm-dd   -> US date display  pic x(10)
      *>
      *> Out: ddmmyyyy     -> Euro date        pic 9(8)
      *>      dd-mm-yyyy   -> Euro date displa pic x(10)
      *>
      *> Returns the given european date in US format
      *>-----------------------------------------------------------
       method-id. "UsToEuro".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Put the European date together
           string yyyymmdd(7:2) delimited by size
                  yyyymmdd(5:2) delimited by size
                  yyyymmdd(1:4) delimited by size
           into ddmmyyyy
      *>---Put the European display date together
           string yyyy-mm-dd(9:2) delimited by size
                  yyyy-mm-dd(8:1) delimited by size
                  yyyy-mm-dd(6:2) delimited by size
                  yyyy-mm-dd(5:1) delimited by size
                  yyyy-mm-dd(1:4) delimited by size
           into dd-mm-yyyy

           exit method.
       end method "UsToEuro".

      *>-----------------------------------------------------------
      *> In : StartDate        -> US start date            pic 9(8)
      *>      StopDate            US stop date             pic 9(8)
      *>
      *> Out: NumberOfDays     -> positiv: start < stop    pic s9(6)
      *>                          negativ: start > stop
      *>
      *> Returns the number of days between a start and stop date
      *>-----------------------------------------------------------
       method-id. "NumberOfDays".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Calculate the number of days between two dates
           compute NumberOfDays = function integer-of-date(StopDate)-
                                  function integer-of-date(StartDate)

           exit method.
       end method "NumberOfDays".

      *>-----------------------------------------------------------
      *> In : yyyymmdd         -> US date      pic 9(8)
      *>
      *> Out: DayOfWeek        -> Monday 1     pic 9
      *>                          ..
      *>                          Sunday 7
      *>      DayOfWeek-A      -> Monday Mon   pic x(3)
      *>                           ..
      *>                          Sunday Sun
      *>
      *> Returns the day of the week
      *>-----------------------------------------------------------
       method-id. "DayOfWeek".

       local-storage section.
       01 LsTemp                       pic 9(6).

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Get the number of days between the given date and a known
      *>   sunday (31-12-1600)
           compute LsTemp = function integer-of-date(yyyymmdd)

      *>---Divide the number of days by 7 to get the day of the week
      *>   as remainder of the division
           divide LsTemp by 7
                         giving LsTemp
                         remainder DayOfWeek

      *>---If there is no remainder, it is sunday
           if DayOfWeek = 0 then
               add 7 to DayOfWeek
           end-if

      *>Get the alphanumeric day of the week
           evaluate DayOfWeek
           when 1
               move "Mon" to DayOfWeek-A
           when 2
               move "Tue" to DayOfWeek-A
           when 3
               move "Wed" to DayOfWeek-A
           when 4
               move "Thu" to DayOfWeek-A
           when 5
               move "Fri" to DayOfWeek-A
           when 6
               move "Sat" to DayOfWeek-A
           when 7
               move "Sun" to DayOfWeek-A
           end-evaluate

           exit method.
       end method "DayOfWeek".

      *>-----------------------------------------------------------
      *> In : StartDate        -> US date
      *>      NumberOfDays     -> Number of days to be added to the
      *>                          date
      *>
      *> Out: StopDate         -> Resulting US date
      *>
      *> Add a number of given days to a given date and return the
      *> new date
      *>-----------------------------------------------------------
       method-id. "Plus".

       local-storage section.
       01 LsTemp                       pic 9(6).

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---Get the number of days between the given start date
      *>   and 31-12-1600
           compute LsTemp = function integer-of-date(StartDate)
      *>---Add this number to the given number of days
           compute LsTemp = LsTemp + NumberOfDays
      *>---Get the stop date using this last calculated number of
      *>   days (number of days between 31-12-1600 and the stop date)
           compute StopDate = function date-of-integer(LsTemp)

           exit method.
       end method "Plus".

      *>-----------------------------------------------------------
      *> In : None
      *>
      *> Out: yyyymmdd         -> US date                  pic 9(8)
      *>      hhmnsscc         -> hour minutes seconds hundredths
      *>                                                   pic 9(8)
      *>      ddmmyyyy         -> Euro date                pic 9(8)
      *>      dd-mm-yyyy       -> dd-mm-yyyy               pic x(10)
      *>      yyyy-mm-dd       -> yyyy-mm-dd               pic x(10)
      *>      hhmnss           -> hour minutes seconds     pic 9(6)
      *>      hh-mn-ss         -> hh:mn:ss                 pic x(8)
      *>      hhmn             -> hh:mn                    pic x(5)
      *>      dd-mm-yyyy-hhmnss -> dd-mm-yyyy hh:mn:ss     pic x(18)
      *>      yyyy-mm-dd-hhmnss -> yyyy-mm-dd hh:mn:ss     pic x(18)
      *>      DayOfYear        -> day of the year          pic 9(3)
      *>      DayOfWeek        -> Monday 1                 pic 9
      *>                          ..
      *>                          Sunday 7
      *>      DayOfWeek-a      -> Monday Mon               pic x(3)
      *>                          ..
      *>                          Sunday Sun
      *>      ExtendedDate     -> Wdy, dd-Mon-yy           pic x(14)
      *>      MonthOfYear      -> Jan .. Dec               pic x(3)
      *>
      *> Get the current time and date from the operating system
      *>-----------------------------------------------------------
       method-id. "DateAndTime".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division returning DateStruct.

      *>---Get the current time and date
           accept yyyymmdd from date YYYYMMDD
           accept hhmnsscc from time
      *>---Get the current day of the year
           accept DayOfYear from day
      *>---Get the current day of the week
           accept DayOfWeek from day-of-week
      *>---Put the time in another data field
           move hhmnsscc(1:6) to hhmnss

      *>---Invoke the methods converting the:
      *>   US date in European format
           invoke self "UsToEuro" using DateStruct
      *>---Time in display format
           invoke self "TimeToDisplay" using DateStruct
      *>---European date in display format
           invoke self "DateToDisplay" using DateStruct
      *>---European date and time in display format
           string dd-mm-yyyy delimited by size
                  " "        delimited by size
                  hhmnss-a   delimited by size
                  into dd-mm-yyyy-hhmnss
           end-string
      *>---US date and time in display format
           string yyyy-mm-dd delimited by size
                  " "        delimited by size
                  hhmnss-a   delimited by size
                  into yyyy-mm-dd-hhmnss
           end-string

           exit method.
       end method "DateAndTime".

      *>-----------------------------------------------------------
      *> In : yyyymmdd         -> Us date                      pic 9(8)
      *>      hhmnss           -> hour minutes seconds         pic 9(6)
      *>      NumberOfDays     -> Number of days to be added to the
      *>                          current date for the expiration date
      *>                          of the cookie                pic s9(6)
      *>
      *> Out: CookieExpireDate -> Expiration date of a cookie
      *>
      *> Returns an expiration date in "cookie format" using
      *> the Euro date and time of expiration. If the given date is
      *> empty (=zeros), the method uses the current date. A number
      *> of given days can be added for the expiration date.
      *>-----------------------------------------------------------
       method-id. "CookieExpire".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

      *>---If no date is given, use the current time
           if (yyyymmdd = zeros) then
      *>---Get the current time and date
               move function current-date to DateStruct(1:16)
      *>---Put the time in another data field
               move hhmnsscc(1:6) to hhmnss
           end-if

      *>---Add the number of days to the current date
           move yyyymmdd to StartDate
           invoke Self "Plus" using DateStruct
      *>---Convert the US date to Euro format
           move StopDate to yyyymmdd
           invoke Self "UsToEuro" using DateStruct

      *>---Time and date in display format
           invoke Self "TimeToDisplay" using DateStruct
           invoke Self "DateToDisplay" using DateStruct

      *>---Put the cookie format together
           string ExtendedDate delimited by size
                  space        delimited by size
                  hhmnss-a     delimited by size
           into CookieExpireDate

           exit method.
       end method "CookieExpire".

      *>-----------------------------------------------------------
      *> In : ddmmyyyy         -> Euro date        pic 9(8)
      *>
      *> Out: MonthOfYear      -> January  Jan     pic x(3)
      *>                           ..
      *>                          December Dec
      *>
      *>> Returns the month of the year in alphanumeric
      *>-----------------------------------------------------------
       method-id. "MonthOfYear".

       local-storage section.

       linkage section.
       copy "Dates.cpy".

       procedure division using DateStruct.

           evaluate ddmmyyyy(3:2)
           when 01
               move "Jan" to MonthOfYear
           when 02
               move "Feb" to MonthOfYear
           when 03
               move "Mar" to MonthOfYear
           when 04
               move "Apr" to MonthOfYear
           when 05
               move "May" to MonthOfYear
           when 06
               move "Jun" to MonthOfYear
           when 07
               move "Jul" to MonthOfYear
           when 08
               move "Aug" to MonthOfYear
           when 09
               move "Sep" to MonthOfYear
           when 10
               move "Oct" to MonthOfYear
           when 11
               move "Nov" to MonthOfYear
           when 12
               move "Dec" to MonthOfYear
           end-evaluate

           exit method.
       end method "MonthOfYear".

      *>-----------------------------------------------------------
      *> Destruction of this object.
      *>-----------------------------------------------------------
       method-id. "Finalize".

       local-storage section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke Super "Finalize" returning lnkData

           exit method.
       end method "Finalize".

       end object.
       end class Dates.
