      $set preprocess(htmlpp) endp
      *>****************************************************************
       identification division.
      *>****************************************************************
           program-id. Eurecas.

      *>****************************************************************
       environment division.
      *>****************************************************************

       class-control.
       copy "ClCtrl.cpy".

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.
       01 FrameSource                  pic x(255).
       01 USNbrSignon                  pic z(17)9.
       copy "UsCtrl.cpy".
       copy "ObjRef.cpy".
      *>----------------------------------------------------------------
           copy "eurecas.cpf".
      *>----------------------------------------------------------------
           copy "eurecas.cpy".
      *>----------------------------------------------------------------

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main Section.
           *> make library entry-point visible
      *    call "tools.lbr"
      *    call "utils.lbr"
      *    call "acccgi"

           perform process-form-input-data
           evaluate f-action
               when spaces
                   perform Counter
                   perform signon-cvt
                   perform signon-out
               when "Entrer"
                   perform app-running
                   perform convert-input-signon
                   perform process-signon
                   perform welcome-cvt
                   perform welcome-out
               when "Changer code accs"
                   perform user-control
                   perform convert-input-welcome
                   perform password-cvt
                   perform password-out
               when "Ok"
                   perform user-control
                   perform convert-input-password
                   perform process-password
                   perform welcome-cvt
                   perform welcome-out
               when "Continuer"
                   perform user-control
                   perform convert-input-welcome
                   perform process-continue
               when "Annuler"
                   perform Counter
                   perform signon-cvt
                   perform signon-out

           end-evaluate
           stop run.

      *>----------------------------------------------------------------
       process-form-input-data section.
           initialize htmlform
           accept htmlform

           exit.
      *>-------------------------------------------------------------
       Counter section.
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Counter" using FormFields
           invoke UsCtrlRef "Finalize" returning UsCtrlRef
           move USNbrSignonTemp to USNbrSignon.
           exit.
      *>-------------------------------------------------------------
       app-running section.
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "App-Running" using UsCtrlStruct
           invoke UsCtrlRef "Finalize" returning UsCtrlRef
           if UsCtrlMsg <> spaces
               move UsCtrlMsg to Msg
               perform output-form-error-and-stop
           end-if.
           exit.
      *>-------------------------------------------------------------
       user-control section.
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Common" using UsCtrlStruct
           invoke UsCtrlRef "Finalize" returning UsCtrlRef.
           exit.
      *>-------------------------------------------------------------
       convert-input-signon section.
           move spaces to v-First-Bad
           move function upper-case(f-USShortname) to USShortname
           move function upper-case(f-USPassword) to USPassword
           move f-USNbrSignonTemp to USNbrSignonTemp
           if USShortname = spaces
              move "User Identification is required."
              to v-first-bad
           else
               if USPassword = spaces
                   move "Password is required." to v-first-bad
               end-if
           end-if
           if v-first-bad not = spaces
              move USNbrSignonTemp to UsNbrSignon
              perform signon-cvt
              perform signon-out
              perform output-form-error-and-stop
           end-if.
           exit.
      *>----------------------------------------------------------------
       process-signon Section.
           call "pSignon" using FormFields
           move USNbrSignonTemp to USNbrSignon
           if Msg not = spaces
               if Msg(1:8) = "Password" then
                   perform password-cvt
                   perform password-out
                   perform output-form-error-and-stop
               end-if
               perform signon-cvt
               perform signon-out
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       convert-input-password section.
           move spaces to v-First-Bad
           move f-USShortname to USShortname
           move f-USName to USName
           move f-GRName to GRName
           move f-DPTName to DPTName
           move function upper-case(f-OldPassword) to OldPassword
           move function upper-case(f-NewPassword1) to NewPassword1
           move function upper-case(f-NewPassword2) to NewPassword2
           move f-USPhone to USPhone
           move f-USFax to USFax
           move f-USEMail to USEMail
           move f-USNbrSignonTemp to USNbrSignonTemp USNbrSignon

           if (NewPassword1 <> NewPassword2) then
               move "The confirmation password and the new password do n
      -    "ot match. " to v-First-Bad
           else
               if OldPassword = spaces or
                  NewPassword1 = spaces or
                  NewPassword2 = spaces then
                   move "Please fill out all the fields." to v-First-Bad
               end-if
           end-if

           if v-first-bad not = spaces
              perform password-cvt
              perform password-out
              perform output-form-error-and-stop
           end-if

           exit.

       convert-input-welcome section.
           move f-USShortname to USShortname
           move f-USNbrSignonTemp to USNbrSignonTemp
           exit.

       process-password section.
           call "pPass" using FormFields
           if Msg not = spaces
              perform password-cvt
              perform password-out
              perform output-form-error-and-stop
           end-if
           exit.

       process-continue section.
           if UsCtrlUrl = spaces then
               move "/COBOL/IMAGE/Blank.htm" to FrameSource
           else
               move UsCtrlUrl to FrameSource
           end-if

       exec html
       <html>
       <head>
       <title>Eurecas</title>
       </head>
       <frameset cols="20%,80%">
           <frame src="/cgi-bin/toc.exe?CHID=:UsCtrlID"
                   name="toc" marginwidth="1"
           marginheight="1" scrolling="No">
           <frame src=":FrameSource" name="main" marginwidth="1"
           marginheight="1">
           <noframes>
           <body>
           <p>This web page uses frames, but your browser doesn't
           support them.</p>
           </body>
           </noframes>
       </frameset>
       </html>
           end-exec
           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           if Msg = spaces
              move v-first-bad to Msg
           end-if
           exec html
              <SCRIPT>
              alert(":Msg")
              </SCRIPT>
           end-exec
           stop run.
      *>----------------------------------------------------------------
           copy "eurecas.cpv".
      *>----------------------------------------------------------------

