      *>-----------------------------------------------------------
      *> Http class implementing methods for reading environment
      *> variables set by a httpd daemon.
      *>-----------------------------------------------------------

      $set mfoo ooctrl(+n)

       class-id. Http data is protected
                       inherits from Base.

       object section.
      *>---Classes used by the Http class
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object.
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.

       procedure division returning LnkApplication.

          invoke Super "New" returning LnkApplication
          invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>---------------------------------------------------------------
       method-id. "Init".

       procedure division.

           exit method.
       end method "Init".

      *>-----------------------------------------------------------
      *> Name and version of httpd daemon.
      *> Format: name/version
      *>-----------------------------------------------------------
       method-id. "GetServerSoftware".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "SERVER_SOFTWARE" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetServerSoftware".

      *>-----------------------------------------------------------
      *> IP name or IP address of the computer running the daemon.
      *>-----------------------------------------------------------
       method-id. "GetServerName".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "SERVER_NAME" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetServerName".

      *>-----------------------------------------------------------
      *> Version of the cgi gateway of the Web server.
      *> Format: CGI/version
      *>-----------------------------------------------------------
       method-id. "GetGatewayInterface".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "GATEWAY_INTERFACE" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetGatewayInterface".

      *>-----------------------------------------------------------
      *> Name and version of the protocol used for the current query
      *> Format: protocol/version
      *>-----------------------------------------------------------
       method-id. "GetServerProtocol".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "SERVER_PROTOCOL" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetServerProtocol".

      *>-----------------------------------------------------------
      *> The IP port, the query was sent to (f.ex.: 80).
      *>-----------------------------------------------------------
       method-id. "GetServerPort".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "SERVER_PORT" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetServerPort".

      *>-----------------------------------------------------------
      *> Method used for the query (post, get).
      *>-----------------------------------------------------------
       method-id. "GetRequestMethod".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "REQUEST_METHOD" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetRequestMethod".

      *>-----------------------------------------------------------
      *> Script name starting at the root directory of the Web
      *> server (f.ex.: /cgi-bin/test_script)
      *>-----------------------------------------------------------
       method-id. "GetScriptName".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "SCRIPT_NAME" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetScriptName".

      *>-----------------------------------------------------------
      *> Name of the computer that did the query. If this computer
      *> doesn't have a name, the Web server gives only REMOTE_ADDR.
      *>-----------------------------------------------------------
       method-id. "GetRemoteHost".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.
           display "HTTP_COOKIE" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetRemoteHost".

      *>-----------------------------------------------------------
      *> IP address of the computer that did the query.
      *>-----------------------------------------------------------
       method-id. "GetRemoteAddr".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "REMOTE_ADDR" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetRemoteAddr".

      *>-----------------------------------------------------------
      *> If the server allows to authenticate a user and if the script
      *> called by the query is secured, then this variable
      *> returns the method used to validate a user.
      *>-----------------------------------------------------------
       method-id. "GetAuthType".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "AUTH_TYPE" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetAuthType".

      *>-----------------------------------------------------------
      *> If the server allows to authenticate a user and if the script
      *> called by the query is secured, then this variable
      *> returns the name of the user that did the query.
      *>-----------------------------------------------------------
       method-id. "GetRemoteUser".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "REMOTE_USER" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetRemoteUser".

      *>-----------------------------------------------------------
      *> This variable is not supported by every Web server. When
      *> used, it gives the name of the user logged on (in terms of
      *> the Operating System) the computer that did the query.
      *>-----------------------------------------------------------
       method-id. "GetRemoteIdent".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "REMOTE_IDENT" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetRemoteIdent".

      *>-----------------------------------------------------------
      *> For queries sending data, this variable gives the type of
      *> the data sent by the client. The used format is the
      *> MIME format.
      *>-----------------------------------------------------------
       method-id. "GetContentType".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "CONTENT_TYPE" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetContentType".

      *>-----------------------------------------------------------
      *> Length of the data sent by the client.
      *>-----------------------------------------------------------
       method-id. "GetContentLength".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "CONTENT_LENGTH" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetContentLength".

      *>-----------------------------------------------------------
      *> It is the character string following the script name and
      *> preceding the '?' character or the end of the URL if there
      *> is no '?'.
      *>-----------------------------------------------------------
       method-id. "GetPathInfo".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "PATH_INFO" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetPathInfo".

      *>-----------------------------------------------------------
      *> It is the character string following the first '?' after
      *> the script name, and stopping at the end of the URL.
      *>-----------------------------------------------------------
       method-id. "GetQueryString".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "QUERY_STRING" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetQueryString".

      *>-----------------------------------------------------------
      *> It corresponds to the variable PATH_INFO appended to the
      *> root directory of the Web server.
      *>-----------------------------------------------------------
       method-id. "GetPathTranslated".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "PATH_TRANSLATED" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetPathTranslated".

      *>-----------------------------------------------------------
      *> List of the MIME types accepted by the client that did the
      *> query.
      *> Format: type/subtype, type/subtype...
      *>-----------------------------------------------------------
       method-id. "GetHttpAccept".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "HTTP_COOKIE" upon environment-name
           accept HttpEnvVar from environment-value
      *    display "HTTP_ACCEPT" upon environment-name
      *    accept HttpEnvVar from environment-value

           exit method.
       end method "GetHttpAccept".

      *>-----------------------------------------------------------
      *> Information concerning the client that did the query.
      *> Format: software/version library/version
      *>-----------------------------------------------------------
       method-id. "GetHttpUserAgent".

       local-storage section.

       linkage section.
       copy "Http.cpy".

       procedure division returning HttpStruct.

           display "HTTP_USER_AGENT" upon environment-name
           accept HttpEnvVar from environment-value

           exit method.
       end method "GetHttpUserAgent".

      *>---------------------------------------------------------------
      *> Destruction of this object.
      *>---------------------------------------------------------------
       method-id. "Finalize".

       local-storage Section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke Super "Finalize" returning LnkData

           exit method.
       end method "Finalize".

       end object.
       end class Http.
