      *>-----------------------------------------------------------
      *> Ini class description:
      *> -Retrieves a string from the specified section in an
      *>  initialization file
      *> -Copies a string into the specified section of the specified
      *>  initialization file
      *>-----------------------------------------------------------

      *>-----------------------------------------------------------
      * Compile using the CASE directive, because Win32 entry points
      * are case-sensitive.
      *>-----------------------------------------------------------
      $set case mfoo ooctrl(+n)

       class-id. Ini data is protected
                       inherits from Base.

      *>-----------------------------------------------------------
      * Call-convention 74 is used to call Win API functions from
      * Cobol.
      *>-----------------------------------------------------------
       special-names.
       call-convention 74 is WINAPI.

       object section.
      *>---Classes used by the Ini class
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(10) value z"Not found".

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication          object reference.

       procedure division returning LnkApplication.

           invoke Super "New" returning LnkApplication
           invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>---------------------------------------------------------------
       method-id. "Init".

       procedure division.
      *>---Needed when making calls to the Win32 API from intermediate
      *>   and generated code
           call "cob32api"

           exit method.
       end method "Init".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : IniString
      *
      *> Retrieves a string, associated to a given key,
      *> from the specified section in an initialization file and
      *> returns the resulting structure containing the wanted string.
      *> When no string is found, the default string is returned.
      *> If the file name does not not contain a full path to the file,
      *> Windows searches for the file in the Windows directory
      *>---------------------------------------------------------------
       method-id. "GetString".

       local-storage Section.
       01 LsBufferSize                 pic 9(9) comp-5.
      *>---Number of characters copied to the buffer, not including
      *>   the terminating null character
       01 LsReturnStringSize           pic 9(9) comp-5.

       linkage section.
       copy "Ini.cpy".

       procedure division using IniStruct.

           initialize LsBufferSize LsBufferSize IniString

      *>---Transform the given strings to null-terminated strings
           invoke Self "ToNullTerminated" using IniStruct

      *>---Windows Api function call returning the string
           call WINAPI "GetPrivateProfileStringA"
                           using by reference IniSectionName
                                    reference IniKeyName
                                    reference WsIniDefaultString
                                    reference IniString
                                    reference LsBufferSize
                                    reference IniFileName
                           returning LsReturnStringSize

      *>---Retrieves the null characters from the strings
           invoke Self "FromNullTerminated" using IniStruct

           exit method.
       end method "GetString".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : None
      *>
      *> Writes a string, associated to the given key, in the specified
      *> section in an initialization file. If the file name does
      *> not contain a full path and filename for the file, then
      *> the Windows directory is searched for the file. If the file
      *> does not exist, it is created in the Windows directory. If
      *> the given section or key name do not exist, they are created.
      *>---------------------------------------------------------------
       method-id. "SetString".

       local-storage Section.
      *>---Boolean: Function call was successfull or not
       01 IniResult                    pic 9(4) comp-5.
           88 ResultOk     value 1.
           88 ResultKo     value 0.

       linkage section.
       copy "Ini.cpy".

       procedure division using IniStruct.

           initialize IniResult

      *>---Transform the given strings to null-terminated strings
           invoke Self "ToNullTerminated" using IniStruct

      *>---Windows Api function call writing in the initialization file
           call WINAPI "WritePrivateProfileStringA"
                           using by reference IniSectionName
                                    reference IniKeyName
                                    reference IniString
                                    reference IniFileName
                           returning IniResult

      *>---Retrieves the null characters from the strings
           invoke Self "FromNullTerminated" using IniStruct

           exit method.
       end method "SetString".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : None
      *>
      *> Deletes the given key in the specified section in an
      *> initialization file. If the file name does not contain
      *> a full path and filename for the file, then the Windows
      *> directory is searched for the file. If the file
      *> does not exist, it is created in the Windows directory.
      *>---------------------------------------------------------------
       method-id. "DeleteKey".

       local-storage Section.
      *>---Pointer to the string to be written
       01 LsStringPr                       pointer.
      *>---Boolean: Function call was successfull or not
       01 IniResult                        pic 9(4) comp-5.
           88 ResultOk     value 1.
           88 ResultKo     value 0.

       linkage section.
       copy "Ini.cpy".

       procedure division using IniStruct.

           initialize IniResult IniString

      *>---Transform the given strings to null-terminated strings
           invoke Self "ToNullTerminated" using IniStruct

      *>---Set the string pointer to null, to allow the destruction
      *>   of the associated key
           set LsStringPr to null

      *>---Windows Api function call writing in the initialization file
           call WINAPI "WritePrivateProfileStringA"
                           using by reference IniSectionName
                                    reference IniKeyName
                                    value     LsStringPr
                                    reference IniFileName
                           returning IniResult

      *>---Retrieves the null characters from the strings
           invoke Self "FromNullTerminated" using IniStruct

           exit method.
       end method "DeleteKey".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : None
      *>
      *> Deletes the section in an initialization file. If the file
      *> name does not contain a full path and filename for the
      *> file, then the Windows directory is searched for the
      *> file. If the file does not exist, it is created in the
      *> Windows directory.
      *>---------------------------------------------------------------
       method-id. "DeleteSection".

       local-storage Section.
      *>---Pointer to the string to be written
       01 LsStringPr                       pointer.
      *>---Pointer to the key name
       01 LsKeyPr                          pointer.
      *>---Boolean: Function call was successfull or not
       01 LsResult                         pic 9(4) comp-5.
           88 ResultOk     value 1.
           88 ResultKo     value 0.

       linkage section.
       copy "Ini.cpy".
       procedure division using IniStruct.

           initialize LsResult IniString IniKeyName

      *>---Transform the given strings to null-terminated strings
           invoke Self "ToNullTerminated" using IniStruct

      *>---Set the pointers to null
           set LsStringPr to null
           set LsKeyPr to null

      *>---Windows Api function call writing in the initialization file
           call WINAPI "WritePrivateProfileStringA"
                           using by reference IniSectionName
                                    value     LsKeyPr
                                    value     LsStringPr
                                    reference IniFileName
                           returning LsResult

      *>---Retrieves the null characters from the strings
           invoke Self "FromNullTerminated" using IniStruct

           exit method.
       end method "DeleteSection".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : IniStruct
      *>
      *> This method transforms the strings of the given structure
      *> to null-terminated strings, if they are not empty and returns
      *> the resulting structure.
      *>---------------------------------------------------------------
       method-id. "ToNullTerminated".

       local-storage Section.
      *>---Length of the strings
       01 LsLength                     pic 9(4).

       linkage section.
       copy "Ini.cpy".

       procedure division using IniStruct.
           initialize LsLength

      *>---Transformation of the "ini" file name
           if IniFileName <> spaces then
               move length of IniFileName to LsLength
               if IniFileName(LsLength:1) = space then
                   subtract 1 from LsLength
                   perform until LsLength = 0
                       if IniFileName(LsLength:1) <> space then
                           move x"00" to IniFileName(LsLength + 1 : 1)
                           exit perform
                       end-if
                       subtract 1 from LsLength
                   end-perform
               end-if
           else
               move x"00" to IniFileName(1:1)
           end-if

      *>---Transformation of the section name
           if IniSectionName <> spaces then
               move length of IniSectionName to LsLength
               if IniSectionName(LsLength:1) = space then
                   subtract 1 from LsLength
                   perform until LsLength = 0
                       if IniSectionName(LsLength:1) <> space then
                           move x"00" to
                               IniSectionName(LsLength + 1 : 1)
                           exit perform
                       end-if
                       subtract 1 from LsLength
                   end-perform
               end-if
           else
               move x"00" to IniSectionName(1:1)
           end-if

      *>---Transformation of the key name
           if IniKeyName <> spaces then
               move length of IniKeyName to LsLength
               if IniKeyName(LsLength:1) = space then
                   subtract 1 from LsLength
                   perform until LsLength = 0
                       if IniKeyName(LsLength:1) <> space then
                           move x"00" to IniKeyName(LsLength + 1 : 1)
                           exit perform
                       end-if
                       subtract 1 from LsLength
                   end-perform
               end-if
           else
               move x"00" to IniKeyName(1:1)
           end-if

      *>---Transformation of the string to be written
           if IniString <> spaces then
               move length of IniString to LsLength
               if IniString(LsLength:1) = space then
                   subtract 1 from LsLength
                   perform until LsLength = 0
                       if IniString(LsLength:1) <> space then
                           move x"00" to IniString(LsLength + 1 : 1)
                           exit perform
                       end-if
                       subtract 1 from LsLength
                   end-perform
               end-if
           else
               move x"00" to IniString(1:1)
           end-if

           exit method.
       end method "ToNullTerminated".

      *>---------------------------------------------------------------
      *> In  : IniStruct
      *>
      *> Out : IniStruct
      *>
      *> This method replaces every null character in the given
      *> structure with a space and returns the resulting structure.
      *>---------------------------------------------------------------
       method-id. "FromNullTerminated".

       linkage section.
       copy "Ini.cpy".

       procedure division using IniStruct.

           inspect IniStruct replacing all x"00" by space

           exit method.
       end method "FromNullTerminated".

      *>---------------------------------------------------------------
      *> Destruction of this object.
      *>---------------------------------------------------------------
       method-id. "Finalize".

       local-storage Section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke Super "Finalize" returning LnkData

           exit method.
       end method "Finalize".

       end object.
       end class Ini.
