       identification division.
       program-id. pPass.

       class-control.
       copy "ClCtrl.cpy".

       data division.
       working-storage section.
       copy "ObjRef.cpy".
       01 WsDefaultDefaultPassword     pic x(7) value "EURECAS".
       01 WsIniDefaultString           pic x(9) value "Not found".

      *>definitions of sqlcode, etc
       exec sql include SQLCA end-exec

       copy "Users.cpy".
       copy "Ini.cpy".
       copy "Dates.cpy".
       linkage section.
       copy "Eurecas.cpy".

       procedure division using FormFields.
       prog section.

           invoke Ini "New" returning IniRef
           initialize IniStruct
      *>---Get the default password from the eurecas "ini" file
           move "..\eurecas.ini"   to IniFileName
           move "Signon"          to IniSectionName
           move "Default-Password"   to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If password not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultDefaultPassword to IniString
           end-if

           if IniString(1:8) = NewPassword2 then
               move "Password cannot be set back to default password."
                                                             to Msg
           end-if

           invoke IniRef "Finalize" returning IniRef

           if Msg = spaces

               EXEC SQL
                   SELECT US.NAME, GR.NAME, DP.NAME, US.PHONE,
                          US.FAX, US.E_MAIL
                   INTO :USName, :GRName, :DPTName, :USPhone:USInd,
                        :USFax:USInd, :USEMail:USInd
                   FROM USERS_V US, USER_GROUP_V GR, DPT_V DP
                   WHERE  US.ID_BELONGS_TO = GR.ID AND
                          US.ID_IS_IN = DP.ID      AND
                          US.SHORTNAME = :USShortname
               END-EXEC

               perform errors

               EXEC SQL
                   UPDATE USERS_V SET PASSWORD = :NewPassword2
                       WHERE PASSWORD = :OldPassword AND
                             SHORTNAME = :USShortname
               END-EXEC

               if sqlcode = 100 then
                   move "Password change was not successful. Please chec"
      -    "k the given old password." to Msg
                   perform exit-ok
               end-if

               perform errors
      *>---Get system date and time
               invoke Dates "New" returning DatesRef
               invoke DatesRef "DateAndTime" returning DateStruct
               invoke DatesRef "Finalize" returning DatesRef
               EXEC SQL
                   UPDATE USERS_V SET PASS_DATE = :yyyy-mm-dd
                       WHERE SHORTNAME = :USShortname
               END-EXEC

               perform errors

           end-if

           perform exit-ok.

       errors section.
           if sqlcode not = 0 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to Msg

               EXEC SQL ROLLBACK END-EXEC

               exit program
           end-if.

       exit-ok section.
           EXEC SQL COMMIT END-EXEC

           exit program.

       end program pPass.
