       identification division.
       program-id. pSignon.

       class-control.
       copy "ClCtrl.cpy".

       data division.
       working-storage section.
      *>---Default values when none is found in the "ini" file
       01 WsDefaultTriesTimeout        pic x value "1".
       01 WsDefaultSignonTries         pic x value "3".
       01 WsDefaultDefaultPassword     pic x(7) value "PASSINI".
       01 WsDefaultPasswordExpired     pic x(2) value "30".
       01 WsDefaultCookieExpired       pic x(4) value "0001".
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(9) value "Not found".
       01 Temp                         pic 9(03).
       01 TempX10                      pic x(10).
       01 SignonTries                  pic 9(02).
       copy "Ini.cpy".
       copy "Cookie.cpy".
       copy "UsCtrl.cpy".
       copy "ObjRef.cpy".
       copy "Connect.cpy".
       copy "Dates.cpy".
      *>definitions of sqlcode, etc
       exec sql include SQLCA end-exec

       exec sql begin declare section end-exec
       copy "Users.cpy".
       01 DifferenceInDays             pic s9(4)v9.
       exec sql end declare section end-exec


       linkage section.
       exec sql begin declare section end-exec
       copy "Eurecas.cpy".
       exec sql end declare section end-exec

       procedure division using FormFields.
       prog section.
           initialize CookieStruct

      *>---Get the reference of the new Connect class object
           invoke Connect "New" returning ConnectRef
      *>---Realize the connection to the data base
           invoke ConnectRef "ConnectDb" returning ConnectStruct

           invoke ConnectRef "Finalize" returning ConnectRef

           move ConnectMsg to Msg
      *>---Get system date and time
           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           invoke DatesRef "Finalize" returning DatesRef

      *>---Get the user name, group name and password of the user
           if Msg = spaces *>connection OK
               EXEC SQL
                   SELECT US.NAME, GR.NAME, DP.NAME, US.ID,
                          US.PASSWORD, US.PHONE, US.FAX, US.E_MAIL
                   INTO :USName, :GRName, :DPTName, :US-Id,
                        :US-Password, :USPhone:USInd, :USFax:USInd,
                        :USEMail:USInd
                   FROM USERS_V US, USER_GROUP_V GR, DPT_V DP
                   WHERE  US.ID_BELONGS_TO = GR.ID AND
                          US.ID_IS_IN = DP.ID      AND
                          US.SHORTNAME = :USShortname
               END-EXEC

               if sqlcode <> 0 then
                   if sqlcode = 100 then
                       move "Signon was not successful. Please check you
      -        "r UserId." to Msg
                       perform exit-ok
                   else
                       perform errors
                   end-if
               end-if

               invoke Ini "New" returning IniRef
      *>------Get the number of signon tries before locking
      *>      from the eurecas "ini" file
               move "..\eurecas.ini"   to IniFileName
               move "Signon"          to IniSectionName
               move "Signon-Tries"   to IniKeyName

               invoke IniRef "GetString" using IniStruct
               invoke IniRef "Finalize" returning IniRef

      *>------If cookie expiration not found, use the default
               if IniString(1:9) = WsIniDefaultString(1:9) then
                       move WsDefaultSignonTries to IniString
               end-if

               compute SignonTries = function NUMVAL(IniString)

      *>------test if user account is not locked due to 3 failed signons
               perform test-locked-signon

      *>------Check the user password
               if US-Password not = USPassword
                   move "Signon was not successful. Please check your pa
      -    "ssword." to Msg
      *>-------Increment the number of tries
                   add 1 to US-NbrTries
                   perform set-nbr-tries

                   if US-NbrTries >= SignonTries then
      *>-------Set the date of account locking
                       EXEC SQL
                           UPDATE USERS_V SET LOCK_DATE = :yyyy-mm-dd
                           WHERE ID = :US-Id
                       END-EXEC

                       perform errors

                       initialize Msg
                       perform locked-account
                   end-if

                   perform exit-ok

               else  *>signon OK
      *>------Set the number of login tries to zero
                   if US-NbrTries not = 0 then
                       move 0 to US-NbrTries
                       perform set-nbr-tries
                   end-if


      *>-------Get the number of user signons
                   initialize US-NbrSignon

                   EXEC SQL
                       SELECT US.NBR_SIGNON
                       INTO :US-NbrSignon:USInd
                       FROM USERS_V US
                       WHERE ID = :US-Id
                   END-EXEC

                   perform errors

                   compute US-NbrSignon = US-NbrSignon + 1

      *>-------Increment the number of user signons
                   EXEC SQL
                       UPDATE USERS_V
                       SET NBR_SIGNON = :US-NbrSignon
                       WHERE ID = :US-Id
                   END-EXEC

                   perform errors

                   move US-NbrSignon to USNbrSignonTemp


      *>-------Set the date of this signon event
                   EXEC SQL
                       UPDATE USERS_V SET LAST_EVENT = :yyyy-mm-dd
                       WHERE ID = :US-Id
                   END-EXEC

                   perform errors

      *>------Cookie creation
                   move yyyymmdd to Cyyyymmdd
                   move hhmnss to Chhmnss

                   string Cyyyymmdd
                          Chhmnss
                          USShortname into US-CookieValue

                   EXEC SQL
                       UPDATE USERS_V SET COOKIE_VALUE = :US-CookieValue
                       WHERE ID = :US-Id
                   END-EXEC

                   perform errors

                   move US-CookieValue to UsCtrlString

                   invoke UsCtrl "New" returning UsCtrlRef
                   invoke UsCtrlRef "Encryption"
                                           using UsCtrlStruct
                   invoke UsCtrlRef "Finalize"
                                           returning UsCtrlRef

                   invoke Ini "New" returning IniRef
      *>------Get the number of days before cookie expiration
                   move "..\eurecas.ini"    to IniFileName
                   move "Signon"           to IniSectionName
                   move "Cookie-Expired"   to IniKeyName

                   invoke IniRef "GetString" using IniStruct
                   invoke IniRef "Finalize" returning IniRef

      *>------If cookie expiration not found, use the default
                   if IniString(1:9) = WsIniDefaultString(1:9) then
                           move WsDefaultCookieExpired to IniString
                   end-if

                   compute CNumberOfDays = function NUMVAL(IniString)

                   invoke Cookie "New" returning CookieRef

                   move UsCtrlString to CookieValue
                   move "CookieId" to CookieName

                   invoke CookieRef "SetCookie"
                                           using CookieStruct
                   invoke CookieRef "Finalize"
                                           returning CookieRef

                   invoke Ini "New" returning IniRef
      *>------Get the default password from the eurecas "ini" file
                   move "..\eurecas.ini"   to IniFileName
                   move "Signon"          to IniSectionName
                   move "Default-Password"   to IniKeyName

                   invoke IniRef "GetString" using IniStruct

      *>------If password not found, use the default
                   if IniString(1:9) =
                       WsIniDefaultString(1:9) then
                       move WsDefaultDefaultPassword to IniString
                   end-if

                   if IniString(1:8) = US-Password(1:8) then
                       move "Password has to be changed, due to the need
      -    " to change the default password." to Msg

                       invoke IniRef "Finalize"
                                           returning IniRef
                       perform exit-ok
                   end-if

      *>------Get the password expiration from the eurecas "ini" file
                   Initialize IniStruct
                   move "..\eurecas.ini"   to IniFileName
                   move "Signon"          to IniSectionName
                   move "Password-Expired"   to IniKeyName

                   invoke IniRef "GetString" using IniStruct

      *>------If password not found, use the default
                   if IniString(1:9) =
                       WsIniDefaultString(1:9) then
                       move WsDefaultPasswordExpired to IniString
                   end-if

                   compute Temp = function NUMVAL(IniString)

      *>------Get the number of days between now and the last
      *>      password change, minus the password expiration
                   exec sql
                       select PASS_DATE
                       into :TempX10:UsInd
                       from USERS_V
                       where ID = :US-Id
                   end-exec
                   perform errors
                   initialize NumberOfDays
                   if TempX10 <> spaces
      *>---Get system date and time
                      invoke Dates "New" returning DatesRef
                      invoke DatesRef "DateAndTime" returning DateStruct
                      move yyyymmdd to StopDate
                      move TempX10 to yyyy-mm-dd
                      invoke DatesRef "DisplayToDate" using DateStruct
                      move yyyymmdd to StartDate
                      invoke DatesRef "NumberOfDays" using DateStruct
                      invoke DatesRef "Finalize" returning DatesRef
                   end-if
      *>------Check if the password is expired
                   if NumberOfDays > Temp then
                       move "Password has to be changed, due to the expi
      -    "ration of the password." to Msg
                       perform exit-ok
                   end-if

                   invoke IniRef "Finalize" returning IniRef
                   perform exit-ok

               end-if
           end-if

           exit program.

       test-locked-signon section.
      *>---Check number of login tries
           initialize US-NbrTries

           EXEC SQL
               SELECT US.NBR_TRIES
               INTO :US-NbrTries:USInd
               FROM USERS_V US
               WHERE US.ID = :US-Id
           END-EXEC

           perform errors

           if US-NbrTries >= SignonTries then
               invoke Ini "New" returning IniRef
      *>------Get the login tries timeout from the eurecas "ini" file
               move "..\eurecas.ini"   to IniFileName
               move "Signon"          to IniSectionName
               move "Tries-Timeout"   to IniKeyName

               invoke IniRef "GetString" using IniStruct

               invoke IniRef "Finalize" returning IniRef

      *>------If timeout not found, use the default
               if IniString(1:9) = WsIniDefaultString(1:9) then
                   move WsDefaultTriesTimeout to IniString
               end-if

               compute Temp = function NUMVAL(IniString)

      *>------Get the number of days between now and the account locking
      *>      date, minus the signon timeout

      *>---Get system date and time
              invoke Dates "New" returning DatesRef
              invoke DatesRef "DateAndTime" returning DateStruct
              move yyyymmdd to StopDate
              exec sql
                  select LOCK_DATE
                  into :yyyy-mm-dd
                  from USERS_V
                  where ID = :US-Id
              end-exec
              perform errors
              invoke DatesRef "DisplayToDate" using DateStruct
              move yyyymmdd to StartDate
              invoke DatesRef "NumberOfDays" using DateStruct
              invoke DatesRef "Finalize" returning DatesRef
              compute DifferenceInDays = NumberOfDays - Temp

      *>------Check if the account is still locked
               if DifferenceInDays < 0 then
                   perform locked-account
               else
      *>------Set the number of login tries to zero
                   move 0 to US-NbrTries
                   perform set-nbr-tries
               end-if

           end-if
           exit.

       locked-account section.
           string "Your account is locked due to "
                   SignonTries
                   " failed signon tries." into Msg
           perform exit-ok
           exit.

      *>---Check of Sql errors
       errors section.
           if sqlcode <> 0 and 1 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to Msg

               EXEC SQL ROLLBACK END-EXEC
               EXEC SQL DISCONNECT END-EXEC

               exit program
           end-if
           exit.

      *>---Update the number of login tries
       set-nbr-tries section.
           EXEC SQL
               UPDATE USERS_V SET NBR_TRIES = :US-NbrTries
               WHERE ID = :US-Id
           END-EXEC

           perform errors
           exit.

      *>---Disconnect from data base and exit the programm
       exit-ok section.
           EXEC SQL COMMIT END-EXEC
           EXEC SQL DISCONNECT END-EXEC

           exit program.

       end program pSignon.
