      *>-----------------------------------------------------------
      *
      *>-----------------------------------------------------------
       class-id. Tree data is protected
                      inherits from Base.

       object section.
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------
       copy "ObjRef.cpy".
      *>definitions of sqlcode, etc
       exec sql include SQLCA end-exec

       exec sql begin declare section end-exec
       01 TempStruct.
           05 TempInd                  occurs 500 pic s9(4) comp-5.
           05 TempMax                  pic 9(3).
           05 TempId                   occurs 500 pic 9(12).
           05 TempIdIsIn               occurs 500 pic 9(12).
           05 TempTabNr                occurs 500 pic 9(12).
           05 TempLineNr               occurs 500 pic 9(12).
           05 TempUrl                  occurs 500 pic x(254).
           05 TempHyperLink            occurs 500 pic x(254).
           05 TempImgSrc               occurs 500 pic x(254).
       exec sql end declare section end-exec
       01 Rien                         pic x(50) value all ".....".
      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.

       procedure division returning LnkApplication.

          invoke Super "new" returning LnkApplication
          invoke LnkApplication "Init"

           exit method.
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>-----------------------------------------------------------
       method-id. "Init".

       procedure division.
           initialize TempStruct

           exit method.
       end method "Init".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "Create".

       local-storage section.
       copy "Chapter.cpy".
       01 Temp                         pic 9(12).
       01 TempI                        pic 9(3).
       linkage section.
       copy "Toc-Tab.cpy".

       procedure division using Toc-Tab.

      *>---Si c'est la premiere fois, remplire la table temporaire
           if TempMax <> 0
               *>ID du chapitre pour lequel on recherche les fils
               move Toc-Id(Toc-Idx) to Temp
           else
               *>first time
               Initialize Temp Toc-Tab
               EXEC SQL
                   DECLARE CUR CURSOR FOR
                   SELECT CH.HYPER_LINK
                         ,CH.ID
                         ,CH.TAB_NR
                         ,CH.ID_IS_IN_CHAPTER
                         ,CH.MASTER_URL
                   FROM CHAPTER_V CH
                   WHERE CH.STATUS = 'Valid'
                   ORDER BY CH.ID_IS_IN_CHAPTER,
                            CH.SEQ_NBR, CH.HYPER_LINK
               END-EXEC

               EXEC SQL OPEN CUR END-EXEC

               perform varying TempI from 1 by 1 until TempI = 500
                       initialize ChapterTable

                       EXEC SQL
                           FETCH CUR INTO
                           :CH-HyperLink
                          ,:CH-Id
                          ,:CH-TabNr:CHInd
                          ,:CH-IdIsInChapter:CHInd
                          ,:CH-URL:CHInd
                       END-EXEC
                       if sqlcode = 100
                           subtract 1 from TempI
                           exit perform
                       else
                           perform errors
                       end-if
                       move CH-Id to TempId(TempI)
                       move CH-IdIsInChapter to TempIdIsIn(TempI)
                       move CH-HyperLink to TempHyperLink(TempI)
                       move CH-TabNr to TempTabNr(TempI)
                       move CH-URL to TempURL(TempI)
               end-perform

               EXEC SQL CLOSE CUR END-EXEC
               if sqlcode >= 0
                   move TempI to TempMax Toc-Max
               else
                   exit method
               end-if
           end-if
      *>---Parcourir tout le tableau
           perform varying TempI from 1 by 1 until TempI > TempMax

               if TempIdIsIn(TempI) = Temp
                   add 1 to Toc-Idx
                   move TempId(TempI) to Toc-ID(Toc-Idx)
                   string Rien(1 : 5 * TempTabNr(TempI))
                          TempHyperLink(TempI)
                   into   Toc-HyperLink(Toc-Idx)

                   invoke self "Create" using Toc-Tab
               end-if

           end-perform

          exit method.

       errors section.
           if sqlcode not = 0 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to Msg

               EXEC SQL ROLLBACK END-EXEC

               exit method
           end-if.
           exit.
       end method "Create".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "CreateChapter".

       local-storage section.
       01 Temp                         pic 9(12).
       01 TempI                        pic 9(3).
       copy "Chapter.cpy".
       linkage section.
       copy "Toc-Tab.cpy".
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct Toc-Tab.

      *>---Si c'est la premiere fois, remplire la table temporaire
           if TempMax <> 0
               *>ID du chapitre pour lequel on recherche les fils
               move Toc-Id(Toc-Idx) to Temp
           else
               *>first time
               Initialize Temp Toc-Tab
               EXEC SQL
                   DECLARE CUR CURSOR FOR
                   SELECT CH.ID
                         ,CH.ID_IS_IN_CHAPTER
                         ,CH.HYPER_LINK
                         ,CH.TAB_NR
                   FROM CHAPTER_V CH
                   WHERE CH.MASTER_URL IS NULL AND
                         CH.STATUS = 'Valid'
                   ORDER BY CH.ID_IS_IN_CHAPTER,
                            CH.SEQ_NBR, CH.HYPER_LINK
               END-EXEC

               EXEC SQL OPEN CUR END-EXEC

               perform varying TempI from 1 by 1 until TempI = 500
                       initialize ChapterTable

                       EXEC SQL
                           FETCH CUR INTO
                           :CH-Id
                          ,:Ch-IdIsInChapter:CHInd
                          ,:CH-HyperLink
                          ,:CH-TabNr:CHInd
                       END-EXEC
                       if sqlcode = 100
                           subtract 1 from TempI
                           exit perform
                       else
                           perform errors
                       end-if
                       move CH-Id to TempId(TempI)
                       move CH-IdIsInChapter to TempIdIsIn(TempI)
                       move CH-HyperLink to TempHyperLink(TempI)
                       move CH-TabNr to TempTabNr(TempI)
               end-perform

               EXEC SQL CLOSE CUR END-EXEC
               if sqlcode >= 0
                   move TempI to TempMax Toc-Max
               else
                   exit method
               end-if
           end-if

      *>---Parcourir tout le tableau
           perform varying TempI from 1 by 1 until TempI > TempMax

               if TempIdIsIn(TempI) = Temp
                   add 1 to Toc-Idx
                   move TempId(TempI) to Toc-ID(Toc-Idx)
                   string Rien(1 : 5 * TempTabNr(TempI))
                          TempHyperLink(TempI)
                   into   Toc-HyperLink(Toc-Idx)

                   invoke self "CreateChapter" using UsCtrlStruct
                                                     Toc-Tab
               end-if

           end-perform

          exit method.

       errors section.
           if sqlcode not = 0 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to Msg

               EXEC SQL ROLLBACK END-EXEC

               exit method
           end-if.
           exit.
       end method "CreateChapter".
      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "CreateToc".

       local-storage section.
       01 Temp                         pic 9(12).
       01 TempI                        pic 9(3).
       copy "Chapter.cpy".

       linkage section.
       copy "Toc-Tab.cpy".
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct Toc-Tab.

      *>---if for the first time, fetch data into the Temp array
           if TempMax <> 0
               *>ID of the chapter we are searching sons for
               move Toc-Id(Toc-Idx) to Temp
           else
               *>first time
               Initialize Temp Toc-Tab
               EXEC SQL
                   DECLARE CUR CURSOR FOR
                   SELECT CH.ID, CH.HYPER_LINK,
                          CH.ID_IS_IN_CHAPTER, CH.IMG_SRC,
                          CH.MASTER_URL,
                          CH.TAB_NR, CH.LINE_NR
                   FROM CHAPTER_V CH, USERS_V US, MAY_ACT_ON_V MA,
                        USER_GROUP_V GR
                   WHERE
                   US.SHORTNAME = :UsCtrlShortname AND
                         US.ID_BELONGS_TO = GR.ID AND
                         MA.ID = GR.ID AND
                         MA.ID_CHAPTER = CH.ID AND
                         CH.STATUS = 'Valid' AND
                         MA.STATUS = 'Valid'
                   ORDER BY CH.ID_IS_IN_CHAPTER,
                            CH.SEQ_NBR, CH.HYPER_LINK
               END-EXEC

               EXEC SQL OPEN CUR END-EXEC

               perform varying TempI from 1 by 1 until TempI > 500
                       initialize ChapterTable

                       EXEC SQL
                           FETCH CUR INTO
                                       :CH-Id, :CH-HyperLink,
                                       :CH-IdIsInChapter:CHInd,
                                       :CH-ImgSrc:CHInd, :CH-Url:CHInd,
                                       :CH-TabNr:CHInd,
                                       :CH-LineNr:CHInd
                       END-EXEC

                       if sqlcode = 100
                           subtract 1 from TempI
                           exit perform
                       else
                           perform errors
                       end-if

                       move CH-Id to TempId(TempI)
                       move CH-Url to TempUrl(TempI)
                       move CH-HyperLink to TempHyperLink(TempI)
                       move CH-LineNr to TempLineNr(TempI)
                       move CH-TabNr to TempTabNr(TempI)
                       move CH-ImgSrc to TempImgSrc(TempI)
                       move CH-IdIsInChapter to TempIdIsIn(TempI)
               end-perform

               EXEC SQL CLOSE CUR END-EXEC

               if sqlcode >= 0
                   move TempI to TempMax Toc-Max
               else
                   exit method
               end-if
           end-if

      *>---Parcourir tout le tableau
           perform varying TempI from 1 by 1 until TempI > TempMax

               if TempIdIsIn(TempI) = Temp
                   add 1 to Toc-Idx
                   *>Show only the master chapter and the chapters of
                   *>the given chapter (UsCtrlId)
                   if (Temp = 0) then
                       move 1 to Toc-Show(Toc-Idx)
                   end-if
                   move TempId(TempI) to Toc-ID(Toc-Idx)
                   move TempIdIsIn(TempI) to Toc-IdIsIn(Toc-Idx)
                   move TempUrl(TempI) to Toc-Url(Toc-Idx)
                   move TempLineNr(TempI) to Toc-LineNr(Toc-Idx)
                   move TempTabNr(TempI) to Toc-TabNr(Toc-Idx)
                   move TempImgSrc(TempI) to Toc-ImgSrc(Toc-Idx)
                   move TempHyperLink(TempI) to Toc-HyperLink(Toc-Idx)

                   invoke self "CreateToc" using UsCtrlStruct Toc-Tab
               end-if

           end-perform

          exit method.

       errors section.
           if sqlcode not = 0 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to Msg

               EXEC SQL ROLLBACK END-EXEC

               exit method
           end-if.

       end method "CreateToc".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "AddId".

       local-storage section.
       01 Temp                         pic x(12).
       01 TempI                        pic 9(3).
       01 TempI1                       pic 9(3).

       linkage section.
       copy "Toc-Tab.cpy".

       procedure division using Toc-Tab.
           initialize TempI Temp
           inspect Toc-ID(Toc-Idx) tallying TempI for leading zeros
           move Toc-ID(Toc-Idx)(TempI + 1 : 12 - TempI) to Temp

           perform varying TempI1 from 241 by -1 until TempI1 <= 0
               if Toc-HyperLink(Toc-Idx)(TempI1:1) <> space
                   string "("
                          Temp delimited by spaces
                          ")"
                   into Toc-HyperLink(Toc-Idx)(TempI1 + 1 :255 - TempI1)
                   exit perform
               end-if
           end-perform

          exit method.
       end method "AddId".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "OpenToc".

       local-storage section.
       01 Temp                         pic 9(12).
       01 TempI                        pic 9(3).

       linkage section.
       copy "Toc-Tab.cpy".
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct Toc-Tab.
           perform until exit
               if TempMax = zero then
                   invoke self "CreateToc" using UsCtrlStruct Toc-Tab
                   *>the given ID is the master chapter
                   move UsCtrlId to Temp
               else
                   *>the master chapter is the preceding chapter in the
                   *>hierarchy
                   move Toc-IdIsIn(Toc-Idx) to Temp
               end-if

      *>---If there is no preceding chapter anymore (highest level)
               if Temp = 0 then
                   exit perform
               end-if

      *>---Move the index to the given master chapter(to get his
      *>   master chapter later)
               perform varying Toc-Idx from 1 by 1 until
                                                  Toc-Idx > Toc-Max
                                               or Toc-Id(Toc-Idx) = Temp
               end-perform

               perform varying TempI from 1 by 1 until TempI > Toc-Max
      *>---Show all the chapters contained in the master chapter
                   if Toc-IdIsIn(TempI) = Temp then
                       move 1 to Toc-Show(TempI)
                   end-if
               end-perform

           end-perform

          exit method.
       end method "OpenToc".

      *>-----------------------------------------------------------
      *> Destruction of this object.
      *>-----------------------------------------------------------
       method-id. "Finalize".

       local-storage section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.

           invoke super "Finalize" returning lnkData

           exit method.
       end method "Finalize".

       end object.
       end class Tree.
