      $set preprocess(htmlpp) endp
      *>-----------------------------------------------------------
      *> Class implementing methods for User Access Control
      *>-----------------------------------------------------------
      $set mfoo ooctrl(+n)

       class-id. UsCtrl data is protected
                       inherits from Base.

       object section.
      *>---Classes used by the Http class
       class-control.
       copy "ClCtrl.cpy".

      *>-----------------------------------------------------------
       working-storage section. *> definition of global data
      *>-----------------------------------------------------------
       01 WsDefaultLastEventExpired    pic x(4) value "0030".
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(9) value "Not found".
       01 WsDefaultAppRunning          pic x(3) value "Yes".
       01 WsDefaultAppFrozen           pic x(3) value "No".

       exec sql include SQLCA end-exec

      *>-----------------------------------------------------------
       class-object.   *> Definition of the class data and method
      *>-----------------------------------------------------------
       object-storage section.

      *>-----------------------------------------------------------
      *> Creation and initialization of a new class object.
      *>-----------------------------------------------------------
       method-id. "New".

       linkage Section.
       01 LnkApplication               object reference.


       procedure division returning LnkApplication.

          invoke Super "new" returning LnkApplication
          invoke LnkApplication "Init"

           exit method
       end method "New".

       end class-object.

      *>-----------------------------------------------------------
       Object.    *> Definition of instance data and methods
      *>-----------------------------------------------------------
       object-storage section.
       copy "ObjRef.cpy".
       copy "Http.cpy".
       copy "Connect.cpy".
       copy "Cookie.cpy".
       copy "Ini.cpy".
       copy "Dates.cpy".
       01 DifferenceInDays             pic s9(4)v9(7).

      *>-----------------------------------------------------------
      *> Initialization of class object.
      *>---------------------------------------------------------------
       method-id. "Init".

       procedure division.
           invoke Ini "New" returning IniRef

           exit method
       end method "Init".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "Counter".

       local-storage section.

       linkage section.
       copy "Eurecas.cpy".

       procedure division using FormFields.
      *>---Get the reference of the new Connect class object
           invoke Connect "New" returning ConnectRef
      *>---Realize the connection to the data base
           invoke ConnectRef "ConnectDb" returning ConnectMsg
           invoke ConnectRef "Finalize" returning ConnectRef

           if ConnectMsg <> spaces
               move ConnectMsg to Msg
               exit method
           end-if

           EXEC SQL
               SELECT SUM(US.NBR_SIGNON)
               INTO :USNbrSignonTemp
               FROM USERS_V US
               WHERE US.STATUS = 'Valid'
           END-EXEC

           exit method.
       end method "Counter".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "App-Running".

       local-storage section.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
      *>---Get the application running state from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "App-Running"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If state not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultAppRunning to IniString
           end-if

      *>---If application not running, alert and stop
           if IniString <> "Yes" then
               move "Application not yet available."
                   to UsCtrlMsg
           end-if


           exit method.
       end method "App-Running".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "Encryption".

       local-storage section.
       01 EncryptionKey                    pic x(255).
       01 EncryptionLength                 pic x(4) comp-5.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.

           initialize HttpEnvVar EncryptionKey EncryptionLength

           invoke Http "New" returning HttpRef
           invoke HttpRef "GetRemoteHost" returning HttpEnvVar
           move HttpEnvVar to EncryptionKey

           invoke HttpRef "GetRemoteAddr" returning HttpEnvVar
           string EncryptionKey delimited by spaces
                  HttpEnvVar delimited by spaces
           into EncryptionKey

           invoke HttpRef "GetHttpAccept" returning HttpEnvVar
           string EncryptionKey delimited by spaces
                  HttpEnvVar delimited by spaces
           into EncryptionKey

           invoke HttpRef "Finalize" returning HttpRef

           inspect UsCtrlString tallying EncryptionLength
                                           for characters before spaces

      *    call "CBL_XOR" using EncryptionKey UsCtrlString
      *                         by value EncryptionLength

           exit method.
       end method "Encryption".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------
       method-id. "Common".

       local-storage Section.
       linkage Section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.

           initialize UsCtrlStruct CookieStruct

           move "CookieId" to CookieName

           invoke Cookie "New" returning CookieRef
           invoke CookieRef "GetCookie" using CookieStruct
           invoke CookieRef "Finalize" returning CookieRef

           move CookieValue to UsctrlString

      *>---If no cookie found force to signon
           if UsCtrlString = low-value or spaces then
               perform signon
           end-if

      *>---Check if the application is running
           invoke Self "App-Running" using UsCtrlStruct
           if UsCtrlMsg <> spaces
               perform error-stop
           end-if

      *>---Get the reference of the new Connect class object
           invoke Connect "New" returning ConnectRef
      *>---Realize the connection to the data base
           invoke ConnectRef "ConnectDb" returning ConnectMsg
           invoke ConnectRef "Finalize" returning ConnectRef

           if ConnectMsg <> spaces then
               move ConnectMsg to UsCtrlMsg
               perform error-stop
           end-if

           invoke Self "Encryption" using UsCtrlStruct

           EXEC SQL
               SELECT US.SHORTNAME
               INTO :UsCtrlShortname
               FROM USERS_V US, DPT_V DP, USER_GROUP_V GR
               WHERE US.COOKIE_VALUE = :UsCtrlString AND
                     US.STATUS = 'Valid' AND
                     US.ID_IS_IN = DP.ID AND
                     DP.STATUS = 'Valid' AND
                     US.ID_BELONGS_TO = GR.ID AND
                     GR.STATUS = 'Valid'
           END-EXEC

           if sqlcode = 100 then
               perform signon
           end-if

           perform errors

      *>---Get the last event
           EXEC SQL
                SELECT CH2.ID, CH1.MASTER_URL
                 INTO :UsCtrlID,
                      :UsCtrlUrl:UsCtrlInd
                 FROM USERS_V US, CHAPTER_V CH1, CHAPTER_V CH2
                 WHERE US.ID_DO_LAST = CH1.ID AND
                       CH1.ID_IS_IN_CHAPTER = CH2.ID AND
                       US.SHORTNAME = :UsCtrlShortname
           END-EXEC

           if sqlcode <> 100 then
               perform errors
           end-if

           initialize IniStruct DifferenceInDays

      *>---Get the default days of expiration of the last user event
      *>   from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "Last-Event-Expired"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If days of expiration not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultLastEventExpired to IniString
           end-if

           compute DifferenceInDays = function NUMVAL(IniString)

      *>---Get the number of days between now and the last
      *>   signon, minus the cookie expiration
           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           move yyyymmdd to StopDate
           *> get the users last-event date
           exec sql
           select LAST_EVENT
             into :yyyy-mm-dd
             from USERS_V
             where SHORTNAME = :UsCtrlShortname
           end-exec
           invoke DatesRef "DisplayToDate" using DateStruct
           move yyyymmdd to StartDate
           invoke DatesRef "NumberOfDays" using DateStruct
           invoke DatesRef "Finalize" returning DatesRef
           compute DifferenceInDays = NumberOfDays - DifferenceInDays

      *>------Check if the last user event is expired
           if DifferenceInDays > 0 then
              perform signon
           end-if

           perform exit-ok.

      *>---Check of Sql errors
       errors section.
           if sqlcode <> 0 and +1 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to UsCtrlMsg

               EXEC SQL ROLLBACK END-EXEC

               perform error-stop
               exit method
           end-if.

      *>---Disconnect from data base and exit the programm
       exit-ok section.
           EXEC SQL COMMIT END-EXEC

           exit method.

       signon section.
           exec html
               <SCRIPT>
               window.open("/cgi-bin/Eurecas.exe", target="_top")
               </SCRIPT>
           end-exec

           EXEC SQL COMMIT END-EXEC
           EXEC SQL DISCONNECT END-EXEC

           stop run.

       error-stop section.
           exec html
               <SCRIPT>
               alert(":UsCtrlMsg")
               </SCRIPT>
           end-exec
           perform signon
           exit.

       end method "Common".

      *>-----------------------------------------------------------
      *
      *
      *>-----------------------------------------------------------

       method-id. "Access".

       local-storage Section.

       linkage Section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
           initialize UsCtrlStruct CookieStruct

           invoke Http "New" returning HttpRef
           invoke HttpRef "GetScriptName" returning HttpStruct
           invoke HttpRef "Finalize" returning HttpRef

           move function UPPER-CASE(HttpEnvVar) to UsCtrlUrl

           move "CookieId" to CookieName

           invoke Cookie "New" returning CookieRef
           invoke CookieRef "GetCookie" using CookieStruct
           invoke CookieRef "Finalize" returning CookieRef

           move CookieValue to UsctrlString


      *>---If no cookie found force to signon
           if UsCtrlString = low-value or spaces then
               perform signon
           end-if

      *>---If no chapter name found force signon
           if HttpEnvVar = low-value or spaces then
               perform signon
           end-if

      *>---Get the application running state from the Eurecas "ini" file
           invoke Self "App-Running" using UsCtrlStruct
           if UsCtrlMsg <> spaces
               perform error-stop
           end-if

      *>---Get the reference of the new Connect class object
           invoke Connect "New" returning ConnectRef
      *>---Realize the connection to the data base
           invoke ConnectRef "ConnectDb" returning ConnectMsg
           invoke ConnectRef "Finalize" returning ConnectRef

           if ConnectMsg <> spaces then
               move ConnectMsg to UsCtrlMsg
               perform error-stop
           end-if

      *>---Decrypt the cookie value
           invoke Self "Encryption" using UsCtrlStruct

      *>---Check if the user has rigths on the chapter and get his
      *>   shortname
           EXEC SQL
               SELECT US.SHORTNAME, CH.CRITICAL, MA.INS, MA.DEL,
                      MA.VAL, MA.UPD, CH.ID, CH.HYPER_LINK
               INTO :UsCtrlShortname,
                    :UsCtrlCritical:UsCtrlInd,
                    :UsCtrlIns:UsCtrlInd,
                    :UsCtrlDel:UsCtrlInd,
                    :UsCtrlVal:UsCtrlInd,
                    :UsCtrlUpd:UsCtrlInd,
                    :UsCtrlID,
                    :UsCtrlHyperLink
               FROM USERS_V US, CHAPTER_V CH, MAY_ACT_ON_V MA,
                    USER_GROUP_V GR
               WHERE US.COOKIE_VALUE = :UsCtrlString AND
                     US.STATUS = 'Valid' AND
                     US.ID_BELONGS_TO = GR.ID AND
                     GR.STATUS = 'Valid' AND
                     MA.ID = GR.ID AND
                     MA.STATUS = 'Valid' AND
                     MA.ID_CHAPTER = CH.ID AND
                     (CH.MASTER_URL = :UsCtrlUrl OR
                      CH.SLAVE_URL = :UsCtrlUrl) AND
                     CH.STATUS = 'Valid'
           END-EXEC

      *>---If not found force to signon
           if sqlcode = 100 then
               perform signon
           end-if

           perform errors

           initialize IniStruct DifferenceInDays

      *>---Get the default days of expiration of the last user event
      *>   from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "Last-Event-Expired"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If days of expiration not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultLastEventExpired to IniString
           end-if

           compute DifferenceInDays = function NUMVAL(IniString)

      *>---Get the number of days between now and the last
      *>   signon, minus the cookie expiration

           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           move yyyymmdd to StopDate
           *> get the users last-event date
           exec sql
           select LAST_EVENT
             into :yyyy-mm-dd
             from USERS_V
             where SHORTNAME = :UsCtrlShortname
           end-exec
           invoke DatesRef "DisplayToDate" using DateStruct
           move yyyymmdd to StartDate
           invoke DatesRef "NumberOfDays" using DateStruct
           invoke DatesRef "Finalize" returning DatesRef
           compute DifferenceInDays = NumberOfDays - DifferenceInDays

      *>------Check if the last user event is expired
           if DifferenceInDays > 0 then
              perform signon
           end-if

           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           invoke DatesRef "Finalize" returning DatesRef

           EXEC SQL
               UPDATE USERS_V US
                 SET US.LAST_EVENT = :yyyy-mm-dd
                 WHERE US.SHORTNAME = :UsCtrlShortname
           END-EXEC

           perform errors

           EXEC SQL
               UPDATE USERS_V US
                 SET US.ID_DO_LAST = :UsCtrlID
               WHERE US.SHORTNAME = :UsCtrlShortname
           END-EXEC

           perform errors

           perform exit-ok.

      *>---Check of Sql errors
       errors section.
           if sqlcode <> 0 and +1 then
               inspect sqlerrmc replacing all x"0A" by spaces
               move sqlerrmc to UsCtrlMsg

               EXEC SQL ROLLBACK END-EXEC

               perform error-stop
           end-if.

      *>---Disconnect from data base and exit the programm
       exit-ok section.
           EXEC SQL COMMIT END-EXEC

           exit method.

       signon section.
           exec html
       <SCRIPT>
               window.open("/cgi-bin/Eurecas.exe", target="_top")
       </SCRIPT>
           end-exec

           EXEC SQL COMMIT END-EXEC
           EXEC SQL DISCONNECT END-EXEC
           stop run.

       error-stop section.
           exec html
               <SCRIPT>
               alert(":UsCtrlMsg")
               </SCRIPT>
           end-exec
           perform signon
           exit.

       end method "Access".

      *>-----------------------------------------------------------
      * control of action "Insert"
      *>-----------------------------------------------------------
       method-id. "Ins".

       local-storage section.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
      *>----Get the application frozen state from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "App-Frozen"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If state not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultAppFrozen to IniString
           end-if

           if IniString <> "No" then
               move "Database modifications not allowed at the moment."
                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlIns-false then
               move "You are not allowed to perfom this insert."
                                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlCritical-False
              move "Valid" to UsCtrlStatus
           else
              move "Pending" to UsCtrlStatus
           end-if
           exit method.

       error-stop section.
           exec html
               <SCRIPT>
               alert(":UsCtrlMsg")
               </SCRIPT>
           end-exec
           exit method.

       end method "Ins".

      *>-----------------------------------------------------------
      * control of action "update"
      *>-----------------------------------------------------------
       method-id. "Upd".

       local-storage section.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
      *>----Get the application frozen state from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "App-Frozen"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If state not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultAppFrozen to IniString
           end-if

           if IniString <> "No" then
               move "Database modifications not allowed at the moment."
                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlUpd-false then
               move "You are not allowed to perfom this update."
                                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlCritical-False
              move "Valid" to UsCtrlStatus
           else
              move "Pending" to UsCtrlStatus
           end-if

           exit method.

       error-stop section.
           exec html
               <SCRIPT>
               alert(":UsCtrlMsg")
               </SCRIPT>
           end-exec
           exit method.

       end method "Upd".


      *>-----------------------------------------------------------
      * control of action "delete"
      *>-----------------------------------------------------------
       method-id. "Del".

       local-storage section.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
      *>----Get the application frozen state from the Eurecas "ini" file
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "App-Frozen"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>----If state not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultAppFrozen to IniString
           end-if

           if IniString = "Yes" then
               move "Database modifications not allowed at the moment."
                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlDel-false then
               move "You are not allowed to perfom this delete."
                                    to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlStatus = "Deleted" or "Pending delete"
               move "Record is already deleted." to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlCritical-False
              move "Deleted" to UsCtrlStatus
           else
              if UsCtrlStatus = "Valid" then
                 move "Pending delete" to UsCtrlStatus
              else
                 move "Deleted" to UsCtrlStatus
              end-if
           end-if
           exit method.

       error-stop section.
           exec html
                <SCRIPT>
                alert(":UsCtrlMsg")
                </SCRIPT>
           end-exec
           exit method

       end method "Del".

      *>------------------------------------------------------------
      * control of action "validate"
      *>------------------------------------------------------------
       method-id. "Val".

       local-storage section.

       linkage section.
       copy "UsCtrl.cpy".

       procedure division using UsCtrlStruct.
      *>----Get the application frozen state from the Eurecas "ini" fil e
           move "..\Eurecas.ini"   to IniFileName
           move "UsCtrl"          to IniSectionName
           move "App-Frozen"  to IniKeyName

           invoke IniRef "GetString" using IniStruct

      *>---If state not found, use the default
           if IniString(1:9) = WsIniDefaultString(1:9) then
               move WsDefaultAppFrozen to IniString
           end-if

           if IniString = "Yes" then
               move "Database modifications not allowed at the moment."
                   to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlVal-false then
               move "You are not allowed to perfom this validation."
                                    to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlStatus = "Deleted"
               move "This transaction is already deleted." to UsCtrlMsg
               perform error-stop
           end-if

           if UsCtrlStatus = "Valid"
              if UsCtrlCritical-false
                  move "This transaction needs no validation."
                                                       to UsCtrlMsg
              else
                  move "This transaction is already validated."
                                                       to UsCtrlMsg
              end-if
              perform error-stop
           end-if

           if UsCtrlShortname = UsCtrlLastUser
              move
              "This transaction cannot be validated by the same user"
              to UsCtrlMsg
              perform error-stop
           end-if

           if UsCtrlStatus = "Pending delete"
                 move "Deleted" to UsCtrlStatus
                 exit method
           end-if

           move "Valid" to UsCtrlStatus

           exit method.

       error-stop section.
           exec html
                <SCRIPT>
                alert(":UsCtrlMsg")
                </SCRIPT>
           end-exec
           exit method.

       end method "Val".


      *>---------------------------------------------------------------
      *> Destruction of this object.
      *>---------------------------------------------------------------
       method-id. "Finalize".

       local-storage Section.

       linkage Section.
       01 LnkData                      object reference.

       procedure division returning LnkData.
           invoke IniRef "Finalize" returning IniRef
           invoke Super "Finalize" returning LnkData

           exit method.
       end method "Finalize".

       end object.
       end class UsCtrl.
