      $set preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set preprocess(htmlpp) stephtml endp
      *set sql(dbman=odbc)

      *>****************************************************************
       identification division.
      *>****************************************************************
           program-id. "USADlist".


      *>****************************************************************
       environment division.
      *>****************************************************************
       class-control.
       copy "ClCtrl.cpy".
      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the CGI without use of the litlink
      *> compiler directive.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.
       copy "ObjRef.cpy".
       copy "UsCtrl.cpy".
       01 TempId                    pic s9(12) comp-3.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "USADlist.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "USADlist.cpy".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Control Area
           exec sql include sqlca end-exec.

      *>----------------------------------------------------------------
      *> The following field receives ESQL error messages wider than the
      *> 70 bytes provided by the SQLCA field SQLERRMC
           01 MFSQLMessageText         pic x(256).
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Descriptor Area
           exec sql include sqlda end-exec.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following record, it contains
      *> state information saved between CGI invokations
      *>     Session identifier for state maintenance routines
           01 client-id                pic x(30).
      *>     Length of saved state record
           01 client-length            pic xxxx comp-x.
      *>     Status returned by state maintenance routines
           01 server-status            pic x comp-x.
      *>     The state record itself
           01 client-state.
      *>     The fieldname used for ordering rows
             03 s-order-field          pic x(32).
      *>     The fieldname used for filtering rows
             03 s-filter-field         pic x(32).
      *>     The current filter value
             03 s-filter-value         pic x(256).
      *>     The current filter operator
             03 s-filter-op            pic xx.
      *>     The first row displayed to the Browser
             03 first-A-ID             pic S9(12) COMP-3.
             03 first-A-ID-DO-LAST     pic S9(12) COMP-3.
             03 first-A-SHORTNAME      pic X(20).
             03 first-A-NAME           pic X(40).
             03 first-A-PASS-DATE      pic X(26).
             03 first-A-NBR-TRIES      pic S9(1) COMP-3.
             03 first-A-LOCK-DATE      pic X(26).
             03 first-A-LAST-EVENT     pic X(26).
             03 first-A-NBR-SIGNON     pic S9(12) COMP-3.
             03 n-first-A-ID-DO-LAST   pic s9(4) comp-5.
             03 n-first-A-NAME         pic s9(4) comp-5.
             03 n-first-A-PASS-DATE    pic s9(4) comp-5.
             03 n-first-A-NBR-TRIES    pic s9(4) comp-5.
             03 n-first-A-LOCK-DATE    pic s9(4) comp-5.
             03 n-first-A-LAST-EVENT   pic s9(4) comp-5.
             03 n-first-A-NBR-SIGNON   pic s9(4) comp-5.
      *>     The last row displayed to the Browser (table view only)
             03 last-A-ID              pic S9(12) COMP-3.
             03 last-A-ID-DO-LAST      pic S9(12) COMP-3.
             03 last-A-SHORTNAME       pic X(20).
             03 last-A-NAME            pic X(40).
             03 last-A-PASS-DATE       pic X(26).
             03 last-A-NBR-TRIES       pic S9(1) COMP-3.
             03 last-A-LOCK-DATE       pic X(26).
             03 last-A-LAST-EVENT      pic X(26).
             03 last-A-NBR-SIGNON      pic S9(12) COMP-3.
             03 n-last-A-ID-DO-LAST    pic s9(4) comp-5.
             03 n-last-A-NAME          pic s9(4) comp-5.
             03 n-last-A-PASS-DATE     pic s9(4) comp-5.
             03 n-last-A-NBR-TRIES     pic s9(4) comp-5.
             03 n-last-A-LOCK-DATE     pic s9(4) comp-5.
             03 n-last-A-LAST-EVENT    pic s9(4) comp-5.
             03 n-last-A-NBR-SIGNON    pic s9(4) comp-5.
      *>     The field values when the filter was last changed
             03 filter-A-ID            pic S9(12) COMP-3.
             03 filter-A-ID-DO-LAST    pic S9(12) COMP-3.
             03 filter-A-SHORTNAME     pic X(20).
             03 filter-A-NAME          pic X(40).
             03 filter-A-PASS-DATE     pic X(26).
             03 filter-A-NBR-TRIES     pic S9(1) COMP-3.
             03 filter-A-LOCK-DATE     pic X(26).
             03 filter-A-LAST-EVENT    pic X(26).
             03 filter-A-NBR-SIGNON    pic S9(12) COMP-3.
             03 n-filter-A-ID-DO-LAST  pic s9(4) comp-5.
             03 n-filter-A-NAME        pic s9(4) comp-5.
             03 n-filter-A-PASS-DATE   pic s9(4) comp-5.
             03 n-filter-A-NBR-TRIES   pic s9(4) comp-5.
             03 n-filter-A-LOCK-DATE   pic s9(4) comp-5.
             03 n-filter-A-LAST-EVENT  pic s9(4) comp-5.
             03 n-filter-A-NBR-SIGNON  pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following fields, they are used by
      *> the generated SQL data access code
      *>----------------------------------------------------------------
           01 sql-text                 pic x(1024).
           01 sql-index                pic 9(4) comp-5.
           01 where-clause             pic x(1024).
           01 order-clause             pic x(1024).
           01 temp                     pic x(256).
           01 temp-index               pic xxxx comp-5.
           01 stat-index               pic xxxx comp-5.
           01 last-indicator           pic s9(4) comp-5.
           01 i                        pic x(4) comp-5.
           01 row-number               pic xxxx comp-5.
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to pass input parameters
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>   Fields to be used in SQL Select statements
           01 selectColumns.
             03 filler pic x(20) value "A.ID, A.ID_DO_LAST, ".
             03 filler pic x(21) value "A.SHORTNAME, A.NAME, ".
             03 filler pic x(26) value "A.PASS_DATE, A.NBR_TRIES, ".
             03 filler pic x(27) value "A.LOCK_DATE, A.LAST_EVENT, ".
             03 filler pic x(12) value "A.NBR_SIGNON".
      *>   Fields that are part of the primary key
           01 PrimaryKeyColumns.
             03 filler pic x(05) value "A.ID#".
      *>   Tables to be used in SQL Select statements
           01 selectTables.
             03 filler pic x(09) value "USERS_V A".
      *>   Contains the name of the field being processed
           01 field-name               pic x(40).
      *>   Operator used for positioning within select rows.
      *>   Will be ">=" for Next, "<=" for Prev
      *>   and "??" (meaning no where clause needed for positioning)
      *>   for First and Last
           01 search-op                pic xx.
      *>   Ordering specification, null terminated.
      *>   Wiil be empty for First and Next and DESC for Last and Prev
           01 sort-spec                pic x(8).
      *>   Holds the name of the column to order by
           01 order-field              pic x(32).
      *>   The name of the file used to store server state
           01 state-filename           pic x(255)
               value "STATE.DAT".
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to return results from
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>      Status of last SQL statement executed
           01 sql-status               pic 9.
               88 sql-ok                 value 0.
               88 no-data                value 1.
               88 sql-error              value 2.
      *>      Result of field comparison routines
           01 compare-status           pic s9.
               88 IsLess               value -1.
               88 IsEqual              value 0.
               88 IsGreater            value +1.
      *>      Result of state mainenance routine call
           01 state-status             pic x comp-x.
      *>      SQL Indicator variables for last SQL statement executed
           01 SQL-Indicators.
             03 n-A-ID-DO-LAST         pic s9(4) comp-5.
             03 n-A-NAME               pic s9(4) comp-5.
             03 n-A-PASS-DATE          pic s9(4) comp-5.
             03 n-A-NBR-TRIES          pic s9(4) comp-5.
             03 n-A-LOCK-DATE          pic s9(4) comp-5.
             03 n-A-LAST-EVENT         pic s9(4) comp-5.
             03 n-A-NBR-SIGNON         pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *> Enter additional working-storage items here

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.
      *>---User access control
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Access" using UsCtrlStruct

           call "sstate"
           call "MF_CLIENT_STATE_FILE"
               using state-filename server-status

           perform process-form-input-data
           perform convert-input
           perform restore-state
           perform sql-start
           evaluate Action
               when "First"
                   perform do-first
               when "Previous"
                   perform do-previous
               when "Next"
                   perform do-next
               when "Last"
                   perform do-last
               when other
                   if client-id = spaces
                       perform do-default-operation
                   else
                       perform do-first-from-form
                   end-if
           end-evaluate
           perform setup-server-persistence
      *    perform USADlist-cvt
           perform blank-sql-nulls
           perform USADlist-out
           perform sql-finish
           perform save-state
           exit program
           stop run.

      *>----------------------------------------------------------------
       base-sql section.

           exec sql
               declare sql_cursor cursor for dyna_stat
           end-exec
           exit.

      *>----------------------------------------------------------------
       sql-start section.
           *> Initialise variables
           move spaces to frmesStatus
           move 1 to stat-index
           move 0 to MF-Row-Index
           exit.

      *>----------------------------------------------------------------
       sql-finish section.
           invoke UsCtrlRef "Finalize" returning UsCtrlRef
           *> Finalise SQL session
           exec sql disconnect end-exec
           exit.

      *>----------------------------------------------------------------
       do-sql-query section.

           *> Build dynamic SQL query for current order and filter
           *> settings, then prepare it
           move spaces to sql-text
           move 0 to sqld sqln
           move 1 to sql-index
           move low-values to where-clause order-clause

           if order-field = spaces
               *> Default to 1st primary key field
               move "A.ID" to order-field
           end-if

           if search-op not = '??'
               *> For next, prev and find add the order field
               *> to the where clause
               move order-field to field-name
               perform sql-add-param
           end-if

           if s-filter-field = spaces
               move "(none)" to s-filter-field
           end-if

           if (s-filter-field not = "(none)")
               move s-filter-field to field-name
               perform sql-add-filter-param
           end-if

           move 1 to sql-index
           move order-field to field-name
           perform trim-field-name

           string
               field-name delimited x"0"
               sort-spec delimited x"0"
           into order-clause pointer sql-index

           *> Append primary key columns that are not the order field
           *> to the order clause to guarantee a unique row order
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform trim-field-name
               string
                   ", " delimited size
                   field-name delimited x"0"
                   sort-spec delimited x"0"
               into order-clause pointer sql-index
           end-perform

           move 1 to sql-index,
           string
               "select " delimited size
               selectColumns delimited size
               " from "  delimited size
               selectTables delimited size
               where-clause delimited x"0"
               " order by " delimited size
               order-clause delimited x"0"
               x"0" delimited size
           into sql-text pointer sql-index

           exec sql
                   prepare dyna_stat from :sql-text
           end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error processing this request.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-add-param section.

           *> Add field-name as a parameter to the where clause
           *> for positioning purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_DO_LAST"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID-DO-LAST
                   set sqlind(sqln) to address of n-A-ID-DO-LAST
                   move n-A-ID-DO-LAST to last-indicator
                 when "A.SHORTNAME"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of A-SHORTNAME to sqllen(sqln)
                   set sqldata(sqln) to address of A-SHORTNAME
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of A-NAME
                   set sqlind(sqln) to address of n-A-NAME
                   move n-A-NAME to last-indicator
                 when "A.PASS_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-PASS-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-PASS-DATE
                   set sqlind(sqln) to address of n-A-PASS-DATE
                   move n-A-PASS-DATE to last-indicator
                 when "A.NBR_TRIES"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of A-NBR-TRIES
                   set sqlind(sqln) to address of n-A-NBR-TRIES
                   move n-A-NBR-TRIES to last-indicator
                 when "A.LOCK_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LOCK-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-LOCK-DATE
                   set sqlind(sqln) to address of n-A-LOCK-DATE
                   move n-A-LOCK-DATE to last-indicator
                 when "A.LAST_EVENT"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-EVENT to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-EVENT
                   set sqlind(sqln) to address of n-A-LAST-EVENT
                   move n-A-LAST-EVENT to last-indicator
                 when "A.NBR_SIGNON"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-NBR-SIGNON
                   set sqlind(sqln) to address of n-A-NBR-SIGNON
                   move n-A-NBR-SIGNON to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If we specify 'is [not] null'
               *> we'll exclude rows from the result set that we may
               *> need to step through. All we can do is exclude
               *> the field from the where clause.
               *> The moral is that for large tables it's best to
               *> disallow ordering on nullable columns.
               subtract 1 from sqld sqln
               exit section
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           string
               field-name delimited x"0"
               search-op delimited size
               " ?" delimited size
           into where-clause pointer sql-index
           exit.

      *>----------------------------------------------------------------
       sql-add-filter-param section.

           *> Add field-name as a parameter to the where clause
           *> for filtering purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_DO_LAST"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-ID-DO-LAST
                   set sqlind(sqln) to address of n-filter-A-ID-DO-LAST
                   move n-filter-A-ID-DO-LAST to last-indicator
                 when "A.SHORTNAME"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of filter-A-SHORTNAME to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-SHORTNAME
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-NAME
                   set sqlind(sqln) to address of n-filter-A-NAME
                   move n-filter-A-NAME to last-indicator
                 when "A.PASS_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-PASS-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-PASS-DATE
                   set sqlind(sqln) to address of n-filter-A-PASS-DATE
                   move n-filter-A-PASS-DATE to last-indicator
                 when "A.NBR_TRIES"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of filter-A-NBR-TRIES
                   set sqlind(sqln) to address of n-filter-A-NBR-TRIES
                   move n-filter-A-NBR-TRIES to last-indicator
                 when "A.LOCK_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LOCK-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LOCK-DATE
                   set sqlind(sqln) to address of n-filter-A-LOCK-DATE
                   move n-filter-A-LOCK-DATE to last-indicator
                 when "A.LAST_EVENT"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-EVENT to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-EVENT
                   set sqlind(sqln) to address of n-filter-A-LAST-EVENT
                   move n-filter-A-LAST-EVENT to last-indicator
                 when "A.NBR_SIGNON"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-NBR-SIGNON
                   set sqlind(sqln) to address of n-filter-A-NBR-SIGNON
                   move n-filter-A-NBR-SIGNON to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If the filter operator is
               *> equals or not equals we will deal with it later.
               *> Otherwise the field must be excluded because
               *> all we can do with nulls is equals and not equals
               *> and this might exclude rows that we might need to
               *> step through
               if s-filter-op = "<=" or ">="
                   subtract 1 from sqld sqln
                   exit section
               end-if
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           if last-indicator >= 0
               string
                   field-name delimited x"0"
                   s-filter-op delimited size
                   " ?" delimited size
               into where-clause pointer sql-index
           else
               *> Deal with null values. These require different
               *> SQL syntax
               subtract 1 from sqld sqln
               if s-filter-op = "="
                   string
                       field-name delimited x"0"
                       ' IS NULL' delimited size
                   into where-clause pointer sql-index
               else
                   string
                       field-name delimited x"0"
                       ' IS NOT NULL' delimited size
                   into where-clause pointer sql-index
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       trim-field-name section.

           *> Null terminate field-name and trim trailing spaces
           move length field-name to i
           perform until i = 0 or field-name(i:1) not = space
               move x"0" to field-name(i:1)
               subtract 1 from i
           end-perform
           exit.

      *>----------------------------------------------------------------
       sql-open section.

           *> Open a cursor to retrieve the query results
           exec sql open sql_cursor using descriptor :sqlda end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em><pre>
                   There was an error opening a SQL cursor.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-fetch section.

           *> Get the next row from the query result set.
           *> Set the status to sql-ok, no-data or sql-error
           *> Terminate with error message if sql-error
           exec sql
             fetch sql_cursor into
                   :A-ID,
                   :A-ID-DO-LAST:n-A-ID-DO-LAST,
                   :A-SHORTNAME,
                   :A-NAME:n-A-NAME,
                   :A-PASS-DATE:n-A-PASS-DATE,
                   :A-NBR-TRIES:n-A-NBR-TRIES,
                   :A-LOCK-DATE:n-A-LOCK-DATE,
                   :A-LAST-EVENT:n-A-LAST-EVENT,
                   :A-NBR-SIGNON:n-A-NBR-SIGNON
           end-exec

           set sql-ok to true

           if sqlcode = 100
               set no-data to true
               initialize A-ID
               initialize A-ID-DO-LAST
               initialize A-SHORTNAME
               initialize A-NAME
               initialize A-PASS-DATE
               initialize A-NBR-TRIES
               initialize A-LOCK-DATE
               initialize A-LAST-EVENT
               initialize A-NBR-SIGNON
           end-if

           if sqlcode < 0
               set sql-error to true
               exec html
                   <br><br><em>
                   There was an error retrieving query results.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if

           if sql-ok
               *> Blank out fields where the database returned a null
               perform init-sql-nulls
           end-if
           exit.

      *>----------------------------------------------------------------
       finish-sql-query section.

           *> Finalise the current query
           exec sql close sql_cursor end-exec
           exit.

      *>----------------------------------------------------------------
       do-first-from-form section.

           *> Start a page of output with the last row viewed
           *> in form view. If it has been deleted, then the
           *> next row in the current ordering will be used

           *> Restore form view field values and position
           *> to the corresponding row
           perform restore-first
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           *> Get 1st row of output, and deal with the case
           *> where the filter has excluded all rows
           perform next-DataTable
           if no-data
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       do-first section.

           *> Output a page starting with the 1st row
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform Next-DataTable
           if no-data
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
           end-if
           if sql-ok
               perform setup-status
               string
                   " - positioned at start" delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       do-next section.

           *> Output next page
           move ">=" to search-op
           move low-values to sort-spec

           *> Restore last row displayed and position to it
           *> If there are no more rows to output
           *> due to deletes by other users, output the last
           *> page of rows
           perform restore-last
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform do-last
               exit section
           end-if

           *> Handle duplicate order field values
           set IsLess to true
           perform compare-to-last
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-last
           end-perform

           *> Prepare 1st row for output
           perform next-DataTable
           *> If no more rows, output last page of rows
           if no-data
               perform do-last
           end-if
           exit.

      *>----------------------------------------------------------------
       do-previous section.

           *> Output previous page or rows
           move "<=" to search-op
           move z" desc " to sort-spec

           *> Restore first row displayed and position to it
           *> If there are no more rows to output
           *> due to deletes by other users, output the first
           *> page of rows
           perform restore-first
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform do-first
               exit section
           end-if
           if not sql-ok
               exit section
           end-if

           *> Handle duplicate order field values
           set IsGreater to true
           perform compare-to-first
           perform until not IsGreater
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if IsEqual
              perform sql-fetch
           end-if

           *> Step back one page of rows plus one, and then do a
           *> 'next page'. If we run out of rows output first page
           move 99 to row-number
           perform until row-number=0 or no-data
               perform sql-fetch
               subtract 1 from row-number
           end-perform
           perform finish-sql-query
           if no-data
               perform do-first
           else
               perform save-last
               perform do-next
           end-if
           exit.

      *>----------------------------------------------------------------
       do-last section.

           *> Output last page of rows

           *> First position to last row
           move "??" to search-op
           move z" desc " to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> Step back one page of rows plus one, and then do a
           *> 'next page'. If we run out of rows output first page
           move 99 to row-number
           perform until row-number=0 or no-data
               perform sql-fetch
               subtract 1 from row-number
           end-perform
           perform finish-sql-query
           if no-data
               perform do-first
           else
               perform save-last
               perform do-next
           end-if
           exit.

      *>----------------------------------------------------------------
       do-default-operation section.

           *> On initial entry, set order field to 1st primary key
           *> column, no filtering and output 1st page of rows
           move "A.ID" to order-field
           move "(none)" to s-filter-field
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform Next-DataTable
           if no-data
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       begin-DataTable section.

           *> This routine is called before the datatable
           *> outputs the 1st row in the table

           *> Remember field values of 1st row in the table
           perform save-first
           exit.

      *>----------------------------------------------------------------
       next-DataTable section.

           *> This routine is called after a row has been output to the
           *> datatable.It should prepare the next row for output, or
           *> signal 'no more data' by setting mf-row-index to zero

           *> Check if enough rows have already been output
           if MF-Row-Index >= 99
               move 0 to mf-row-index
               exit section
           end-if

           *> Get the next row
           perform sql-fetch
           if sql-ok
               *> Set up row number for display
               add 1 to mf-row-index
               move mf-row-index to mf-row-id
               *> Save field values in case this turns out to be the
               *> last row
               perform save-last
               *> Prepare the row for output
               perform DataTable-row-cvt
               if A-ID <> 0 then
                  exec sql
                     select SHORTNAME
                     into :f-A-ID
                     from USERS_V A
                     where A.ID = :A-ID
                  end-exec
               end-if
               *>Fill the combo field in the record list
               if A-ID-DO-LAST <>spaces and "0" then
                  compute TempId = function NUMVAL(A-ID-DO-LAST)
                   exec sql
                       SELECT A.HYPER_LINK
                       INTO :f-A-ID-DO-LAST
                       FROM CHAPTER_V A
                       WHERE A.ID = :TempId
                   end-exec
               end-if

               perform blank-sql-nulls
               perform DataTable-row-fix
           end-if

           if no-data
               if mf-row-index > 0 and stat-index <= 1
                   perform setup-status
                   string
                       " - end of data" delimited size
                   into frmesStatus pointer stat-index
               end-if
               move 0 to mf-row-index
           end-if
           exit.

      *>----------------------------------------------------------------
       end-DataTable section.

           *> This rotine is called when output to the datatable has
           *> been completed. If no other status information has been
           *> set up so far, do so now, and check if the last row read
           *> was the last selected row. Then tidy up and disconnect
           *> from the SQL server
           if frmesStatus = spaces
               perform setup-status
               perform sql-fetch
               if no-data
                   string
                       " - positioned at end" delimited size
                   into frmesStatus pointer stat-index
               end-if
           end-if
           perform finish-sql-query
           perform sql-finish
           perform USADlist-cvt
           perform blank-sql-nulls
           exit.

      *>----------------------------------------------------------------
       init-sql-nulls section.

           *> Initialize working fields where the server has returned
           *>a null
           if n-A-ID-DO-LAST < 0
             initialize A-ID-DO-LAST
           end-if
           if n-A-NAME < 0
             initialize A-NAME
           end-if
           if n-A-PASS-DATE < 0
             initialize A-PASS-DATE
           end-if
           if n-A-NBR-TRIES < 0
             initialize A-NBR-TRIES
           end-if
           if n-A-LOCK-DATE < 0
             initialize A-LOCK-DATE
           end-if
           if n-A-LAST-EVENT < 0
             initialize A-LAST-EVENT
           end-if
           if n-A-NBR-SIGNON < 0
             initialize A-NBR-SIGNON
           end-if
           exit.

      *>----------------------------------------------------------------
       blank-sql-nulls section.

           *> Set Browser fields to spaces for nullable fields where
           *> the server has returned a null and the SpacesAsNull
           *> attribute is set
           if n-A-ID-DO-LAST < 0
             move spaces to f-A-ID-DO-LAST
           end-if
           if n-A-NAME < 0
             move spaces to f-A-NAME
           end-if
           if n-A-PASS-DATE < 0
             move spaces to f-A-PASS-DATE
           end-if
           if n-A-NBR-TRIES < 0
             move spaces to f-A-NBR-TRIES
           end-if
           if n-A-LOCK-DATE < 0
             move spaces to f-A-LOCK-DATE
           end-if
           if n-A-LAST-EVENT < 0
             move spaces to f-A-LAST-EVENT
           end-if
           if n-A-NBR-SIGNON < 0
             move spaces to f-A-NBR-SIGNON
           end-if
           exit.
      *>----------------------------------------------------------------
       save-first section.

           *> Save field values for the 1st row output
           move A-ID to first-A-ID
           move A-ID-DO-LAST to first-A-ID-DO-LAST
           move n-A-ID-DO-LAST to n-first-A-ID-DO-LAST
           move A-SHORTNAME to first-A-SHORTNAME
           move A-NAME to first-A-NAME
           move n-A-NAME to n-first-A-NAME
           move A-PASS-DATE to first-A-PASS-DATE
           move n-A-PASS-DATE to n-first-A-PASS-DATE
           move A-NBR-TRIES to first-A-NBR-TRIES
           move n-A-NBR-TRIES to n-first-A-NBR-TRIES
           move A-LOCK-DATE to first-A-LOCK-DATE
           move n-A-LOCK-DATE to n-first-A-LOCK-DATE
           move A-LAST-EVENT to first-A-LAST-EVENT
           move n-A-LAST-EVENT to n-first-A-LAST-EVENT
           move A-NBR-SIGNON to first-A-NBR-SIGNON
           move n-A-NBR-SIGNON to n-first-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       save-last section.

           *> Save field values for the last row output
           move A-ID to last-A-ID
           move A-ID-DO-LAST to last-A-ID-DO-LAST
           move n-A-ID-DO-LAST to n-last-A-ID-DO-LAST
           move A-SHORTNAME to last-A-SHORTNAME
           move A-NAME to last-A-NAME
           move n-A-NAME to n-last-A-NAME
           move A-PASS-DATE to last-A-PASS-DATE
           move n-A-PASS-DATE to n-last-A-PASS-DATE
           move A-NBR-TRIES to last-A-NBR-TRIES
           move n-A-NBR-TRIES to n-last-A-NBR-TRIES
           move A-LOCK-DATE to last-A-LOCK-DATE
           move n-A-LOCK-DATE to n-last-A-LOCK-DATE
           move A-LAST-EVENT to last-A-LAST-EVENT
           move n-A-LAST-EVENT to n-last-A-LAST-EVENT
           move A-NBR-SIGNON to last-A-NBR-SIGNON
           move n-A-NBR-SIGNON to n-last-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       restore-first section.

           *> Restore the 1st row output last time, or last row output
           *> in form view
           move first-A-ID to A-ID
           move first-A-ID-DO-LAST to A-ID-DO-LAST
           move n-first-A-ID-DO-LAST to n-A-ID-DO-LAST
           move first-A-SHORTNAME to A-SHORTNAME
           move first-A-NAME to A-NAME
           move n-first-A-NAME to n-A-NAME
           move first-A-PASS-DATE to A-PASS-DATE
           move n-first-A-PASS-DATE to n-A-PASS-DATE
           move first-A-NBR-TRIES to A-NBR-TRIES
           move n-first-A-NBR-TRIES to n-A-NBR-TRIES
           move first-A-LOCK-DATE to A-LOCK-DATE
           move n-first-A-LOCK-DATE to n-A-LOCK-DATE
           move first-A-LAST-EVENT to A-LAST-EVENT
           move n-first-A-LAST-EVENT to n-A-LAST-EVENT
           move first-A-NBR-SIGNON to A-NBR-SIGNON
           move n-first-A-NBR-SIGNON to n-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       restore-last section.

           *> Restore field values for the last row output
           move last-A-ID to A-ID
           move last-A-ID-DO-LAST to A-ID-DO-LAST
           move n-last-A-ID-DO-LAST to n-A-ID-DO-LAST
           move last-A-SHORTNAME to A-SHORTNAME
           move last-A-NAME to A-NAME
           move n-last-A-NAME to n-A-NAME
           move last-A-PASS-DATE to A-PASS-DATE
           move n-last-A-PASS-DATE to n-A-PASS-DATE
           move last-A-NBR-TRIES to A-NBR-TRIES
           move n-last-A-NBR-TRIES to n-A-NBR-TRIES
           move last-A-LOCK-DATE to A-LOCK-DATE
           move n-last-A-LOCK-DATE to n-A-LOCK-DATE
           move last-A-LAST-EVENT to A-LAST-EVENT
           move n-last-A-LAST-EVENT to n-A-LAST-EVENT
           move last-A-NBR-SIGNON to A-NBR-SIGNON
           move n-last-A-NBR-SIGNON to n-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       setup-server-persistence section.

           *> Initialise the server state file
           move frmehstate to client-id
           move length of client-state to client-length
           if client-id = spaces
               call "MF_CLIENT_STATE_ALLOCATE"
                   using client-id client-length state-status
               move client-id to frmehstate
           end-if
           exit.

      *>----------------------------------------------------------------
       save-state section.

           *> Save state for next call
           move order-field to s-order-field
           call "MF_CLIENT_STATE_SAVE"
               using client-id client-state client-length state-status
           exit.

      *>----------------------------------------------------------------
       restore-state section.

           *> Resore state from last call, if there was a last call
           move frmehstate to client-id
           if client-id not = spaces
               move length of client-state to client-length
               call "MF_CLIENT_STATE_RESTORE"
                   using client-id client-state client-length
                       state-status
               move s-order-field to order-field
           end-if
           exit.

      *>----------------------------------------------------------------
       setup-status section.

           *> Setup status line
           if frmesStatus not = spaces
               exit section
           end-if

           if s-filter-field not = '(none)'
               if s-filter-op = '<>'
                   move '!=' to s-filter-op
               end-if

               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", filtering on " delimited size
                   s-filter-field(3:) delimited space
                   " " delimited size
                   s-filter-op delimited size
                  " " delimited size
                   s-filter-value delimited x"0"
               into frmesStatus pointer stat-index

               if s-filter-op = '!='
                   move '<>' to s-filter-op
               end-if

           else
               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", with no filtering " delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       compare-to-first section.

           *> Compare current order field values with the
           *> corresponding 'first-' values
           move order-field to field-name
           perform compare-field-to-first
           if not IsEqual
               exit section
           end-if

           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-field-to-first section.

           *> Compare the field (whose name is in field-name)
           *> with the corresponding 'first-' value
           evaluate field-name
               when "A.ID"
                 if A-ID > first-A-ID
                   set IsGreater to true
                 else
                   if A-ID < first-A-ID
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ID_DO_LAST"
                 if A-ID-DO-LAST > first-A-ID-DO-LAST
                   set IsGreater to true
                 else
                   if A-ID-DO-LAST < first-A-ID-DO-LAST
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.SHORTNAME"
                 if A-SHORTNAME > first-A-SHORTNAME
                   set IsGreater to true
                 else
                   if A-SHORTNAME < first-A-SHORTNAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NAME"
                 if A-NAME > first-A-NAME
                   set IsGreater to true
                 else
                   if A-NAME < first-A-NAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.PASS_DATE"
                 if A-PASS-DATE > first-A-PASS-DATE
                   set IsGreater to true
                 else
                   if A-PASS-DATE < first-A-PASS-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_TRIES"
                 if A-NBR-TRIES > first-A-NBR-TRIES
                   set IsGreater to true
                 else
                   if A-NBR-TRIES < first-A-NBR-TRIES
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LOCK_DATE"
                 if A-LOCK-DATE > first-A-LOCK-DATE
                   set IsGreater to true
                 else
                   if A-LOCK-DATE < first-A-LOCK-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_EVENT"
                 if A-LAST-EVENT > first-A-LAST-EVENT
                   set IsGreater to true
                 else
                   if A-LAST-EVENT < first-A-LAST-EVENT
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_SIGNON"
                 if A-NBR-SIGNON > first-A-NBR-SIGNON
                   set IsGreater to true
                 else
                   if A-NBR-SIGNON < first-A-NBR-SIGNON
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       compare-to-last section.

           *> Compare current order field values with the
           *> corresponding 'last-' values
           move order-field to field-name
           perform compare-field-to-last
           if not IsEqual
               exit section
           end-if

           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform compare-field-to-last
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-field-to-last section.

           *> Compare the field (whose name is in field-name)
           *> with the corresponding 'last-' value
           evaluate field-name
               when "A.ID"
                 if A-ID > last-A-ID
                   set IsGreater to true
                 else
                   if A-ID < last-A-ID
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ID_DO_LAST"
                 if A-ID-DO-LAST > last-A-ID-DO-LAST
                   set IsGreater to true
                 else
                   if A-ID-DO-LAST < last-A-ID-DO-LAST
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.SHORTNAME"
                 if A-SHORTNAME > last-A-SHORTNAME
                   set IsGreater to true
                 else
                   if A-SHORTNAME < last-A-SHORTNAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NAME"
                 if A-NAME > last-A-NAME
                   set IsGreater to true
                 else
                   if A-NAME < last-A-NAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.PASS_DATE"
                 if A-PASS-DATE > last-A-PASS-DATE
                   set IsGreater to true
                 else
                   if A-PASS-DATE < last-A-PASS-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_TRIES"
                 if A-NBR-TRIES > last-A-NBR-TRIES
                   set IsGreater to true
                 else
                   if A-NBR-TRIES < last-A-NBR-TRIES
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LOCK_DATE"
                 if A-LOCK-DATE > last-A-LOCK-DATE
                   set IsGreater to true
                 else
                   if A-LOCK-DATE < last-A-LOCK-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_EVENT"
                 if A-LAST-EVENT > last-A-LAST-EVENT
                   set IsGreater to true
                 else
                   if A-LAST-EVENT < last-A-LAST-EVENT
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_SIGNON"
                 if A-NBR-SIGNON > last-A-NBR-SIGNON
                   set IsGreater to true
                 else
                   if A-NBR-SIGNON < last-A-NBR-SIGNON
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       process-form-input-data section.

           *> Accept the CGI input from the Browser, and check for
           *> errors
           initialize htmlform
           accept htmlform
           exit.

      *>----------------------------------------------------------------
       convert-input section.
           perform input-conversion
           if v-all-ok = 0
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           *> The input conversion routines detected errors so
           *> display a message and stop
           exec html
               :v-first-bad is a numeric field and
               contains an invalid or out of range value,
               please enter a valid value
           end-exec
           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "USADlist.cpv".
      *>----------------------------------------------------------------
