      $set preprocess(htmlpp) endp

      *>****************************************************************
       identification division.
      *>****************************************************************
           program-id. toc.

      *>****************************************************************
       environment division.
      *>***************************************************************
       class-control.
       copy "ClCtrl.cpy".

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.
       01 FrameTarget                  pic x(10).
       copy "ObjRef.cpy".
       copy "UsCtrl.cpy".
       copy "Toc-Tab.cpy".

      *>----------------------------------------------------------------
           copy "toc.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
           copy "toc.cpy".
      *>----------------------------------------------------------------

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main Section.

           perform process-form-input-data
           perform input-conversion
           perform process-business-logic
           perform sql-finish
           stop run.

      *>----------------------------------------------------------------
       process-business-logic Section.

           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Common" using UsCtrlStruct
           invoke UsCtrlRef "Finalize" returning UsCtrlRef

           if UsCtrlId <> CHID then
               exec html <SCRIPT>
                   window.open("/COBOL/IMAGE/Blank.htm", target="main")
               </SCRIPT> end-exec
           end-if

           compute UsCtrlID = function NUMVAL(CHID)

           invoke Tree "New" returning TreeRef
           invoke TreeRef "OpenToc" using UsCtrlStruct Toc-Tab
           invoke TreeRef "Finalize" returning TreeRef

           if Msg not = spaces
               perform output-form-error-and-stop
           end-if

           exec html <HTML>
               <HEAD><TITLE>Table des mati&egrave;res</TITLE></HEAD>
               <FONT FACE="Arial">
               <BODY VLINK="#0000FF"
                     BACKGROUND="/COBOL/IMAGE/Dbback.gif">
               <H2>Table des mati&egrave;res</H2>
           end-exec

           perform TOC-cvt

           exec html
               <INPUT TYPE="Hidden" NAME="CHID"
                     VALUE=":f-CHID">
           end-exec

       exec html
       <TABLE BORDER=0 CELLSPACING=0 CELLPADDING=0 WIDTH=340>
           <TR VALIGN="center" ALIGN="left">
               <TD NOWRAP COLSPAN="1" WIDTH="18"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="18"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="18"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="280"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="1"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="1"></TD>
               <TD NOWRAP COLSPAN="1" WIDTH="1"></TD>
           </TR>
       end-exec

           perform varying Toc-Idx from 1 by 1 until Toc-Idx > Toc-Max
             if Toc-Show(Toc-Idx) = 1 then

               if Toc-Url(Toc-Idx) = spaces then
                   string "/cgi-bin/toc.exe?CHID="
                                                  delimited by spaces
                   Toc-ID(Toc-Idx)                delimited by size
                                                  into Toc-Url(Toc-Idx)
                   move "_self" to FrameTarget
               else
                   move "main" to FrameTarget
               end-if

           exec html
           <TR VALIGN="top" ALIGN="left">
           end-exec

               if Toc-TabNr(Toc-Idx) <> 0 then
           exec html
               <TD COLSPAN=":Toc-TabNr(Toc-Idx)"></TD>
           end-exec
               end-if
           exec html
               <TD COLSPAN="4" NOWRAP>
           end-exec

               if Toc-ImgSrc(Toc-Idx) <> spaces then
           exec html
                   <img src="/COBOL/IMAGE/:Toc-ImgSrc(Toc-Idx)">
           end-exec
               end-if

           exec html
                   <a href=":Toc-Url(Toc-Idx)" target = ":FrameTarget">
                   :Toc-HyperLink(Toc-Idx)</a>
               </TD>
           </TR>
           end-exec


           exec html
           end-exec

               perform Toc-LineNr(Toc-Idx) times
                   exec html
           <BR>
                   end-exec
               end-perform

             end-if
           end-perform

           exec html
       </table></body></FONT>
       </HTML>

           end-exec

           exit.

      *>----------------------------------------------------------------
       process-form-input-data section.
           initialize htmlform
           accept htmlform.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           perform sql-finish

           exec html
               <SCRIPT>
               alert(":Msg")
               window.open("/cgi-bin/eurecas.exe", target="_top")
               </SCRIPT>
           end-exec

           stop run.

      *>----------------------------------------------------------------
       sql-finish section.
           EXEC SQL DISCONNECT END-EXEC
           exit.

      *>----------------------------------------------------------------
           copy "toc.cpv".
      *>----------------------------------------------------------------
