      $set preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set preprocess(htmlpp) stephtml endp
      *set sql(dbman=odbc)

      *>***************************************************************
       identification division.
      *>***************************************************************
           program-id. "USADform".


      *>***************************************************************
       environment division.
      *>***************************************************************
       class-control.
      *> class used by the CGI's
       copy "ClCtrl.cpy".


      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the CGI without use of the litlink
      *> compiler directive.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.
      *> Objects References
       copy "ObjRef.cpy".
      *> User Control definition
       copy "UsCtrl.cpy".
      *> Temporary field
       01 TempIdx                      pic 9(5).
       01 TempX254                     pic x(254).
       01 TempX20                      pic x(20).
      *>---Default string returned when no string is found in the
      *>   "ini" file
       01 WsIniDefaultString           pic x(9) value "Not found".
      *>---Default values when none is found in the "ini" file
       01 WsDefaultSignonTries         pic x value "3".
       copy "Ini.cpy".
       copy "Dates.cpy".
      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "USADform.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "USADform.cpy".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Control Area
           exec sql include sqlca end-exec.

      *>----------------------------------------------------------------
      *> The following field receives ESQL error messages wider than the
      *> 70 bytes provided by the SQLCA field SQLERRMC
           01 MFSQLMessageText         pic x(256).
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this exec sql statement or modify the
      *> contents of the copy file.
      *> This copy file contains the Embedded SQL Descriptor Area
           exec sql include sqlda end-exec.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following record, it contains
      *> state information saved between CGI invokations
      *>     Session identifier for state maintenance routines
           01 client-id                pic x(30).
      *>     Length of saved state record
           01 client-length            pic xxxx comp-x.
      *>     Status returned by state maintenance routines
           01 server-status            pic x comp-x.
      *>     The state record itself
           01 client-state.
      *>     The fieldname used for ordering rows
             03 s-order-field          pic x(32).
      *>     The fieldname used for filtering rows
             03 s-filter-field         pic x(32).
      *>     The current filter value
             03 s-filter-value         pic x(256).
      *>     The current filter operator
             03 s-filter-op            pic xx.
      *>     The first row displayed to the Browser
             03 first-A-ID             pic S9(12) COMP-3.
             03 first-A-ID-DO-LAST     pic S9(12) COMP-3.
             03 first-A-SHORTNAME      pic X(20).
             03 first-A-NAME           pic X(40).
             03 first-A-PASS-DATE      pic X(26).
             03 first-A-NBR-TRIES      pic S9(1) COMP-3.
             03 first-A-LOCK-DATE      pic X(26).
             03 first-A-LAST-EVENT     pic X(26).
             03 first-A-NBR-SIGNON     pic S9(12) COMP-3.
             03 n-first-A-ID-DO-LAST   pic s9(4) comp-5.
             03 n-first-A-NAME         pic s9(4) comp-5.
             03 n-first-A-PASS-DATE    pic s9(4) comp-5.
             03 n-first-A-NBR-TRIES    pic s9(4) comp-5.
             03 n-first-A-LOCK-DATE    pic s9(4) comp-5.
             03 n-first-A-LAST-EVENT   pic s9(4) comp-5.
             03 n-first-A-NBR-SIGNON   pic s9(4) comp-5.
      *>     The last row displayed to the Browser (table view only)
             03 last-A-ID              pic S9(12) COMP-3.
             03 last-A-ID-DO-LAST      pic S9(12) COMP-3.
             03 last-A-SHORTNAME       pic X(20).
             03 last-A-NAME            pic X(40).
             03 last-A-PASS-DATE       pic X(26).
             03 last-A-NBR-TRIES       pic S9(1) COMP-3.
             03 last-A-LOCK-DATE       pic X(26).
             03 last-A-LAST-EVENT      pic X(26).
             03 last-A-NBR-SIGNON      pic S9(12) COMP-3.
             03 n-last-A-ID-DO-LAST    pic s9(4) comp-5.
             03 n-last-A-NAME          pic s9(4) comp-5.
             03 n-last-A-PASS-DATE     pic s9(4) comp-5.
             03 n-last-A-NBR-TRIES     pic s9(4) comp-5.
             03 n-last-A-LOCK-DATE     pic s9(4) comp-5.
             03 n-last-A-LAST-EVENT    pic s9(4) comp-5.
             03 n-last-A-NBR-SIGNON    pic s9(4) comp-5.
      *>     The field values when the filter was last changed
             03 filter-A-ID            pic S9(12) COMP-3.
             03 filter-A-ID-DO-LAST    pic S9(12) COMP-3.
             03 filter-A-SHORTNAME     pic X(20).
             03 filter-A-NAME          pic X(40).
             03 filter-A-PASS-DATE     pic X(26).
             03 filter-A-NBR-TRIES     pic S9(1) COMP-3.
             03 filter-A-LOCK-DATE     pic X(26).
             03 filter-A-LAST-EVENT    pic X(26).
             03 filter-A-NBR-SIGNON    pic S9(12) COMP-3.
             03 n-filter-A-ID-DO-LAST  pic s9(4) comp-5.
             03 n-filter-A-NAME        pic s9(4) comp-5.
             03 n-filter-A-PASS-DATE   pic s9(4) comp-5.
             03 n-filter-A-NBR-TRIES   pic s9(4) comp-5.
             03 n-filter-A-LOCK-DATE   pic s9(4) comp-5.
             03 n-filter-A-LAST-EVENT  pic s9(4) comp-5.
             03 n-filter-A-NBR-SIGNON  pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not alter the following fields, they are used by
      *> the generated SQL data access code
      *>----------------------------------------------------------------
           01 sql-text                 pic x(1024).
           01 sql-index                pic 9(4) comp-5.
           01 where-clause             pic x(1024).
           01 order-clause             pic x(1024).
           01 temp                     pic x(256).
           01 temp-index               pic xxxx comp-5.
           01 stat-index               pic xxxx comp-5.
           01 last-indicator           pic s9(4) comp-5.
           01 i                        pic x(4) comp-5.
           01 target-row               pic S9(15).
           01 filter-field             pic x(32).
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to pass input parameters
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>   Fields to be used in SQL Select statements
           01 selectColumns.
             03 filler pic x(20) value "A.ID, A.ID_DO_LAST, ".
             03 filler pic x(21) value "A.SHORTNAME, A.NAME, ".
             03 filler pic x(26) value "A.PASS_DATE, A.NBR_TRIES, ".
             03 filler pic x(27) value "A.LOCK_DATE, A.LAST_EVENT, ".
             03 filler pic x(12) value "A.NBR_SIGNON".
      *>   Fields that are part of the primary key
           01 PrimaryKeyColumns.
             03 filler pic x(05) value "A.ID#".
      *>   Tables to be used in SQL Select statements
           01 selectTables.
             03 filler pic x(09) value "USERS_V A".
      *>   Fields that can be updated
           01 updateColumns.
             03 filler pic x(25) value "A.ID_DO_LAST#A.SHORTNAME#".
             03 filler pic x(19) value "A.NAME#A.PASS_DATE#".
             03 filler pic x(24) value "A.NBR_TRIES#A.LOCK_DATE#".
             03 filler pic x(26) value "A.LAST_EVENT#A.NBR_SIGNON#".
      *>   Field values for SQL Insert and Update statements
           01 New-SQL-Values.
             03 new-A-ID               pic S9(12) COMP-3.
             03 new-A-ID-DO-LAST       pic S9(12) COMP-3.
             03 new-A-SHORTNAME        pic X(20).
             03 new-A-NAME             pic X(40).
             03 new-A-PASS-DATE        pic X(26).
             03 new-A-NBR-TRIES        pic S9(1) COMP-3.
             03 new-A-LOCK-DATE        pic X(26).
             03 new-A-LAST-EVENT       pic X(26).
             03 new-A-NBR-SIGNON       pic S9(12) COMP-3.
             03 n-new-A-ID-DO-LAST     pic s9(4) comp-5.
             03 n-new-A-NAME           pic s9(4) comp-5.
             03 n-new-A-PASS-DATE      pic s9(4) comp-5.
             03 n-new-A-NBR-TRIES      pic s9(4) comp-5.
             03 n-new-A-LOCK-DATE      pic s9(4) comp-5.
             03 n-new-A-LAST-EVENT     pic s9(4) comp-5.
             03 n-new-A-NBR-SIGNON     pic s9(4) comp-5.
      *>   Contains the name of the field being processed
           01 field-name               pic x(40).
      *>   Operator used for positioning within select rows.
      *>   Will be ">=" for Next, "<=" for Prev
      *>   and "??" (meaning no where clause needed for positioning)
      *>   for First and Last
           01 search-op                pic xx.
      *>   Ordering specification, null terminated.
      *>   Wiil be empty for First and Next and DESC for Last and Prev
           01 sort-spec                pic x(8).
      *>   Holds the name of the column to order by
           01 order-field              pic x(32).
      *>   The name of the file used to store server state
           01 state-filename           pic x(255)
               value "STATE.DAT".
      *>----------------------------------------------------------------
      *> WARNING: The following fields are used to return results from
      *> to SQL data access and utility routines, use them with care
      *>----------------------------------------------------------------
      *>      Status of last SQL statement executed
           01 sql-status               pic 9.
               88 sql-ok                 value 0.
               88 no-data                value 1.
               88 sql-error              value 2.
      *>      Result of field comparison routines
           01 order-status             pic s9.
               88 IsLess               value -1.
               88 IsEqual              value 0.
               88 IsGreater            value +1.
      *>      Partial result of field comparison - order field only
           01 find-status              pic s9.
               88 foundLess            value -1.
               88 foundEqual           value 0.
               88 foundGreater         value +1.
      *>      Result of state mainenance routine call
           01 state-status             pic x comp-x.
      *>      SQL Indicator variables for last SQL statement executed
           01 SQL-Indicators.
             03 n-A-ID-DO-LAST         pic s9(4) comp-5.
             03 n-A-NAME               pic s9(4) comp-5.
             03 n-A-PASS-DATE          pic s9(4) comp-5.
             03 n-A-NBR-TRIES          pic s9(4) comp-5.
             03 n-A-LOCK-DATE          pic s9(4) comp-5.
             03 n-A-LAST-EVENT         pic s9(4) comp-5.
             03 n-A-NBR-SIGNON         pic s9(4) comp-5.
      *>----------------------------------------------------------------

      *> Enter additional working-storage items here

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.
           *> Connect to Database and control the User access
           invoke UsCtrl "New" returning UsCtrlRef
           invoke UsCtrlRef "Access" using UsCtrlStruct

           *> allocate state file
           call "sstate"
           call "MF_CLIENT_STATE_FILE"
               using state-filename server-status
           *> get system date and time
           invoke Dates "New" returning DatesRef
           invoke DatesRef "DateAndTime" returning DateStruct
           invoke DatesRef "Finalize" returning DatesRef

           perform process-form-input-data

      *>---get the number of tries before lock
           perform get-ini-value

           *> Get ID corresponding to selection in Combo-box
           if f-Action = "Modifier" or "Query"
              initialize A-ID-DO-LAST
              if f-AIDDOLASTSelect(1) <> spaces then
                  move f-AIDDOLASTSelect(1) to TempX254

                  EXEC SQL
                      SELECT A.ID
                      INTO :A-ID-DO-LAST
                      FROM CHAPTER_V A
                      WHERE A.HYPER_LINK = :TempX254
                  END-EXEC
                  if sqlcode <> 0 then
              move "Selected chapter has benn modified by another user"
                     to f-frmesStatus
                     perform convert-input
                     perform combo
                     perform USADform-cvt
                     perform USADform-out
                     stop run
                  end-if

                  move A-ID-DO-LAST to f-A-ID-DO-LAST
              else
                  initialize f-A-ID-DO-LAST
              end-if

              if f-Action = "Query" and f-filterby(1) = "NBR_TRIES"
                   move SignonTries to f-A-NBR-TRIES
                   if f-Locked = 1 then
                       move ">=" to f-FilterType(1)
                   else
                       move "<" to f-FilterType(1)
                   end-if
              else
                   if f-Locked = 1 then
                       move SignonTries to f-A-NBR-TRIES
                   else
                       move 0 to f-A-NBR-TRIES
                   end-if
              end-if
           end-if

           perform set-sql-nulls
           perform convert-input
           perform translate-combos
           perform restore-state
           perform sql-start

           evaluate Action
               when "<<"
                   perform do-first
               when "<"
                   perform do-previous
               when ">"
                   perform do-next
               when ">>"
                   perform do-last
               when "Modifier"
                   perform do-update
               when "Query"
                   perform do-find
               when other
                   if client-id = spaces
                       perform do-default-operation
                   else
                       perform do-first-from-table
                   end-if
           end-evaluate

           *> setup the form controls

           perform save-state
           perform combo
           perform setup-controls
           perform USADform-cvt
           perform blank-sql-nulls
           perform USADform-out
           perform sql-finish
           exit program
           stop run.
      *>----------------------------------------------------------------
       get-ini-value section.
               invoke Ini "New" returning IniRef
      *>------Get the number of signon tries before locking
      *>      from the eurecas "ini" file
               move "..\eurecas.ini"   to IniFileName
               move "Signon"          to IniSectionName
               move "Signon-Tries"   to IniKeyName

               invoke IniRef "GetString" using IniStruct
               invoke IniRef "Finalize" returning IniRef

      *>------If cookie expiration not found, use the default
               if IniString(1:9) = WsIniDefaultString(1:9) then
                       move WsDefaultSignonTries to IniString
               end-if

               move function NUMVAL (IniString) to SignonTries
               move SignonTries to f-SignonTries
           exit.

      *>----------------------------------------------------------------
       combo section.
           *> fill the Chapter DO LAST Combo Box
           EXEC SQL
             SELECT A.HYPER_LINK
             INTO :AIDDOLASTSelect
             FROM CHAPTER_V A, MAY_ACT_ON_V B, USER_GROUP_V C, USERS_V D
             WHERE D.ID = :A-ID AND
                   C.ID = D.ID_BELONGS_TO AND
                   B.ID = C.ID AND
                   A.ID = B.ID_CHAPTER AND
                   A.STATUS = 'Valid' AND
                   A.MASTER_URL IS NOT NULL
             ORDER BY A.HYPER_LINK
           END-EXEC

           compute c-AIDDOLASTSelect = sqlerrd(3) + 1
           *> get the item to be selected
           if A-ID-DO-LAST <> 0
              EXEC SQL
                SELECT A.HYPER_LINK
                INTO :TempX254
                FROM CHAPTER_V A
                WHERE A.ID = :A-ID-DO-LAST
              END-EXEC
              perform varying TempIdx from 1 by 1 until
                           TempIdx > c-AIDDOLASTSelect
                if AIDDOLASTSelect(TempIdx) = TempX254
                   move 1 to i-AIDDOLASTSelect(TempIdx)
                   exit perform
                end-if
              end-perform
           else
              move 1 to i-AIDDOLASTSelect(c-AIDDOLASTSelect)
           end-if

           if A-NBR-TRIES >= SignonTries
               move 1 to Locked
           else
               initialize Locked
           end-if

           exit.
      *>----------------------------------------------------------------
       base-sql section.

           exec sql
               declare sql_cursor cursor for dyna_stat
           end-exec
           exit.

      *>----------------------------------------------------------------
       sql-start section.
           *> Initialise variables
           move 0 to target-row
           move spaces to frmesStatus
           move 1 to stat-index
           move OrderBy(1) to order-field

           *> Initialise filtering control variables
           move FilterBy(1) to filter-field
           if filter-field = spaces
               if client-id = spaces
                   move "(none)" to filter-field
               else
                   move "(existing)" to filter-field
               end-if
           end-if

           *> We use != in Browser to avoid special HTML chars
           *> Convert to SQL 'not equal' if necessary
           if c-FilterType > 0
               move FilterType(1) to s-filter-op
               if s-filter-op = "!="
                   move "<>" to s-filter-op
               end-if
           end-if

           *> If filter field has changed, save filter value
           *> for status line
           if filter-field not = "(existing)"
               perform save-filter
               move filter-field to s-filter-field

               if s-filter-field not = '(none)'
                   evaluate s-filter-field
                       when "A.ID"
                           move f-A-ID to s-filter-value
                       when "A.ID_DO_LAST"
                           move f-A-ID-DO-LAST to s-filter-value
                       when "A.SHORTNAME"
                           move f-A-SHORTNAME to s-filter-value
                       when "A.NAME"
                           move f-A-NAME to s-filter-value
                       when "A.PASS_DATE"
                           move f-A-PASS-DATE to s-filter-value
                       when "A.NBR_TRIES"
                           move f-A-NBR-TRIES to s-filter-value
                       when "A.LOCK_DATE"
                           move f-A-LOCK-DATE to s-filter-value
                       when "A.LAST_EVENT"
                           move f-A-LAST-EVENT to s-filter-value
                       when "A.NBR_SIGNON"
                           move f-A-NBR-SIGNON to s-filter-value
                   end-evaluate

                   perform varying i from length s-filter-value by -1
                           until i = 0
                       if s-filter-value(i:1) = space
                           move x"0" to s-filter-value(i:1)
                       else
                           exit perform
                       end-if
                   end-perform

                   if s-filter-value(1:1)=x"0"
                       move z"(empty)" to s-filter-value
                   end-if
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-finish section.

           *> Finalise SQL session
           exec sql disconnect end-exec
           invoke UsCtrlRef "Finalize" returning UsCtrlRef
           exit.

      *>----------------------------------------------------------------
       do-sql-query section.

           *> Build dynamic SQL query for current order and filter
           *> settings, then prepare it
           move spaces to sql-text
           move 0 to sqld sqln
           move 1 to sql-index
           move low-values to where-clause order-clause

           if order-field = spaces
               *> Default to 1st primary key field
               move "A.ID" to order-field
           end-if

           if search-op not = '??'
               *> For next, prev and find add the order field
               *> to the where clause
               move order-field to field-name
               perform sql-add-param
           end-if

           if (s-filter-field not = "(none)")
               move s-filter-field to field-name
               perform sql-add-filter-param
           end-if

           move 1 to sql-index
           move order-field to field-name
           perform trim-field-name
           string
               field-name delimited x"0"
               sort-spec delimited x"0"
           into order-clause pointer sql-index

           *> Append primary key columns that are not the order field
           *> to the order clause to guarantee a unique row order
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform trim-field-name
               string
                   ", " delimited size
                   field-name delimited x"0"
                   sort-spec delimited x"0"
               into order-clause pointer sql-index
           end-perform

           move 1 to sql-index,
           string
               "select " delimited size
               selectColumns delimited size
               " from "  delimited size
               selectTables delimited size
               where-clause delimited x"0"
               " order by " delimited size
               order-clause delimited x"0"
               x"0" delimited size
           into sql-text pointer sql-index

           exec sql
                   prepare dyna_stat from :sql-text
           end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error processing this request.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-add-param section.

           *> Add field-name as a parameter to the where clause
           *> for positioning purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_DO_LAST"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-ID-DO-LAST
                   set sqlind(sqln) to address of n-A-ID-DO-LAST
                   move n-A-ID-DO-LAST to last-indicator
                 when "A.SHORTNAME"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of A-SHORTNAME to sqllen(sqln)
                   set sqldata(sqln) to address of A-SHORTNAME
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of A-NAME
                   set sqlind(sqln) to address of n-A-NAME
                   move n-A-NAME to last-indicator
                 when "A.PASS_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-PASS-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-PASS-DATE
                   set sqlind(sqln) to address of n-A-PASS-DATE
                   move n-A-PASS-DATE to last-indicator
                 when "A.NBR_TRIES"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of A-NBR-TRIES
                   set sqlind(sqln) to address of n-A-NBR-TRIES
                   move n-A-NBR-TRIES to last-indicator
                 when "A.LOCK_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LOCK-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of A-LOCK-DATE
                   set sqlind(sqln) to address of n-A-LOCK-DATE
                   move n-A-LOCK-DATE to last-indicator
                 when "A.LAST_EVENT"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of A-LAST-EVENT to sqllen(sqln)
                   set sqldata(sqln) to address of A-LAST-EVENT
                   set sqlind(sqln) to address of n-A-LAST-EVENT
                   move n-A-LAST-EVENT to last-indicator
                 when "A.NBR_SIGNON"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of A-NBR-SIGNON
                   set sqlind(sqln) to address of n-A-NBR-SIGNON
                   move n-A-NBR-SIGNON to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If we specify 'is [not] null'
               *> we'll exclude rows from the result set that we may
               *> need to step through. All we can do is exclude
               *> the field from the where clause.
               *> The moral is that for large tables it's best to
               *> disallow ordering on nullable columns.
               subtract 1 from sqld sqln
               exit section
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           string
               field-name delimited x"0"
               search-op delimited size
               " ?" delimited size
           into where-clause pointer sql-index
           exit.

      *>----------------------------------------------------------------
       sql-add-filter-param section.

           *> Add field-name as a parameter to the where clause
           *> for filtering purposes
           add 1 to sqld sqln
           evaluate field-name
                 when "A.ID"
                   move ESQL-DECIMAL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-ID
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.ID_DO_LAST"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-ID-DO-LAST
                   set sqlind(sqln) to address of n-filter-A-ID-DO-LAST
                   move n-filter-A-ID-DO-LAST to last-indicator
                 when "A.SHORTNAME"
                   move ESQL-CHAR to sqltype(sqln)
                   move length of filter-A-SHORTNAME to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-SHORTNAME
                   set sqlind(sqln) to null
                   move 0 to last-indicator
                 when "A.NAME"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-NAME to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-NAME
                   set sqlind(sqln) to address of n-filter-A-NAME
                   move n-filter-A-NAME to last-indicator
                 when "A.PASS_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-PASS-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-PASS-DATE
                   set sqlind(sqln) to address of n-filter-A-PASS-DATE
                   move n-filter-A-PASS-DATE to last-indicator
                 when "A.NBR_TRIES"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 001
                   set sqldata(sqln) to address of filter-A-NBR-TRIES
                   set sqlind(sqln) to address of n-filter-A-NBR-TRIES
                   move n-filter-A-NBR-TRIES to last-indicator
                 when "A.LOCK_DATE"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LOCK-DATE to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LOCK-DATE
                   set sqlind(sqln) to address of n-filter-A-LOCK-DATE
                   move n-filter-A-LOCK-DATE to last-indicator
                 when "A.LAST_EVENT"
                   move ESQL-CHAR-NULL to sqltype(sqln)
                   move length of filter-A-LAST-EVENT to sqllen(sqln)
                   set sqldata(sqln) to address of filter-A-LAST-EVENT
                   set sqlind(sqln) to address of n-filter-A-LAST-EVENT
                   move n-filter-A-LAST-EVENT to last-indicator
                 when "A.NBR_SIGNON"
                   move ESQL-DECIMAL-NULL to sqltype(sqln)
                   compute sqllen(sqln) = 012
                   set sqldata(sqln) to address of filter-A-NBR-SIGNON
                   set sqlind(sqln) to address of n-filter-A-NBR-SIGNON
                   move n-filter-A-NBR-SIGNON to last-indicator
           end-evaluate

           if last-indicator < 0
               *> The field is null. If the filter operator is
               *> equals or not equals we will deal with it later.
               *> Otherwise the field must be excluded because
               *> all we can do with nulls is equals and not equals
               *> and this might exclude rows that we might need to
               *> step through
               if s-filter-op = "<=" or ">="
                   subtract 1 from sqld sqln
                   exit section
               end-if
           end-if

           if sqln = 1
               string
                   " where " delimited size
               into where-clause pointer sql-index
           else
               string
                   " and " delimited size
               into where-clause pointer sql-index
           end-if

           perform trim-field-name

           if last-indicator >= 0
               string
                   field-name delimited x"0"
                   s-filter-op delimited size
                   " ?" delimited size
               into where-clause pointer sql-index
           else
               *> Deal with null values. These require different
               *> SQL syntax
               subtract 1 from sqld sqln
               if s-filter-op = "="
                   string
                       field-name delimited x"0"
                       ' IS NULL' delimited size
                   into where-clause pointer sql-index
               else
                   string
                       field-name delimited x"0"
                       ' IS NOT NULL' delimited size
                   into where-clause pointer sql-index
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       trim-field-name section.

           *> Null terminate field-name and trim trailing spaces
           move length field-name to i
           perform until i = 0 or field-name(i:1) not = space
               move x"0" to field-name(i:1)
               subtract 1 from i
           end-perform
           exit.

      *>----------------------------------------------------------------
       sql-open section.

           *> Open a cursor to retrieve the query results
           exec sql open sql_cursor using descriptor :sqlda end-exec

           if sqlcode not = 0
               exec html
                   <br><br><em>
                   There was an error opening a SQL cursor.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if
           exit.

      *>----------------------------------------------------------------
       sql-fetch section.

           *> Get the next row from the query result set.
           *> Set the status to sql-ok, no-data or sql-error
           *> Terminate with error message if sql-error
           exec sql
             fetch sql_cursor into
                   :A-ID,
                   :A-ID-DO-LAST:n-A-ID-DO-LAST,
                   :A-SHORTNAME,
                   :A-NAME:n-A-NAME,
                   :A-PASS-DATE:n-A-PASS-DATE,
                   :A-NBR-TRIES:n-A-NBR-TRIES,
                   :A-LOCK-DATE:n-A-LOCK-DATE,
                   :A-LAST-EVENT:n-A-LAST-EVENT,
                   :A-NBR-SIGNON:n-A-NBR-SIGNON
           end-exec

           set sql-ok to true

           if sqlcode = 100
               set no-data to true
               initialize A-ID
               initialize A-ID-DO-LAST
               initialize A-SHORTNAME
               initialize A-NAME
               initialize A-PASS-DATE
               initialize A-NBR-TRIES
               initialize A-LOCK-DATE
               initialize A-LAST-EVENT
               initialize A-NBR-SIGNON
           end-if

           if sqlcode < 0
               set sql-error to true
               exec html
                   <br><br><em>
                   There was an error retrieving query results.<br><br>
                   SQLSTATE = :sqlstate<br><br>
                   SQL Error Message = :MFSQLMessageText<br><br>
                   SQL Statement = :sql-text<br><br>
                   </pre></em>
                   </BODY>
                   </HTML>
               end-exec
               stop run
           end-if

           if sql-ok
               *> Blank out fields where the database returned a null
               perform init-sql-nulls
           end-if
           exit.

      *>----------------------------------------------------------------
       finish-sql-query section.

           *> Finalise the current query
           exec sql close sql_cursor end-exec
           exit.

      *>----------------------------------------------------------------
       do-first-from-table section.

           *> Get the row the user selected in table view. If it has
           *> been deleted by another user, get the next row in the
           *> current ordering

           *> Retrieve the 'row-numer in table' parameter passed in the
           *> hpyerlink.
           move function numval(Action) to target-row
           *> Get the ordering from the saved server state
           move s-order-field to order-field

           *> Restore field values for 1st row in table and
           *> position to it
           perform restore-first
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> Check that the filter hasn't excluded all rows
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> Step through rows until we get to the one we need
           *> or we've read all the selected rows
           subtract 1 from target-row
           perform until target-row <= 0 or no-data
              perform sql-fetch
              subtract 1 from target-row
           end-perform

           *> Tidy up and deal with the case where we ran out of data
           *> becuase rows were deleted by other users
           perform finish-sql-query
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-first section.

           *> Output 1st row
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-next section.

           *> Output next row
           move ">=" to search-op
           move low-values to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicate order field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
               perform sql-fetch
           end-if
           perform finish-sql-query

           *> If end of data reached, wrap round to start
           if no-data
               move
                "End of table reached, position reset to 1st record"
                to frmesStatus
               perform do-first
           end-if
           exit.

      *>----------------------------------------------------------------
       do-previous section.

           *> Output previous row
           move "<=" to search-op
           move z" desc " to sort-spec

           *> Restore last row's field values and position to it
           perform restore-first
           perform do-sql-query
           perform sql-open

           *> There may be duplicates order field values,
           *> so skip rows until we're at or before the last row
           *> or out of rows
           set IsGreater to true
           perform until not IsGreater
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if

           *> If we found the last row, then step one more row
           if IsEqual
              perform sql-fetch
           end-if
           perform finish-sql-query

           *> If start of data reached, wrap round to end
           if no-data
               move
          "Start of table reached, position reset to last record"
                to frmesStatus
               perform do-last
           end-if
           exit.

      *>----------------------------------------------------------------
       do-last section.

           *> Output last row
           move "??" to search-op
           move z" desc " to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.
      *>----------------------------------------------------------------
       do-update section.

           *> Update the last row output

           *> Check that there are some columns the user is allowed to
           *> update
           if updateColumns = spaces
               perform restore-first
               perform do-re-read
               move "There are no updatable columns on this form"
                   to frmesStatus
               exit section
           end-if

           *> Check that this isn't an attempt to update the primary
           *> key
           perform compare-key-to-first
           if not IsEqual
               perform restore-first
               perform do-re-read
               move "Primary Key fields may not be updated"
                   to frmesStatus
               exit section
           end-if

           *> Save new values and retrieve old row. This checks that
           *> row is still there, and should be enough for most servers
           *> to lock the row until the update is complete
           move A-ID to new-A-ID
           move A-ID-DO-LAST to new-A-ID-DO-LAST
           move n-A-ID-DO-LAST to n-new-A-ID-DO-LAST
           move A-SHORTNAME to new-A-SHORTNAME
           move A-NAME to new-A-NAME
           move n-A-NAME to n-new-A-NAME
           move A-PASS-DATE to new-A-PASS-DATE
           move n-A-PASS-DATE to n-new-A-PASS-DATE
           move A-NBR-TRIES to new-A-NBR-TRIES
           move n-A-NBR-TRIES to n-new-A-NBR-TRIES
           move A-LOCK-DATE to new-A-LOCK-DATE
           move n-A-LOCK-DATE to n-new-A-LOCK-DATE
           move A-LAST-EVENT to new-A-LAST-EVENT
           move n-A-LAST-EVENT to n-new-A-LAST-EVENT
           move A-NBR-SIGNON to new-A-NBR-SIGNON
           move n-A-NBR-SIGNON to n-new-A-NBR-SIGNON

           perform Restore-First

           perform do-re-read
           if no-data
               move
                   "The row has been deleted by another user"
                   to frmesStatus
               exit section
           else
               perform compare-key-to-first
               if not IsEqual
                   move
                       "The row has been deleted by another user"
                   to frmesStatus
               exit section
           end-if

           *> Chech that the row hasn't changed since it was output
           *> last time
           perform compare-updatable-to-first
           if not IsEqual
               perform do-re-read
               move
          "This row has been updated by another user - please try again"
                   to frmesStatus
               exit section
           end-if

           *> All OK, so do the update
           exec sql
             update USERS_V set
               ID_DO_LAST = :new-A-ID-DO-LAST
                            :n-new-A-ID-DO-LAST,
               SHORTNAME = :new-A-SHORTNAME,
               NAME = :new-A-NAME
                      :n-new-A-NAME,
               PASS_DATE = :new-A-PASS-DATE
                           :n-new-A-PASS-DATE,
               NBR_TRIES = :new-A-NBR-TRIES
                           :n-new-A-NBR-TRIES,
               LOCK_DATE = :new-A-LOCK-DATE
                           :n-new-A-LOCK-DATE,
               LAST_EVENT = :new-A-LAST-EVENT
                            :n-new-A-LAST-EVENT,
               NBR_SIGNON = :new-A-NBR-SIGNON
                            :n-new-A-NBR-SIGNON
             where ID = :new-A-ID
           end-exec

           if sqlcode not = 0
               if sqlcode = 100
                       move
                   "No record to update, it may have been deleted"
                       to frmesStatus
                   exec sql rollback end-exec
               else
                   *>Check the unicity constraint
                   if sqlstate = 23000
                      move "Downloadkey and Shortname should  be unique"
                                                       to frmesStatus
                   else
                       move sqlerrmc to frmesStatus
                   end-if

                   exec sql rollback end-exec
               end-if
           else
               *> Reset ordering and filtering to avoid confusion
               *> if the row is now excluded from the selected
               *> row set. Commit the update first
               exec sql commit end-exec
               move "A.ID" to order-field
               move "(none)" to s-filter-field
               perform do-re-read
               move "Record updated successfully" to frmesStatus
           end-if
           exit.
      *>----------------------------------------------------------------
       do-default-operation section.

           *> On initial entry, set order field to 1st primary key
           *> column, no filtering and output 1st row
           move "A.ID" to order-field
           move "??" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           if no-data
               perform finish-sql-query
               perform setup-status
               string
                   " - no data to display" delimited size
               into frmesStatus pointer stat-index
               exit section
           end-if
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       do-find section.

           *> Position to the row with order field >= the value input
           *> by the user. If this is an empty value, position to 1st
           *> row
           move ">=" to search-op
           move low-values to sort-spec
           evaluate order-field
                 when "A.ID"
                   if f-A-ID = spaces
                       move "??" to search-op
                   end-if
                 when "A.ID_DO_LAST"
                   if f-A-ID-DO-LAST = spaces
                       move "??" to search-op
                   end-if
                 when "A.SHORTNAME"
                   if f-A-SHORTNAME = spaces
                       move "??" to search-op
                   end-if
                 when "A.NAME"
                   if f-A-NAME = spaces
                       move "??" to search-op
                   end-if
                 when "A.PASS_DATE"
                   if f-A-PASS-DATE = spaces
                       move "??" to search-op
                   end-if
                 when "A.NBR_TRIES"
                   if f-A-NBR-TRIES = spaces
                       move "??" to search-op
                   end-if
                 when "A.LOCK_DATE"
                   if f-A-LOCK-DATE = spaces
                       move "??" to search-op
                   end-if
                 when "A.LAST_EVENT"
                   if f-A-LAST-EVENT = spaces
                       move "??" to search-op
                   end-if
                 when "A.NBR_SIGNON"
                   if f-A-NBR-SIGNON = spaces
                       move "??" to search-op
                   end-if
           end-evaluate
           if search-op = ">="
               perform save-first
           end-if
           perform do-sql-query
           perform sql-open
           perform sql-fetch
           perform finish-sql-query

           *> If there are no suitable rows, output the last row,
           *> if there is one
           if no-data
               perform do-last
               if not no-data
                   perform setup-status
                   string
                       " - positioned at end" delimited size
                   into frmesStatus pointer stat-index
               end-if
           else
               *> Inform the user what happened
               perform setup-status
               if search-op = "??"
                   *> Empty search value, so we're on the 1st row
                   string
                       " - positioned at start" delimited size
                   into frmesStatus pointer stat-index
               else
                   *> Compare order field and the user's value
                   perform compare-to-first
                   if foundEqual
                       string
                           " - positioned where requested"
                               delimited size
                       into frmesStatus pointer stat-index
                   else
                       string
                           " - positioned at next match"
                               delimited size
                       into frmesStatus pointer stat-index
                   end-if
               end-if
           end-if
           exit.

      *>----------------------------------------------------------------
       do-re-read section.

           *> Re-read current row, allowing for the possibility
           *> that it may no longer exist
           move ">=" to search-op
           move low-values to sort-spec
           perform do-sql-query
           perform sql-open

           *> There may be duplicate field values,
           *> so skip rows until we're at or beyond the last row
           *> or out of rows
           set IsLess to true
           perform until not IsLess
               perform sql-fetch
               if not sql-ok
                   exit perform
               end-if
               perform compare-to-first
           end-perform
           perform finish-sql-query
           exit.

      *>----------------------------------------------------------------
       init-sql-nulls section.

           *> Initialize working fields where the server has returned
           *>a null
           if n-A-ID-DO-LAST < 0
             initialize A-ID-DO-LAST
           end-if
           if n-A-NAME < 0
             initialize A-NAME
           end-if
           if n-A-PASS-DATE < 0
             initialize A-PASS-DATE
           end-if
           if n-A-NBR-TRIES < 0
             initialize A-NBR-TRIES
           end-if
           if n-A-LOCK-DATE < 0
             initialize A-LOCK-DATE
           end-if
           if n-A-LAST-EVENT < 0
             initialize A-LAST-EVENT
           end-if
           if n-A-NBR-SIGNON < 0
             initialize A-NBR-SIGNON
           end-if
           exit.

      *>----------------------------------------------------------------
       set-sql-nulls section.

           *> Set SQL Indicator variable for nullable fields where the
           *> input from the Browser is blank and the SpacesAsNull
           *> attribute is set
           if f-A-ID-DO-LAST = spaces
             move -1 to n-A-ID-DO-LAST
           else
             move 0 to n-A-ID-DO-LAST
           end-if
           if f-A-NAME = spaces
             move -1 to n-A-NAME
           else
             move 0 to n-A-NAME
           end-if
           if f-A-PASS-DATE = spaces
             move -1 to n-A-PASS-DATE
           else
             move 0 to n-A-PASS-DATE
           end-if
           if f-A-NBR-TRIES = spaces
             move -1 to n-A-NBR-TRIES
           else
             move 0 to n-A-NBR-TRIES
           end-if
           if f-A-LOCK-DATE = spaces
             move -1 to n-A-LOCK-DATE
           else
             move 0 to n-A-LOCK-DATE
           end-if
           if f-A-LAST-EVENT = spaces
             move -1 to n-A-LAST-EVENT
           else
             move 0 to n-A-LAST-EVENT
           end-if
           if f-A-NBR-SIGNON = spaces
             move -1 to n-A-NBR-SIGNON
           else
             move 0 to n-A-NBR-SIGNON
           end-if
           exit.

      *>----------------------------------------------------------------
       blank-sql-nulls section.

           *> Set Browser fields to spaces for nullable fields where
           *> the server has returned a null and the SpacesAsNull
           *> attribute is set
           if n-A-ID-DO-LAST < 0
             move spaces to f-A-ID-DO-LAST
           end-if
           if n-A-NAME < 0
             move spaces to f-A-NAME
           end-if
           if n-A-PASS-DATE < 0
             move spaces to f-A-PASS-DATE
           end-if
           if n-A-NBR-TRIES < 0
             move spaces to f-A-NBR-TRIES
           end-if
           if n-A-LOCK-DATE < 0
             move spaces to f-A-LOCK-DATE
           end-if
           if n-A-LAST-EVENT < 0
             move spaces to f-A-LAST-EVENT
           end-if
           if n-A-NBR-SIGNON < 0
             move spaces to f-A-NBR-SIGNON
           end-if
           exit.

      *>----------------------------------------------------------------
       save-filter section.

           *> Save current field values for use in filtering
           move A-ID to filter-A-ID
           move A-ID-DO-LAST to filter-A-ID-DO-LAST
           move n-A-ID-DO-LAST to n-filter-A-ID-DO-LAST
           move A-SHORTNAME to filter-A-SHORTNAME
           move A-NAME to filter-A-NAME
           move n-A-NAME to n-filter-A-NAME
           move A-PASS-DATE to filter-A-PASS-DATE
           move n-A-PASS-DATE to n-filter-A-PASS-DATE
           move A-NBR-TRIES to filter-A-NBR-TRIES
           move n-A-NBR-TRIES to n-filter-A-NBR-TRIES
           move A-LOCK-DATE to filter-A-LOCK-DATE
           move n-A-LOCK-DATE to n-filter-A-LOCK-DATE
           move A-LAST-EVENT to filter-A-LAST-EVENT
           move n-A-LAST-EVENT to n-filter-A-LAST-EVENT
           move A-NBR-SIGNON to filter-A-NBR-SIGNON
           move n-A-NBR-SIGNON to n-filter-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       save-first section.

           *> Save current field values for future use
           move A-ID to first-A-ID
           move A-ID-DO-LAST to first-A-ID-DO-LAST
           move n-A-ID-DO-LAST to n-first-A-ID-DO-LAST
           move A-SHORTNAME to first-A-SHORTNAME
           move A-NAME to first-A-NAME
           move n-A-NAME to n-first-A-NAME
           move A-PASS-DATE to first-A-PASS-DATE
           move n-A-PASS-DATE to n-first-A-PASS-DATE
           move A-NBR-TRIES to first-A-NBR-TRIES
           move n-A-NBR-TRIES to n-first-A-NBR-TRIES
           move A-LOCK-DATE to first-A-LOCK-DATE
           move n-A-LOCK-DATE to n-first-A-LOCK-DATE
           move A-LAST-EVENT to first-A-LAST-EVENT
           move n-A-LAST-EVENT to n-first-A-LAST-EVENT
           move A-NBR-SIGNON to first-A-NBR-SIGNON
           move n-A-NBR-SIGNON to n-first-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       restore-first section.

           *> Restore the 1st row output last time in table view,
           *> or last row output in form view
           move first-A-ID to A-ID
           move first-A-ID-DO-LAST to A-ID-DO-LAST
           move n-first-A-ID-DO-LAST to n-A-ID-DO-LAST
           move first-A-SHORTNAME to A-SHORTNAME
           move first-A-NAME to A-NAME
           move n-first-A-NAME to n-A-NAME
           move first-A-PASS-DATE to A-PASS-DATE
           move n-first-A-PASS-DATE to n-A-PASS-DATE
           move first-A-NBR-TRIES to A-NBR-TRIES
           move n-first-A-NBR-TRIES to n-A-NBR-TRIES
           move first-A-LOCK-DATE to A-LOCK-DATE
           move n-first-A-LOCK-DATE to n-A-LOCK-DATE
           move first-A-LAST-EVENT to A-LAST-EVENT
           move n-first-A-LAST-EVENT to n-A-LAST-EVENT
           move first-A-NBR-SIGNON to A-NBR-SIGNON
           move n-first-A-NBR-SIGNON to n-A-NBR-SIGNON
           exit.

      *>----------------------------------------------------------------
       save-state section.

           *> Save state for next call, initialising the state file
           *> if this is the first call of the session
           move order-field to s-order-field
           perform save-first
           move length of client-state to client-length
           move frmehstate to client-id
           if client-id = spaces
               call "MF_CLIENT_STATE_ALLOCATE"
                   using client-id client-length state-status
               move client-id to frmehstate
           end-if
           call "MF_CLIENT_STATE_SAVE"
               using client-id client-state client-length state-status
           exit.

      *>----------------------------------------------------------------
       restore-state section.

           *> Resore state from last call, if there was a last call
           move frmehstate to client-id
           if client-id not = spaces
               move length of client-state to client-length
               call "MF_CLIENT_STATE_RESTORE"
                   using client-id client-state client-length
                       state-status
           end-if
           exit.

      *>----------------------------------------------------------------
       setup-controls section.

           *> Set up data for HTML Select controls
           move "ID" to OrderBy(001)
           move "ID_DO_LAST" to OrderBy(002)
           move "SHORTNAME" to OrderBy(003)
           move "NAME" to OrderBy(004)
           move "PASS_DATE" to OrderBy(005)
           move "NBR_TRIES" to OrderBy(006)
           move "LOCK_DATE" to OrderBy(007)
           move "LAST_EVENT" to OrderBy(008)
           move "NBR_SIGNON" to OrderBy(009)
           move 009 to c-OrderBy

           evaluate order-field
             when spaces
             when "A.ID"
               move 1 to i-OrderBy(001)
             when "A.ID_DO_LAST"
               move 1 to i-OrderBy(002)
             when "A.SHORTNAME"
               move 1 to i-OrderBy(003)
             when "A.NAME"
               move 1 to i-OrderBy(004)
             when "A.PASS_DATE"
               move 1 to i-OrderBy(005)
             when "A.NBR_TRIES"
               move 1 to i-OrderBy(006)
             when "A.LOCK_DATE"
               move 1 to i-OrderBy(007)
             when "A.LAST_EVENT"
               move 1 to i-OrderBy(008)
             when "A.NBR_SIGNON"
               move 1 to i-OrderBy(009)
           end-evaluate

           move "(none)" to FilterBy(001)
           move "(existing)" to FilterBy(002)
           move "ID" to FilterBy(003)
           move "ID_DO_LAST" to FilterBy(004)
           move "SHORTNAME" to FilterBy(005)
           move "NAME" to FilterBy(006)
           move "PASS_DATE" to FilterBy(007)
           move "NBR_TRIES" to FilterBy(008)
           move "LOCK_DATE" to FilterBy(009)
           move "LAST_EVENT" to FilterBy(010)
           move "NBR_SIGNON" to FilterBy(011)
           move 011 to c-FilterBy

           if s-filter-field = spaces or "(none)"
               move 1 to i-FilterBy(1)
           else
               move 1 to i-FilterBy(2)
           end-if

           move 6 to c-FilterType
           move "<" to FilterType(1)
           move "<=" to FilterType(2)
           move "=" to FilterType(3)
           move "!=" to FilterType(4)
           move ">=" to FilterType(5)
           move ">" to FilterType(6)

           evaluate s-filter-op
               when "<"
                   move 1 to i-FilterType(1)
               when "<="
                   move 1 to i-FilterType(2)
               when spaces
               when "="
                   move 1 to i-FilterType(3)
               when "<>"
                   move 1 to i-FilterType(4)
               when  ">="
                   move 1 to i-FilterType(5)
               when  ">"
                   move 1 to i-FilterType(6)
           end-evaluate
           perform setup-status
           exit.

      *>----------------------------------------------------------------
       setup-status section.

           *> Setup status line
           if frmesStatus not = spaces
               exit section
           end-if

           if s-filter-field not = '(none)'
               if s-filter-op = '<>'
                   move '!=' to s-filter-op
               end-if

               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", filtering on " delimited size
                   s-filter-field(3:) delimited space
                   " " delimited size
                   s-filter-op delimited size
                  " " delimited size
                   s-filter-value delimited x"0"
               into frmesStatus pointer stat-index

               if s-filter-op = '!='
                   move '<>' to s-filter-op
               end-if

           else
               move spaces to frmesStatus
               string
                   "Ordering by " delimited size
                  order-field(3:) delimited space
                   ", with no filtering " delimited size
               into frmesStatus pointer stat-index
           end-if
           exit.

      *>----------------------------------------------------------------
       translate-combos section.

           *> Pre-process data returned by HTML Select controls
           evaluate OrderBy(1)
             when "ID"
               move "A.ID" to OrderBy(1)
             when "ID_DO_LAST"
               move "A.ID_DO_LAST" to OrderBy(1)
             when "SHORTNAME"
               move "A.SHORTNAME" to OrderBy(1)
             when "NAME"
               move "A.NAME" to OrderBy(1)
             when "PASS_DATE"
               move "A.PASS_DATE" to OrderBy(1)
             when "NBR_TRIES"
               move "A.NBR_TRIES" to OrderBy(1)
             when "LOCK_DATE"
               move "A.LOCK_DATE" to OrderBy(1)
             when "LAST_EVENT"
               move "A.LAST_EVENT" to OrderBy(1)
             when "NBR_SIGNON"
               move "A.NBR_SIGNON" to OrderBy(1)
           end-evaluate

           evaluate FilterBy(1)
             when "ID"
               move "A.ID" to FilterBy(1)
             when "ID_DO_LAST"
               move "A.ID_DO_LAST" to FilterBy(1)
             when "SHORTNAME"
               move "A.SHORTNAME" to FilterBy(1)
             when "NAME"
               move "A.NAME" to FilterBy(1)
             when "PASS_DATE"
               move "A.PASS_DATE" to FilterBy(1)
             when "NBR_TRIES"
               move "A.NBR_TRIES" to FilterBy(1)
             when "LOCK_DATE"
               move "A.LOCK_DATE" to FilterBy(1)
             when "LAST_EVENT"
               move "A.LAST_EVENT" to FilterBy(1)
             when "NBR_SIGNON"
               move "A.NBR_SIGNON" to FilterBy(1)
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       compare-to-first section.

           *> Compare current order field values with the
           *> corresponding 'first-' values
           move order-field to field-name
           perform compare-field-to-first
           move order-status to find-status
           if not IsEqual
               exit section
           end-if

           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               if field-name = order-field
                   exit perform cycle
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-key-to-first section.

           *> Compare current primary key field values with the
           *> corresponding 'first-' values
           move PrimaryKeyColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-updatable-to-first section.

           *> Compare current updateable field values with the
           *> corresponding 'first-' values
           move UpdateColumns to temp
           move 1 to temp-index
           perform until exit
               unstring temp delimited by '#' into field-name
                   pointer temp-index
               if field-name = spaces
                   exit perform
               end-if
               perform compare-field-to-first
               if not IsEqual
                   exit perform
               end-if
           end-perform
           exit.

      *>----------------------------------------------------------------
       compare-field-to-first section.

           *> Compare the field (whose name is in field-name)
           *> with the corresponding 'first-' value
           evaluate field-name
               when "A.ID"
                 if A-ID > first-A-ID
                   set IsGreater to true
                 else
                   if A-ID < first-A-ID
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.ID_DO_LAST"
                 if A-ID-DO-LAST > first-A-ID-DO-LAST
                   set IsGreater to true
                 else
                   if A-ID-DO-LAST < first-A-ID-DO-LAST
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.SHORTNAME"
                 if A-SHORTNAME > first-A-SHORTNAME
                   set IsGreater to true
                 else
                   if A-SHORTNAME < first-A-SHORTNAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NAME"
                 if A-NAME > first-A-NAME
                   set IsGreater to true
                 else
                   if A-NAME < first-A-NAME
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.PASS_DATE"
                 if A-PASS-DATE > first-A-PASS-DATE
                   set IsGreater to true
                 else
                   if A-PASS-DATE < first-A-PASS-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_TRIES"
                 if A-NBR-TRIES > first-A-NBR-TRIES
                   set IsGreater to true
                 else
                   if A-NBR-TRIES < first-A-NBR-TRIES
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LOCK_DATE"
                 if A-LOCK-DATE > first-A-LOCK-DATE
                   set IsGreater to true
                 else
                   if A-LOCK-DATE < first-A-LOCK-DATE
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.LAST_EVENT"
                 if A-LAST-EVENT > first-A-LAST-EVENT
                   set IsGreater to true
                 else
                   if A-LAST-EVENT < first-A-LAST-EVENT
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
               when "A.NBR_SIGNON"
                 if A-NBR-SIGNON > first-A-NBR-SIGNON
                   set IsGreater to true
                 else
                   if A-NBR-SIGNON < first-A-NBR-SIGNON
                     set IsLess to true
                   else
                     set IsEqual to true
                   end-if
                 end-if
           end-evaluate
           exit.

      *>----------------------------------------------------------------
       process-form-input-data section.
           *> Accept the CGI input from the Browser, and check for
           *> errors
           perform browser-initialize
           accept htmlform
           exit.

      *>----------------------------------------------------------------
       convert-input section.
           perform input-conversion
           *> field validation
           if Action = "Modifier" then
               if A-SHORTNAME = spaces
                   move "A_SHORTNAME" to v-first-bad
                   perform output-form-error-and-stop
               end-if

           end-if

           if v-all-ok = 0
               inspect v-first-bad replacing all "-" by "_"
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.
           *> The input conversion routines detected errors so
           *> display a message and stop
           perform setup-controls
           perform combo
           evaluate v-first-bad
           when "A_ID"
             move "Id." to frmesStatus
           when "A_SHORTNAME"
             move "Shortname." to frmesStatus
           when other
               string v-first-bad delimited by space
                      "."
               into frmesStatus
           end-evaluate

           if v-all-ok = 0
               string frmesStatus delimited by "."
               " is a numeric field and has an invalid value."
               into frmesStatus
           else
               string frmesStatus delimited by "."
               " is a required field."
               into frmesStatus
           end-if
           perform USADform-cvt
           perform USADform-out
           exec HTML
                <SCRIPT>
                document.DataForm.:v-first-bad .focus();
                alert(":frmesStatus");
                </SCRIPT>
           end-exec

           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "USADform.cpv".
      *>----------------------------------------------------------------
