      $set ibmcomp preprocess(htmlpp) endp
      *> Add a 'stephtml' directive to the line above to step through
      *> HMTL source when animating. It should then look like the
      *> following line (apart from the comment mark '*>' )
      *>$set ibmcomp preprocess(htmlpp) stephtml endp

      *>****************************************************************
       identification division.
      *>****************************************************************
           program-id. "clientt-server1".
            *> clientt_server1

      *>****************************************************************
       environment division.
      *>****************************************************************

      *> The call convention below is used to force numeric conversion
      *> routines to be linked into the server-side application
      *> without use of the litlink compiler directive. This retains
      *> the flexibility for other routine which may be called by the
      *> server-side application to be either statically or
      *> dynamically linked at the developer's discretion.

       configuration section.
       special-names.
           call-convention 8 is llnk.
       input-output section.
       file-control.

      *>****************************************************************
       data division.
      *>****************************************************************
       file section.
       working-storage section.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items representing controls on
      *> your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "clientt_server1.cpf".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains data items to be used in your
      *> business logic.
      *> These will be regenerated after every Form Designer Save.
           copy "clientt_server1.cpy".
      *>----------------------------------------------------------------

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains parameter data for the called
      *> application
      *> This will be regenerated after every Form Designer Save.
           copy "clientt_server1.cpl".
      *>----------------------------------------------------------------


      *> Enter additional working-storage items here

       local-storage section.
       linkage section.

      *>****************************************************************
       Procedure Division.
      *>****************************************************************
       main section.

           perform process-form-input-data
           perform convert-input
           if MF-SERVER-EXEC = "yes"
               perform process-business-logic
           else
      *>       Output initial empty form - this can be removed if the
      *>       application uses separate input and output forms
               perform clientt-input1-cvt
                  *> clientt_input1
               perform clientt-input1-out
                  *> clientt_input1
           end-if

           exit program
           stop run.

      *>----------------------------------------------------------------
       process-business-logic section.

      *> Add pre-call application business logic here

           CALL "ClientT" USING
             WL-IO-Liens
           ON EXCEPTION
             PERFORM handle-call-exception
           END-CALL

      *> Add post-call application business logic here

           perform clientt-input1-cvt
              *> clientt_input1
           perform clientt-input1-out
              *> clientt_input1
           exit.

      *>----------------------------------------------------------------
       handle-call-exception section.

           *> Deal with an exception when calling the application
           exec html
               The requested application program could not be found
           end-exec
           exit program
           stop run.

      *>----------------------------------------------------------------
       process-form-input-data section.

           *> Accept the input from the Browser, and check for errors
           perform browser-initialize
           accept htmlform
           exit.

      *>----------------------------------------------------------------
       convert-input section.

           *> Convert numeric input values
           perform input-conversion

           *> Add additional validation here

           if v-all-ok = 0
               perform output-form-error-and-stop
           end-if
           exit.

      *>----------------------------------------------------------------
       output-form-error-and-stop section.

           *> The input conversion routines detected errors so
           *> display a message and stop
           exec html
               :v-first-bad is a numeric field and
               contains an invalid or out of range value,
               please enter a valid value
           end-exec
           exit program
           stop run.

      *>----------------------------------------------------------------
      *> WARNING: Do not remove this copy statement or modify the
      *> contents of the copy file.
      *> This copy file contains output and data conversion routines
      *> for controls on your forms.
      *> These will be regenerated after every Form Designer Save.
           copy "clientt_server1.cpv".
      *>----------------------------------------------------------------
       END PROGRAM "clientt-server1".
        *> clientt_server1
