       special-names.
           call-convention 8 is CICS.   *> Utilis pour forcer le static
                                        *> linking des CICS ECI routines

       working-storage section.
       01  program-identity       pic x(13)    value "ControlModule".

       01  ws-cicslist-params.
           03  ws-namespace       usage is pointer.
           03  ws-systems         PIC 9(4) COMP-5  VALUE 16.

       01  ws-eci-call-params.
           03  ws-cics-system     pic x(8)     value spaces.

       01 ws-error-display.
           03  ws-disp-rc         pic ZZZ9-.
           03  ws-abend-code      pic x(4)     value spaces.

       01  wx-sub1                pic 9(4)     comp-5 value 0.
       01  DataLocation           pic x(15)    value "MAINFRAME".

      *COPY CICSECI.

       linkage section.

           copy "Client.cpy".

           copy "CTLnk.cpy" replacing ==:TAG:== by ==WL-==.

       procedure division using FormFields
                                WL-IO-Liens.
       Principale section.

           perform a-debut

           perform b-milieu

           perform c-fin

           goback
           .

       a-debut section.

      *    Initialiser les liens

           initialize TextMessage
                      WL-IO-Liens
           .

       b-milieu section.

           evaluate ssubmit
               when "A"
                   perform ajouter-client
               when "S"
                   perform supprimer-client
               when "M"
                   perform modifier-client
               when "L"
                   perform lire-client
           end-evaluate
           .

       ajouter-client section.

           perform move-de-form-a-record
           set wl-ajout-cl to true
           perform call-sync-cics-eci
           move "Client ajout" to TextMessage
           .

       supprimer-client section.

           perform move-de-form-a-record
           set wl-supp-cl to true
           perform call-sync-cics-eci
           if wl-rien then
               move "Client non trouv"      to TextMessage
           else
               move "Client supprim"        to TextMessage
           end-if
           .

       modifier-client section.

           perform move-de-form-a-record
           set wl-modif-cl to true
           perform call-sync-cics-eci
           move "Client modifi"             to TextMessage
           .

       lire-client section.

           perform move-de-form-a-record
           set wl-lire-cl to true
           perform call-sync-cics-eci
           if wl-rien then
               move "Client non trouv"      to TextMessage
           else
               perform move-de-record-a-form
           end-if
           .

       c-fin section.

           .

       move-de-form-a-record section.

           move EFClNumero         to wl-cl-numero
           move EFClNom            to wl-cl-nom
           move EFClAdresse        to wl-cl-adresse
           move EFClTel            to wl-cl-tel
           move EFClDate           to wl-cl-date
           move EFClMontant        to wl-cl-montant
           move CBClStatut         to wl-cl-statut
           move EFClCommentaire    to wl-cl-commentaire
           .

       move-de-record-a-form section.

           move wl-cl-numero       to EFClNumero
           move wl-cl-nom          to EFClNom
           move wl-cl-adresse      to EFClAdresse
           move wl-cl-tel          to EFClTel
           move wl-cl-date         to EFClDate
           move wl-cl-montant      to EFClMontant
           move wl-cl-statut       to CBClStatut
           move wl-cl-commentaire  to EFClCommentaire
           .


      *-----------------------------------------------------------------
      * Les API CICS avec appels ECI Asynchrones
      *
      * Les appels asynchrones n'attendent pas que la requte CICS
      * soit competement termin avant de retourner au program appelant
      *-----------------------------------------------------------------
       call-async-cics-eci section.

      *    Dabord obtenir la liste des systmes CICS disponibles

           set ws-namespace to null.
           call CICS 'CICSEciListSystems'
               using by reference ws-namespace
                     by reference ws-systems
                     by reference CICS-ECISYSTEM
               returning ECI-ERROR-ID
           end-call
           perform eci-check-status

      *    Recherche du systme CICS  appeler. Le nom du systme et
      *    sa description sont normallement dfini dans le fichier
      *    CICSCLI.INI du sous-rpertoire BIN.
      *    (Pour cette demo; Serveur = CICSESA Description = MAINFRAME)


           perform varying wx-sub1 from 1 by 1
                                   until wx-sub1 > ws-systems
               if DataLocation(1:4) = SYSTEMDESC(wx-sub1)(1:4)
                   move SYSTEMNAME(wx-sub1) to ws-cics-system
                   exit perform
               end-if
           end-perform

      *    Initialiser le block de paramtres ECI et la commarea

           move low-values to eci-parms
      *
           set  eci-async           to true
           move "CLIENTT"           to eci-program-name
           move ws-cics-system      to eci-system-name
           set  eci-commarea        to address of wl-IO-Liens
           move length of wl-datahand-commarea
                                    to eci-commarea-length
           move 0                   to eci-timeout
           set  eci-no-extend       to true
           set  eci-version-1       to true

      *    Excution de l'appel ECI asynchrone

           call  cics 'cicsexternalcall'
                 using by reference eci-parms
                 returning ECI-ERROR-ID
           end-call
           perform eci-check-status

      *    A ce stade, le systme mainframe est en train d'excuter la
      *    requte.
      *
      *    On pourrait ici excuter paralllement d'autres tches
      *    tel qu'une requte sur une base de donnes locale ou autres
      *    platteforme
      *
           ......
           ......

      *    Maintenant retrouver le rsultat de la requte ECI

           move low-values to eci-parms
           set  eci-get-reply-wait  to true
           move "CLIENTT"           to eci-program-name
           move ws-cics-system      to eci-system-name
           set  eci-commarea        to address of wl-IO-Liens
           move length of wl-IO-Liens
                                    to eci-commarea-length
           move 0                   to eci-timeout
           set  eci-no-extend       to true
           set  eci-version-1       to true

           call  cics 'CICSExternalCall'
                       using by reference eci-parms
                       returning ECI-ERROR-ID
           end-call
           perform eci-check-status

      *    message erreur retourn

           if wl-erreur then
               move wl-message-erreur to TextMessage
               goback
           end-if
           .

      *-----------------------------------------------------------------
      * Les API CICS avec appels ECI synchrones
      *
      * Les appels synchrones attendent que la transaction soit
      * termine avant de retourner au program appelant
      *-----------------------------------------------------------------
       call-sync-cics-eci section.

      *    Dabord obtenir la liste des systmes CICS disponibles

           set ws-namespace to null.
           call CICS 'CICSEciListSystems'
               using by reference ws-namespace
                     by reference ws-systems
                     by reference CICS-ECISYSTEM
               returning ECI-ERROR-ID
           end-call
           perform eci-check-status


      *    Recherche du systme CICS  appeler. Le nom du systme et
      *    sa description sont normallement dfini dans le fichier
      *    CICSCLI.INI du sous-rpertoire BIN.
      *    (Pour cette demo; Serveur = CICSESA Description = MAINFRAME)


           perform varying wx-sub1 from 1 by 1
                                   until wx-sub1 > ws-systems
               if DataLocation(1:4) = SYSTEMDESC(wx-sub1)(1:4)
                   move SYSTEMNAME(wx-sub1) to ws-cics-system
                   exit perform
               end-if
           end-perform

           move low-values to eci-parms
      *
           set  eci-sync            to true
           move "CLIENTT"           to eci-program-name
           move ws-cics-system      to eci-system-name
           set  eci-commarea        to address of wl-datahand-commarea
           move length of wl-datahand-commarea
                                    to eci-commarea-length
           move 0                   to eci-timeout
           set  eci-no-extend       to true
           set  eci-version-1       to true

      *    appel synchrone

           call  cics 'cicsexternalcall'
                 using by reference eci-parms
                 returning ECI-ERROR-ID
           end-call
           perform eci-check-status

      *    message erreur retourn

           if wl-erreur then
               move wl-message-erreur to TextMessage
               goback
           end-if
           .

      *-----------------------------------------------------------------
      *    Contrle du status de l'appel ECI.
      *-----------------------------------------------------------------
       eci-check-status section.

           if not ECI-NO-ERROR
               move ECI-ERROR-ID   to ws-disp-rc
               if ECI-ABEND-CODE = SPACES OR LOW-VALUES
                   continue
               else
                   move eci-abend-code to ws-abend-code
               end-if
               string "ECI Error = "
                      ws-disp-rc
                      " , Abend Code = "
                      ws-abend-code delimited by size
                   into TextMessage
               end-string
               goback
           end-if
           .
