// Product.cpp : Implementation of CProduct
#include "stdafx.h"
#include "DataAccess.h"
#include "Product.h"

/////////////////////////////////////////////////////////////////////////////
// CProduct

#define CHECK_OUT_PARAM(p) \
   if (p == NULL) return E_POINTER; 

STDMETHODIMP CProduct::get_ProductID(long *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_lProdID;
   return S_OK;
}

STDMETHODIMP CProduct::put_ProductID(long newVal)
{
   m_lProdID = newVal;
   return S_OK;
}

STDMETHODIMP CProduct::get_Description(BSTR *pVal)
{
   CHECK_OUT_PARAM(pVal);
   return m_bstrDesc.CopyTo(pVal);
}

STDMETHODIMP CProduct::put_Description(BSTR newVal)
{
   m_bstrDesc = newVal;
   return S_OK;
}

STDMETHODIMP CProduct::get_UnitCost(CURRENCY *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_cyUnitCost;
   return S_OK;
}

STDMETHODIMP CProduct::put_UnitCost(CURRENCY newVal)
{
   m_cyUnitCost = newVal;
   return S_OK;
}

void CProduct::Initialize(long lProdID, LPCTSTR strDesc, double dUnitCost)
{
   m_lProdID = lProdID;
   m_bstrDesc = strDesc;
   VarCyFromR8(dUnitCost, &m_cyUnitCost);
}
