// VCTest.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#import "..\..\DataAccess\DataAccess.tlb" no_namespace

void PrintValues(IEnumVARIANT* pEnum)
{
   _variant_t varArray[5];
   ULONG ulFetched = 1;

   pEnum->Reset();

   while (ulFetched > 0)
   {
      pEnum->Next(5, varArray, &ulFetched);
      for (ULONG ul = 0; ul < ulFetched; ul++)
      {
         IProductPtr pProd;
         pProd = varArray[ul].pdispVal;
         _bstr_t bstrDesc = pProd->Description;
         CURRENCY cyCost = pProd->UnitCost;
         double dCost;
         VarR8FromCy(cyCost, &dCost);
         printf("%ld\t%S\t$%.2lf\n", pProd->ProductID, (LPWSTR)bstrDesc, dCost);
         varArray[ul].Clear();
      }
   }
}

int main(int argc, char* argv[])
{
   CoInitialize(NULL);

   try
   {
      IProductsPtr pColl(__uuidof(Products));
      IEnumVARIANTPtr pEnum;

      pEnum = pColl->_NewEnum;

      printf("Initial contents\n");
      PrintValues(pEnum);

      IProductPtr pProd(__uuidof(Product));
      _bstr_t bstrDesc(L"Coat");
      pProd->ProductID = 4;
      pProd->Description = bstrDesc;
      CURRENCY cyCost;
      VarCyFromR8(50.00, &cyCost);
      pProd->UnitCost = cyCost;

      IDispatchPtr pDisp = pProd;
      _variant_t var((IDispatch*)pDisp);
      
      //add new product
      pColl->Add(var);
      //remove first item
      pColl->Remove(1);

      printf("New contents\n");
      PrintValues(pEnum);
   }
   catch(_com_error e)
   {
      printf("Error %s (0x%08x)\n");
   }

   CoUninitialize();
   return 0;
}

