// Product.h : Declaration of the CProduct

#ifndef __PRODUCT_H_
#define __PRODUCT_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CProduct
class ATL_NO_VTABLE CProduct : 
	public CComObjectRootEx<CComSingleThreadModel>,
// the object is noncreatable
//	public CComCoClass<CProduct, &CLSID_Product>,
	public IDispatchImpl<IProduct, &IID_IProduct, &LIBID_DATAACCESSLib>
{
public:
	CProduct()
	{
      m_lProdID = -1;
      VarCyFromI4(0, &m_cyUnitCost);
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PRODUCT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

DECLARE_NOT_AGGREGATABLE(CProduct)

BEGIN_COM_MAP(CProduct)
	COM_INTERFACE_ENTRY(IProduct)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

BEGIN_CATEGORY_MAP(CProduct)
END_CATEGORY_MAP()

// IProduct
public:
	void Initialize(long lProdID, LPCTSTR strDesc, double dUnitCost);
	STDMETHOD(get_UnitCost)(/*[out, retval]*/ CURRENCY *pVal);
	STDMETHOD(get_Description)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_ProductID)(/*[out, retval]*/ long *pVal);
private:
   long m_lProdID;
   CComBSTR m_bstrDesc;
   CURRENCY m_cyUnitCost;
};

#endif //__PRODUCT_H_
