// Events.h : Declaration of the CEvents

#ifndef __EVENTS_H_
#define __EVENTS_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CEvents
class ATL_NO_VTABLE CEvents : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CEvents, &CLSID_Events>,
	public IDispatchImpl<IEvents, &IID_IEvents, &LIBID_EVENTLOGGERLib>
{
public:
	CEvents()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_EVENTS)
DECLARE_CLASSFACTORY_SINGLETON(CEvents)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CEvents)
	COM_INTERFACE_ENTRY(IEvents)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

   HRESULT FinalConstruct()
   {
      HRESULT hr;
      hr = StgOpenStorage(L"Data.dat", NULL, STGM_READWRITE | STGM_SHARE_DENY_WRITE | STGM_TRANSACTED, NULL, 0, &m_pStg);
      if (FAILED(hr))
      {
         hr = StgCreateDocfile(L"Data.dat", STGM_READWRITE | STGM_SHARE_DENY_WRITE | STGM_TRANSACTED, 0, &m_pStg);
         if (FAILED(hr))
            return hr;
      }
      hr = m_pStg->OpenStream(L"CurrentRecord", NULL, STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, &m_pStm);
      if (FAILED(hr))
      {
         hr = m_pStg->CreateStream(L"CurrentRecord", STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, 0, &m_pStm);
         if (FAILED(hr))
            return hr;
         ULONG count = 0;
         m_pStm->Write(&count, sizeof(ULONG), NULL);
      }
      m_pStg->Commit(STGC_DEFAULT);
      return S_OK;
   }

// IEvents
public:
	STDMETHOD(get__NewEnum)(/*[out, retval]*/ LPUNKNOWN *pVal);
	STDMETHOD(Add)(/*[in]*/ BSTR bstrMsg, /*[in]*/ long lSeverity);
private:
   CComPtr<IStorage> m_pStg;
   CComPtr<IStream> m_pStm;
};

#endif //__EVENTS_H_
