// EnumEvents.cpp : Implementation of CEnumEvents
#include "stdafx.h"
#include "EventLogger.h"
#include "EnumEvents.h"
#include "Event.h"

/////////////////////////////////////////////////////////////////////////////
// CEnumEvents

STDMETHODIMP CEnumEvents::Next(ULONG celt, VARIANT* rgVar, ULONG* pCeltFetched)
{
   if (rgVar == NULL || (celt != 1 && pCeltFetched == NULL))
      return E_POINTER;
   //get total in file
   LARGE_INTEGER li;
   li.LowPart = 0;
   li.HighPart = 0;
   ULONG ulRecMax;

   g_csCount.Lock();
   m_pStm->Seek(li, STREAM_SEEK_SET, NULL);
   m_pStm->Read(&ulRecMax, sizeof(ULONG), NULL);
   g_csCount.Unlock();

   ULONG nRem = ulRecMax - m_ulRecPos;
   HRESULT hr = S_OK;
   if (nRem < celt)
      hr = S_FALSE;

   ULONG nMin = min(celt, nRem);
   if (pCeltFetched != NULL)
      *pCeltFetched = nMin;

   VARIANT* pelt = rgVar;
   for (ULONG pos = 0; pos < nMin; pos++)
   {
      //get the data
      CComPtr<IStream> pStm;
      WCHAR strName[20];
      swprintf(strName, L"%ld", pos + m_ulRecPos);
      CComVariant varDate;
      CComVariant varMsg;
      CComVariant varSev;

      g_csData.Lock();
      hr = m_pStg->OpenStream(strName, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE, 0, &pStm);
      if (SUCCEEDED(hr))
      {
         varDate.ReadFromStream(pStm);
         varMsg.ReadFromStream(pStm);
         varSev.ReadFromStream(pStm);
         g_csData.Unlock();
      }
      else
      {
         g_csData.Unlock();
         while (rgVar < pelt)
            VariantClear(rgVar++);
         if (pCeltFetched != NULL)
            *pCeltFetched = 0;
         return hr;
      }

      CComObject<CEvent>* pObj;
      CComObject<CEvent>::CreateInstance(&pObj);
      pObj->Initialize(varDate.date, varMsg.bstrVal, varSev.lVal);
      IDispatch* pDisp;
      pObj->QueryInterface(&pDisp);
      pelt->pdispVal = pDisp;
      pelt->vt = VT_DISPATCH;
      pelt++;
   }
   m_ulRecPos += *pCeltFetched;
   return hr;
}

STDMETHODIMP CEnumEvents::Skip(ULONG celt)
{
   //get the record count
   LARGE_INTEGER li;
   li.LowPart = 0;
   li.HighPart = 0;
   ULONG ulRec;

   g_csCount.Lock();
   m_pStm->Seek(li, STREAM_SEEK_SET, NULL);
   m_pStm->Read(&ulRec, sizeof(ULONG), NULL);
   g_csCount.Unlock();

   if (m_ulRecPos + celt <= ulRec)
   {
      m_ulRecPos += celt;
      return S_OK;
   }
   m_ulRecPos = ulRec;
   return S_FALSE;
}

STDMETHODIMP CEnumEvents::Reset()
{
   m_ulRecPos = 0;
   return S_OK;
}

STDMETHODIMP CEnumEvents::Clone(IEnumVARIANT** ppEnum)
{
   HRESULT hr;
   CComObject<CEnumEvents>* pObj;
   CComObject<CEnumEvents>::CreateInstance(&pObj);
   pObj->m_ulRecPos = m_ulRecPos;
   pObj->m_pStg = m_pStg;
   pObj->m_pStm = m_pStm;
   hr = pObj->QueryInterface(ppEnum);
   if (FAILED(hr))
   {
      delete pObj;
      *ppEnum = NULL;
   }
   return hr;
}

