// LoggedEvent.h : Declaration of the CLoggedEvent

#ifndef __LOGGEDEVENT_H_
#define __LOGGEDEVENT_H_

#include "resource.h"       // main symbols
#import "..\EventLogger\EventLogger.tlb" no_namespace, no_implementation, named_guids

/////////////////////////////////////////////////////////////////////////////
// CLoggedEvent
class ATL_NO_VTABLE CLoggedEvent : 
	public CComObjectRootEx<CComMultiThreadModel>,
// object is noncreatable
// public CComCoClass<CLoggedEvent, &CLSID_LoggedEvent>,
// public ILoggedEvent
	public IUnknown,
    public IDispEventImpl<99, CLoggedEvent, &DIID_DLoggerEvents, &LIBID_EVENTLOGGERLib, 1, 0>
{
public:
   CLoggedEvent() : m_pEvents(NULL), m_pListbox(NULL)
	{
	}

DECLARE_NO_REGISTRY()

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CLoggedEvent)
//	COM_INTERFACE_ENTRY(ILoggedEvent)
	COM_INTERFACE_ENTRY(IUnknown)
END_COM_MAP()

BEGIN_SINK_MAP(CLoggedEvent)
   SINK_ENTRY_EX(99, DIID_DLoggerEvents, 1, OnNewEvent)
END_SINK_MAP()

public:
   void __stdcall OnNewEvent(long lEventID)
   {
      CComPtr<IEvent> pEvent;
      if (SUCCEEDED(m_pEvents->raw_Item(lEventID, &pEvent)))
      {
         DATE dDate;
         pEvent->get_Date(&dDate);

         CComBSTR bstrDesc;
         pEvent->get_Message(&bstrDesc);

         long lSeverity;
         pEvent->get_Severity(&lSeverity);

         SYSTEMTIME st;
         VariantTimeToSystemTime(dDate, &st);

         CString str;
         str.Format(_T("%04d-%02d-%02d %02d:%02d:%02d %S "),
            st.wYear, st.wMonth, st.wDay, 
            st.wHour, st.wMinute, st.wSecond,
            bstrDesc.m_str);
         if (lSeverity == 0)
            str += _T("Info");
         else
            str += _T("Error");

         m_pListbox->AddString(str);
      }
   }
   void Initialize(IEvents* pEvent, CListBox* pListbox)
   {
      m_pEvents = pEvent;
      m_pListbox = pListbox;
   }
private:
   CComPtr<IEvents> m_pEvents;
   CListBox* m_pListbox;
};

#endif //__LOGGEDEVENT_H_
