// Product.cpp : Implementation of CProduct
#include "stdafx.h"
#include "DataAccess.h"
#include "Product.h"

/////////////////////////////////////////////////////////////////////////////
// CProduct

#define CHECK_OUT_PARAM(p) \
   if (p == NULL) \
      return AtlReportError(CLSID_Product, _T("out pointer is invalid"), IID_IProduct, E_POINTER); 

STDMETHODIMP CProduct::get_ProductID(long *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_lProdID;
   return S_OK;
}

STDMETHODIMP CProduct::get_Description(BSTR *pVal)
{
   CHECK_OUT_PARAM(pVal);
   return m_bstrDesc.CopyTo(pVal);
}

STDMETHODIMP CProduct::get_UnitCost(CURRENCY *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_cyUnitCost;
   return S_OK;
}

void CProduct::Initialize(long lProdID, LPCTSTR strDesc, double dUnitCost)
{
   m_lProdID = lProdID;
   m_bstrDesc = strDesc;
   VarCyFromR8(dUnitCost, &m_cyUnitCost);
}
