// Products.h : Declaration of the CProducts

#ifndef __PRODUCTS_H_
#define __PRODUCTS_H_

#include "resource.h"       // main symbols
#include "product.h"
#include "..\EventLogger\EventLogger.h"
#include "ProductsTable.h"

/////////////////////////////////////////////////////////////////////////////
// CProducts
class ATL_NO_VTABLE CProducts : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CProducts, &CLSID_Products>,
   public ISupportErrorInfo,
	public IDispatchImpl<IProducts, &IID_IProducts, &LIBID_DATAACCESSLib>
{
public:
	CProducts()
	{
	}

   HRESULT FinalConstruct()
   {
      HRESULT hr;
      hr = m_pLogger.CoCreateInstance(__uuidof(Events));
      if (FAILED(hr))
         return hr;
      return hr;
   }

DECLARE_REGISTRY_RESOURCEID(IDR_PRODUCTS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

DECLARE_NOT_AGGREGATABLE(CProducts)

BEGIN_COM_MAP(CProducts)
	COM_INTERFACE_ENTRY(IProducts)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// IProducts
public:
	STDMETHOD(Remove)(long lProdID);
	STDMETHOD(Add)(BSTR strDesc, double dCost, VARIANT* pVar);
	STDMETHOD(get_Item)(long lProdID, VARIANT *pVal);
	STDMETHOD(get__NewEnum)(LPUNKNOWN *pVal);
	STDMETHOD(get_Count)(long *pVal);
// ISupportErrorInfo
public:
   STDMETHOD (InterfaceSupportsErrorInfo)(REFIID riid)
   {
      static const IID* arr[] = 
      {
         &IID_IProducts
      };
      for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
      {
         if (InlineIsEqualGUID(*arr[i],riid))
            return S_OK;
      }
      return S_FALSE;
   }

private:
   CComPtr<IEvents> m_pLogger;
   _CritSec m_cs;
};

#endif //__PRODUCTS_H_
