// ProductsTable.H : Declaration of the CProductsTable class

#ifndef __PRODUCTSTABLE_H_
#define __PRODUCTSTABLE_H_


class COutParamAccessor
{
public:
	LONG m_Param;

BEGIN_COLUMN_MAP(COutParamAccessor)
	COLUMN_ENTRY(1, m_Param)
END_COLUMN_MAP()
};

class CInParamAccessor
{
public:
	LONG m_Param;

BEGIN_PARAM_MAP(CInParamAccessor)
   COLUMN_ENTRY(1, m_Param)
END_PARAM_MAP()
};

class CProductsTableAccessor
{
public:
	TCHAR m_Description[51];
	LONG m_ProductID;
	CURRENCY m_UnitCost;

BEGIN_COLUMN_MAP(CProductsTableAccessor)
	COLUMN_ENTRY(1, m_ProductID)
	COLUMN_ENTRY(2, m_Description)
	COLUMN_ENTRY_TYPE(3, DBTYPE_CY, m_UnitCost)
END_COLUMN_MAP()

BEGIN_PARAM_MAP(CProductsTableAccessor)
   COLUMN_ENTRY(1, m_ProductID)
END_PARAM_MAP()

DEFINE_COMMAND(CProductsTableAccessor, \
	_T("SELECT ProductID, Description, UnitCost FROM Products \
       WHERE ProductID = ?"))

	// You may wish to call this function if you are inserting a record and wish to
	// initialize all the fields, if you are not going to explicitly set all of them.
	void ClearRecord()
	{
		memset(this, 0, sizeof(*this));
	}
};

class CInsertProductsAccessor
{
public:
	TCHAR m_Description[51];
	LONG m_ProductID;
	CURRENCY m_UnitCost;

BEGIN_PARAM_MAP(CInsertProductsAccessor)
	COLUMN_ENTRY(1, m_ProductID)
	COLUMN_ENTRY(2, m_Description)
	COLUMN_ENTRY_TYPE(3, DBTYPE_CY, m_UnitCost)
END_PARAM_MAP()
};


class CProductsTable : public CCommand<CAccessor<CProductsTableAccessor> >
{
public:
	HRESULT Open()
	{
		HRESULT		hr;

		hr = OpenDataSource();
		if (FAILED(hr))
			return hr;

		return OpenRowset();
	}
	HRESULT OpenDataSource()
	{
		HRESULT		hr;
		CDataSource db;
		CDBPropSet	dbinit(DBPROPSET_DBINIT);

		dbinit.AddProperty(DBPROP_AUTH_CACHE_AUTHINFO, true);
		dbinit.AddProperty(DBPROP_AUTH_ENCRYPT_PASSWORD, false);
		dbinit.AddProperty(DBPROP_AUTH_MASK_PASSWORD, false);
		dbinit.AddProperty(DBPROP_AUTH_PASSWORD, OLESTR(""));
		dbinit.AddProperty(DBPROP_AUTH_PERSIST_ENCRYPTED, false);
		dbinit.AddProperty(DBPROP_AUTH_PERSIST_SENSITIVE_AUTHINFO, false);
		dbinit.AddProperty(DBPROP_AUTH_USERID, OLESTR("Admin"));
		dbinit.AddProperty(DBPROP_INIT_DATASOURCE, OLESTR("E:\\Wrox\\ATLProgRef\\Code\\Chapter5\\Products.mdb"));
		dbinit.AddProperty(DBPROP_INIT_MODE, (long)16);
		dbinit.AddProperty(DBPROP_INIT_PROMPT, (short)4);
		dbinit.AddProperty(DBPROP_INIT_PROVIDERSTRING, OLESTR(";COUNTRY=0;CP=1252;LANGID=0x0409"));
		dbinit.AddProperty(DBPROP_INIT_LCID, (long)1033);
		hr = db.Open(_T("Microsoft.Jet.OLEDB.3.51"), &dbinit);

		if (FAILED(hr))
			return hr;

		return m_session.Open(db);
	}
	HRESULT OpenRowset()
	{
		// Set properties for open
		CDBPropSet	propset(DBPROPSET_ROWSET);
		propset.AddProperty(DBPROP_IRowsetChange, true);
		propset.AddProperty(DBPROP_UPDATABILITY, DBPROPVAL_UP_CHANGE | DBPROPVAL_UP_INSERT | DBPROPVAL_UP_DELETE);

		return CCommand<CAccessor<CProductsTableAccessor> >::Open(m_session, NULL, &propset);
	}
	CSession	m_session;
};

#endif // __PRODUCTSTABLE_H_
