// ProductAccess.h : Declaration of the CProductAccess

#ifndef __PRODUCTACCESS_H_
#define __PRODUCTACCESS_H_

#include "resource.h"       // main symbols
#include <atlctl.h>
#include <comcat.h>
#include <AtlControls.h>
using namespace ATLControls;
#include "..\DataAccess\DataAccess.h"
#include "..\EventLogger\EventLogger.h"

/////////////////////////////////////////////////////////////////////////////
// CProductAccess
class ATL_NO_VTABLE CProductAccess : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public IDispatchImpl<IProductAccess, &IID_IProductAccess, &LIBID_CONTROLSLib>,
	public CComCompositeControl<CProductAccess>,
	public IPersistStreamInitImpl<CProductAccess>,
	public IOleControlImpl<CProductAccess>,
	public IOleObjectImpl<CProductAccess>,
	public IOleInPlaceActiveObjectImpl<CProductAccess>,
	public IViewObjectExImpl<CProductAccess>,
	public IOleInPlaceObjectWindowlessImpl<CProductAccess>,
	public IPersistStorageImpl<CProductAccess>,
//	public ISpecifyPropertyPagesImpl<CProductAccess>,
	public IQuickActivateImpl<CProductAccess>,
	public IDataObjectImpl<CProductAccess>,
//	public IProvideClassInfo2Impl<&CLSID_ProductAccess, NULL, &LIBID_CONTROLSLib>,
	public CComCoClass<CProductAccess, &CLSID_ProductAccess>
{
public:
	CProductAccess()
	{
		m_bWindowOnly = TRUE;
		CalcExtent(m_sizeExtent);
      m_bAutoSize = TRUE;
	}

DECLARE_REGISTRY_RESOURCEID(IDR_PRODUCTACCESS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CProductAccess)
	COM_INTERFACE_ENTRY(IProductAccess)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(IViewObjectEx)
	COM_INTERFACE_ENTRY(IViewObject2)
	COM_INTERFACE_ENTRY(IViewObject)
	COM_INTERFACE_ENTRY(IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceObject)
	COM_INTERFACE_ENTRY2(IOleWindow, IOleInPlaceObjectWindowless)
	COM_INTERFACE_ENTRY(IOleInPlaceActiveObject)
	COM_INTERFACE_ENTRY(IOleControl)
	COM_INTERFACE_ENTRY(IOleObject)
	COM_INTERFACE_ENTRY(IPersistStreamInit)
	COM_INTERFACE_ENTRY2(IPersist, IPersistStreamInit)
//	COM_INTERFACE_ENTRY(ISpecifyPropertyPages)
	COM_INTERFACE_ENTRY(IQuickActivate)
	COM_INTERFACE_ENTRY(IPersistStorage)
	COM_INTERFACE_ENTRY(IDataObject)
//	COM_INTERFACE_ENTRY(IProvideClassInfo)
//	COM_INTERFACE_ENTRY(IProvideClassInfo2)
END_COM_MAP()

BEGIN_PROP_MAP(CProductAccess)
	PROP_DATA_ENTRY("_cx", m_sizeExtent.cx, VT_UI4)
	PROP_DATA_ENTRY("_cy", m_sizeExtent.cy, VT_UI4)
	// Example entries
	// PROP_ENTRY("Property Description", dispid, clsid)
	// PROP_PAGE(CLSID_StockColorPage)
END_PROP_MAP()

BEGIN_MSG_MAP(CProductAccess)
	CHAIN_MSG_MAP(CComCompositeControl<CProductAccess>)
	COMMAND_CODE_HANDLER(EN_CHANGE, OnChangeEditBoxes)
	COMMAND_HANDLER(IDC_ITEMS, LBN_SELCHANGE, OnSelChangeItems)
	COMMAND_HANDLER(IDC_ADD, BN_CLICKED, OnClickedAdd)
	COMMAND_HANDLER(IDC_REMOVE, BN_CLICKED, OnClickedRemove)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	COMMAND_HANDLER(IDC_ITEMS, LBN_DBLCLK, OnDblclkItems)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

BEGIN_CATEGORY_MAP(CProductAccess)
   IMPLEMENTED_CATEGORY(CATID_Insertable)
   IMPLEMENTED_CATEGORY(CATID_Control)
END_CATEGORY_MAP()

BEGIN_SINK_MAP(CProductAccess)
	//Make sure the Event Handlers have __stdcall calling convention
END_SINK_MAP()

   HRESULT FinalConstruct();

	STDMETHOD(OnAmbientPropertyChange)(DISPID dispid)
	{
		if (dispid == DISPID_AMBIENT_BACKCOLOR)
		{
			SetBackgroundColorFromAmbient();
			FireViewChange();
		}
		return IOleControlImpl<CProductAccess>::OnAmbientPropertyChange(dispid);
	}

// IViewObjectEx
	DECLARE_VIEW_STATUS(0)

// IProductAccess
public:
	enum { IDD = IDD_PRODUCTACCESS };

	LRESULT OnChangeEditBoxes(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnSelChangeItems(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedAdd(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnClickedRemove(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
	LRESULT OnDblclkItems(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
   HRESULT OnDraw(ATL_DRAWINFO& di)
   {
      return S_OK;
   }
private:
   CComPtr<IProducts> m_pProducts;
   CComPtr<IEvents> m_pLogger;
};

#endif //__PRODUCTACCESS_H_
