// Event.cpp : Implementation of CEvent
#include "stdafx.h"
#include "EventLogger.h"
#include "Event.h"

/////////////////////////////////////////////////////////////////////////////
// CEvent

#define CHECK_OUT_PARAM(p) \
   if (p == NULL) return E_POINTER; 

STDMETHODIMP CEvent::get_Date(DATE *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_dDate;
   return S_OK;
}

STDMETHODIMP CEvent::get_Message(BSTR *pVal)
{
   CHECK_OUT_PARAM(pVal);
   return m_bstrMsg.CopyTo(pVal);
}

STDMETHODIMP CEvent::get_Severity(long *pVal)
{
   CHECK_OUT_PARAM(pVal);
   *pVal = m_lSeverity;
   return S_OK;
}

void CEvent::Initialize(DATE dDate, BSTR bstrMsg, long lSeverity)
{
   m_dDate = dDate;
   m_bstrMsg = bstrMsg;
   m_lSeverity = lSeverity;
}
