// Products.h : Declaration of the CProducts

#ifndef __PRODUCTS_H_
#define __PRODUCTS_H_

#include "resource.h"       // main symbols
#pragma warning(disable : 4530)
#include <vector>
#include "product.h"
#include "..\EventLogger\EventLogger.h"

typedef std::vector<CComVariant> VarVector;
typedef CComEnumOnSTL<IEnumVARIANT, &IID_IEnumVARIANT, VARIANT, _Copy<VARIANT>, VarVector> VarEnum;
typedef ICollectionOnSTLImpl<IProducts, VarVector, VARIANT, _Copy<VARIANT>, VarEnum> IProdCollection;

/////////////////////////////////////////////////////////////////////////////
// CProducts
class ATL_NO_VTABLE CProducts : 
	public CComObjectRootEx<CComSingleThreadModel>,
	public CComCoClass<CProducts, &CLSID_Products>,
    public ISupportErrorInfo,
	public IDispatchImpl<IProdCollection, &IID_IProducts, &LIBID_DATAACCESSLib>
{
public:
	CProducts()
	{
      CComObject<CProduct>* pObj;
      CComVariant var;

      CComObject<CProduct>::CreateInstance(&pObj);
      pObj->Initialize(1, _T("Shoes"), 40.50);
      var = pObj;
      m_coll.push_back(var);

      CComObject<CProduct>::CreateInstance(&pObj);
      pObj->Initialize(2, _T("Shirt"), 20.00);
      var = pObj;
      m_coll.push_back(var);

      CComObject<CProduct>::CreateInstance(&pObj);
      pObj->Initialize(3, _T("Tie"), 12.00);
      var = pObj;
      m_coll.push_back(var);
	}

   HRESULT FinalConstruct()
   {
      return m_pLogger.CoCreateInstance(__uuidof(Events));
   }

DECLARE_REGISTRY_RESOURCEID(IDR_PRODUCTS)

DECLARE_PROTECT_FINAL_CONSTRUCT()

DECLARE_NOT_AGGREGATABLE(CProducts)

BEGIN_COM_MAP(CProducts)
	COM_INTERFACE_ENTRY(IProducts)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
END_COM_MAP()

// IProducts
public:
	STDMETHOD(Remove)(long lProdID);
	STDMETHOD(Add)(BSTR strDesc, double dCost, VARIANT* pVar);
// remove these because ICollectionOnSTLImpl<> will supply them
//	STDMETHOD(get_Item)(/*[in]*/ long lIndex, /*[out, retval]*/ VARIANT *pVal);
//	STDMETHOD(get__NewEnum)(/*[out, retval]*/ LPUNKNOWN *pVal);
//	STDMETHOD(get_Count)(/*[out, retval]*/ long *pVal);
private:
   CComPtr<IEvents> m_pLogger;

// ISupportErrorInfo
public:
   STDMETHOD (InterfaceSupportsErrorInfo)(REFIID riid)
   {
      static const IID* arr[] = 
      {
         &IID_IProducts
      };
      for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
      {
         if (InlineIsEqualGUID(*arr[i],riid))
            return S_OK;
      }
      return S_FALSE;
   }

};

#endif //__PRODUCTS_H_
