// Event.h : Declaration of the CEvent

#ifndef __EVENT_H_
#define __EVENT_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CEvent
class ATL_NO_VTABLE CEvent : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CEvent, &CLSID_Event>,
	public IDispatchImpl<IEvent, &IID_IEvent, &LIBID_EVENTLOGGERLib>
{
public:
	CEvent()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_EVENT)

DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CEvent)
	COM_INTERFACE_ENTRY(IEvent)
	COM_INTERFACE_ENTRY(IDispatch)
END_COM_MAP()

// IEvent
public:
	void Initialize(DATE dDate, BSTR bstrMsg, long lSeverity);
	STDMETHOD(get_Severity)(/*[out, retval]*/ long *pVal);
	STDMETHOD(get_Message)(/*[out, retval]*/ BSTR *pVal);
	STDMETHOD(get_Date)(/*[out, retval]*/ DATE *pVal);
private:
   DATE m_dDate;
   CComBSTR m_bstrMsg;
   long m_lSeverity;
};
#endif //__EVENT_H_
