// Events.cpp : Implementation of CEvents
#include "stdafx.h"
#include "EventLogger.h"
#include "Events.h"
#include "EnumEvents.h"
#include "Event.h"

/////////////////////////////////////////////////////////////////////////////
// CEvents

STDMETHODIMP CEvents::Add(BSTR bstrMsg, long lSeverity)
{
   //get current time
	SYSTEMTIME st;
   GetLocalTime(&st);
   DATE dDate;
   SystemTimeToVariantTime(&st, &dDate);

   //get the record count
   LARGE_INTEGER li;
   li.LowPart = 0;
   li.HighPart = 0;

   CComPtr<IStream> pStm;
   WCHAR strName[20];

   //only one thread here
   g_csCount.Lock();
   m_pStm->Seek(li, STREAM_SEEK_SET, NULL);
   ULONG ulRec;
   m_pStm->Read(&ulRec, sizeof(ULONG), NULL);
   ulRec++;
   m_pStm->Seek(li, STREAM_SEEK_SET, NULL);
   m_pStm->Write(&ulRec, sizeof(ULONG), NULL);
   m_pStg->Commit(STGC_DEFAULT);
   g_csCount.Unlock();
   
   CComVariant varDate;
   CComVariant varMsg;
   CComVariant varSev;
   varDate = dDate;
   varMsg = bstrMsg;
   varSev = lSeverity;

   swprintf(strName, L"%ld", ulRec - 1);

   g_csData.Lock();
   m_pStg->CreateStream(strName, STGM_WRITE | STGM_SHARE_EXCLUSIVE, 0, 0, &pStm);
   varDate.WriteToStream(pStm);
   varMsg.WriteToStream(pStm);
   varSev.WriteToStream(pStm);
   m_pStg->Commit(STGC_DEFAULT);
   g_csData.Unlock();
   pStm.Release();
   Fire_NewEvent((long)ulRec - 1);

   return S_OK;
}

STDMETHODIMP CEvents::get__NewEnum(LPUNKNOWN *pVal)
{
   HRESULT hr;
   CComObject<CEnumEvents>* pObj;
   CComObject<CEnumEvents>::CreateInstance(&pObj);
   pObj->m_pStg = m_pStg;
   pObj->m_pStm = m_pStm;
   hr = pObj->QueryInterface(pVal);
   if (FAILED(hr))
      delete pObj;
   return hr;
}

STDMETHODIMP CEvents::Item(long lEventID, IEvent **pOut)
{
   if (pOut == NULL)
      return Error(L"out pointer is invalid", IID_IEvents, E_POINTER);

   WCHAR strName[20];
   CComPtr<IStream> pStm;
   CComVariant varDate;
   CComVariant varMsg;
   CComVariant varSev;

   swprintf(strName, L"%ld", lEventID);
   HRESULT hr;
   g_csData.Lock();
   hr = m_pStg->OpenStream(strName, NULL, STGM_READ | STGM_SHARE_EXCLUSIVE,
                                                                  0, &pStm);
   if (SUCCEEDED(hr))
   {
      varDate.ReadFromStream(pStm);
      varMsg.ReadFromStream(pStm);
      varSev.ReadFromStream(pStm);
      g_csData.Unlock();
   }
   else
   {
      g_csData.Unlock();
      return Error(L"cannot get item", IID_IEvents, hr);
   }

   CComObject<CEvent>* pObj;
   CComObject<CEvent>::CreateInstance(&pObj);
   pObj->Initialize(varDate.date, varMsg.bstrVal, varSev.lVal);
   hr = pObj->QueryInterface(pOut);
   if (FAILED(hr))
   {
      delete pObj;
      return Error(L"cannot create the object", IID_IEvents, hr);
   }
   return hr;

}
