// Events.h : Declaration of the CEvents

#ifndef __EVENTS_H_
#define __EVENTS_H_

#include "resource.h"       // main symbols
#include "EventLoggerCP.h"

/////////////////////////////////////////////////////////////////////////////
// CEvents
class ATL_NO_VTABLE CEvents : 
	public CComObjectRootEx<CComMultiThreadModel>,
	public CComCoClass<CEvents, &CLSID_Events>,
	public IDispatchImpl<IEvents, &IID_IEvents, &LIBID_EVENTLOGGERLib>,
	public ISupportErrorInfo,
	public IProvideClassInfo2Impl<&CLSID_Events, &DIID_DLoggerEvents>,
	public CProxyDLoggerEvents< CEvents >,
	public IConnectionPointContainerImpl<CEvents>
{
public:
	CEvents()
	{
	}

DECLARE_REGISTRY_RESOURCEID(IDR_EVENTS)
DECLARE_CLASSFACTORY_SINGLETON(CEvents)
DECLARE_PROTECT_FINAL_CONSTRUCT()

BEGIN_COM_MAP(CEvents)
	COM_INTERFACE_ENTRY(IEvents)
	COM_INTERFACE_ENTRY(IDispatch)
	COM_INTERFACE_ENTRY(ISupportErrorInfo)
	COM_INTERFACE_ENTRY(IProvideClassInfo2)
	COM_INTERFACE_ENTRY(IConnectionPointContainer)
END_COM_MAP()

   HRESULT FinalConstruct()
   {
      HRESULT hr;
      hr = StgOpenStorage(L"Data.dat", NULL, STGM_READWRITE | STGM_SHARE_DENY_WRITE | STGM_TRANSACTED, NULL, 0, &m_pStg);
      if (FAILED(hr))
      {
         hr = StgCreateDocfile(L"Data.dat", STGM_READWRITE | STGM_SHARE_DENY_WRITE | STGM_TRANSACTED, 0, &m_pStg);
         if (FAILED(hr))
            return hr;
      }
      hr = m_pStg->OpenStream(L"CurrentRecord", NULL, STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, &m_pStm);
      if (FAILED(hr))
      {
         hr = m_pStg->CreateStream(L"CurrentRecord", STGM_READWRITE | STGM_SHARE_EXCLUSIVE, 0, 0, &m_pStm);
         if (FAILED(hr))
            return hr;
         ULONG count = 0;
         m_pStm->Write(&count, sizeof(ULONG), NULL);
      }
      m_pStg->Commit(STGC_DEFAULT);
      return S_OK;
   }

// IEvents
public:
	STDMETHOD(Item)(/*[in]*/ long lEventID, /*[out, retval]*/ IEvent** pOut);
	STDMETHOD(get__NewEnum)(/*[out, retval]*/ LPUNKNOWN *pVal);
	STDMETHOD(Add)(/*[in]*/ BSTR bstrMsg, /*[in]*/ long lSeverity);
private:
   CComPtr<IStorage> m_pStg;
   CComPtr<IStream> m_pStm;
   // ISupportErrorInfo
public:
   STDMETHOD (InterfaceSupportsErrorInfo)(REFIID riid)
   {
      static const IID* arr[] = 
      {
         &IID_IEvents
      };
      for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
      {
         if (InlineIsEqualGUID(*arr[i],riid))
            return S_OK;
      }
      return S_FALSE;
   }
public :

BEGIN_CONNECTION_POINT_MAP(CEvents)
	CONNECTION_POINT_ENTRY(DIID_DLoggerEvents)
END_CONNECTION_POINT_MAP()

};

#endif //__EVENTS_H_
