// EnumProducts.cpp : Implementation of CEnumProducts
#include "stdafx.h"
#include "DataAccess.h"
#include "EnumProducts.h"

#include "Product.h"
#include "ProductsTable.h"
#include <OLEDBERR.H>

/////////////////////////////////////////////////////////////////////////////
// CEnumProducts

HRESULT CEnumProducts::Initialize(IEvents* pLogger)
{
   HRESULT hr;
   m_pLogger = pLogger;

   hr = OpenDataSource();
   if (FAILED(hr))
   {
      TCHAR str[40];
      wsprintf(str, _T("Cannot open the database 0x%08x"), hr);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
   }
   return hr;
}

STDMETHODIMP CEnumProducts::InterfaceSupportsErrorInfo(REFIID riid)
{
	static const IID* arr[] = 
	{
		&IID_IEnumVARIANT
	};
	for (int i=0; i < sizeof(arr) / sizeof(arr[0]); i++)
	{
		if (InlineIsEqualGUID(*arr[i],riid))
			return S_OK;
	}
	return S_FALSE;
}

STDMETHODIMP CEnumProducts::Next(ULONG celt, VARIANT* rgVar, ULONG* pCeltFetched)
{
   if (rgVar == NULL || (celt != 1 && pCeltFetched == NULL))
      return AtlReportError(CLSID_EnumProducts, L"out pointer invalid", IID_IEnumVARIANT, E_POINTER);
   HRESULT hr = S_OK;

   if (m_ProductID == -1)
   {
      Reset(); // for next time
      if (pCeltFetched != NULL)
         *pCeltFetched = 0;
      return S_FALSE;
   }

   if (!m_spRowset)
      hr = Reset();

   if (FAILED(hr))
   {
      CComBSTR bstr = L"Database error";
      m_pLogger->Add(bstr, 1);
      if (pCeltFetched != NULL)
         *pCeltFetched = 0;
      return AtlReportError(CLSID_EnumProducts, bstr, IID_IEnumVARIANT, hr);
   }

   VARIANT* pelt = rgVar;
   ULONG pos;
   for (pos = 0; pos < celt; pos++)
   {
      CComObject<CProduct>* pObj;
      CComObject<CProduct>::CreateInstance(&pObj);
      double dCost;
      VarR8FromCy(m_UnitCost, &dCost);
      pObj->Initialize(m_ProductID, m_Description, dCost);
      IDispatch* pDisp;
      pObj->QueryInterface(&pDisp);
      pelt->pdispVal = pDisp;
      pelt->vt = VT_DISPATCH;
      pelt++;

      //get the next data
      hr = MoveNext();
      if (hr == DB_S_ENDOFROWSET)
      {
         pos++;
         m_ProductID = -1;
         if (celt != pos)
            hr = S_FALSE;
         else
            hr = S_OK;
         break;
      }
      if (FAILED(hr))
      {
         CComBSTR bstr = L"Database error";
         m_pLogger->Add(bstr, 1);
         while (rgVar < pelt)
            VariantClear(rgVar++);
         if (pCeltFetched != NULL)
            *pCeltFetched = 0;
         return AtlReportError(CLSID_EnumProducts, bstr, IID_IEnumVARIANT, hr);
      }
   }
   if (pCeltFetched != NULL)
      *pCeltFetched = pos;
   return hr;
}

STDMETHODIMP CEnumProducts::Skip(ULONG celt)
{
   HRESULT hr;
   if (!m_spRowset)
      Reset();
   hr = MoveNext(celt - 1, true);
   if (hr == DB_E_BADSTARTPOSITION)
   {
      Reset();
      return S_FALSE;
   }

   return S_OK;
}

STDMETHODIMP CEnumProducts::Reset()
{
   HRESULT hr;
   Close();

   CDBPropSet propset(DBPROPSET_ROWSET);
   propset.AddProperty(DBPROP_IRowsetLocate, true);
   hr = CCommand<CAccessor<CProductsTableAccessor> >::Open(m_session, _T("SELECT ProductID, Description, UnitCost FROM Products ORDER BY ProductID"), &propset);
   MoveFirst();
   return hr;
}

STDMETHODIMP CEnumProducts::Clone(IEnumVARIANT** ppEnum)
{
   HRESULT hr;
   CComObject<CEnumProducts>* pObj;
   CComObject<CEnumProducts>::CreateInstance(&pObj);
   hr = pObj->QueryInterface(ppEnum);
   if (FAILED(hr))
   {
      delete pObj;
      *ppEnum = NULL;
      return AtlReportError(CLSID_EnumProducts, L"cannot clone enumerator", IID_IEnumVARIANT, hr);
   }

   return pObj->InitializeClone(this, m_pLogger);
}

HRESULT CEnumProducts::InitializeClone(CEnumProducts* pCreator, IEvents* pLogger)
{
   m_pLogger = pLogger;
   m_spRowset = pCreator->m_spRowset; 
   if (m_spRowset)
      Bind();

   m_ProductID = pCreator->m_ProductID;
   m_UnitCost = pCreator->m_UnitCost;
   lstrcpy(m_Description, pCreator->m_Description);
   return S_OK;
}
