// Products.cpp : Implementation of CProducts
#include "stdafx.h"
#include "DataAccess.h"
#include "Products.h"
#include "ProductsTable.h"
#include "EnumProducts.h"
#include <OLEDBERR.H>

/////////////////////////////////////////////////////////////////////////////
// CProducts

#define CHECK_OUT_PARAM(p) \
   if (p == NULL) \
      return Error(_T("out pointer is invalid"), IID_IProducts, E_POINTER); 

STDMETHODIMP CProducts::get_Count(long *pVal)
{
   CHECK_OUT_PARAM(pVal);
   HRESULT hr;
   *pVal = 0;

   CProductsTable db;
   db.OpenDataSource();
   CCommand<CAccessor<COutParamAccessor> > count;
   hr = count.Open(db.m_session, _T("SELECT COUNT(ProductID) FROM Products"));
   if (SUCCEEDED(hr))
      hr = count.MoveNext();
	if (FAILED(hr))
   {
      TCHAR str[40];
      wsprintf(str, _T("Cannot access the database 0x%08x"), hr);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
		return Error(L"Cannot access the database", IID_IProducts, hr);
   }
   else
      *pVal = count.m_Param;
   return hr;
}

STDMETHODIMP CProducts::get__NewEnum(LPUNKNOWN *pVal)
{
   HRESULT hr;
   CComObject<CEnumProducts>* pObj;
   CComObject<CEnumProducts>::CreateInstance(&pObj);
   hr = pObj->QueryInterface(pVal);
   if (FAILED(hr))
   {
      delete pObj;
      return Error(L"Cannot return enumerator", IID_IProducts, hr);
   }
   pObj->Initialize(m_pLogger);
   return hr;
}

STDMETHODIMP CProducts::get_Item(long lProdID, VARIANT *pVal)
{
   CHECK_OUT_PARAM(pVal);
   HRESULT hr;

   CProductsTable db;
   db.m_ProductID = lProdID;
   hr = db.Open();
   if (SUCCEEDED(hr))
      hr = db.MoveNext();
   if (hr == DB_S_ENDOFROWSET || FAILED(hr))
   {
      TCHAR str[50];
      wsprintf(str, _T("Cannot get product #%ld"), lProdID);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
		return Error(str, IID_IProducts, E_INVALIDARG);
   }

   CComObject<CProduct>* pObj;
   CComObject<CProduct>::CreateInstance(&pObj);
   CComVariant var;

   var = pObj;                                        // QIs for IDispatch
   double dCost;
   VarR8FromCy(db.m_UnitCost, &dCost);
   pObj->Initialize(db.m_ProductID, db.m_Description, dCost);
   var.Detach(pVal);
   return S_OK;
}

STDMETHODIMP CProducts::Add(BSTR strDesc, double dCost, VARIANT* pVar)
{
   CHECK_OUT_PARAM(pVar);

   USES_CONVERSION;
   HRESULT hr;
   CProductsTable db;
   db.OpenDataSource();
   CCommand<CAccessor<COutParamAccessor> > max;
   max.m_Param = 0;
   m_cs.Lock();
   hr = max.Open(db.m_session, _T("SELECT MAX(ProductID) FROM Products"));
   if (SUCCEEDED(hr))
      hr = max.MoveNext();

   CCommand<CAccessor<CInsertProductsAccessor> > insert;
   if (SUCCEEDED(hr))
   {
      if (SysStringLen(strDesc) >= sizeof(insert.m_Description))
		   return Error(L"Description too large", IID_IProducts, E_INVALIDARG);
      insert.m_ProductID = max.m_Param + 1;
      VarCyFromR8(dCost, &insert.m_UnitCost);
      lstrcpy(insert.m_Description, W2T(strDesc));
      hr = insert.Open(db.m_session, _T("INSERT INTO Products VALUES(?, ?, ?)"));
   }
   m_cs.Unlock();

   if (FAILED(hr))
   {
      TCHAR str[50];
      wsprintf(str, _T("Cannot add the product %S 0x%08x"), strDesc, hr);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
		return Error(L"Cannot add the product", IID_IProducts, hr);
   }

   CComObject<CProduct>* pObj;
   CComObject<CProduct>::CreateInstance(&pObj);
   CComVariant var;

   var = pObj;
   pObj->Initialize(insert.m_ProductID, W2T(strDesc), dCost);
   var.Detach(pVar);

   WCHAR str[20];
   swprintf(str, L", $%.2lf", dCost);
   CComBSTR bstr = L"Added ";
   bstr += strDesc;
   bstr += str;
   m_pLogger->Add(bstr, 0);
   return S_OK;
}

STDMETHODIMP CProducts::Remove(long lProdID)
{
   HRESULT hr;
   CProductsTable db;
   db.m_ProductID = lProdID;
   m_cs.Lock();
   hr = db.Open();
   if (SUCCEEDED(hr))
      hr = db.MoveNext();
   if (hr == DB_S_ENDOFROWSET || FAILED(hr))
   {
      m_cs.Unlock();
      TCHAR str[50];
      wsprintf(str, _T("Cannot get the product %ld"), lProdID);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
		return Error(L"Cannot get the product", IID_IProducts, E_INVALIDARG);
   }

   CCommand<CAccessor<CInParamAccessor> > del;
   del.m_Param = lProdID;
	CDBPropSet	propset(DBPROPSET_ROWSET);
	propset.AddProperty(DBPROP_UPDATABILITY, DBPROPVAL_UP_DELETE);
   hr = del.Open(db.m_session, _T("DELETE FROM Products WHERE ProductID = ?"), &propset);
   m_cs.Unlock();
   if (FAILED(hr))
   { 
      CComBSTR bstr = L"Delete failed";
      m_pLogger->Add(bstr, 1);
      return Error(L"Delete failed", IID_IProducts, E_INVALIDARG);
   }

   CComBSTR bstr;
   bstr = L"Removed ";
   bstr += db.m_Description;
   m_pLogger->Add(bstr, 0);
   return S_OK;
}
