// ProductAccess.cpp : Implementation of CProductAccess

#include "stdafx.h"
#include "Controls.h"
#include "ProductAccess.h"
#include "ProductDetails.h"

/////////////////////////////////////////////////////////////////////////////
// CProductAccess

LRESULT CProductAccess::OnChangeEditBoxes(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	CWindow hDesc, hCost;
   hDesc = GetDlgItem(IDC_DESC);
   hCost = GetDlgItem(IDC_COST);
   bool bEnable = (hDesc.GetWindowTextLength() > 0
        && hCost.GetWindowTextLength() > 0);
   CWindow hAdd;
   hAdd = GetDlgItem(IDC_ADD);
   hAdd.EnableWindow(bEnable);
	return 0;
}

LRESULT CProductAccess::OnSelChangeItems(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
	CWindow hRemove;
   hRemove = GetDlgItem(IDC_REMOVE);
   hRemove.EnableWindow();
	return 0;
}

LRESULT CProductAccess::OnClickedAdd(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
   CWindow hAdd;
   hAdd = GetDlgItem(IDC_ADD);
   hAdd.EnableWindow(FALSE);

	CWindow hDesc, hCost;
   hDesc = GetDlgItem(IDC_DESC);
   hCost = GetDlgItem(IDC_COST);

   USES_CONVERSION;
   CComBSTR bstr;
   hCost.GetWindowText(bstr.m_str);
   double dCost;
   dCost = atof(W2A(bstr.m_str));
   bstr.Empty();
   hDesc.GetWindowText(bstr.m_str);

   HRESULT hr;
   CComVariant var;
   hr = m_pProducts->Add(bstr, dCost, &var);
   if (FAILED(hr))
   {
      bstr += L": cannot add this item";
      m_pLogger->Add(bstr, 1);
      MessageBox(W2T(bstr.m_str), _T("Products"), MB_OK | MB_ICONWARNING);
   }
   else
   {
      CListBox hListBox;
      hListBox = GetDlgItem(IDC_ITEMS);
      hListBox.ResetContent();
      OnInitDialog(0, 0, 0, bHandled);
      hDesc.SetWindowText(_T(""));
      hCost.SetWindowText(_T(""));
   }
	return 0;
}

LRESULT CProductAccess::OnClickedRemove(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
   CWindow hAdd;
   hAdd = GetDlgItem(IDC_REMOVE);
   hAdd.EnableWindow(FALSE);

   CListBox hListBox;
   hListBox = GetDlgItem(IDC_ITEMS);
   long ID;
   ID = (long)hListBox.GetItemData(hListBox.GetCurSel());

   HRESULT hr;
   CComVariant var;
   hr = m_pProducts->get_Item(ID, &var);
   if (FAILED(hr))
   {
      TCHAR str[30];
      wsprintf(str, _T("item %ld doesn\'t exist"), ID);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
      MessageBox(str, _T("Products"), MB_OK | MB_ICONWARNING);
      hListBox.ResetContent();
      OnInitDialog(0, 0, 0, bHandled);
      return 0;
   }

   hr = m_pProducts->Remove(ID);
   if (FAILED(hr))
   {
      TCHAR str[30];
      wsprintf(str, _T("cannot remove item %ld"), ID);
      CComBSTR bstr = str;
      m_pLogger->Add(bstr, 1);
      MessageBox(str, _T("Products"), MB_OK | MB_ICONWARNING);
   }
   else
   {
      USES_CONVERSION;
      CWindow hDesc, hCost;
      hDesc = GetDlgItem(IDC_DESC);
      hCost = GetDlgItem(IDC_COST);

      CComPtr<IProduct> pProd;
      CComBSTR bstr;
      var.pdispVal->QueryInterface(&pProd);
      pProd->get_Description(&bstr.m_str);
      hDesc.SetWindowText(W2T(bstr.m_str));
      
      CURRENCY cy;
      pProd->get_UnitCost(&cy);
      bstr.Empty();
      VarBstrFromCy(cy, LOCALE_USER_DEFAULT, 0, &bstr.m_str);
      hCost.SetWindowText(W2T(bstr.m_str));
   }
   hListBox.ResetContent();
   OnInitDialog(0, 0, 0, bHandled);
	return 0;
}

LRESULT CProductAccess::OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
{
   USES_CONVERSION;
   HRESULT hr;
   CListBox hListBox;
   hListBox = GetDlgItem(IDC_ITEMS);

   CComPtr<IUnknown> pUnk;
   CComPtr<IEnumVARIANT> pEnum;
   hr = m_pProducts->get__NewEnum(&pUnk);
   if (FAILED(hr))
   {
      CComBSTR bstr;
      bstr = L"Cannot get the enumerator";
      m_pLogger->Add(bstr, 1);
      return 0;
   }
   pUnk.QueryInterface(&pEnum);

   CComVariant vars[5];
   ULONG ulFetched;
   while(SUCCEEDED(pEnum->Next(5, vars, &ulFetched)))
   {
      ULONG idx;
      for (idx = 0; idx < ulFetched; idx++)
      {
         CComPtr<IDispatch> pDisp;
         CComPtr<IProduct> pProd;
         pDisp = vars[idx].pdispVal;
         pDisp->QueryInterface(&pProd);

         CComBSTR bstrDesc;
         pProd->get_Description(&bstrDesc.m_str);
         long ID;
         pProd->get_ProductID(&ID);

         int item;
         item = hListBox.AddString(W2T(bstrDesc));
         hListBox.SetItemData(item, ID);
         vars[idx].Clear();
      }
      if (ulFetched == 0)
         break;
   }
	return 0;
}

HRESULT CProductAccess::FinalConstruct()
{
   HRESULT hr;
   hr = m_pLogger.CoCreateInstance(__uuidof(Events));
   if (FAILED(hr))
      return hr;
   hr = m_pProducts.CoCreateInstance(__uuidof(Products));
   if (FAILED(hr))
   {
      CComBSTR bstr = L"Cannot create Products";
      m_pLogger->Add(bstr, 1);
      return hr;
   }
   return hr;
}

LRESULT CProductAccess::OnDblclkItems(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
{
   HRESULT hr;
   CListBox hListBox;
   hListBox = GetDlgItem(IDC_ITEMS);
   int item = hListBox.GetCurSel();
   if (item == LB_ERR)
      return 0;

   long ID;
   ID = (long)hListBox.GetItemData(item);

   CComVariant var;
   hr = m_pProducts->get_Item(ID, &var);
   if (FAILED(hr))
   {
      // item has disappeared
      MessageBox(_T("Item has been deleted"), _T("Information"), MB_OK | MB_ICONWARNING);
      return OnInitDialog(0, 0, 0, bHandled);
   }

   CComPtr<IDispatch> pDisp;
   CComPtr<IProduct> pProd;
   pDisp = var.pdispVal;
   pDisp->QueryInterface(&pProd);

   CComBSTR bstrDesc;
   pProd->get_Description(&bstrDesc.m_str);
   pProd->get_ProductID(&ID);
   CURRENCY cy;
   pProd->get_UnitCost(&cy);

   CProductDetails dlg;
   dlg.m_lProductID = ID;
   dlg.m_bstrDesc = bstrDesc;
   VarR8FromCy(cy, &dlg.m_dCost);
   dlg.DoModal();
   return 0;
}
