// ProductDetails.h : Declaration of the CProductDetails

#ifndef __PRODUCTDETAILS_H_
#define __PRODUCTDETAILS_H_

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CProductDetails
class CProductDetails : 
	public CDialogImpl<CProductDetails>
{
public:
   CProductDetails() : m_dCost(-1), m_lProductID(-1)
	{
	}

	enum { IDD = IDD_PRODUCTDETAILS };

BEGIN_MSG_MAP(CProductDetails)
	MESSAGE_HANDLER(WM_INITDIALOG, OnInitDialog)
	COMMAND_ID_HANDLER(IDOK, OnOK)
END_MSG_MAP()
// Handler prototypes:
//  LRESULT MessageHandler(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled);
//  LRESULT CommandHandler(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled);
//  LRESULT NotifyHandler(int idCtrl, LPNMHDR pnmh, BOOL& bHandled);

	LRESULT OnInitDialog(UINT uMsg, WPARAM wParam, LPARAM lParam, BOOL& bHandled)
	{
      USES_CONVERSION;
      CWindow hEdit;
      if (m_lProductID != -1)
      {
         TCHAR str[20];
         wsprintf(str, _T("%ld"), m_lProductID);
         hEdit = GetDlgItem(IDC_ID);
         hEdit.SetWindowText(str);
      }
      if (m_bstrDesc.Length() > 0)
      {
         hEdit = GetDlgItem(IDC_DESC);
         hEdit.SetWindowText(W2T(m_bstrDesc));
      }
      if (m_dCost != -1)
      {
         TCHAR str[20];
         _stprintf(str, _T("$%.02f"), m_dCost);
         hEdit = GetDlgItem(IDC_UNITCOST);
         hEdit.SetWindowText(str);
      }
		return 1;
	}

	LRESULT OnOK(WORD wNotifyCode, WORD wID, HWND hWndCtl, BOOL& bHandled)
	{
		EndDialog(wID);
		return 0;
	}
public:
   CComBSTR m_bstrDesc;
   long m_lProductID;
   double m_dCost;
};

#endif //__PRODUCTDETAILS_H_
