// JavaScript Document
window.onload=testerNavigateur;
//-----------------------------
function testerNavigateur() {   
	objetXHR = creationXHR();
	if(objetXHR==null) {
		document.getElementById("button").disabled= true;
		var erreurNavigateur="Erreur Navigateur : Création d'objet XHR impossible";
		remplacerContenu("info", erreurNavigateur);
	    document.getElementById("info").style.visibility="visible";
	}
	lectureRss();
}
//##############################MOTEUR AJAX 1############################################
function jouer() {   
	 /*-----------------------------Config et envoi de la requete ASYNCHRONE : */
	 //verif si nom du joueur est bien saisi
	 document.getElementById("nom").style.backgroundColor="white";
	 var nom=document.getElementById("nom").value;
	 if(nom==""){
		 //-------------change la couleur du champ
	   document.getElementById("nom").style.backgroundColor="red";
	   //-----------affiche message Alert
	   alert("Attention : vous devez saisir votre nom avant de jouer");
	   return null;
	 }
	 //création d'un objet XHR multi-navigateurs
	 objetXHR = creationXHR();
	 var temps = new Date().getTime();//création d'une variable temps pour l'anti-cache
	 //construction de la chaine des parametres
	 var parametres = "nom="+ codeContenu("nom") +
	                  "&anticache="+temps ;
	 //Config. objet XHR
     objetXHR.open("get","gainAleatoire.php?"+parametres, true); 
	 objetXHR.onreadystatechange = actualiserPage;//désignation de la fonction de rappel
	 //gestion du bouton et du chargeur
	 document.getElementById("button").disabled= true;
	 document.getElementById("charge").style.visibility="visible";
     objetXHR.send(null);//envoi de la requete
	 /*---------------------------------------- */
  }
  function actualiserPage() {
	if (objetXHR.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR.status == 200) {
	   var nouveauResultatXML = objetXHR.responseXML;//recup du résulat au format XML 
	   //récupération des valeurs dans l'arbre XML
	   var gainTxt=nouveauResultatXML.getElementsByTagName("gain")[0].firstChild.nodeValue;
	   var gagnantTxt=nouveauResultatXML.getElementsByTagName("nom")[0].firstChild.nodeValue;
	   //actualisation des résultats
	   remplacerContenu("resultat",gainTxt);
	   remplacerContenu("gagnant",gagnantTxt);
	   //affiche la zone info
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	 }else{
	   //message d'erreur serveur
	   var erreurServeur="Erreur serveur : "+objetXHR.status+" – "+ objetXHR.statusText;
	   remplacerContenu("info", erreurServeur);
	   document.getElementById("info").style.visibility="visible";
	   //gestion du bouton et du chargeur
	   document.getElementById("button").disabled= false;
	   document.getElementById("charge").style.visibility="hidden";
	   //annule la requete en cours
	   objetXHR.abort();
	   objetXHR=null;
	   }
	 }
  }
//##############################MOTEUR AJAX 2############################################
  function lectureRss() {   
	 //création d'un objet XHR multi-navigateurs
	 objetXHR2 = creationXHR();
     objetXHR2.open("get","proxyRss.php", true); 
	 objetXHR2.onreadystatechange = afficheRss;//désignation de la fonction de rappel
     objetXHR2.send(null);//envoi de la requete
	 setTimeout("lectureRss()",6000);//timer de 6 s
  }
  function afficheRss() {
	if (objetXHR2.readyState == 4) {//test si le résultat est disponible
	 if (objetXHR2.status == 200) {
	   var nouveauRss=objetXHR2.responseXML;//recup du résulat au format XML 
	   //récupération des valeurs des items  
	   var elementItem=nouveauRss.getElementsByTagName("item");
	   for(i=0;i<elementItem.length;i++){
		    var titre=elementItem[i].getElementsByTagName("title")[0].firstChild.nodeValue;
	   		var lien=elementItem[i].getElementsByTagName("link")[0].firstChild.nodeValue;
			nouvelleLigne(titre,lien);
	   }//fin du for
	  }//fin du if status
	 }//fin du if readyState
  }//fin de function
  
  function nouvelleLigne(titre,lien) { 
	   var nouveauTR=document.createElement('tr');
	   //-----------------------------------------
	   var nouveauTD=document.createElement('td');
	   var nouveauA=document.createElement('a');
	   nouveauA.setAttribute('href',lien); 
	   nouveauA.setAttribute('target','_blank'); 
	   var nouveauTXT=document.createTextNode(titre);
	   nouveauA.appendChild(nouveauTXT);
	   nouveauTD.appendChild(nouveauA);
	   //------------------------------------------
	   nouveauTR.appendChild(nouveauTD);
	   //------------------------------------------
	   document.getElementById("tableRss").appendChild(nouveauTR);
}