REBOL [
	subject: "Insre une image dans un fichier PFA"
	author: "Olivier Auverlot"
	version: 1.0
]

buffer: layout [
	imgico: image 22x22
]


integre-image: does [
	pfa: read/lines to-file fpfa/text
	debut: #{000000000000000003000000}
	fin: #{00000000}
	dessin: array/initial 1024 0
	imgico/image: load to-file fimg/text

	ptr: 5 * 32
	for x 1 22 1 [
		for y 0 21 1 [
			ptr: ptr + 1
			either (pick imgico/image ((y * 32) + x)) = 0.0.0 [
				poke dessin ptr 255
			] [ poke dessin ptr 0 ]	
		]
		ptr: ptr + 10
	]

	pfa/6: join debut [ (to-binary dessin) fin ]
	write/lines (to-file fpfa/text) pfa
]

view/title layout [
	across
	text "Projet PFA" return
	fpfa: field 200
	button "Choisir" [
		nom: request-file/title/filter "Projet PFA" "Ok" "*.pfa"
		if not none? nom [
			fpfa/text: first nom
			show fpfa
		]
	] return
	text "Fichier Image" return
	fimg: field 200
	button "Choisir" [
		nom: request-file/title/filter "Image" "Ok" [ "*.bmp" "*.jpg" "*.png" "*.gif" ]
		if not none? nom [
			fimg/text: first nom
			show fimg
		]
	] return
	button "Intgrer" [ integre-image ]
	button "Quitter" [ quit ]
] "Images vers PFA"
