import java.io.*;
import java.sql.*;
import javax.servlet.*;
import javax.servlet.http.*;
import com.wrox.pssjp.jdbc.pool1.*;

public class Pool2TestServlet extends HttpServlet
{
   private PoolManager poolMgr;

   public void init() throws ServletException
   {
      poolMgr = PoolManager.getInstance();
   }

   public void service(HttpServletRequest req, HttpServletResponse res) 
      throws IOException
      {

      res.setContentType("text/html");
      PrintWriter out = res.getWriter();
      Connection conn = poolMgr.getConnection("idb");
      if (conn == null)
      {
         out.println("Can't get connection");
         return;
      }
      ResultSet rs = null;
      ResultSetMetaData md = null;
      Statement stmt = null;
      try
      {
         stmt = conn.createStatement();
         rs = stmt.executeQuery("SELECT * FROM EMPLOYEE");
         md = rs.getMetaData();
         out.println("<H1>Employee data</H1>");
         while (rs.next())
         {
            out.println("<BR>");
            for (int i = 1; i < md.getColumnCount(); i++)
            {
               out.print(rs.getString(i) + ", ");
            }
         }
         stmt.close();
         rs.close();
         conn.close();
      }
      catch (SQLException e)
      {
         e.printStackTrace(out);
      }
   }

   public void destroy()
   {
      poolMgr.release();
      super.destroy();
   }
}
