package com.wrox.WroxJiniServices;

import net.jini.core.entry.*;
import net.jini.lookup.entry.*;
import java.net.*;

public class ProxyRemoteJiniServiceImpl implements IWroxJiniService {

    IRMIBasedJiniService myRemoteService;

    static final String SERVICE_NAME = "Jini Service - Remote Proxy";
    static final String SERVICE_MFR = "Sing Li";
    static final String SERVICE_VENDOR = "Wrox";
    static final String SERVICE_VERSION = "1.0";
    static final String SERVICE_COMMENT = "This is a remote proxy implementation.";
    static final String LOCATION_FLOOR = "third";
    static final String LOCATION_ROOM = "computer";
    static final String LOCATION_BUILDING = "8C";
    static final String CLASS_NAME = "wroxCallable";

    public ProxyRemoteJiniServiceImpl() {
    }

    public ProxyRemoteJiniServiceImpl(IRMIBasedJiniService inRMIProxy) {
        myRemoteService = inRMIProxy;
    }

    public String grabData() {
        try {
            return "First Local: " + InetAddress.getLocalHost()
                    + ". Then... " + myRemoteService.grabData()
                    + " ... then local: " + InetAddress.getLocalHost()
                    + " again!";
        } catch (Exception e) {
            return "Data returned locally from within the client.";
        }
    }

    public Entry[] getEntries() {
        Entry myEntry[] = new Entry[5];
        myEntry[0] = new ServiceInfo(
                SERVICE_NAME,
                SERVICE_MFR,
                SERVICE_VENDOR,
                SERVICE_VERSION,
                "",                              //   Model goes here
                ""                               //   Serial Number goes here
                );
        myEntry[1] = new Name(
                CLASS_NAME
                );
        myEntry[2] = new Comment(
                SERVICE_COMMENT
                );
        myEntry[3] = new Location(
                LOCATION_FLOOR,
                LOCATION_ROOM,
                LOCATION_BUILDING
                );
        myEntry[4] = new WroxServiceAttributes(
                "Beginning Java 2"
                );
        return myEntry;
    }

}