// Example 9.5
// Adding an object to an LDAP server

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;

public class JNDIDel {
   // initial context implementation 
   public static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

   public static String MY_HOST = "ldap://localhost:389";
   public static String MGR_DN = "uid=kvaughan, ou=People, o=fedup.com";
   public static String MGR_PW = "boo";
   public static String MY_SEARCHBASE = "o=fedup.com";
   public static String MY_ENTRY = "uid=mewilcox, ou=People, o=fedup.com";

   public static void main(String args[])
   {
      try 
      {
         //Hashtable for environmental information
         Hashtable env = new Hashtable(); 

         //Specify which class to use for our JNDI provider
         env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);

         env.put(Context.PROVIDER_URL,MY_HOST);
         env.put(Context.SECURITY_AUTHENTICATION,"simple");
         env.put(Context.SECURITY_PRINCIPAL,MGR_DN);
         env.put(Context.SECURITY_CREDENTIALS,MGR_PW);

         //Get a reference to a directory context
         DirContext ctx = new InitialDirContext(env);

         ctx.destroySubcontext(MY_ENTRY);
      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
   }
}
