// Example 9.5
// Adding an object to an LDAP server

import java.util.Hashtable;
import java.util.Enumeration;

import javax.naming.*;
import javax.naming.directory.*;

public class JNDIMod {
   // initial context implementation 
   public static String INITCTX = "com.sun.jndi.ldap.LdapCtxFactory";

   public static String MY_HOST = "ldap://localhost:389";
   public static String MGR_DN = "uid=kvaughan, ou=People, o=fedup.com";
   public static String MGR_PW = "boo";
   public static String MY_SEARCHBASE = "o=fedup.com";
   public static String MY_ENTRY = "uid=mewilcox, ou=People, o=fedup.com";

   public static void main(String args[])
   {
      try 
      {
         //Hashtable for environmental information
         Hashtable env = new Hashtable(); 

         //Specify which class to use for our JNDI provider
         env.put(Context.INITIAL_CONTEXT_FACTORY, INITCTX);

         env.put(Context.PROVIDER_URL,MY_HOST);
         env.put(Context.SECURITY_AUTHENTICATION,"simple");
         env.put(Context.SECURITY_PRINCIPAL,MGR_DN);
         env.put(Context.SECURITY_CREDENTIALS,MGR_PW);

         //Get a reference to a directory context
         DirContext ctx = new InitialDirContext(env);
         ModificationItem[] mods = new ModificationItem[2];

         Attribute mod0 = new BasicAttribute("telephonenumber","940-555-2555");
         Attribute mod1 = new BasicAttribute("l", "Waco");

         mods[0] = new ModificationItem(DirContext.REPLACE_ATTRIBUTE,mod0);
         mods[1] = new ModificationItem(DirContext.ADD_ATTRIBUTE,mod1);

         //DirContext.DELETE_ATTRIBUTE not shown here
         ctx.modifyAttributes("uid=mewilcox,ou=People,o=fedup.com", mods);

      }
      catch(Exception e)
      {
         e.printStackTrace();
         System.exit(1);
      }
   }
}
