package com.wrox.statistics;

import java.util.*;
import java.io.*;
import java.net.URLEncoder;

import javax.servlet.*;


public final class Stats
{
  private StatValue[] values;
  private int total, max;


  public Stats(String source) throws IOException
  {
    if(source == null || source.length() == 0)
      throw new IOException("No source specified");

    InputStream in =
      getClass().getResourceAsStream(source.substring(1));
    if(in == null)
      throw new IOException("Source not found");

    BufferedReader reader =
      new BufferedReader(new InputStreamReader(in));
    Hashtable h = new Hashtable();
    String line;
    while((line = reader.readLine()) != null)
    {
      int[] countWrapper = (int[])h.get(line);
      if(countWrapper == null)
	h.put(line, new int[] {1});
      else
	countWrapper[0]++;
    }
    reader.close();

    values = new StatValue[h.size()];
    Enumeration e = h.keys();
    for(int i=0; i<values.length; i++)
    {
      String key = (String)e.nextElement();
      int count = ((int[])h.get(key))[0];
      values[i] = new StatValue(key, count);
    }

    sort();
    process();
  }


  public Stats(ServletRequest req) throws ServletException
  {
    try
    {
      int num = Integer.parseInt(req.getParameter("num"));
      values = new StatValue[num];
      for(int i=0; i<values.length; i++)
      {
	String s = req.getParameter("v"+i);
	int sep = s.indexOf('|');
	values[i] = new StatValue(s.substring(0,sep),
				  Integer.parseInt(s.substring(sep+1)));
      }
    }
    catch(Exception e)
    {
      throw new ServletException("Error parsing chart values: "+
				 e.toString());
    }
    process();
  }


  public int getMax()
  {
    return max;
  }


  public int getTotal()
  {
    return total;
  }


  public int size()
  {
    return values.length;
  }


  public String nameAt(int i)
  {
    return values[i].name;
  }


  public int valueAt(int i)
  {
    return values[i].value;
  }


  private void process()
  {
    for(int i=0; i<values.length; i++)
    {
      total += values[i].value;
      if(values[i].value > max) max = values[i].value;
    }
  }


  private void sort()
  {
    for(int i=0; i<values.length; i++)
    {
      for(int j=i+1; j<values.length; j++)
      {
	if(values[i].value < values[j].value)
	{
	  StatValue tmp = values[i];
	  values[i] = values[j];
	  values[j] = tmp;
	}
      }
    }
  }
  

  public String toString()
  {
    StringBuffer b = new StringBuffer();
    b.append("num=").append(values.length);
    for(int i=0; i<values.length; i++)
    {
      b.append("&v").append(i).append('=');
      b.append(URLEncoder.encode(values[i].name+'|'+values[i].value));
    }
    return b.toString();
  }


  private static final class StatValue
  {
    int value;
    String name;

    StatValue()
    {
    }

    StatValue(String name, int value)
    {
      this.name = name;
      this.value = value;
    }
  }
}
