package com.wrox.rmi;

import java.rmi.*;
import java.rmi.server.*;

public class Reverse extends UnicastRemoteObject implements ReverseInterface
{

   public Reverse() throws RemoteException
   {
      super();
   }

   public String reverseString(String originalString) throws RemoteException
   {
      int length = originalString.length();

      StringBuffer temp = new StringBuffer(length);

      for (int i = length ; i>0 ; i--)
      {
         temp.append(originalString.substring(i-1,i));
      }

      return temp.toString();
   }

   public static void main(String[] args)
   {
      if (System.getSecurityManager() == null)
      {
         System.setSecurityManager(new RMISecurityManager());
      }

      String name = "//jamesh/com.wrox.rmi.Reverse";

      try
      {
         Reverse r = new Reverse();
         Naming.rebind(name,r);
         System.out.println("Reverse object bound");
      }
      catch (Exception e)
      {
         System.out.println("Error while binding Reverse object");
         System.out.println(e.toString());
      }
   }
}