import javax.servlet.*;
import javax.servlet.http.*;

import java.io.*;
import java.sql.*;

import ap.servlets.*;

public class qry_movie extends HttpServlet {

  Connection dbCon;

  public void init() throws ServletException {

    /* Connect to the database */
    try{
      String driver = getInitParameter("JdbcDriver");
      String dbURL = getInitParameter("dbURL");
      Class.forName(driver);
      dbCon = DriverManager.getConnection(dbURL);
    }
    catch(ClassNotFoundException e) {
      System.out.println("qry_movie: Database driver could not be found.");
      System.out.println(e.toString());
      throw new UnavailableException(this, "Database driver class not found");
    }
    catch(SQLException e) {
      System.out.println("qry_movie: Error connecting to the database.");
      System.out.println(e.toString());
      throw new UnavailableException(this, "Cannot connect to the database");
    }

  }

  public void doGet(HttpServletRequest _req, HttpServletResponse _res)
    throws ServletException, IOException {

    ResultSet rs;
    Statement stmt;

    StringBuffer qry = new StringBuffer(1024);
    int numCriteria = 0;

    _res.setContentType("text/html");
    PrintWriter out = _res.getWriter();

    /* Get form field values */

    String _title = _req.getParameter("txt_title");
    String _actor = _req.getParameter("txt_actor");
    String _actress = _req.getParameter("txt_actress");
    String _type = _req.getParameter("ddlb_type");

    /* Build Query String */

    qry.append("SELECT * FROM titles WHERE");

    if (_title.length() > 0) {
      qry.append(" title LIKE '%");
      qry.append(_title);
      qry.append("%' AND");
      numCriteria++;
    }

    if (_actor.length() > 0) {
      qry.append(" lead_actor LIKE '%");
      qry.append(_actor);
      qry.append("%' AND");
      numCriteria++;
    }

    if (_actress.length() > 0) {
      qry.append(" lead_actress LIKE '%");
      qry.append(_actress);
      qry.append("%*' AND");
      numCriteria++;
    }

    if (_type.length() > 0) {
      qry.append(" type LIKE '%");
      qry.append(_type);
      qry.append("%' AND");
      numCriteria++;
    }

    if (numCriteria > 0) {
      qry.delete(qry.length() - 3, qry.length());  //Strip off AND
    }
    else {
      qry.delete(qry.length() - 5, qry.length());  //Strip off WHERE
    }

    /* Execute Query */

    try{
      stmt = dbCon.createStatement();
      rs = stmt.executeQuery(qry.toString());
    }
    catch(SQLException e) {
      _res.sendError(_res.SC_ACCEPTED, "The request has been accepted, but it failed to complete due to a problem querying the database.");
      return;
    }

    /* Output Results */

    html h = new html("Search Results");
    h.add(html.HEADING, "Selected Movies", true);
    h.add(html.LINE, "", false);

    String labels[] = {"Title","Lead Actor","Lead Actress","Type"};
    if (!h.addTable(labels, rs)) {
      _res.sendError(_res.SC_ACCEPTED, "The request has been accepted, but it failed to complete due to a problem accessing the data.");
      return;
    }
    
    out.println(h.getPage());

    out.close();
  }

  public void destroy() {

    /* Disconnect from the database */
    try{
      dbCon.close();
    }
    catch(Exception e) {
      System.out.println("qry_movie: Database close failed");
      System.out.println(e.toString());
    }

  }

}
